#!/usr/bin/env python

from setuptools import setup

with open('README.md') as f:
    long_description = f.read()

setup(name="macrometa-target-bigquery",
      version='0.0.3',
      description="Macrometa target bigquery connector for loading data to BigQuery",
      long_description=long_description,
      long_description_content_type='text/markdown',
      author="Macrometa",
      url='https://github.com/Macrometacorp/macrometa-target-bigquery',
      classifiers=[
          'License :: OSI Approved :: Apache Software License',
          'Programming Language :: Python :: 3 :: Only'
      ],
      py_modules=["macrometa_target_bigquery"],
      install_requires=[
          'pipelinewise-singer-python==1.2.0',
          'google-cloud-bigquery>=2.20.0,<3.1.0',
          'fastavro>=0.22.8,<1.4.11',
          'c8connector==0.0.15'
      ],
      extras_require={
          "test": [
              'pytest==7.0.1',
              'pylint==2.13.4',
              'pytest-cov==3.0.0',
          ]
      },
      entry_points="""
          [console_scripts]
          macrometa-target-bigquery=macrometa_target_bigquery:main
      """,
      packages=["macrometa_target_bigquery"],
      package_data={},
      include_package_data=True,
)
