# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.meeting_recordings = MeetingRecordingService(self)
        self.meetings = MeetingService(self)
        self.reports = ReportService(self)
        self.room_configs = RoomConfigService(self)
        self.reserves = ReserveService(self)
        



class MeetingRecordingService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, user_access_token=None, timeout=None):
        # type: (str, int) -> MeetingRecordingGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingRecordingGetReqCall(self, request_opts=request_opts)

    def stop(self, user_access_token=None, timeout=None):
        # type: (str, int) -> MeetingRecordingStopReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingRecordingStopReqCall(self, request_opts=request_opts)

    def set_permission(self, body, user_access_token=None, timeout=None):
        # type: (MeetingRecordingSetPermissionReqBody, str, int) -> MeetingRecordingSetPermissionReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingRecordingSetPermissionReqCall(self, body, request_opts=request_opts)

    def start(self, body, user_access_token=None, timeout=None):
        # type: (MeetingRecordingStartReqBody, str, int) -> MeetingRecordingStartReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingRecordingStartReqCall(self, body, request_opts=request_opts)


class MeetingService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def invite(self, body, user_access_token=None, timeout=None):
        # type: (MeetingInviteReqBody, str, int) -> MeetingInviteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingInviteReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MeetingListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingListReqCall(self, request_opts=request_opts)

    def set_host(self, body, user_access_token=None, timeout=None):
        # type: (MeetingSetHostReqBody, str, int) -> MeetingSetHostReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingSetHostReqCall(self, body, request_opts=request_opts)

    def end(self, user_access_token=None, timeout=None):
        # type: (str, int) -> MeetingEndReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingEndReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MeetingGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MeetingGetReqCall(self, request_opts=request_opts)


class ReportService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get_top_user(self, tenant_key=None, timeout=None):
        # type: (str, int) -> ReportGetTopUserReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ReportGetTopUserReqCall(self, request_opts=request_opts)

    def get_daily(self, tenant_key=None, timeout=None):
        # type: (str, int) -> ReportGetDailyReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return ReportGetDailyReqCall(self, request_opts=request_opts)


class RoomConfigService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def query(self, tenant_key=None, timeout=None):
        # type: (str, int) -> RoomConfigQueryReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomConfigQueryReqCall(self, request_opts=request_opts)

    def set(self, body, tenant_key=None, timeout=None):
        # type: (RoomConfigSetReqBody, str, int) -> RoomConfigSetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return RoomConfigSetReqCall(self, body, request_opts=request_opts)


class ReserveService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def update(self, body, user_access_token=None, timeout=None):
        # type: (ReserveUpdateReqBody, str, int) -> ReserveUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ReserveUpdateReqCall(self, body, request_opts=request_opts)

    def apply(self, body, user_access_token=None, timeout=None):
        # type: (ReserveApplyReqBody, str, int) -> ReserveApplyReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ReserveApplyReqCall(self, body, request_opts=request_opts)

    def get(self, user_access_token=None, timeout=None):
        # type: (str, int) -> ReserveGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ReserveGetReqCall(self, request_opts=request_opts)

    def get_active_meeting(self, user_access_token=None, timeout=None):
        # type: (str, int) -> ReserveGetActiveMeetingReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ReserveGetActiveMeetingReqCall(self, request_opts=request_opts)

    def delete(self, user_access_token=None, timeout=None):
        # type: (str, int) -> ReserveDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ReserveDeleteReqCall(self, request_opts=request_opts)



class RoomConfigQueryReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (RoomConfigService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_scope(self, scope):
        # type: (int) -> RoomConfigQueryReqCall
        self.query_params['scope'] = scope
        return self

    def set_country_id(self, countryId):
        # type: (int) -> RoomConfigQueryReqCall
        self.query_params['country_id'] = countryId
        return self

    def set_district_id(self, districtId):
        # type: (int) -> RoomConfigQueryReqCall
        self.query_params['district_id'] = districtId
        return self

    def set_building_id(self, buildingId):
        # type: (int) -> RoomConfigQueryReqCall
        self.query_params['building_id'] = buildingId
        return self

    def set_floor_name(self, floorName):
        # type: (str) -> RoomConfigQueryReqCall
        self.query_params['floor_name'] = floorName
        return self

    def set_room_id(self, roomId):
        # type: (int) -> RoomConfigQueryReqCall
        self.query_params['room_id'] = roomId
        return self

    def do(self):
        # type: () -> Response[RoomConfig]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/room_configs/query', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=RoomConfig, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingInviteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MeetingService, MeetingInviteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingInviteReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> MeetingInviteReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[MeetingInviteResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/meetings/:meeting_id/invite', 'PATCH', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=MeetingInviteResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MeetingService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_room_id(self, roomId):
        # type: (int) -> MeetingListReqCall
        self.query_params['room_id'] = roomId
        return self

    def set_start_time(self, startTime):
        # type: (int) -> MeetingListReqCall
        self.query_params['start_time'] = startTime
        return self

    def set_end_time(self, endTime):
        # type: (int) -> MeetingListReqCall
        self.query_params['end_time'] = endTime
        return self

    def set_status(self, status):
        # type: (int) -> MeetingListReqCall
        self.query_params['status'] = status
        return self

    def set_page_token(self, pageToken):
        # type: (str) -> MeetingListReqCall
        self.query_params['page_token'] = pageToken
        return self

    def set_page_size(self, pageSize):
        # type: (int) -> MeetingListReqCall
        self.query_params['page_size'] = pageSize
        return self

    def do(self):
        # type: () -> Response[MeetingListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/meetings', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MeetingListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReportGetTopUserReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ReportService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_start_time(self, startTime):
        # type: (int) -> ReportGetTopUserReqCall
        self.query_params['start_time'] = startTime
        return self

    def set_end_time(self, endTime):
        # type: (int) -> ReportGetTopUserReqCall
        self.query_params['end_time'] = endTime
        return self

    def set_limit(self, limit):
        # type: (int) -> ReportGetTopUserReqCall
        self.query_params['limit'] = limit
        return self

    def set_order_by(self, orderBy):
        # type: (int) -> ReportGetTopUserReqCall
        self.query_params['order_by'] = orderBy
        return self

    def do(self):
        # type: () -> Response[ReportGetTopUserResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/reports/get_top_user', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ReportGetTopUserResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingSetHostReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MeetingService, MeetingSetHostReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingSetHostReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> MeetingSetHostReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[MeetingSetHostResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/meetings/:meeting_id/set_host', 'PATCH', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=MeetingSetHostResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingRecordingGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MeetingRecordingService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingRecordingGetReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def do(self):
        # type: () -> Response[MeetingRecordingGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('vc/v1/meetings/:meeting_id/recording', 'GET', [ACCESS_TOKEN_TYPE_USER],
                      None, output_class=MeetingRecordingGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingEndReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MeetingService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingEndReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('vc/v1/meetings/:meeting_id/end', 'PATCH', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingRecordingStopReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MeetingRecordingService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingRecordingStopReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('vc/v1/meetings/:meeting_id/recording/stop', 'PATCH', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReportGetDailyReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ReportService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_start_time(self, startTime):
        # type: (int) -> ReportGetDailyReqCall
        self.query_params['start_time'] = startTime
        return self

    def set_end_time(self, endTime):
        # type: (int) -> ReportGetDailyReqCall
        self.query_params['end_time'] = endTime
        return self

    def do(self):
        # type: () -> Response[ReportGetDailyResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/reports/get_daily', 'GET', [ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=ReportGetDailyResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MeetingService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingGetReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def set_with_participants(self, withParticipants):
        # type: (bool) -> MeetingGetReqCall
        self.query_params['with_participants'] = withParticipants
        return self

    def set_with_meeting_ability(self, withMeetingAbility):
        # type: (bool) -> MeetingGetReqCall
        self.query_params['with_meeting_ability'] = withMeetingAbility
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> MeetingGetReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[MeetingGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/meetings/:meeting_id', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=MeetingGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class RoomConfigSetReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (RoomConfigService, RoomConfigSetReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('vc/v1/room_configs/set', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingRecordingSetPermissionReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MeetingRecordingService, MeetingRecordingSetPermissionReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingRecordingSetPermissionReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> MeetingRecordingSetPermissionReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/meetings/:meeting_id/recording/set_permission', 'PATCH', [ACCESS_TOKEN_TYPE_USER],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MeetingRecordingStartReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MeetingRecordingService, MeetingRecordingStartReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_meeting_id(self, meetingId):
        # type: (int) -> MeetingRecordingStartReqCall
        self.path_params['meeting_id'] = meetingId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('vc/v1/meetings/:meeting_id/recording/start', 'PATCH', [ACCESS_TOKEN_TYPE_USER],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReserveUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ReserveService, ReserveUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_reserve_id(self, reserveId):
        # type: (int) -> ReserveUpdateReqCall
        self.path_params['reserve_id'] = reserveId
        return self

    def set_user_id_type(self, userIdType):
        # type: (str) -> ReserveUpdateReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[ReserveUpdateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/reserves/:reserve_id', 'PUT', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=ReserveUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReserveApplyReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ReserveService, ReserveApplyReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, userIdType):
        # type: (str) -> ReserveApplyReqCall
        self.query_params['user_id_type'] = userIdType
        return self

    def do(self):
        # type: () -> Response[ReserveApplyResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/reserves/apply', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=ReserveApplyResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReserveGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ReserveService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_reserve_id(self, reserveId):
        # type: (int) -> ReserveGetReqCall
        self.path_params['reserve_id'] = reserveId
        return self

    def do(self):
        # type: () -> Response[ReserveGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('vc/v1/reserves/:reserve_id', 'GET', [ACCESS_TOKEN_TYPE_USER],
                      None, output_class=ReserveGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReserveGetActiveMeetingReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ReserveService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_reserve_id(self, reserveId):
        # type: (int) -> ReserveGetActiveMeetingReqCall
        self.path_params['reserve_id'] = reserveId
        return self

    def set_with_participants(self, withParticipants):
        # type: (bool) -> ReserveGetActiveMeetingReqCall
        self.query_params['with_participants'] = withParticipants
        return self

    def do(self):
        # type: () -> Response[ReserveGetActiveMeetingResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('vc/v1/reserves/:reserve_id/get_active_meeting', 'GET', [ACCESS_TOKEN_TYPE_USER],
                      None, output_class=ReserveGetActiveMeetingResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ReserveDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ReserveService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_reserve_id(self, reserveId):
        # type: (int) -> ReserveDeleteReqCall
        self.path_params['reserve_id'] = reserveId
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('vc/v1/reserves/:reserve_id', 'DELETE', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

