# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.files = FileService(self)
        self.medias = MediaService(self)
        



class FileService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def upload_all(self, user_access_token=None, timeout=None):
        # type: (str, int) -> FileUploadAllReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadAllReqCall(self, request_opts=request_opts)

    def upload_finish(self, body, user_access_token=None, timeout=None):
        # type: (FileUploadFinishReqBody, str, int) -> FileUploadFinishReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadFinishReqCall(self, body, request_opts=request_opts)

    def upload_part(self, user_access_token=None, timeout=None):
        # type: (str, int) -> FileUploadPartReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadPartReqCall(self, request_opts=request_opts)

    def upload_prepare(self, body, user_access_token=None, timeout=None):
        # type: (UploadInfo, str, int) -> FileUploadPrepareReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadPrepareReqCall(self, body, request_opts=request_opts)


class MediaService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def batch_get_tmp_download_url(self, user_access_token=None, timeout=None):
        # type: (str, int) -> MediaBatchGetTmpDownloadUrlReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaBatchGetTmpDownloadUrlReqCall(self, request_opts=request_opts)

    def upload_all(self, user_access_token=None, timeout=None):
        # type: (str, int) -> MediaUploadAllReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadAllReqCall(self, request_opts=request_opts)

    def upload_finish(self, body, user_access_token=None, timeout=None):
        # type: (MediaUploadFinishReqBody, str, int) -> MediaUploadFinishReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadFinishReqCall(self, body, request_opts=request_opts)

    def upload_part(self, user_access_token=None, timeout=None):
        # type: (str, int) -> MediaUploadPartReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadPartReqCall(self, request_opts=request_opts)

    def upload_prepare(self, body, user_access_token=None, timeout=None):
        # type: (UploadInfo, str, int) -> MediaUploadPrepareReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadPrepareReqCall(self, body, request_opts=request_opts)



class MediaBatchGetTmpDownloadUrlReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_tokens(self, fileTokens):
        # type: (List[str]) -> MediaBatchGetTmpDownloadUrlReqCall
        self.query_params['file_tokens'] = fileTokens
        return self

    def do(self):
        # type: () -> Response[MediaBatchGetTmpDownloadUrlResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('drive/v1/medias/batch_get_tmp_download_url', 'GET', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadAllReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_name(self, fileName):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('file_name', fileName)
        return self

    def set_parent_type(self, parentType):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('parent_type', parentType)
        return self

    def set_parent_node(self, parentNode):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('parent_node', parentNode)
        return self

    def set_size(self, size):
        # type: (int) -> MediaUploadAllReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> MediaUploadAllReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> Response[MediaUploadAllResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/medias/upload_all', 'POST', [ACCESS_TOKEN_TYPE_USER], self.body,  output_class=MediaUploadAllResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadAllReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_name(self, fileName):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('file_name', fileName)
        return self

    def set_parent_type(self, parentType):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('parent_type', parentType)
        return self

    def set_parent_node(self, parentNode):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('parent_node', parentNode)
        return self

    def set_size(self, size):
        # type: (int) -> FileUploadAllReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> FileUploadAllReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> Response[FileUploadAllResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/files/upload_all', 'POST', [ACCESS_TOKEN_TYPE_USER], self.body,  output_class=FileUploadAllResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadFinishReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileService, FileUploadFinishReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[FileUploadFinishResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/files/upload_finish', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=FileUploadFinishResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadFinishReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MediaService, MediaUploadFinishReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[MediaUploadFinishResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/medias/upload_finish', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=MediaUploadFinishResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadPartReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_upload_id(self, uploadId):
        # type: (str) -> FileUploadPartReqCall
        self.body.add_param('upload_id', uploadId)
        return self

    def set_seq(self, seq):
        # type: (int) -> FileUploadPartReqCall
        self.body.add_param('seq', seq)
        return self

    def set_size(self, size):
        # type: (int) -> FileUploadPartReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> FileUploadPartReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> FileUploadPartReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/files/upload_part', 'POST', [ACCESS_TOKEN_TYPE_USER], self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadPartReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_upload_id(self, uploadId):
        # type: (str) -> MediaUploadPartReqCall
        self.body.add_param('upload_id', uploadId)
        return self

    def set_seq(self, seq):
        # type: (int) -> MediaUploadPartReqCall
        self.body.add_param('seq', seq)
        return self

    def set_size(self, size):
        # type: (int) -> MediaUploadPartReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> MediaUploadPartReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> MediaUploadPartReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/medias/upload_part', 'POST', [ACCESS_TOKEN_TYPE_USER], self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadPrepareReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileService, UploadInfo, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[FileUploadPrepareResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/files/upload_prepare', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=FileUploadPrepareResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadPrepareReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MediaService, UploadInfo, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[MediaUploadPrepareResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('drive/v1/medias/upload_prepare', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=MediaUploadPrepareResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

