# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request, Response, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.calendars = CalendarService(self)
        self.calendar_acls = CalendarAclService(self)
        self.calendar_events = CalendarEventService(self)
        self.calendar_event_attendees = CalendarEventAttendeeService(self)
        self.freebusys = FreebusyService(self)
        self.timeoff_events = TimeoffEventService(self)
        self.settings = SettingService(self)
        self.calendar_event_attendee_chat_members = CalendarEventAttendeeChatMemberService(self)
        



class CalendarService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (Calendar, str, str, int) -> CalendarCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarCreateReqCall(self, body, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (Calendar, str, str, int) -> CalendarPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarPatchReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarDeleteReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarListReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarGetReqCall(self, request_opts=request_opts)

    def search(self, body, tenant_key=None, timeout=None):
        # type: (CalendarSearchReqBody, str, int) -> CalendarSearchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return CalendarSearchReqCall(self, body, request_opts=request_opts)

    def unsubscribe(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarUnsubscribeReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarUnsubscribeReqCall(self, request_opts=request_opts)

    def subscribe(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarSubscribeReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarSubscribeReqCall(self, request_opts=request_opts)

    def subscription(self, user_access_token=None, timeout=None):
        # type: (str, int) -> CalendarSubscriptionReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarSubscriptionReqCall(self, request_opts=request_opts)


class CalendarAclService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarAclListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarAclListReqCall(self, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarAclDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarAclDeleteReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (CalendarAcl, str, str, int) -> CalendarAclCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarAclCreateReqCall(self, body, request_opts=request_opts)

    def subscription(self, user_access_token=None, timeout=None):
        # type: (str, int) -> CalendarAclSubscriptionReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarAclSubscriptionReqCall(self, request_opts=request_opts)


class CalendarEventService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarEventDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventDeleteReqCall(self, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarEventGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventGetReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (CalendarEvent, str, str, int) -> CalendarEventCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventCreateReqCall(self, body, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarEventListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventListReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (CalendarEvent, str, str, int) -> CalendarEventPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventPatchReqCall(self, body, request_opts=request_opts)

    def search(self, body, user_access_token=None, timeout=None):
        # type: (CalendarEventSearchReqBody, str, int) -> CalendarEventSearchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventSearchReqCall(self, body, request_opts=request_opts)

    def subscription(self, user_access_token=None, timeout=None):
        # type: (str, int) -> CalendarEventSubscriptionReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventSubscriptionReqCall(self, request_opts=request_opts)


class CalendarEventAttendeeService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarEventAttendeeListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventAttendeeListReqCall(self, request_opts=request_opts)

    def batch_delete(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (CalendarEventAttendeeBatchDeleteReqBody, str, str, int) -> CalendarEventAttendeeBatchDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventAttendeeBatchDeleteReqCall(self, body, request_opts=request_opts)

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (CalendarEventAttendeeCreateReqBody, str, str, int) -> CalendarEventAttendeeCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventAttendeeCreateReqCall(self, body, request_opts=request_opts)


class FreebusyService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, body, tenant_key=None, timeout=None):
        # type: (FreebusyListReqBody, str, int) -> FreebusyListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return FreebusyListReqCall(self, body, request_opts=request_opts)


class TimeoffEventService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def delete(self, tenant_key=None, timeout=None):
        # type: (str, int) -> TimeoffEventDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return TimeoffEventDeleteReqCall(self, request_opts=request_opts)

    def create(self, body, tenant_key=None, timeout=None):
        # type: (TimeoffEvent, str, int) -> TimeoffEventCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        return TimeoffEventCreateReqCall(self, body, request_opts=request_opts)


class SettingService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def generate_caldav_conf(self, body, user_access_token=None, timeout=None):
        # type: (SettingGenerateCaldavConfReqBody, str, int) -> SettingGenerateCaldavConfReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return SettingGenerateCaldavConfReqCall(self, body, request_opts=request_opts)


class CalendarEventAttendeeChatMemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> CalendarEventAttendeeChatMemberListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return CalendarEventAttendeeChatMemberListReqCall(self, request_opts=request_opts)



class CalendarCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarService, Calendar, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[CalendarCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('calendar/v4/calendars', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarEventService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventDeleteReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventDeleteReqCall
        self.path_params['event_id'] = event_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarEventService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventGetReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventGetReqCall
        self.path_params['event_id'] = event_id
        return self

    def do(self):
        # type: () -> Response[CalendarEventGetResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=CalendarEventGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarService, Calendar, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarPatchReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[CalendarPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarDeleteReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarAclListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarAclService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarAclListReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> CalendarAclListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> CalendarAclListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> CalendarAclListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[CalendarAclListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/acls', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=CalendarAclListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarAclDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarAclService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarAclDeleteReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_acl_id(self, acl_id):
        # type: (str) -> CalendarAclDeleteReqCall
        self.path_params['acl_id'] = acl_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/acls/:acl_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarEventService, CalendarEvent, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventCreateReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[CalendarEventCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarEventCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarAclCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarAclService, CalendarAcl, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarAclCreateReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> CalendarAclCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[CalendarAcl]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/acls', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarAcl, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_page_size(self, page_size):
        # type: (int) -> CalendarListReqCall
        self.query_params['page_size'] = page_size
        return self

    def set_page_token(self, page_token):
        # type: (str) -> CalendarListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_sync_token(self, sync_token):
        # type: (str) -> CalendarListReqCall
        self.query_params['sync_token'] = sync_token
        return self

    def do(self):
        # type: () -> Response[CalendarListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=CalendarListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventAttendeeListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarEventAttendeeService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventAttendeeListReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventAttendeeListReqCall
        self.path_params['event_id'] = event_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> CalendarEventAttendeeListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> CalendarEventAttendeeListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> CalendarEventAttendeeListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[CalendarEventAttendeeListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id/attendees', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=CalendarEventAttendeeListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventAttendeeBatchDeleteReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarEventAttendeeService, CalendarEventAttendeeBatchDeleteReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventAttendeeBatchDeleteReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventAttendeeBatchDeleteReqCall
        self.path_params['event_id'] = event_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id/attendees/batch_delete', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventAttendeeCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarEventAttendeeService, CalendarEventAttendeeCreateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventAttendeeCreateReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventAttendeeCreateReqCall
        self.path_params['event_id'] = event_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> CalendarEventAttendeeCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[CalendarEventAttendeeCreateResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id/attendees', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarEventAttendeeCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarGetReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[Calendar]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=Calendar, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarEventService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventListReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_page_size(self, page_size):
        # type: (int) -> CalendarEventListReqCall
        self.query_params['page_size'] = page_size
        return self

    def set_page_token(self, page_token):
        # type: (str) -> CalendarEventListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_sync_token(self, sync_token):
        # type: (str) -> CalendarEventListReqCall
        self.query_params['sync_token'] = sync_token
        return self

    def do(self):
        # type: () -> Response[CalendarEventListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=CalendarEventListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarSearchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarService, CalendarSearchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_page_token(self, page_token):
        # type: (str) -> CalendarSearchReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> CalendarSearchReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[CalendarSearchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/search', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=CalendarSearchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FreebusyListReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FreebusyService, FreebusyListReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> FreebusyListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[FreebusyListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/freebusy/list', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=FreebusyListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarEventService, CalendarEvent, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventPatchReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventPatchReqCall
        self.path_params['event_id'] = event_id
        return self

    def do(self):
        # type: () -> Response[CalendarEventPatchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarEventPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class TimeoffEventDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (TimeoffEventService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_timeoff_event_id(self, timeoff_event_id):
        # type: (str) -> TimeoffEventDeleteReqCall
        self.path_params['timeoff_event_id'] = timeoff_event_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/timeoff_events/:timeoff_event_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class TimeoffEventCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (TimeoffEventService, TimeoffEvent, List[Any]) -> None

        self.service = service
        self.body = body
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_user_id_type(self, user_id_type):
        # type: (str) -> TimeoffEventCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> Response[TimeoffEvent]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/timeoff_events', 'POST', [ACCESS_TOKEN_TYPE_TENANT],
                      self.body, output_class=TimeoffEvent, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarUnsubscribeReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarUnsubscribeReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/unsubscribe', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventSearchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (CalendarEventService, CalendarEventSearchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventSearchReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> CalendarEventSearchReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_page_token(self, page_token):
        # type: (str) -> CalendarEventSearchReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> CalendarEventSearchReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[CalendarEventSearchResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/search', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=CalendarEventSearchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarSubscribeReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarSubscribeReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[CalendarSubscribeResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/subscribe', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                      None, output_class=CalendarSubscribeResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class SettingGenerateCaldavConfReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (SettingService, SettingGenerateCaldavConfReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[SettingGenerateCaldavConfResult]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('calendar/v4/settings/generate_caldav_conf', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      self.body, output_class=SettingGenerateCaldavConfResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventSubscriptionReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarEventService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventSubscriptionReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/subscription', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarSubscriptionReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarService, List[Any]) -> None

        self.service = service
        

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        req = Request('calendar/v4/calendars/subscription', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarAclSubscriptionReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarAclService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarAclSubscriptionReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def do(self):
        # type: () -> Response[None]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = Request('calendar/v4/calendars/:calendar_id/acls/subscription', 'POST', [ACCESS_TOKEN_TYPE_USER],
                      None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class CalendarEventAttendeeChatMemberListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (CalendarEventAttendeeChatMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_calendar_id(self, calendar_id):
        # type: (str) -> CalendarEventAttendeeChatMemberListReqCall
        self.path_params['calendar_id'] = calendar_id
        return self

    def set_event_id(self, event_id):
        # type: (str) -> CalendarEventAttendeeChatMemberListReqCall
        self.path_params['event_id'] = event_id
        return self

    def set_attendee_id(self, attendee_id):
        # type: (str) -> CalendarEventAttendeeChatMemberListReqCall
        self.path_params['attendee_id'] = attendee_id
        return self

    def set_page_token(self, page_token):
        # type: (str) -> CalendarEventAttendeeChatMemberListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> CalendarEventAttendeeChatMemberListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> Response[CalendarEventAttendeeChatMemberListResult]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = Request('calendar/v4/calendars/:calendar_id/events/:event_id/attendees/:attendee_id/chat_members', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                      None, output_class=CalendarEventAttendeeChatMemberListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

