# **数据挖掘平台算法通用模块**
统一的取数（不同维度的sql取数）、写数功能（接口写数、hbase写数）

## **功能**
- 取数
  - 供应协同
    - [x] 渠道
    - [x] 店铺
    - [x] 类目
    - [x] 商品
  - 智能运营
    - [x] 店铺前后端口径
    - [x] 会员前后端口径
    - [x] 店铺类目前后端口径
    - [ ] ...
- 写数
  - 供应协同
    - [x] 模型管理表接口调用
    - [x] 树形结构表接口调用
    - [x] hbase写数
  - 智能运营
    - [x] 模型管理表接口调用
    - [ ] 树形结构表接口调用（暂不确定是否适用）
    - [ ] hbase写数（暂不确定是否适用）

## **项目结构**
- dm-platform-utils
  - LISENCE.md
  - README.md
  - setup.py
  - src
    - \_\_init\_\_.py
    - dm_platform_utils
      - conf
        - process_dtypes.yml
        - raw_sql.yml
        - sql.yml
      - \_\_init\_\_.py
      - DataLoader.py
      - DataWriter.py
      - utils.py
  - tests
    - \_\_init\_\_.py
    - test_DataLoader.py
    - test_DataWriter.py

## **使用方法**
### **安装/更新**
```
pip install dm-platform-utils               # 安装

pip install dm-platform-utils --upgrade     # 更新
```

### **配置文件模板**
#### **DataWriter通用信息**
#### token_param, model_name, model_version, hbase, env必须存在
```
# 获取登录接口的token用
token_param:
  # 员工编号与密码
  account: xxx
  pwd: xxx
# 模型名称、模型版本，内置生成模型md5 id
model_name: xxx
model_version: v1.0.0
# hbase配置信息
hbase:
  test:
    host: 192.168.x.x
    port: 9090
    'table_name': 'pred_system:fact_alg_dm_pred_detail',
    'rowkeys_col': 'model_cd', 
    'family': 'INFO'
  prd:
    host: 192.168.x.x
    port: 9090
    'table_name': 'pred_system:fact_alg_dm_pred_detail',
    'rowkeys_col': 'model_cd', 
    'family': 'INFO'
# 环境，test or prd
env: test
```
### **示例1(读数)**
#### 目前仅支持impala/hive取数
#### 请根据conf中的sql.yml了解可读取的数据
#### ps: 供应协同与智能运营逻辑不尽相同，智能运营取数请详细查看sql.yml输入对应参数
```
# 初始化
gyxt_loader = DataLoader(
        engine='impala',
        project='gyxt',
        host=YOUR_IMPALA_IP,
        port=21050
    )
smart_oper = DataLoader(
        engine='impala',
        project='smart_operation',
        host=YOUR_IMPALA_IP,
        port=21050
    )
# 取5级维度
gyxt_loader.get_data(
        dim='fifth_dim',
        date_type='month',
        data_date='202211'
    )

# 智能运营
smart_oper.get_data(
        dim='shop_user_back',
        date_type='month',
        data_date='202211'
    )

```
### **示例2(模型管理表操作)**
#### 数据必须与下面展示的字段名称和数量一致
```
import pandas as pd
from dm_platform_utils.DataWriter import DataWriter
# 数据准备
data = pd.DataFrame({
    'model_date': ['202209', '202209'],
    'data_date': ['202210', '202211'],
    'date_type': ['3', '3'],
    'first_dim': ['1', '1'],
    'second_dim': ['14', '14'],
    'third_dim': ['tmall', 'tmall'],
    'fourth_dim': ['102', '102'],
    'fifth_dim': ['10001244', '10001244'],
    'date_diff': ['1', '2'],
    'create_time': ['2022-11-04 11:45:00', '2022-11-04 11:45:00'],
    'pred_pay_amt': ['1223123.1231', '31231231.323'],
    'pred_pay_cnt': ['231231', '3324234']
})
```
#### 基础信息表准备
#### 可使用上述模板进行yml文件配置，亦可以以下方式配置
#### token_param, model_name, model_version, hbase, env必须存在
#### 1. token_param: dict, 登录接口所需的account(员工编号)与pwd(密码), {'account': xxx, 'pwd': xxx}
#### 2. model_name: str, 模型名称
#### 3. model_version: str, 模型版本
#### 4. hbase: dict, 测试和生产环境的ip与端口, {'test': {'host': xxx, 'port': xxx, 'table_name': xxx, 'rowkeys_col': xxx, 'family': xxx}, 'prd': ...}
#### 5. env: str, 'test' or 'prd'
```
info = {
    'token_param':
        {
            'account': 'xxx',
            'pwd': 'xxx'
        },
    'model_name': 'testing1',
    'model_version': 'v1.0.1',
    'hbase':
        {
            'test': {
                'host': YOUR_TEST_HOST,
                'port': 9090,
                'table_name': 'pred_system:fact_alg_dm_pred_detail',
                'rowkeys_col': 'model_cd', 
                'family': 'INFO'
            },
            'prd': {
                'host': YOUR_PRD_HOST,
                'port': 9090,
                'table_name': 'pred_system:fact_alg_dm_pred_detail',
                'rowkeys_col': 'model_cd', 
                'family': 'INFO'
            }
        },
    'env': 'test'
}

writer = DataWriter(info=info)
```

#### 每一次初始化，DataWriter会记录info中的"model_name", "model_version"，生成对应的md5_id。
#### 自此，下面的有关模型管理表的所有insert、update操作均是对同一个模型进行（***默认***）
```
# 模型管理表数据准备
model_data = {
    'dateType': 3,
    'deployStatus': 1,
    'dimLevel': 5,
    'lastEndTime': '2022-11-04 12:15:00',
    'lastRunTime': 1800,
    'lastStartTime': '2022-11-04 11:45:00',
    'modelDesc': 'testing12345',
    'modelName': info['model_name'],
    'modelParam': json.dumps({"changepoint_prior_scale": 0.1, "seasonality_prior_scale": 1.0}),
    'modelVersion': info['model_version'],
    'modelStatus': 2
}

# 插入数据
writer.insert_model_data(data=model_data)
```

#### 模型管理表更新数据，只需要提供需要修改的字段的key-value对即可，默认为修改info提供的模型数据
#### 若希望修改其他模型数据，可传入对应的modelId
```
# 默认更新原模型数据
writer.update_model_data(data={'modelDesc': 'Hello, world!'})

# 更新其他模型数据
writer.update_model_data(data={'modelId': 'xxxxxx', 'modelDesc': 'Hello, world!'})
```

#### 在插入/更新数据前，可以先调用check_model_data函数：
#### 返回0则数据中暂无此model_cd，使用insert_model_data函数进行新数据的插入；
#### 返回1则数据中已存在此model_cd，使用update_model_data函数进行数据的更新即可
#### PS： *此为简化步骤用。insert函数没有设限，亦可进行更新操作，只是需要传入的是全部字段，比较繁琐*
```
if writer.check_model_data():
    writer.update_model_data(data=xxx)
else:
    writer.insert_model_data(data=xxx)
```
### 示例3(树形结构表操作)
```
dim_data = {
    'dmId': 'tmall_moonmall',
    'dmLevel': 3,
    'dmName': '你好',
    'dmParentId': '33'
}

dim_data_update = {
'dmId': 'tmall_moonmall',
'dmLevel': 3,
'dmName': '修改',
'dmParentId': '33'
}
```
#### 树形结构表无论是**插入数据**还是**更新数据**，都需要把完整的信息传入
#### 其中"dmId" "dmParentId"为联合主键，不可使用update操作
#### 故，update操作可修改字段为"dmLevel"与"dmName"
#### ps: 目前接口限制了GET方法返回的内容：
#### 1. 对于dmLevel==3时，只返回'tmall', 'tmall_tejia', 'tmall_moonmall', 'tmall_washking', '200288', 'pdd_zmd', 'pdd_gongxiao', 'pddwn', 'pdd_jiaju', 'pinduoduo'的数据
#### 2. 对于dm_level为4，只返回dm_parent_id为'tmall', 'tmall_tejia', 'tmall_moonmall', 'tmall_washking', '200288', 'pdd_zmd', 'pdd_gongxiao', 'pddwn', 'pdd_jiaju', 'pinduoduo'的数据
```
# 插入数据
writer.insert_dim_data(data=dim_data)

# 更新数据
writer.update_dim_data(data=dim_data_update)
```
### 示例4(hbase操作)
#### hbase部分包含数据的转化和写出两个功能。
#### 目前数据转化仅支持自动生成model_cd的MD5和填充parent_model_cd的MD5
#### 写出功能仅支持数据挖掘平台的模型结果表
```
writer.insert_forecast(
    data=data
)
```

## **开发日志**
2022-11-10  # v1.0.0
1. 完成开发与测试
2. 打包并发布

2022-11-14 # v1.0.1
1. 优化功能，调整初始化入参、hbase入参
2. 新增功能，判断模型管理表数据是否存在


2022-11-14 # v1.0.2
1. 调整文件结构

2022-11-14 # v1.0.3 ~ v1.0.8
1. 修复相对路径问题

2022-11-15 # v1.0.9
1. 调整sql参数，适配供应协同date_type
2. 取数逻辑从"包含当前月份"改为"不包含当前月份"
