# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 backend_type: Optional[pulumi.Input['InstanceBackendType']] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 current_disk_size: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input['InstanceDatabaseVersion']] = None,
                 disk_encryption_configuration: Optional[pulumi.Input['DiskEncryptionConfigurationArgs']] = None,
                 disk_encryption_status: Optional[pulumi.Input['DiskEncryptionStatusArgs']] = None,
                 failover_replica: Optional[pulumi.Input['InstanceFailoverReplicaArgs']] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input['InstanceInstanceType']] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['IpMappingArgs']]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 max_disk_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_premises_configuration: Optional[pulumi.Input['OnPremisesConfigurationArgs']] = None,
                 out_of_disk_report: Optional[pulumi.Input['SqlOutOfDiskReportArgs']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input['ReplicaConfigurationArgs']] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 scheduled_maintenance: Optional[pulumi.Input['SqlScheduledMaintenanceArgs']] = None,
                 secondary_gce_zone: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 server_ca_cert: Optional[pulumi.Input['SslCertArgs']] = None,
                 service_account_email_address: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input['SettingsArgs']] = None,
                 state: Optional[pulumi.Input['InstanceState']] = None,
                 suspension_reason: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceBackendType'] backend_type: The backend type. `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database server that is not managed by Google. This property is read-only; use the `tier` property in the `settings` object to determine the database type.
        :param pulumi.Input[str] connection_name: Connection name of the Cloud SQL instance used in connection strings.
        :param pulumi.Input[str] current_disk_size: The current disk usage of the instance in bytes. This property has been deprecated. Use the "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud Monitoring API instead. Please see [this announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ) for details.
        :param pulumi.Input['InstanceDatabaseVersion'] database_version: The database engine type and version. The `databaseVersion` field cannot be changed after instance creation.
        :param pulumi.Input['DiskEncryptionConfigurationArgs'] disk_encryption_configuration: Disk encryption configuration specific to an instance.
        :param pulumi.Input['DiskEncryptionStatusArgs'] disk_encryption_status: Disk encryption status specific to an instance.
        :param pulumi.Input['InstanceFailoverReplicaArgs'] failover_replica: The name and status of the failover replica.
        :param pulumi.Input[str] gce_zone: The Compute Engine zone that the instance is currently serving from. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary zone. WARNING: Changing this might restart the instance.
        :param pulumi.Input['InstanceInstanceType'] instance_type: The instance type.
        :param pulumi.Input[Sequence[pulumi.Input['IpMappingArgs']]] ip_addresses: The assigned IP addresses for the instance.
        :param pulumi.Input[str] kind: This is always `sql#instance`.
        :param pulumi.Input[str] master_instance_name: The name of the instance which will act as primary in the replication setup.
        :param pulumi.Input[str] max_disk_size: The maximum disk size of the instance in bytes.
        :param pulumi.Input[str] name: Name of the Cloud SQL instance. This does not include the project ID.
        :param pulumi.Input['OnPremisesConfigurationArgs'] on_premises_configuration: Configuration specific to on-premises instances.
        :param pulumi.Input['SqlOutOfDiskReportArgs'] out_of_disk_report: This field represents the report generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job
        :param pulumi.Input[str] project: The project ID of the project containing the Cloud SQL instance. The Google apps domain is prefixed if applicable.
        :param pulumi.Input[str] region: The geographical region. Can be: * `us-central` (`FIRST_GEN` instances only) * `us-central1` (`SECOND_GEN` instances only) * `asia-east1` or `europe-west1`. Defaults to `us-central` or `us-central1` depending on the instance type. The region cannot be changed after instance creation.
        :param pulumi.Input['ReplicaConfigurationArgs'] replica_configuration: Configuration specific to failover replicas and read replicas.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replica_names: The replicas of the instance.
        :param pulumi.Input[str] root_password: Initial root password. Use only on creation.
        :param pulumi.Input[bool] satisfies_pzs: The status indicating if instance satisfiesPzs. Reserved for future use.
        :param pulumi.Input['SqlScheduledMaintenanceArgs'] scheduled_maintenance: The start time of any upcoming scheduled maintenance for this instance.
        :param pulumi.Input[str] secondary_gce_zone: The Compute Engine zone that the failover instance is currently serving from for a regional instance. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary/failover zone. Reserved for future use.
        :param pulumi.Input[str] self_link: The URI of this resource.
        :param pulumi.Input['SslCertArgs'] server_ca_cert: SSL configuration.
        :param pulumi.Input[str] service_account_email_address: The service account email address assigned to the instance. \This property is read-only.
        :param pulumi.Input['SettingsArgs'] settings: The user settings.
        :param pulumi.Input['InstanceState'] state: The current serving state of the Cloud SQL instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]] suspension_reason: If the instance state is SUSPENDED, the reason for the suspension.
        """
        if backend_type is not None:
            pulumi.set(__self__, "backend_type", backend_type)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if current_disk_size is not None:
            pulumi.set(__self__, "current_disk_size", current_disk_size)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if disk_encryption_configuration is not None:
            pulumi.set(__self__, "disk_encryption_configuration", disk_encryption_configuration)
        if disk_encryption_status is not None:
            pulumi.set(__self__, "disk_encryption_status", disk_encryption_status)
        if failover_replica is not None:
            pulumi.set(__self__, "failover_replica", failover_replica)
        if gce_zone is not None:
            pulumi.set(__self__, "gce_zone", gce_zone)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if master_instance_name is not None:
            pulumi.set(__self__, "master_instance_name", master_instance_name)
        if max_disk_size is not None:
            pulumi.set(__self__, "max_disk_size", max_disk_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if on_premises_configuration is not None:
            pulumi.set(__self__, "on_premises_configuration", on_premises_configuration)
        if out_of_disk_report is not None:
            pulumi.set(__self__, "out_of_disk_report", out_of_disk_report)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_configuration is not None:
            pulumi.set(__self__, "replica_configuration", replica_configuration)
        if replica_names is not None:
            pulumi.set(__self__, "replica_names", replica_names)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if satisfies_pzs is not None:
            pulumi.set(__self__, "satisfies_pzs", satisfies_pzs)
        if scheduled_maintenance is not None:
            pulumi.set(__self__, "scheduled_maintenance", scheduled_maintenance)
        if secondary_gce_zone is not None:
            pulumi.set(__self__, "secondary_gce_zone", secondary_gce_zone)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if server_ca_cert is not None:
            pulumi.set(__self__, "server_ca_cert", server_ca_cert)
        if service_account_email_address is not None:
            pulumi.set(__self__, "service_account_email_address", service_account_email_address)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if suspension_reason is not None:
            pulumi.set(__self__, "suspension_reason", suspension_reason)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> Optional[pulumi.Input['InstanceBackendType']]:
        """
        The backend type. `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database server that is not managed by Google. This property is read-only; use the `tier` property in the `settings` object to determine the database type.
        """
        return pulumi.get(self, "backend_type")

    @backend_type.setter
    def backend_type(self, value: Optional[pulumi.Input['InstanceBackendType']]):
        pulumi.set(self, "backend_type", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Connection name of the Cloud SQL instance used in connection strings.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="currentDiskSize")
    def current_disk_size(self) -> Optional[pulumi.Input[str]]:
        """
        The current disk usage of the instance in bytes. This property has been deprecated. Use the "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud Monitoring API instead. Please see [this announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ) for details.
        """
        return pulumi.get(self, "current_disk_size")

    @current_disk_size.setter
    def current_disk_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_disk_size", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input['InstanceDatabaseVersion']]:
        """
        The database engine type and version. The `databaseVersion` field cannot be changed after instance creation.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input['InstanceDatabaseVersion']]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> Optional[pulumi.Input['DiskEncryptionConfigurationArgs']]:
        """
        Disk encryption configuration specific to an instance.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @disk_encryption_configuration.setter
    def disk_encryption_configuration(self, value: Optional[pulumi.Input['DiskEncryptionConfigurationArgs']]):
        pulumi.set(self, "disk_encryption_configuration", value)

    @property
    @pulumi.getter(name="diskEncryptionStatus")
    def disk_encryption_status(self) -> Optional[pulumi.Input['DiskEncryptionStatusArgs']]:
        """
        Disk encryption status specific to an instance.
        """
        return pulumi.get(self, "disk_encryption_status")

    @disk_encryption_status.setter
    def disk_encryption_status(self, value: Optional[pulumi.Input['DiskEncryptionStatusArgs']]):
        pulumi.set(self, "disk_encryption_status", value)

    @property
    @pulumi.getter(name="failoverReplica")
    def failover_replica(self) -> Optional[pulumi.Input['InstanceFailoverReplicaArgs']]:
        """
        The name and status of the failover replica.
        """
        return pulumi.get(self, "failover_replica")

    @failover_replica.setter
    def failover_replica(self, value: Optional[pulumi.Input['InstanceFailoverReplicaArgs']]):
        pulumi.set(self, "failover_replica", value)

    @property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone that the instance is currently serving from. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary zone. WARNING: Changing this might restart the instance.
        """
        return pulumi.get(self, "gce_zone")

    @gce_zone.setter
    def gce_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gce_zone", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input['InstanceInstanceType']]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input['InstanceInstanceType']]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpMappingArgs']]]]:
        """
        The assigned IP addresses for the instance.
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpMappingArgs']]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always `sql#instance`.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance which will act as primary in the replication setup.
        """
        return pulumi.get(self, "master_instance_name")

    @master_instance_name.setter
    def master_instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_name", value)

    @property
    @pulumi.getter(name="maxDiskSize")
    def max_disk_size(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum disk size of the instance in bytes.
        """
        return pulumi.get(self, "max_disk_size")

    @max_disk_size.setter
    def max_disk_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_disk_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud SQL instance. This does not include the project ID.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="onPremisesConfiguration")
    def on_premises_configuration(self) -> Optional[pulumi.Input['OnPremisesConfigurationArgs']]:
        """
        Configuration specific to on-premises instances.
        """
        return pulumi.get(self, "on_premises_configuration")

    @on_premises_configuration.setter
    def on_premises_configuration(self, value: Optional[pulumi.Input['OnPremisesConfigurationArgs']]):
        pulumi.set(self, "on_premises_configuration", value)

    @property
    @pulumi.getter(name="outOfDiskReport")
    def out_of_disk_report(self) -> Optional[pulumi.Input['SqlOutOfDiskReportArgs']]:
        """
        This field represents the report generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job
        """
        return pulumi.get(self, "out_of_disk_report")

    @out_of_disk_report.setter
    def out_of_disk_report(self, value: Optional[pulumi.Input['SqlOutOfDiskReportArgs']]):
        pulumi.set(self, "out_of_disk_report", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The project ID of the project containing the Cloud SQL instance. The Google apps domain is prefixed if applicable.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The geographical region. Can be: * `us-central` (`FIRST_GEN` instances only) * `us-central1` (`SECOND_GEN` instances only) * `asia-east1` or `europe-west1`. Defaults to `us-central` or `us-central1` depending on the instance type. The region cannot be changed after instance creation.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> Optional[pulumi.Input['ReplicaConfigurationArgs']]:
        """
        Configuration specific to failover replicas and read replicas.
        """
        return pulumi.get(self, "replica_configuration")

    @replica_configuration.setter
    def replica_configuration(self, value: Optional[pulumi.Input['ReplicaConfigurationArgs']]):
        pulumi.set(self, "replica_configuration", value)

    @property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The replicas of the instance.
        """
        return pulumi.get(self, "replica_names")

    @replica_names.setter
    def replica_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "replica_names", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[str]]:
        """
        Initial root password. Use only on creation.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> Optional[pulumi.Input[bool]]:
        """
        The status indicating if instance satisfiesPzs. Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @satisfies_pzs.setter
    def satisfies_pzs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "satisfies_pzs", value)

    @property
    @pulumi.getter(name="scheduledMaintenance")
    def scheduled_maintenance(self) -> Optional[pulumi.Input['SqlScheduledMaintenanceArgs']]:
        """
        The start time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "scheduled_maintenance")

    @scheduled_maintenance.setter
    def scheduled_maintenance(self, value: Optional[pulumi.Input['SqlScheduledMaintenanceArgs']]):
        pulumi.set(self, "scheduled_maintenance", value)

    @property
    @pulumi.getter(name="secondaryGceZone")
    def secondary_gce_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The Compute Engine zone that the failover instance is currently serving from for a regional instance. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary/failover zone. Reserved for future use.
        """
        return pulumi.get(self, "secondary_gce_zone")

    @secondary_gce_zone.setter
    def secondary_gce_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_gce_zone", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serverCaCert")
    def server_ca_cert(self) -> Optional[pulumi.Input['SslCertArgs']]:
        """
        SSL configuration.
        """
        return pulumi.get(self, "server_ca_cert")

    @server_ca_cert.setter
    def server_ca_cert(self, value: Optional[pulumi.Input['SslCertArgs']]):
        pulumi.set(self, "server_ca_cert", value)

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> Optional[pulumi.Input[str]]:
        """
        The service account email address assigned to the instance. \This property is read-only.
        """
        return pulumi.get(self, "service_account_email_address")

    @service_account_email_address.setter
    def service_account_email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email_address", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['SettingsArgs']]:
        """
        The user settings.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['SettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input['InstanceState']]:
        """
        The current serving state of the Cloud SQL instance.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input['InstanceState']]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="suspensionReason")
    def suspension_reason(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]]]:
        """
        If the instance state is SUSPENDED, the reason for the suspension.
        """
        return pulumi.get(self, "suspension_reason")

    @suspension_reason.setter
    def suspension_reason(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]]]):
        pulumi.set(self, "suspension_reason", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_type: Optional[pulumi.Input['InstanceBackendType']] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 current_disk_size: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input['InstanceDatabaseVersion']] = None,
                 disk_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']]] = None,
                 disk_encryption_status: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']]] = None,
                 failover_replica: Optional[pulumi.Input[pulumi.InputType['InstanceFailoverReplicaArgs']]] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input['InstanceInstanceType']] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpMappingArgs']]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 max_disk_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_premises_configuration: Optional[pulumi.Input[pulumi.InputType['OnPremisesConfigurationArgs']]] = None,
                 out_of_disk_report: Optional[pulumi.Input[pulumi.InputType['SqlOutOfDiskReportArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input[pulumi.InputType['ReplicaConfigurationArgs']]] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 scheduled_maintenance: Optional[pulumi.Input[pulumi.InputType['SqlScheduledMaintenanceArgs']]] = None,
                 secondary_gce_zone: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 server_ca_cert: Optional[pulumi.Input[pulumi.InputType['SslCertArgs']]] = None,
                 service_account_email_address: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[pulumi.InputType['SettingsArgs']]] = None,
                 state: Optional[pulumi.Input['InstanceState']] = None,
                 suspension_reason: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]]] = None,
                 __props__=None):
        """
        Creates a new Cloud SQL instance.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['InstanceBackendType'] backend_type: The backend type. `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database server that is not managed by Google. This property is read-only; use the `tier` property in the `settings` object to determine the database type.
        :param pulumi.Input[str] connection_name: Connection name of the Cloud SQL instance used in connection strings.
        :param pulumi.Input[str] current_disk_size: The current disk usage of the instance in bytes. This property has been deprecated. Use the "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud Monitoring API instead. Please see [this announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ) for details.
        :param pulumi.Input['InstanceDatabaseVersion'] database_version: The database engine type and version. The `databaseVersion` field cannot be changed after instance creation.
        :param pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']] disk_encryption_configuration: Disk encryption configuration specific to an instance.
        :param pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']] disk_encryption_status: Disk encryption status specific to an instance.
        :param pulumi.Input[pulumi.InputType['InstanceFailoverReplicaArgs']] failover_replica: The name and status of the failover replica.
        :param pulumi.Input[str] gce_zone: The Compute Engine zone that the instance is currently serving from. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary zone. WARNING: Changing this might restart the instance.
        :param pulumi.Input['InstanceInstanceType'] instance_type: The instance type.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpMappingArgs']]]] ip_addresses: The assigned IP addresses for the instance.
        :param pulumi.Input[str] kind: This is always `sql#instance`.
        :param pulumi.Input[str] master_instance_name: The name of the instance which will act as primary in the replication setup.
        :param pulumi.Input[str] max_disk_size: The maximum disk size of the instance in bytes.
        :param pulumi.Input[str] name: Name of the Cloud SQL instance. This does not include the project ID.
        :param pulumi.Input[pulumi.InputType['OnPremisesConfigurationArgs']] on_premises_configuration: Configuration specific to on-premises instances.
        :param pulumi.Input[pulumi.InputType['SqlOutOfDiskReportArgs']] out_of_disk_report: This field represents the report generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job
        :param pulumi.Input[str] project: The project ID of the project containing the Cloud SQL instance. The Google apps domain is prefixed if applicable.
        :param pulumi.Input[str] region: The geographical region. Can be: * `us-central` (`FIRST_GEN` instances only) * `us-central1` (`SECOND_GEN` instances only) * `asia-east1` or `europe-west1`. Defaults to `us-central` or `us-central1` depending on the instance type. The region cannot be changed after instance creation.
        :param pulumi.Input[pulumi.InputType['ReplicaConfigurationArgs']] replica_configuration: Configuration specific to failover replicas and read replicas.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] replica_names: The replicas of the instance.
        :param pulumi.Input[str] root_password: Initial root password. Use only on creation.
        :param pulumi.Input[bool] satisfies_pzs: The status indicating if instance satisfiesPzs. Reserved for future use.
        :param pulumi.Input[pulumi.InputType['SqlScheduledMaintenanceArgs']] scheduled_maintenance: The start time of any upcoming scheduled maintenance for this instance.
        :param pulumi.Input[str] secondary_gce_zone: The Compute Engine zone that the failover instance is currently serving from for a regional instance. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary/failover zone. Reserved for future use.
        :param pulumi.Input[str] self_link: The URI of this resource.
        :param pulumi.Input[pulumi.InputType['SslCertArgs']] server_ca_cert: SSL configuration.
        :param pulumi.Input[str] service_account_email_address: The service account email address assigned to the instance. \This property is read-only.
        :param pulumi.Input[pulumi.InputType['SettingsArgs']] settings: The user settings.
        :param pulumi.Input['InstanceState'] state: The current serving state of the Cloud SQL instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]] suspension_reason: If the instance state is SUSPENDED, the reason for the suspension.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Cloud SQL instance.

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_type: Optional[pulumi.Input['InstanceBackendType']] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 current_disk_size: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input['InstanceDatabaseVersion']] = None,
                 disk_encryption_configuration: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionConfigurationArgs']]] = None,
                 disk_encryption_status: Optional[pulumi.Input[pulumi.InputType['DiskEncryptionStatusArgs']]] = None,
                 failover_replica: Optional[pulumi.Input[pulumi.InputType['InstanceFailoverReplicaArgs']]] = None,
                 gce_zone: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input['InstanceInstanceType']] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IpMappingArgs']]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 master_instance_name: Optional[pulumi.Input[str]] = None,
                 max_disk_size: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 on_premises_configuration: Optional[pulumi.Input[pulumi.InputType['OnPremisesConfigurationArgs']]] = None,
                 out_of_disk_report: Optional[pulumi.Input[pulumi.InputType['SqlOutOfDiskReportArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 replica_configuration: Optional[pulumi.Input[pulumi.InputType['ReplicaConfigurationArgs']]] = None,
                 replica_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 root_password: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 scheduled_maintenance: Optional[pulumi.Input[pulumi.InputType['SqlScheduledMaintenanceArgs']]] = None,
                 secondary_gce_zone: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 server_ca_cert: Optional[pulumi.Input[pulumi.InputType['SslCertArgs']]] = None,
                 service_account_email_address: Optional[pulumi.Input[str]] = None,
                 settings: Optional[pulumi.Input[pulumi.InputType['SettingsArgs']]] = None,
                 state: Optional[pulumi.Input['InstanceState']] = None,
                 suspension_reason: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSuspensionReasonItem']]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["backend_type"] = backend_type
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["current_disk_size"] = current_disk_size
            __props__.__dict__["database_version"] = database_version
            __props__.__dict__["disk_encryption_configuration"] = disk_encryption_configuration
            __props__.__dict__["disk_encryption_status"] = disk_encryption_status
            __props__.__dict__["failover_replica"] = failover_replica
            __props__.__dict__["gce_zone"] = gce_zone
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["ip_addresses"] = ip_addresses
            __props__.__dict__["kind"] = kind
            __props__.__dict__["master_instance_name"] = master_instance_name
            __props__.__dict__["max_disk_size"] = max_disk_size
            __props__.__dict__["name"] = name
            __props__.__dict__["on_premises_configuration"] = on_premises_configuration
            __props__.__dict__["out_of_disk_report"] = out_of_disk_report
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_configuration"] = replica_configuration
            __props__.__dict__["replica_names"] = replica_names
            __props__.__dict__["root_password"] = root_password
            __props__.__dict__["satisfies_pzs"] = satisfies_pzs
            __props__.__dict__["scheduled_maintenance"] = scheduled_maintenance
            __props__.__dict__["secondary_gce_zone"] = secondary_gce_zone
            __props__.__dict__["self_link"] = self_link
            __props__.__dict__["server_ca_cert"] = server_ca_cert
            __props__.__dict__["service_account_email_address"] = service_account_email_address
            __props__.__dict__["settings"] = settings
            __props__.__dict__["state"] = state
            __props__.__dict__["suspension_reason"] = suspension_reason
            __props__.__dict__["create_time"] = None
            __props__.__dict__["database_installed_version"] = None
        super(Instance, __self__).__init__(
            'google-native:sqladmin/v1beta4:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceArgs.__new__(InstanceArgs)

        __props__.__dict__["backend_type"] = None
        __props__.__dict__["connection_name"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["current_disk_size"] = None
        __props__.__dict__["database_installed_version"] = None
        __props__.__dict__["database_version"] = None
        __props__.__dict__["disk_encryption_configuration"] = None
        __props__.__dict__["disk_encryption_status"] = None
        __props__.__dict__["failover_replica"] = None
        __props__.__dict__["gce_zone"] = None
        __props__.__dict__["instance_type"] = None
        __props__.__dict__["ip_addresses"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["master_instance_name"] = None
        __props__.__dict__["max_disk_size"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["on_premises_configuration"] = None
        __props__.__dict__["out_of_disk_report"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["replica_configuration"] = None
        __props__.__dict__["replica_names"] = None
        __props__.__dict__["root_password"] = None
        __props__.__dict__["satisfies_pzs"] = None
        __props__.__dict__["scheduled_maintenance"] = None
        __props__.__dict__["secondary_gce_zone"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["server_ca_cert"] = None
        __props__.__dict__["service_account_email_address"] = None
        __props__.__dict__["settings"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["suspension_reason"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendType")
    def backend_type(self) -> pulumi.Output[str]:
        """
        The backend type. `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database server that is not managed by Google. This property is read-only; use the `tier` property in the `settings` object to determine the database type.
        """
        return pulumi.get(self, "backend_type")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        Connection name of the Cloud SQL instance used in connection strings.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the instance was created in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example `2012-11-15T16:19:00.094Z`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="currentDiskSize")
    def current_disk_size(self) -> pulumi.Output[str]:
        """
        The current disk usage of the instance in bytes. This property has been deprecated. Use the "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud Monitoring API instead. Please see [this announcement](https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ) for details.
        """
        return pulumi.get(self, "current_disk_size")

    @property
    @pulumi.getter(name="databaseInstalledVersion")
    def database_installed_version(self) -> pulumi.Output[str]:
        """
        Stores the current database version running on the instance including minor version such as `MYSQL_8_0_18`.
        """
        return pulumi.get(self, "database_installed_version")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The database engine type and version. The `databaseVersion` field cannot be changed after instance creation.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="diskEncryptionConfiguration")
    def disk_encryption_configuration(self) -> pulumi.Output['outputs.DiskEncryptionConfigurationResponse']:
        """
        Disk encryption configuration specific to an instance.
        """
        return pulumi.get(self, "disk_encryption_configuration")

    @property
    @pulumi.getter(name="diskEncryptionStatus")
    def disk_encryption_status(self) -> pulumi.Output['outputs.DiskEncryptionStatusResponse']:
        """
        Disk encryption status specific to an instance.
        """
        return pulumi.get(self, "disk_encryption_status")

    @property
    @pulumi.getter(name="failoverReplica")
    def failover_replica(self) -> pulumi.Output['outputs.InstanceFailoverReplicaResponse']:
        """
        The name and status of the failover replica.
        """
        return pulumi.get(self, "failover_replica")

    @property
    @pulumi.getter(name="gceZone")
    def gce_zone(self) -> pulumi.Output[str]:
        """
        The Compute Engine zone that the instance is currently serving from. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary zone. WARNING: Changing this might restart the instance.
        """
        return pulumi.get(self, "gce_zone")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> pulumi.Output[Sequence['outputs.IpMappingResponse']]:
        """
        The assigned IP addresses for the instance.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        This is always `sql#instance`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="masterInstanceName")
    def master_instance_name(self) -> pulumi.Output[str]:
        """
        The name of the instance which will act as primary in the replication setup.
        """
        return pulumi.get(self, "master_instance_name")

    @property
    @pulumi.getter(name="maxDiskSize")
    def max_disk_size(self) -> pulumi.Output[str]:
        """
        The maximum disk size of the instance in bytes.
        """
        return pulumi.get(self, "max_disk_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Cloud SQL instance. This does not include the project ID.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="onPremisesConfiguration")
    def on_premises_configuration(self) -> pulumi.Output['outputs.OnPremisesConfigurationResponse']:
        """
        Configuration specific to on-premises instances.
        """
        return pulumi.get(self, "on_premises_configuration")

    @property
    @pulumi.getter(name="outOfDiskReport")
    def out_of_disk_report(self) -> pulumi.Output['outputs.SqlOutOfDiskReportResponse']:
        """
        This field represents the report generated by the proactive database wellness job for OutOfDisk issues. * Writers: * the proactive database wellness job for OOD. * Readers: * the proactive database wellness job
        """
        return pulumi.get(self, "out_of_disk_report")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The project ID of the project containing the Cloud SQL instance. The Google apps domain is prefixed if applicable.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The geographical region. Can be: * `us-central` (`FIRST_GEN` instances only) * `us-central1` (`SECOND_GEN` instances only) * `asia-east1` or `europe-west1`. Defaults to `us-central` or `us-central1` depending on the instance type. The region cannot be changed after instance creation.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replicaConfiguration")
    def replica_configuration(self) -> pulumi.Output['outputs.ReplicaConfigurationResponse']:
        """
        Configuration specific to failover replicas and read replicas.
        """
        return pulumi.get(self, "replica_configuration")

    @property
    @pulumi.getter(name="replicaNames")
    def replica_names(self) -> pulumi.Output[Sequence[str]]:
        """
        The replicas of the instance.
        """
        return pulumi.get(self, "replica_names")

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[str]:
        """
        Initial root password. Use only on creation.
        """
        return pulumi.get(self, "root_password")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        The status indicating if instance satisfiesPzs. Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="scheduledMaintenance")
    def scheduled_maintenance(self) -> pulumi.Output['outputs.SqlScheduledMaintenanceResponse']:
        """
        The start time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "scheduled_maintenance")

    @property
    @pulumi.getter(name="secondaryGceZone")
    def secondary_gce_zone(self) -> pulumi.Output[str]:
        """
        The Compute Engine zone that the failover instance is currently serving from for a regional instance. This value could be different from the zone that was specified when the instance was created if the instance has failed over to its secondary/failover zone. Reserved for future use.
        """
        return pulumi.get(self, "secondary_gce_zone")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serverCaCert")
    def server_ca_cert(self) -> pulumi.Output['outputs.SslCertResponse']:
        """
        SSL configuration.
        """
        return pulumi.get(self, "server_ca_cert")

    @property
    @pulumi.getter(name="serviceAccountEmailAddress")
    def service_account_email_address(self) -> pulumi.Output[str]:
        """
        The service account email address assigned to the instance. \This property is read-only.
        """
        return pulumi.get(self, "service_account_email_address")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.SettingsResponse']:
        """
        The user settings.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current serving state of the Cloud SQL instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="suspensionReason")
    def suspension_reason(self) -> pulumi.Output[Sequence[str]]:
        """
        If the instance state is SUSPENDED, the reason for the suspension.
        """
        return pulumi.get(self, "suspension_reason")

