# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetCatalogItemResult',
    'AwaitableGetCatalogItemResult',
    'get_catalog_item',
    'get_catalog_item_output',
]

@pulumi.output_type
class GetCatalogItemResult:
    def __init__(__self__, category_hierarchies=None, description=None, item_attributes=None, item_group_id=None, product_metadata=None, tags=None, title=None):
        if category_hierarchies and not isinstance(category_hierarchies, list):
            raise TypeError("Expected argument 'category_hierarchies' to be a list")
        pulumi.set(__self__, "category_hierarchies", category_hierarchies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if item_attributes and not isinstance(item_attributes, dict):
            raise TypeError("Expected argument 'item_attributes' to be a dict")
        pulumi.set(__self__, "item_attributes", item_attributes)
        if item_group_id and not isinstance(item_group_id, str):
            raise TypeError("Expected argument 'item_group_id' to be a str")
        pulumi.set(__self__, "item_group_id", item_group_id)
        if product_metadata and not isinstance(product_metadata, dict):
            raise TypeError("Expected argument 'product_metadata' to be a dict")
        pulumi.set(__self__, "product_metadata", product_metadata)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if title and not isinstance(title, str):
            raise TypeError("Expected argument 'title' to be a str")
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="categoryHierarchies")
    def category_hierarchies(self) -> Sequence['outputs.GoogleCloudRecommendationengineV1beta1CatalogItemCategoryHierarchyResponse']:
        """
        Catalog item categories. This field is repeated for supporting one catalog item belonging to several parallel category hierarchies. For example, if a shoes product belongs to both ["Shoes & Accessories" -> "Shoes"] and ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be represented as: "categoryHierarchies": [ { "categories": ["Shoes & Accessories", "Shoes"]}, { "categories": ["Sports & Fitness", "Athletic Clothing", "Shoes"] } ]
        """
        return pulumi.get(self, "category_hierarchies")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Catalog item description. UTF-8 encoded string with a length limit of 5 KiB.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="itemAttributes")
    def item_attributes(self) -> 'outputs.GoogleCloudRecommendationengineV1beta1FeatureMapResponse':
        """
        Optional. Highly encouraged. Extra catalog item attributes to be included in the recommendation model. For example, for retail products, this could include the store name, vendor, style, color, etc. These are very strong signals for recommendation model, thus we highly recommend providing the item attributes here.
        """
        return pulumi.get(self, "item_attributes")

    @property
    @pulumi.getter(name="itemGroupId")
    def item_group_id(self) -> str:
        """
        Optional. Variant group identifier for prediction results. UTF-8 encoded string with a length limit of 128 bytes. This field must be enabled before it can be used. [Learn more](/recommendations-ai/docs/catalog#item-group-id).
        """
        return pulumi.get(self, "item_group_id")

    @property
    @pulumi.getter(name="productMetadata")
    def product_metadata(self) -> 'outputs.GoogleCloudRecommendationengineV1beta1ProductCatalogItemResponse':
        """
        Optional. Metadata specific to retail products.
        """
        return pulumi.get(self, "product_metadata")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Optional. Filtering tags associated with the catalog item. Each tag should be a UTF-8 encoded string with a length limit of 1 KiB. This tag can be used for filtering recommendation results by passing the tag as part of the predict request filter.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Catalog item title. UTF-8 encoded string with a length limit of 1 KiB.
        """
        return pulumi.get(self, "title")


class AwaitableGetCatalogItemResult(GetCatalogItemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogItemResult(
            category_hierarchies=self.category_hierarchies,
            description=self.description,
            item_attributes=self.item_attributes,
            item_group_id=self.item_group_id,
            product_metadata=self.product_metadata,
            tags=self.tags,
            title=self.title)


def get_catalog_item(catalog_id: Optional[str] = None,
                     catalog_item_id: Optional[str] = None,
                     location: Optional[str] = None,
                     project: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogItemResult:
    """
    Gets a specific catalog item.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    __args__['catalogItemId'] = catalog_item_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:recommendationengine/v1beta1:getCatalogItem', __args__, opts=opts, typ=GetCatalogItemResult).value

    return AwaitableGetCatalogItemResult(
        category_hierarchies=__ret__.category_hierarchies,
        description=__ret__.description,
        item_attributes=__ret__.item_attributes,
        item_group_id=__ret__.item_group_id,
        product_metadata=__ret__.product_metadata,
        tags=__ret__.tags,
        title=__ret__.title)


@_utilities.lift_output_func(get_catalog_item)
def get_catalog_item_output(catalog_id: Optional[pulumi.Input[str]] = None,
                            catalog_item_id: Optional[pulumi.Input[str]] = None,
                            location: Optional[pulumi.Input[str]] = None,
                            project: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogItemResult]:
    """
    Gets a specific catalog item.
    """
    ...
