# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetStreamResult',
    'AwaitableGetStreamResult',
    'get_stream',
    'get_stream_output',
]

@pulumi.output_type
class GetStreamResult:
    def __init__(__self__, backfill_all=None, backfill_none=None, create_time=None, customer_managed_encryption_key=None, destination_config=None, display_name=None, errors=None, labels=None, name=None, source_config=None, state=None, update_time=None):
        if backfill_all and not isinstance(backfill_all, dict):
            raise TypeError("Expected argument 'backfill_all' to be a dict")
        pulumi.set(__self__, "backfill_all", backfill_all)
        if backfill_none and not isinstance(backfill_none, dict):
            raise TypeError("Expected argument 'backfill_none' to be a dict")
        pulumi.set(__self__, "backfill_none", backfill_none)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if customer_managed_encryption_key and not isinstance(customer_managed_encryption_key, str):
            raise TypeError("Expected argument 'customer_managed_encryption_key' to be a str")
        pulumi.set(__self__, "customer_managed_encryption_key", customer_managed_encryption_key)
        if destination_config and not isinstance(destination_config, dict):
            raise TypeError("Expected argument 'destination_config' to be a dict")
        pulumi.set(__self__, "destination_config", destination_config)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if errors and not isinstance(errors, list):
            raise TypeError("Expected argument 'errors' to be a list")
        pulumi.set(__self__, "errors", errors)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if source_config and not isinstance(source_config, dict):
            raise TypeError("Expected argument 'source_config' to be a dict")
        pulumi.set(__self__, "source_config", source_config)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="backfillAll")
    def backfill_all(self) -> 'outputs.BackfillAllStrategyResponse':
        """
        Automatically backfill objects included in the stream source configuration. Specific objects can be excluded.
        """
        return pulumi.get(self, "backfill_all")

    @property
    @pulumi.getter(name="backfillNone")
    def backfill_none(self) -> 'outputs.BackfillNoneStrategyResponse':
        """
        Do not automatically backfill any objects.
        """
        return pulumi.get(self, "backfill_none")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the stream.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customerManagedEncryptionKey")
    def customer_managed_encryption_key(self) -> str:
        """
        Immutable. A reference to a KMS encryption key. If provided, it will be used to encrypt the data. If left blank, data will be encrypted using an internal Stream-specific encryption key provisioned through KMS.
        """
        return pulumi.get(self, "customer_managed_encryption_key")

    @property
    @pulumi.getter(name="destinationConfig")
    def destination_config(self) -> 'outputs.DestinationConfigResponse':
        """
        Destination connection profile configuration.
        """
        return pulumi.get(self, "destination_config")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.ErrorResponse']:
        """
        Errors on the Stream.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The stream's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> 'outputs.SourceConfigResponse':
        """
        Source connection profile configuration.
        """
        return pulumi.get(self, "source_config")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the stream.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The last update time of the stream.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetStreamResult(GetStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamResult(
            backfill_all=self.backfill_all,
            backfill_none=self.backfill_none,
            create_time=self.create_time,
            customer_managed_encryption_key=self.customer_managed_encryption_key,
            destination_config=self.destination_config,
            display_name=self.display_name,
            errors=self.errors,
            labels=self.labels,
            name=self.name,
            source_config=self.source_config,
            state=self.state,
            update_time=self.update_time)


def get_stream(location: Optional[str] = None,
               project: Optional[str] = None,
               stream_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamResult:
    """
    Use this method to get details about a stream.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['project'] = project
    __args__['streamId'] = stream_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:datastream/v1:getStream', __args__, opts=opts, typ=GetStreamResult).value

    return AwaitableGetStreamResult(
        backfill_all=__ret__.backfill_all,
        backfill_none=__ret__.backfill_none,
        create_time=__ret__.create_time,
        customer_managed_encryption_key=__ret__.customer_managed_encryption_key,
        destination_config=__ret__.destination_config,
        display_name=__ret__.display_name,
        errors=__ret__.errors,
        labels=__ret__.labels,
        name=__ret__.name,
        source_config=__ret__.source_config,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_stream)
def get_stream_output(location: Optional[pulumi.Input[str]] = None,
                      project: Optional[pulumi.Input[Optional[str]]] = None,
                      stream_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStreamResult]:
    """
    Use this method to get details about a stream.
    """
    ...
