# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetPhraseMatcherResult',
    'AwaitableGetPhraseMatcherResult',
    'get_phrase_matcher',
    'get_phrase_matcher_output',
]

@pulumi.output_type
class GetPhraseMatcherResult:
    def __init__(__self__, activation_update_time=None, active=None, display_name=None, name=None, phrase_match_rule_groups=None, revision_create_time=None, revision_id=None, role_match=None, type=None, update_time=None, version_tag=None):
        if activation_update_time and not isinstance(activation_update_time, str):
            raise TypeError("Expected argument 'activation_update_time' to be a str")
        pulumi.set(__self__, "activation_update_time", activation_update_time)
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if phrase_match_rule_groups and not isinstance(phrase_match_rule_groups, list):
            raise TypeError("Expected argument 'phrase_match_rule_groups' to be a list")
        pulumi.set(__self__, "phrase_match_rule_groups", phrase_match_rule_groups)
        if revision_create_time and not isinstance(revision_create_time, str):
            raise TypeError("Expected argument 'revision_create_time' to be a str")
        pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)
        if role_match and not isinstance(role_match, str):
            raise TypeError("Expected argument 'role_match' to be a str")
        pulumi.set(__self__, "role_match", role_match)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if version_tag and not isinstance(version_tag, str):
            raise TypeError("Expected argument 'version_tag' to be a str")
        pulumi.set(__self__, "version_tag", version_tag)

    @property
    @pulumi.getter(name="activationUpdateTime")
    def activation_update_time(self) -> str:
        """
        The most recent time at which the activation status was updated.
        """
        return pulumi.get(self, "activation_update_time")

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        Applies the phrase matcher only when it is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name of the phrase matcher.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the phrase matcher. Format: projects/{project}/locations/{location}/phraseMatchers/{phrase_matcher}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="phraseMatchRuleGroups")
    def phrase_match_rule_groups(self) -> Sequence['outputs.GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupResponse']:
        """
        A list of phase match rule groups that are included in this matcher.
        """
        return pulumi.get(self, "phrase_match_rule_groups")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> str:
        """
        The timestamp of when the revision was created. It is also the create time when a new matcher is added.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Immutable. The revision ID of the phrase matcher. A new revision is committed whenever the matcher is changed, except when it is activated or deactivated. A server generated random ID will be used. Example: locations/global/phraseMatchers/my-first-matcher@1234567
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter(name="roleMatch")
    def role_match(self) -> str:
        """
        The role whose utterances the phrase matcher should be matched against. If the role is ROLE_UNSPECIFIED it will be matched against any utterances in the transcript.
        """
        return pulumi.get(self, "role_match")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this phrase matcher.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The most recent time at which the phrase matcher was updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="versionTag")
    def version_tag(self) -> str:
        """
        The customized version tag to use for the phrase matcher. If not specified, it will default to `revision_id`.
        """
        return pulumi.get(self, "version_tag")


class AwaitableGetPhraseMatcherResult(GetPhraseMatcherResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPhraseMatcherResult(
            activation_update_time=self.activation_update_time,
            active=self.active,
            display_name=self.display_name,
            name=self.name,
            phrase_match_rule_groups=self.phrase_match_rule_groups,
            revision_create_time=self.revision_create_time,
            revision_id=self.revision_id,
            role_match=self.role_match,
            type=self.type,
            update_time=self.update_time,
            version_tag=self.version_tag)


def get_phrase_matcher(location: Optional[str] = None,
                       phrase_matcher_id: Optional[str] = None,
                       project: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPhraseMatcherResult:
    """
    Gets a phrase matcher.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['phraseMatcherId'] = phrase_matcher_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:contactcenterinsights/v1:getPhraseMatcher', __args__, opts=opts, typ=GetPhraseMatcherResult).value

    return AwaitableGetPhraseMatcherResult(
        activation_update_time=__ret__.activation_update_time,
        active=__ret__.active,
        display_name=__ret__.display_name,
        name=__ret__.name,
        phrase_match_rule_groups=__ret__.phrase_match_rule_groups,
        revision_create_time=__ret__.revision_create_time,
        revision_id=__ret__.revision_id,
        role_match=__ret__.role_match,
        type=__ret__.type,
        update_time=__ret__.update_time,
        version_tag=__ret__.version_tag)


@_utilities.lift_output_func(get_phrase_matcher)
def get_phrase_matcher_output(location: Optional[pulumi.Input[str]] = None,
                              phrase_matcher_id: Optional[pulumi.Input[str]] = None,
                              project: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPhraseMatcherResult]:
    """
    Gets a phrase matcher.
    """
    ...
