# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EkmConnectionArgs', 'EkmConnection']

@pulumi.input_type
class EkmConnectionArgs:
    def __init__(__self__, *,
                 ekm_connection_id: pulumi.Input[str],
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceResolverArgs']]]] = None):
        """
        The set of arguments for constructing a EkmConnection resource.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other fields, and may be sent on update requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceResolverArgs']]] service_resolvers: A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported.
        """
        pulumi.set(__self__, "ekm_connection_id", ekm_connection_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_resolvers is not None:
            pulumi.set(__self__, "service_resolvers", service_resolvers)

    @property
    @pulumi.getter(name="ekmConnectionId")
    def ekm_connection_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "ekm_connection_id")

    @ekm_connection_id.setter
    def ekm_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ekm_connection_id", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[str]]:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceResolvers")
    def service_resolvers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceResolverArgs']]]]:
        """
        A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported.
        """
        return pulumi.get(self, "service_resolvers")

    @service_resolvers.setter
    def service_resolvers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceResolverArgs']]]]):
        pulumi.set(self, "service_resolvers", value)


class EkmConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ekm_connection_id: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceResolverArgs']]]]] = None,
                 __props__=None):
        """
        Creates a new EkmConnection in a given Project and Location.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] etag: This checksum is computed by the server based on the value of other fields, and may be sent on update requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceResolverArgs']]]] service_resolvers: A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EkmConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new EkmConnection in a given Project and Location.
        Auto-naming is currently not supported for this resource.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param EkmConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EkmConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ekm_connection_id: Optional[pulumi.Input[str]] = None,
                 etag: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_resolvers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceResolverArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EkmConnectionArgs.__new__(EkmConnectionArgs)

            if ekm_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'ekm_connection_id'")
            __props__.__dict__["ekm_connection_id"] = ekm_connection_id
            __props__.__dict__["etag"] = etag
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["service_resolvers"] = service_resolvers
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
        super(EkmConnection, __self__).__init__(
            'google-native:cloudkms/v1:EkmConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EkmConnection':
        """
        Get an existing EkmConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EkmConnectionArgs.__new__(EkmConnectionArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["service_resolvers"] = None
        return EkmConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time at which the EkmConnection was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        This checksum is computed by the server based on the value of other fields, and may be sent on update requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name for the EkmConnection in the format `projects/*/locations/*/ekmConnections/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceResolvers")
    def service_resolvers(self) -> pulumi.Output[Sequence['outputs.ServiceResolverResponse']]:
        """
        A list of ServiceResolvers where the EKM can be reached. There should be one ServiceResolver per EKM replica. Currently, only a single ServiceResolver is supported.
        """
        return pulumi.get(self, "service_resolvers")

