# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BitbucketServerConfigArgs', 'BitbucketServerConfig']

@pulumi.input_type
class BitbucketServerConfigArgs:
    def __init__(__self__, *,
                 api_key: pulumi.Input[str],
                 host_uri: pulumi.Input[str],
                 secrets: pulumi.Input['BitbucketServerSecretsArgs'],
                 bitbucket_server_config_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peered_network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BitbucketServerConfig resource.
        :param pulumi.Input[str] api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[str] host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input['BitbucketServerSecretsArgs'] secrets: Secret Manager secrets needed by the config.
        :param pulumi.Input[str] create_time: Time when the config was created.
        :param pulumi.Input[str] name: The resource name for the config.
        :param pulumi.Input[str] peered_network: Optional. The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[str] ssl_ca: Optional. SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
        :param pulumi.Input[str] username: Username of the account Cloud Build will use on Bitbucket Server.
        """
        pulumi.set(__self__, "api_key", api_key)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "secrets", secrets)
        if bitbucket_server_config_id is not None:
            pulumi.set(__self__, "bitbucket_server_config_id", bitbucket_server_config_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peered_network is not None:
            pulumi.set(__self__, "peered_network", peered_network)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Input[str]:
        """
        Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "api_key")

    @api_key.setter
    def api_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_key", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Input[str]:
        """
        Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Input['BitbucketServerSecretsArgs']:
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: pulumi.Input['BitbucketServerSecretsArgs']):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter(name="bitbucketServerConfigId")
    def bitbucket_server_config_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bitbucket_server_config_id")

    @bitbucket_server_config_id.setter
    def bitbucket_server_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bitbucket_server_config_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the config was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peered_network", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Username of the account Cloud Build will use on Bitbucket Server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class BitbucketServerConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 bitbucket_server_config_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 host_uri: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peered_network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[pulumi.InputType['BitbucketServerSecretsArgs']]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new `BitbucketServerConfig`. This API is experimental.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_key: Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[str] create_time: Time when the config was created.
        :param pulumi.Input[str] host_uri: Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        :param pulumi.Input[str] name: The resource name for the config.
        :param pulumi.Input[str] peered_network: Optional. The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        :param pulumi.Input[pulumi.InputType['BitbucketServerSecretsArgs']] secrets: Secret Manager secrets needed by the config.
        :param pulumi.Input[str] ssl_ca: Optional. SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
        :param pulumi.Input[str] username: Username of the account Cloud Build will use on Bitbucket Server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BitbucketServerConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new `BitbucketServerConfig`. This API is experimental.

        :param str resource_name: The name of the resource.
        :param BitbucketServerConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BitbucketServerConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key: Optional[pulumi.Input[str]] = None,
                 bitbucket_server_config_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 host_uri: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peered_network: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[pulumi.InputType['BitbucketServerSecretsArgs']]] = None,
                 ssl_ca: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BitbucketServerConfigArgs.__new__(BitbucketServerConfigArgs)

            if api_key is None and not opts.urn:
                raise TypeError("Missing required property 'api_key'")
            __props__.__dict__["api_key"] = api_key
            __props__.__dict__["bitbucket_server_config_id"] = bitbucket_server_config_id
            __props__.__dict__["create_time"] = create_time
            if host_uri is None and not opts.urn:
                raise TypeError("Missing required property 'host_uri'")
            __props__.__dict__["host_uri"] = host_uri
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["peered_network"] = peered_network
            __props__.__dict__["project"] = project
            if secrets is None and not opts.urn:
                raise TypeError("Missing required property 'secrets'")
            __props__.__dict__["secrets"] = secrets
            __props__.__dict__["ssl_ca"] = ssl_ca
            __props__.__dict__["username"] = username
            __props__.__dict__["connected_repositories"] = None
            __props__.__dict__["webhook_key"] = None
        super(BitbucketServerConfig, __self__).__init__(
            'google-native:cloudbuild/v1:BitbucketServerConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'BitbucketServerConfig':
        """
        Get an existing BitbucketServerConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BitbucketServerConfigArgs.__new__(BitbucketServerConfigArgs)

        __props__.__dict__["api_key"] = None
        __props__.__dict__["connected_repositories"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["host_uri"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["peered_network"] = None
        __props__.__dict__["secrets"] = None
        __props__.__dict__["ssl_ca"] = None
        __props__.__dict__["username"] = None
        __props__.__dict__["webhook_key"] = None
        return BitbucketServerConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiKey")
    def api_key(self) -> pulumi.Output[str]:
        """
        Immutable. API Key that will be attached to webhook. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "api_key")

    @property
    @pulumi.getter(name="connectedRepositories")
    def connected_repositories(self) -> pulumi.Output[Sequence['outputs.BitbucketServerRepositoryIdResponse']]:
        """
        Connected Bitbucket Server repositories for this config.
        """
        return pulumi.get(self, "connected_repositories")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time when the config was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Output[str]:
        """
        Immutable. The URI of the Bitbucket Server host. Once this field has been set, it cannot be changed. If you need to change it, please create another BitbucketServerConfig.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name for the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> pulumi.Output[str]:
        """
        Optional. The network to be used when reaching out to the Bitbucket Server instance. The VPC network must be enabled for private service connection. This should be set if the Bitbucket Server instance is hosted on-premises and not reachable by public internet. If this field is left empty, no network peering will occur and calls to the Bitbucket Server instance will be made over the public internet. Must be in the format `projects/{project}/global/networks/{network}`, where {project} is a project number or id and {network} is the name of a VPC network in the project.
        """
        return pulumi.get(self, "peered_network")

    @property
    @pulumi.getter
    def secrets(self) -> pulumi.Output['outputs.BitbucketServerSecretsResponse']:
        """
        Secret Manager secrets needed by the config.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> pulumi.Output[str]:
        """
        Optional. SSL certificate to use for requests to Bitbucket Server. The format should be PEM format but the extension can be one of .pem, .cer, or .crt.
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Username of the account Cloud Build will use on Bitbucket Server.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="webhookKey")
    def webhook_key(self) -> pulumi.Output[str]:
        """
        UUID included in webhook requests. The UUID is used to look up the corresponding config.
        """
        return pulumi.get(self, "webhook_key")

