/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class TopologicalChargeDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"GGI1", "GGI2", "GGI3", "GGI4", "GGI5", "GGI6", "GGI7", "GGI8", "GGI9", "GGI10", "JGI1", "JGI2", "JGI3", "JGI4", "JGI5", "JGI6", "JGI7", "JGI8", "JGI9", "JGI10", "JGT"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("topologicalcharge", this.getClass().getName(), "$Id: TopologicalChargeDescriptor.java 1 2014-06-09 11:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        int n3;
        int n4;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n5 = iAtomContainer2.getAtomCount();
        int[][] nArray = AdjacencyMatrix.getMatrix(iAtomContainer2);
        int[][] nArray2 = PathTools.computeFloydAPSP(nArray);
        double[][] dArray = new double[nArray2.length][nArray2[0].length];
        for (int i = 0; i < nArray2.length; ++i) {
            for (n4 = 0; n4 < nArray2[i].length; ++n4) {
                double d = nArray2[i][n4];
                dArray[i][n4] = d != 0.0 ? 1.0 / (d * d) : 0.0;
            }
        }
        double[][] dArray2 = new double[nArray2.length][nArray2[0].length];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            for (int i = 0; i < dArray[0].length; ++i) {
                for (n3 = 0; n3 < nArray[0].length; ++n3) {
                    double[] dArray3 = dArray2[n4];
                    int n6 = i;
                    dArray3[n6] = dArray3[n6] + (double)nArray[n4][n3] * dArray[n3][i];
                }
            }
        }
        double[][] dArray4 = new double[n5][n5];
        for (int i = 0; i < n5; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                dArray4[i][n3] = dArray2[i][n3] - dArray2[n3][i];
                if (i != n3) continue;
                dArray4[i][n3] = iAtomContainer2.getConnectedAtomsCount(iAtomContainer2.getAtom(i));
            }
        }
        double[] dArray5 = new double[Math.max(n5, 11)];
        int[] nArray3 = new int[Math.max(n5, 11)];
        int n7 = 0;
        while (n7 < n5) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (int i = 0; i < n5; ++i) {
                    double d = dArray4[n2][i];
                    if (d < 0.0) {
                        d *= -1.0;
                    }
                    double d2 = 0.0;
                    if (n7 == nArray2[n2][i]) {
                        d2 = 1.0;
                        int n8 = n7;
                        nArray3[n8] = nArray3[n8] + 1;
                    }
                    int n9 = n7;
                    dArray5[n9] = dArray5[n9] + 0.5 * (d * d2);
                }
            }
            int n10 = n7++;
            nArray3[n10] = nArray3[n10] / 2;
        }
        double[] dArray6 = new double[Math.max(n5, 11)];
        for (n2 = 0; n2 < dArray6.length; ++n2) {
            dArray6[n2] = nArray3[n2] > 0 ? dArray5[n2] / (double)nArray3[n2] : 0.0;
        }
        double d = 0.0;
        for (int i = 1; i < dArray6.length; ++i) {
            d += dArray6[i];
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n = 1; n <= 10; ++n) {
            doubleArrayResult.add(dArray5[n]);
        }
        for (n = 1; n <= 10; ++n) {
            doubleArrayResult.add(dArray6[n]);
        }
        doubleArrayResult.add(d);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

