/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.WrappedGraph;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorGraph
extends WrappedGraph {
    protected Set<Triple> snapshot = new HashSet<Triple>();

    public MonitorGraph(Graph g) {
        super(g);
    }

    public void snapshot(List<Triple> additions, List<Triple> deletions) {
        ExtendedIterator<Triple> i;
        HashSet<Triple> deletionsTempSet;
        boolean listening = this.getEventManager().listening();
        boolean wantAdditions = listening || additions != null;
        boolean wantDeletions = listening || deletions != null;
        ArrayList<Triple> additionsTemp = additions != null ? additions : new ArrayList<Triple>();
        ArrayList<Triple> deletionsTemp = deletions != null ? deletions : new ArrayList<Triple>();
        HashSet<Triple> hashSet = deletionsTempSet = wantDeletions ? new HashSet<Triple>() : null;
        if (wantAdditions || wantDeletions) {
            if (wantDeletions) {
                deletionsTempSet.addAll(this.snapshot);
            }
            i = this.base.find(Node.ANY, Node.ANY, Node.ANY);
            while (i.hasNext()) {
                Triple triple = (Triple)i.next();
                if (wantAdditions && !this.snapshot.contains(triple)) {
                    additionsTemp.add(triple);
                }
                if (!wantDeletions) continue;
                deletionsTempSet.remove(triple);
            }
        }
        if (deletions != null) {
            deletionsTemp.addAll(deletionsTempSet);
        }
        if (listening) {
            this.getEventManager().notifyAddList(this, additionsTemp);
            this.getEventManager().notifyDeleteList(this, deletionsTemp);
        }
        this.snapshot.clear();
        i = this.base.find(Node.ANY, Node.ANY, Node.ANY);
        while (i.hasNext()) {
            this.snapshot.add((Triple)i.next());
        }
    }
}

