/*
 * Decompiled with CFR 0.152.
 */
package signature.chemistry;

import signature.AbstractGraphSignature;
import signature.AbstractVertexSignature;
import signature.chemistry.AtomSignature;
import signature.chemistry.Molecule;

public class MoleculeSignature
extends AbstractGraphSignature {
    private Molecule molecule;
    private AbstractVertexSignature.InvariantType invariantType;

    public MoleculeSignature(Molecule molecule) {
        this(molecule, AbstractVertexSignature.InvariantType.STRING);
    }

    public MoleculeSignature(Molecule molecule, AbstractVertexSignature.InvariantType invariantType) {
        super(" + ");
        this.molecule = molecule;
        this.invariantType = invariantType;
    }

    public static boolean isCanonicallyLabelled(Molecule molecule) {
        return new MoleculeSignature(molecule).isCanonicallyLabelled();
    }

    public String getMolecularSignature() {
        return super.getGraphSignature();
    }

    public int getVertexCount() {
        return this.molecule.getAtomCount();
    }

    public String signatureStringForVertex(int vertexIndex) {
        int height = super.getHeight();
        AtomSignature atomSignature = new AtomSignature(this.molecule, vertexIndex, height, this.invariantType);
        return atomSignature.toCanonicalString();
    }

    public String signatureStringForVertex(int vertexIndex, int height) {
        AtomSignature atomSignature = new AtomSignature(this.molecule, vertexIndex, height, this.invariantType);
        return atomSignature.toCanonicalString();
    }

    public AbstractVertexSignature signatureForVertex(int vertexIndex) {
        return new AtomSignature(this.molecule, vertexIndex, -1, this.invariantType);
    }
}

