"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTemplateReferences = void 0;
function getTemplateReferences(template) {
    return walk(template, []);
}
exports.getTemplateReferences = getTemplateReferences;
function walk(node, path) {
    const jsonNode = node && typeof node.toJSON === 'function' ? node.toJSON() : node;
    if (Array.isArray(jsonNode)) {
        let refsFromAllKeys = {};
        for (let i = 0; i < jsonNode.length; i++) {
            const n = jsonNode[i];
            const refsForKey = walk(n, path.concat(`${i}`));
            refsFromAllKeys = mergeReferenceMaps(refsFromAllKeys, refsForKey);
        }
        return refsFromAllKeys;
    }
    else if (typeof jsonNode === 'object') {
        const refValue = jsonNode['Ref'];
        const getAtt = jsonNode['Fn::GetAtt'];
        if (refValue) {
            return {
                [refValue]: [path],
            };
        }
        else if (getAtt) {
            return {
                [getAtt[0]]: [path],
            };
        }
        let refsFromAllKeys = {};
        for (const key of Object.keys(jsonNode)) {
            const refsForKey = walk(jsonNode[key], path.concat(key));
            refsFromAllKeys = mergeReferenceMaps(refsFromAllKeys, refsForKey);
        }
        return refsFromAllKeys;
    }
    else {
        return {};
    }
}
function mergeReferenceMaps(a, b) {
    const bKeys = Object.keys(b);
    for (const bKey of bKeys) {
        if (a[bKey]) {
            a[bKey] = a[bKey].concat(b[bKey]);
        }
        else {
            a[bKey] = b[bKey];
        }
    }
    return a;
}
//# sourceMappingURL=getTemplateReferences.js.map