# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/expanding.ipynb.

# %% auto 0
__all__ = ['expanding_mean', 'expanding_std', 'expanding_max', 'expanding_min', 'seasonal_expanding_mean',
           'seasonal_expanding_std', 'seasonal_expanding_min', 'seasonal_expanding_max']

# %% ../nbs/expanding.ipynb 4
from math import sqrt
from typing import Callable, Optional

import numpy as np
from numba import njit  # type: ignore

from .rolling import *

# %% ../nbs/expanding.ipynb 6
@njit
def _expanding_op(rolling_op: Callable, x: np.ndarray, min_samples: int = 1) -> np.ndarray:
    n_samples = x.size
    return rolling_op(x, window_size=n_samples, min_samples=min_samples)

# %% ../nbs/expanding.ipynb 7
@njit
def expanding_mean(input_array: np.ndarray) -> np.ndarray:
    return _expanding_op(rolling_mean, input_array)

# %% ../nbs/expanding.ipynb 9
@njit
def expanding_std(input_array: np.ndarray) -> np.ndarray:
    return _expanding_op(rolling_std, input_array, min_samples = 2)

# %% ../nbs/expanding.ipynb 11
@njit
def expanding_max(x: np.ndarray) -> np.ndarray:
    return _expanding_op(rolling_max, x)

# %% ../nbs/expanding.ipynb 13
@njit
def expanding_min(x: np.ndarray) -> np.ndarray:
    return _expanding_op(rolling_min, x)

# %% ../nbs/expanding.ipynb 17
@njit
def _seasonal_expanding_op(rolling_op: Callable, x: np.ndarray, season_length: int,
                           min_samples: int = 1) -> np.ndarray:
    n_samples = x.size
    return rolling_op(x, season_length=season_length, window_size=n_samples, min_samples=min_samples)

# %% ../nbs/expanding.ipynb 18
@njit
def seasonal_expanding_mean(x: np.ndarray, season_length: int) -> np.ndarray:
    return _seasonal_expanding_op(seasonal_rolling_mean, x, season_length)

# %% ../nbs/expanding.ipynb 20
@njit
def seasonal_expanding_std(x: np.ndarray, season_length: int) -> np.ndarray:
    return _seasonal_expanding_op(seasonal_rolling_std, x, season_length, min_samples=2)

# %% ../nbs/expanding.ipynb 22
@njit
def seasonal_expanding_min(x: np.ndarray, season_length: int):
    return _seasonal_expanding_op(seasonal_rolling_min, x, season_length)

# %% ../nbs/expanding.ipynb 24
@njit
def seasonal_expanding_max(x: np.ndarray, season_length: int):
    return _seasonal_expanding_op(seasonal_rolling_max, x, season_length)
