/**
 *
 * RenderPipeline
 *
 * Copyright (c) 2014-2016 tobspr <tobias.springer1@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 */

// lint: skip-file

#pragma once


// Autogenerated, do not edit!

// python-script to generate the weights:
/*
from __future__ import print_function
SIGMA = 1.0
file_handle = open("gaussian_weights.txt", "w")
import math
def gauss(x):
    return math.exp( -(x**2) / (2.0 * (SIGMA**2) ) )
for i in range(2, 40):
    weights = [gauss(k / float(i-1) * 3.0) for k in range(0, i)]
    wsum = weights[0] + 2 * sum(weights[1:])
    weights = [k / wsum for k in weights]
    print("CONST_ARRAY float gaussian_weights_{0}[{0}] = float[{0}]({1});".format(i, ', '.join([str(i) for i in weights])), file=file_handle)
file_handle.close()

*/

CONST_ARRAY float gaussian_weights_2[2] = float[2](0.97826491685, 0.0108675415748);
CONST_ARRAY float gaussian_weights_3[3] = float[3](0.598256825182, 0.194225554409, 0.00664603299992);
CONST_ARRAY float gaussian_weights_4[4] = float[4](0.399050279652, 0.242036229376, 0.0540055826224, 0.00443304817524);
CONST_ARRAY float gaussian_weights_5[5] = float[5](0.299372412212, 0.22597815248, 0.0971919922835, 0.0238179220394, 0.0033257270909);
CONST_ARRAY float gaussian_weights_6[6] = float[6](0.239559410861, 0.200096839755, 0.116606083673, 0.0474084957625, 0.0134476107133, 0.00266126466595);
CONST_ARRAY float gaussian_weights_7[7] = float[7](0.199675627498, 0.176213122789, 0.121109390075, 0.0648251851385, 0.0270231576029, 0.00877313479159, 0.00221819585465);
CONST_ARRAY float gaussian_weights_8[8] = float[8](0.171180679737, 0.156160272964, 0.118554487683, 0.0749026292285, 0.0393829054464, 0.0172325706915, 0.00627514853941, 0.00190164557861);
CONST_ARRAY float gaussian_weights_9[9] = float[9](0.149804857814, 0.139633481336, 0.113078639248, 0.0795607594227, 0.0486345167116, 0.0258295968515, 0.0119184008913, 0.00477799498463, 0.00166418164687);
CONST_ARRAY float gaussian_weights_10[10] = float[10](0.133175996016, 0.125979094462, 0.10663900118, 0.0807753247212, 0.0547502887625, 0.0332077287626, 0.0180234111411, 0.00875346226514, 0.00380423901867, 0.00147945167871);
CONST_ARRAY float gaussian_weights_11[11] = float[11](0.119870627342, 0.114596017885, 0.100124364242, 0.0799509287402, 0.0583472982821, 0.0389162949304, 0.0237222412093, 0.013215799633, 0.00672890923663, 0.00313118978625, 0.00133164238418);
CONST_ARRAY float gaussian_weights_12[12] = float[12](0.108982774698, 0.105004137779, 0.0939186994792, 0.0779820830369, 0.0601083349811, 0.043010220493, 0.0285697042449, 0.0176172016263, 0.0100847516981, 0.00535908443022, 0.00264370561491, 0.00121068926685);
CONST_ARRAY float gaussian_weights_13[13] = float[13](0.099908358105, 0.0968345010773, 0.0881688165699, 0.0754147852673, 0.0605974823522, 0.0457413794603, 0.0324354949685, 0.0216066977333, 0.0135211259418, 0.00794865988767, 0.00438966689848, 0.00227732918643, 0.00110988160433);
CONST_ARRAY float gaussian_weights_14[14] = float[14](0.0922291029445, 0.0898057057742, 0.0829109263623, 0.0725757439402, 0.060234195822, 0.0473987215842, 0.0353640528944, 0.0250166600045, 0.0167790942071, 0.0106703727296, 0.0064337259728, 0.00367804823216, 0.00199362821896, 0.00102457278534);
CONST_ARRAY float gaussian_weights_15[15] = float[15](0.0856461968131, 0.0837022313712, 0.0781310922076, 0.0696576247716, 0.0593159286476, 0.0482427341138, 0.0374757556435, 0.0278052491152, 0.0197043035237, 0.0133368508235, 0.00862190840291, 0.00532367362189, 0.00313962187592, 0.00176848417109, 0.00095144330391);
CONST_ARRAY float gaussian_weights_16[16] = float[16](0.0799404796215, 0.0783575520685, 0.0737943634766, 0.0667719013138, 0.0580487023004, 0.0484863518426, 0.0389112087983, 0.0300025492495, 0.0222264351509, 0.0158201169212, 0.0108187674517, 0.00710843674843, 0.0044874398644, 0.00272176986138, 0.00158610663008, 0.000888058511381);
CONST_ARRAY float gaussian_weights_17[17] = float[17](0.0749475595843, 0.0736416335058, 0.0698588070848, 0.0639809599576, 0.0565733860467, 0.0482953623493, 0.0398043484331, 0.0316728718988, 0.0243319101415, 0.0180466584178, 0.0129225799304, 0.0089337437364, 0.00596279102016, 0.00384235530188, 0.00239043692594, 0.00143578327773, 0.000832592179972);
CONST_ARRAY float gaussian_weights_18[18] = float[18](0.0705417098914, 0.069451816911, 0.0662821365674, 0.0613175289906, 0.0549854836326, 0.047795467276, 0.0402717621111, 0.03289196444, 0.0260407956595, 0.0199845303108, 0.0148665056404, 0.0107201068137, 0.00749315271104, 0.00507697836848, 0.00333442766635, 0.00212281695053, 0.0013100233939, 0.000783647610985);
CONST_ARRAY float gaussian_weights_19[19] = float[19](0.0666251318775, 0.0657061792116, 0.0630246743667, 0.0587964725162, 0.0533492350686, 0.0470805347033, 0.0404101851911, 0.0337346772335, 0.0273904105715, 0.0216300134521, 0.0166131237937, 0.0124102942088, 0.00901673109332, 0.006371657499, 0.00437917188719, 0.00292730399695, 0.00190318025692, 0.0012034506512, 0.000740138359388);
CONST_ARRAY float gaussian_weights_20[20] = float[20](0.0631206079092, 0.0623386696286, 0.0600504962028, 0.0564219880656, 0.0517074216853, 0.0462200163444, 0.0402976778174, 0.0342690969121, 0.0284248389542, 0.0229967296489, 0.0181470844488, 0.0139675538565, 0.0104859205472, 0.00767830721424, 0.00548399588371, 0.00382033519528, 0.00259584365953, 0.00172039554551, 0.00111211782068, 0.000701206614755);
CONST_ARRAY float gaussian_weights_21[21] = float[21](0.0599663578227, 0.0592955168529, 0.0573276870732, 0.0541920219987, 0.0500881123762, 0.0452649816716, 0.0399961700994, 0.0345543588197, 0.0291887599519, 0.024107758111, 0.0194682260256, 0.0153717852441, 0.0118672642019, 0.00895788098686, 0.00661132245055, 0.004770893968, 0.00336619727441, 0.00232224340187, 0.00156640581013, 0.00103306870905, 0.000666166061464);
CONST_ARRAY float gaussian_weights_22[22] = float[22](0.057112364552, 0.0565325485975, 0.0548281807346, 0.0521009873998, 0.0485092901538, 0.0442527977069, 0.0395542717215, 0.0346404001495, 0.0297241370428, 0.0249903568146, 0.0205860255043, 0.0166153465249, 0.0131396303393, 0.0101810773885, 0.00772931803295, 0.00574943890287, 0.004190314276, 0.0029922961728, 0.0020936274558, 0.0014352616483, 0.000964050097101, 0.000634461060099);
CONST_ARRAY float gaussian_weights_23[23] = float[23](0.054517701579, 0.0540131711974, 0.0525274224654, 0.0501414375277, 0.0469820267016, 0.0432106689856, 0.0390098705349, 0.034568640811, 0.030068680835, 0.0256726513374, 0.021515495198, 0.0176993063323, 0.0142917503664, 0.0113276252744, 0.00881285454125, 0.00673005489098, 0.00504481084372, 0.00371189295693, 0.00268083618271, 0.00190050661455, 0.0013224911384, 0.000903317516786, 0.000605636958114);
CONST_ARRAY float gaussian_weights_24[24] = float[24](0.0521485573767, 0.0517068310725, 0.050403975608, 0.0483050916261, 0.0455126658702, 0.042158280221, 0.0383923542943, 0.0343730326211, 0.0302553514918, 0.0261816975872, 0.0222743299567, 0.0186304241426, 0.0153197642695, 0.0123849047314, 0.00984338574556, 0.00769143875473, 0.00590856360058, 0.00446238965579, 0.00331332710032, 0.00241864641078, 0.00173576808421, 0.00122467897537, 0.00084950134862, 0.000579318143372);
CONST_ARRAY float gaussian_weights_25[25] = float[25](0.0499767536015, 0.0495878314194, 0.0484391305418, 0.046583456592, 0.0441043302545, 0.0411097561541, 0.0377244327973, 0.0340811848931, 0.0303124333322, 0.0265424534827, 0.0228810251118, 0.0194188737985, 0.0162250763673, 0.0133463837679, 0.0108082309552, 0.00861707301291, 0.0067636181039, 0.00522651897931, 0.00397612596387, 0.00297798074754, 0.0021958253057, 0.00159399822903, 0.00113917916157, 0.000801512644787, 0.000555191582752);
CONST_ARRAY float gaussian_weights_26[26] = float[26](0.0479786188192, 0.0476344133902, 0.0466165426396, 0.0449681953731, 0.0427579639989, 0.0400751110844, 0.0370235971586, 0.033715425763, 0.0302638965903, 0.0267773256187, 0.0233537009481, 0.0200766102918, 0.0170126208304, 0.0142101353977, 0.0116996095611, 0.00949490624815, 0.00759549623064, 0.00598918576442, 0.00465506312071, 0.00356639567308, 0.00269326838853, 0.00200482238421, 0.00147101916547, 0.00106391496797, 0.000758475690917, 0.000532994310372);
CONST_ARRAY float gaussian_weights_27[27] = float[27](0.0461341220677, 0.0458280361329, 0.0449219092487, 0.0434513364077, 0.041473056502, 0.0390613205401, 0.0363032722123, 0.03329374093, 0.0301298793329, 0.0269060634368, 0.0237094185849, 0.0206162474982, 0.0176895305381, 0.0149775565587, 0.0125136384235, 0.0103167809312, 0.00839310755091, 0.00673781900749, 0.00533745056926, 0.00417221196467, 0.00321822819374, 0.00244954419315, 0.00183980458116, 0.00136356575469, 0.000997237148304, 0.000719678922527, 0.000512503802344);
CONST_ARRAY float gaussian_weights_28[28] = float[28](0.0444261989064, 0.0441528077786, 0.0433426874556, 0.0420253835231, 0.0402481455205, 0.0380731143611, 0.0355737191338, 0.0328305743187, 0.0299271960082, 0.0269458517312, 0.0239638252082, 0.021050320394, 0.0182641563909, 0.0156523252517, 0.0132494072776, 0.0110777708249, 0.00914843153174, 0.00746241242714, 0.00601243221213, 0.00478475249866, 0.00376103264156, 0.00292006868614, 0.00223932625116, 0.00169621154636, 0.00126905661972, 0.000937821796457, 0.000684538667784, 0.000493530489859);
CONST_ARRAY float gaussian_weights_29[29] = float[29](0.0428402218449, 0.0425950320572, 0.0418678504625, 0.0406833639509, 0.0390811670302, 0.0371135646233, 0.0348427391927, 0.0323374960065, 0.0296698234919, 0.0269115067302, 0.0241310123361, 0.0213908255587, 0.0187453704346, 0.0162395871695, 0.0139081837241, 0.0117755263835, 0.00985609128793, 0.00815536834958, 0.00667109187858, 0.00539466821111, 0.00431267799915, 0.00340834700336, 0.00266290118508, 0.00205674653671, 0.00157043864968, 0.00118542928527, 0.000884595662595, 0.000652572000374, 0.000475911876172);
CONST_ARRAY float gaussian_weights_30[30] = float[30](0.0413635803064, 0.0411428442631, 0.0404876787473, 0.0394188384355, 0.0379696981566, 0.0361845223744, 0.034116221224, 0.0318237516855, 0.0293693415551, 0.02681571743, 0.0242235064343, 0.02164895686, 0.0191420884567, 0.0167453427128, 0.0144927613074, 0.0124096809627, 0.0105128984936, 0.00881123336238, 0.00730639779605, 0.00599407677732, 0.00486512123495, 0.00390676609731, 0.00310379858835, 0.00243961912893, 0.00189715540038, 0.0014596077497, 0.00111101978377, 0.000836680798136, 0.000623376159936, 0.000459507870433);
CONST_ARRAY float gaussian_weights_31[31] = float[31](0.0399853445765, 0.0397859168385, 0.0391935817056, 0.0382258887254, 0.0369111251945, 0.0352869427376, 0.0333985672178, 0.0312967106632, 0.0290353194613, 0.0266692976067, 0.0242523374248, 0.0218349741136, 0.019462956678, 0.0171759989834, 0.015006943611, 0.0129813407749, 0.0111174172637, 0.00942638810365, 0.00791304767411, 0.00657656782027, 0.00541142793358, 0.00440840524404, 0.00355556151442, 0.00283917353606, 0.00224456783464, 0.00175683343057, 0.00136139920952, 0.00104447357383, 0.000793353010129, 0.000596612772324, 0.000444197054481);
CONST_ARRAY float gaussian_weights_32[32] = float[32](0.0386959947766, 0.038515219631, 0.0379779455684, 0.0370990921929, 0.035902758976, 0.0344211273781, 0.03269302325, 0.0307622290963, 0.0286756484161, 0.0264814290509, 0.0242271492383, 0.0219581595966, 0.0197161578279, 0.017538052295, 0.0154551477556, 0.0134926634575, 0.0116695723433, 0.00999873179996, 0.00848726229109, 0.00713712091343, 0.00594581251708, 0.00490718118467, 0.00401222890115, 0.00324991525467, 0.00260790097568, 0.00207320803451, 0.00163277896075, 0.001273927269, 0.000984678824041, 0.0007540103176, 0.000571995622223, 0.000429873672017);
CONST_ARRAY float gaussian_weights_33[33] = float[33](0.0374872006405, 0.0373228234108, 0.0368340037493, 0.0360334897628, 0.0349419131486, 0.0335869056163, 0.0320019370398, 0.0302249435008, 0.0282968236112, 0.0262598859882, 0.024156329418, 0.0220268304723, 0.0199093019753, 0.0178378709241, 0.0158421076059, 0.0139465201734, 0.0121703121823, 0.0105273857368, 0.00902656082137, 0.00767197268489, 0.00646360400967, 0.0053979069534, 0.00446847163236, 0.00366670165813, 0.00298246326618, 0.00240468165596, 0.00192186570093, 0.00152254956825, 0.00119564651815, 0.000930715882533, 0.000718148744363, 0.000549281085644, 0.000416445182144);
CONST_ARRAY float gaussian_weights_34[34] = float[34](0.0363516413217, 0.036201737859, 0.0357557262315, 0.0350245510305, 0.0340259562937, 0.0327837698447, 0.0313269586531, 0.0296885074803, 0.0279041813374, 0.0260112363621, 0.0240471434912, 0.0220483849925, 0.0200493760572, 0.0180815530273, 0.0161726573904, 0.0143462314376, 0.0126213284443, 0.0110124282972, 0.00952953936303, 0.00817845959286, 0.00696116464401, 0.00587628821513, 0.00491965967439, 0.00408486607427, 0.00336380935028, 0.00274723438686, 0.00222520918402, 0.0017875440918, 0.00142414258053, 0.00112528095772, 0.000881818604268, 0.00068534355663, 0.000528260575697, 0.000403830257603);
CONST_ARRAY float gaussian_weights_35[35] = float[35](0.0352828569912, 0.0351457772102, 0.0347377250654, 0.034068138963, 0.0331523456006, 0.0320109768082, 0.0306691971283, 0.0291557825023, 0.027502097108, 0.025741019002, 0.0239058656123, 0.0220293674457, 0.0201427329382, 0.0182748397359, 0.0164515784956, 0.0146953652717, 0.0130248284398, 0.0114546665776, 0.00999566534574, 0.00865485462404, 0.0074357822241, 0.00633887752729, 0.00536187733782, 0.00450028691203, 0.00374785124891, 0.00309701495804, 0.00253935298702, 0.00206595882394, 0.00166778115643, 0.00133590408651, 0.00106176965372, 0.000837344464398, 0.000655234585795, 0.000508754527564, 0.000391957136174);
CONST_ARRAY float gaussian_weights_36[36] = float[36](0.0342751258684, 0.0341494482206, 0.0337751734808, 0.0331604756171, 0.0323186475622, 0.0312676233073, 0.0300293428847, 0.0286289916303, 0.0270941505287, 0.0254538975676, 0.0237379007598, 0.021975541872, 0.0201951061634, 0.0184230679295, 0.0166834948398, 0.0149975864603, 0.013383354516, 0.0118554448693, 0.0104250943304, 0.00910020962319, 0.0078855513561, 0.00678300282029, 0.00579190187853, 0.0049094140256, 0.00413092573351, 0.00345043921075, 0.0028609524436, 0.00235481157601, 0.00192402606174, 0.00156054035493, 0.00125645900204, 0.00100422471517, 0.000796751251198, 0.000627514647567, 0.000490607571324, 0.00038076225462);
CONST_ARRAY float gaussian_weights_37[37] = float[37](0.0333233617429, 0.0332078562721, 0.0328637365047, 0.0322981096857, 0.0315225495765, 0.030552702685, 0.0294077635218, 0.0281098434571, 0.0266832621385, 0.025153793115, 0.0235478961881, 0.0218919680964, 0.0202116405818, 0.0185311509155, 0.0168728049169, 0.0152565467323, 0.0136996435735, 0.0122164876079, 0.0108185116105, 0.00951421011541, 0.00830925385448, 0.00720668238666, 0.00620715804382, 0.00530926362864, 0.00450982659987, 0.00380425362601, 0.00318686120024, 0.00265119028911, 0.00219029553592, 0.00179700217107, 0.00146412633301, 0.00118465684373, 0.000951898516011, 0.000759578735218, 0.000601920330354, 0.000473684629482, 0.000370189110245);
CONST_ARRAY float gaussian_weights_38[38] = float[38](0.0324230281088, 0.0323166262891, 0.0319995113068, 0.0314778862896, 0.0307618652238, 0.0298651468432, 0.028804578888, 0.02759963209, 0.0262718068088, 0.0248439975284, 0.0233398413379, 0.0217830760655, 0.0201969319937, 0.0186035782268, 0.0170236410318, 0.0154758070976, 0.0139765199563, 0.0125397730562, 0.011176998459, 0.00989704607063, 0.00870624489846, 0.00760853518304, 0.00660565843784, 0.00569739146478, 0.0048818102413, 0.00415557011334, 0.00351418985579, 0.00295232873728, 0.00246404760181, 0.00204304700967, 0.00168287753264, 0.00137711925802, 0.00111952933378, 0.000904157917575, 0.000725434137119, 0.000578224612709, 0.000457867740317, 0.00036018730702);
CONST_ARRAY float gaussian_weights_39[39] = float[39](0.0315700658546, 0.0314718358241, 0.0311789757839, 0.0306969191808, 0.0300345351942, 0.0292038573418, 0.0282197199596, 0.0270993178919, 0.0258617076395, 0.0245272701486, 0.0231171563159, 0.0216527361219, 0.0201550711348, 0.0186444280746, 0.0171398483337, 0.0156587850296, 0.0142168155126, 0.0128274335027, 0.0115019213772, 0.0102492997744, 0.00907634875668, 0.00798769241821, 0.00698593707642, 0.00607185210057, 0.0052445819707, 0.00450187828841, 0.00384034109358, 0.00325565988292, 0.00274284606771, 0.00229645013991, 0.00191075843051, 0.00157996594715, 0.00129832328924, 0.00106025699581, 0.000860463840048, 0.00069398052067, 0.000556230904611, 0.000443053455279, 0.000350711752291);



// Offsets and weights for n = 2, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_2[] = float[2] (0.274068619061, 0.725931380939);
CONST_ARRAY float opt_gaussian_offsets_2[] = float[2] (-1.0, 0.377540668798);

// Offsets and weights for n = 3, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_3[] = float[3] (0.15246914402, 0.473220416416, 0.374310439564);
CONST_ARRAY float opt_gaussian_offsets_3[] = float[3] (-2.0, -0.468790626626, 1.40733340005);

// Offsets and weights for n = 4, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_4[] = float[4] (0.106288519406, 0.306091409205, 0.341010215168, 0.24660985622);
CONST_ARRAY float opt_gaussian_offsets_4[] = float[4] (-2.0, -0.458429516783, 1.48611468225, 3.43099866743);

// Offsets and weights for n = 5, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_5[] = float[5] (0.0816744222584, 0.220481043971, 0.265173712396, 0.249350938326, 0.183319883049);
CONST_ARRAY float opt_gaussian_offsets_5[] = float[5] (-3.0, -1.46101677931, 0.507811864279, 2.47657965106, 4.44552953504);

// Offsets and weights for n = 6, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_6[] = float[6] (0.0663416657403, 0.170786343946, 0.208182532594, 0.216591983241, 0.192330414616, 0.145767059863);
CONST_ARRAY float opt_gaussian_offsets_6[] = float[6] (-3.0, -1.46505705484, 0.514995501619, 2.49500016666, 4.47502081252, 6.45512110763);

// Offsets and weights for n = 7, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_7[] = float[7] (0.0558645795815, 0.138837939971, 0.168410194672, 0.182939846093, 0.177962436458, 0.155034498765, 0.12095050446);
CONST_ARRAY float opt_gaussian_offsets_7[] = float[7] (-4.0, -2.46879062663, -0.482645862567, 1.50347216641, 3.48958484011, 5.47571357137, 7.46187967409);

// Offsets and weights for n = 8, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_8[] = float[8] (0.0482490884887, 0.116731177798, 0.140135626714, 0.155109457758, 0.158290996847, 0.148936931244, 0.12920422877, 0.10334249238);
CONST_ARRAY float opt_gaussian_offsets_8[] = float[8] (-4.0, -2.47196820019, -0.482150445594, 1.50765246363, 3.49744900173, 5.48724766412, 7.47705693918, 9.46688527998);

// Offsets and weights for n = 9, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_9[] = float[9] (0.042462603473, 0.100587552233, 0.119370554051, 0.133110608252, 0.139473180769, 0.137319230357, 0.127038284604, 0.110433394405, 0.0902045918559);
CONST_ARRAY float opt_gaussian_offsets_9[] = float[9] (-5.0, -3.47463117774, -1.48242911339, 0.509764383426, 2.50195311507, 4.49414089321, 6.48633153138, 8.47852883754, 10.4707366066);

// Offsets and weights for n = 10, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_10[] = float[10] (0.0379163821476, 0.0883084946127, 0.103630848659, 0.115769751833, 0.12311774987, 0.124642393984, 0.120124182183, 0.110208385676, 0.0962539004871, 0.0800279105479);
CONST_ARRAY float opt_gaussian_offsets_10[] = float[10] (-5.0, -3.47686837586, -1.48303121052, 0.510800788681, 2.50462949733, 4.49845679502, 6.49228456308, 8.48611468225, 10.4799490304, 12.4737894803);

// Offsets and weights for n = 11, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_11[] = float[11] (0.034250034987, 0.0786680908358, 0.0913650297743, 0.101960743385, 0.109334598331, 0.112655883289, 0.111537726901, 0.106111230043, 0.0970001809665, 0.0852030922382, 0.0719133892488);
CONST_ARRAY float opt_gaussian_offsets_11[] = float[11] (-6.0, -4.47876278503, -2.48375571894, -0.488751898053, 1.5062496745, 3.5012499974, 5.49625007031, 7.49125089312, 9.4862534651, 11.4812587841, 13.4762678459);

// Offsets and weights for n = 12, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_12[] = float[12] (0.0312305401816, 0.0709054311219, 0.0815774390232, 0.0908099474451, 0.0978069207462, 0.101924493536, 0.10276858031, 0.100257061632, 0.0946329555381, 0.0864256482923, 0.0763687507926, 0.0652922313807);
CONST_ARRAY float opt_gaussian_offsets_12[] = float[12] (-6.0, -4.48038197724, -2.48450909152, -0.488638319781, 1.5072309008, 3.50309913386, 5.49896694362, 7.49483489448, 9.49070355081, 11.4865734766, 13.482445235, 15.4783193884);

// Offsets and weights for n = 13, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_13[] = float[13] (0.0287005193039, 0.0645245840776, 0.0736085919864, 0.0816749725356, 0.0881468265092, 0.0925297883119, 0.0944742956035, 0.093821628, 0.0906253035588, 0.0851438313916, 0.0778061819627, 0.0691563739381, 0.0597871028205);
CONST_ARRAY float opt_gaussian_offsets_13[] = float[13] (-7.0, -5.48177890584, -3.48524733884, -1.48871719346, 0.507811864279, 2.50434016876, 4.50086805468, 6.49739585688, 8.49392391023, 10.4904525495, 12.4869821093, 14.4835129238, 16.4800453267);

// Offsets and weights for n = 14, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_14[] = float[14] (0.0265498357372, 0.0591891116629, 0.067008146258, 0.0740882641635, 0.080003184581, 0.084372549444, 0.0869022686967, 0.0874172424738, 0.0858814043683, 0.0824018985422, 0.0772167186324, 0.0706677895493, 0.0631637213247, 0.0551378645661);
CONST_ARRAY float opt_gaussian_offsets_14[] = float[14] (-7.0, -5.482994727, -3.48595044497, -1.48890714597, 0.508135376648, 2.50517732975, 4.50221892034, 6.49926035557, 8.49630184259, 10.4933435885, 12.4903858005, 14.4874286855, 16.4844724502, 18.4815173012);

// Offsets and weights for n = 15, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_15[] = float[15] (0.0246991001359, 0.0546630307477, 0.0614599000867, 0.0677077117875, 0.0730857269119, 0.0772992275365, 0.0801061552404, 0.0813401134339, 0.0809266963759, 0.0788909166077, 0.0753546997316, 0.0705247954691, 0.0646727718699, 0.0581097839419, 0.0511593701234);
CONST_ARRAY float opt_gaussian_offsets_15[] = float[15] (-8.0, -6.48406152432, -4.48661034495, -2.48915986216, -0.491709943445, 1.5057395438, 3.50318873228, 5.50063775476, 7.49808674403, 9.49553583291, 11.4929851542, 13.4904348406, 15.4878850248, 17.4853358393, 19.4827874166);

// Offsets and weights for n = 16, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_16[] = float[16] (0.0230896376799, 0.050776085665, 0.0567362408729, 0.0622801542701, 0.0671624585612, 0.0711526823588, 0.074053187201, 0.0757153650032, 0.0760522510849, 0.0750460631044, 0.0727497562674, 0.0692824055002, 0.0648189750606, 0.0595756988869, 0.0537927708459, 0.0477162676376);
CONST_ARRAY float opt_gaussian_offsets_16[] = float[16] (-8.0, -6.48500449838, -4.48722500316, -2.48944601229, -0.491667438186, 1.50611080683, 3.50388881047, 5.50166666049, 7.49944444467, 9.4972222508, 11.4950001667, 13.49277828, 15.4905566786, 17.4883354502, 19.4861146823, 21.4838944625);

// Offsets and weights for n = 17, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_17[] = float[17] (0.0216771440358, 0.0474024431083, 0.0526696583526, 0.0576157272943, 0.0620500832243, 0.0657906931345, 0.0686763697103, 0.0705782641713, 0.0714094011985, 0.0711312736702, 0.0697568007769, 0.0673493330105, 0.0640178107627, 0.0599085918637, 0.0551948018209, 0.0500642848839, 0.0447073189814);
CONST_ARRAY float opt_gaussian_offsets_17[] = float[17] (-9.0, -7.48584362821, -5.48779539349, -3.489747531, -1.49169998126, 0.506347315253, 2.5043944181, 4.50244138685, 6.50048828109, 8.49853516044, 10.4965820845, 12.4946291128, 14.4926763051, 16.4907237208, 18.4887714194, 20.4868194606, 22.4848679037);

// Offsets and weights for n = 18, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_18[] = float[18] (0.0204275387753, 0.0444471422165, 0.0491344246582, 0.0535700569458, 0.0576039868414, 0.0610909922542, 0.063899287897, 0.0659187647663, 0.0670681468019, 0.0673004170345, 0.0666060084333, 0.0650134576635, 0.062587459498, 0.0594245067401, 0.0556465251586, 0.0513930883489, 0.0468129040831, 0.0420552918834);
CONST_ARRAY float opt_gaussian_offsets_18[] = float[18] (-9.0, -7.48659490868, -5.48832392241, -3.49005321559, -1.49178274685, 0.506487525174, 2.50475764187, 4.50302764466, 6.50129757494, 8.49956747416, 10.4978373837, 12.4961073451, 14.4943773996, 16.4926475888, 18.490917954, 20.4891885367, 22.487459378, 24.4857305195);

// Offsets and weights for n = 19, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_19[] = float[19] (0.0193141765234, 0.0418372042117, 0.0460345037418, 0.0500318718292, 0.0537096734822, 0.0569509205974, 0.0596473922603, 0.0617056100684, 0.0630522103997, 0.063638283716, 0.0634423231446, 0.0624715344916, 0.0607613964306, 0.058373508293, 0.0553919075004, 0.0519181635644, 0.0480656477248, 0.0439534278952, 0.0397002441254);
CONST_ARRAY float opt_gaussian_offsets_19[] = float[19] (-10.0, -8.48727126934, -6.48881359538, -4.49035613443, -2.49189885715, -0.493441734166, 1.50501526389, 3.50347216641, 5.50192900278, 7.50038580239, 9.49884259466, 11.497299409, 13.4957562747, 15.4942132214, 17.4926702782, 19.4911274747, 21.4895848401, 23.4880424039, 25.4865001954);

// Offsets and weights for n = 20, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_20[] = float[20] (0.0183159239212, 0.0395156384342, 0.0432953808504, 0.0469143095749, 0.0502759514807, 0.0532851842709, 0.0558526585709, 0.0578991827119, 0.0593597716547, 0.0601870718495, 0.0603539103928, 0.0598547770814, 0.0587061266098, 0.0569454777934, 0.0546293785999, 0.0518303909461, 0.0486333194666, 0.0451309573637, 0.0414196460388, 0.0375949423883);
CONST_ARRAY float opt_gaussian_offsets_20[] = float[20] (-10.0, -8.48788325916, -6.48926757672, -4.4906520589, -2.4920366845, -0.493421432277, 1.50519371901, 3.50380879059, 5.50242380373, 7.50103877967, 9.49965373967, 11.498268705, 13.4968836969, 15.4954987366, 17.4941138453, 19.4927290444, 21.4913443551, 23.4899597986, 25.488575396, 27.4871911687);

// Offsets and weights for n = 21, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_21[] = float[21] (0.017415804187, 0.0374373032386, 0.0408584208729, 0.0441487454036, 0.0472296714025, 0.050023174672, 0.0524550548792, 0.0544581909425, 0.0559756111883, 0.0569631828342, 0.0573917437838, 0.0572485330749, 0.0565378220739, 0.0552807028518, 0.0535140483716, 0.0512887160172, 0.0486671165854, 0.0457203108183, 0.0425248216691, 0.0391593610009, 0.0357016641323);
CONST_ARRAY float opt_gaussian_offsets_21[] = float[21] (-11.0, -9.48843956064, -7.48968896203, -5.49093849226, -3.49218813572, -1.49343787681, 0.505312300099, 2.50406241061, 4.50281247034, 6.50156249491, 8.50031249996, 10.4990625011, 12.497812514, 14.4965625542, 16.4953126373, 18.4940627791, 20.492812995, 22.4915633008, 24.490313712, 26.4890642443, 28.4878149131);

// Offsets and weights for n = 22, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_22[] = float[22] (0.0166000229565, 0.0355659864281, 0.0386768958381, 0.0416803556939, 0.044511709669, 0.047106429585, 0.0494025259225, 0.0513429921806, 0.0528781496068, 0.0539677581387, 0.0545827685096, 0.0547066090713, 0.0543359277732, 0.0534807429267, 0.05216399329, 0.0504205156771, 0.0482955136927, 0.0458426115287, 0.0431216096972, 0.040196073531, 0.0371308894807, 0.0339899188026);
CONST_ARRAY float opt_gaussian_offsets_22[] = float[22] (-11.0, -9.48894737902, -7.49008066671, -5.49121405638, -3.49234753637, -1.49348109503, 0.505385279274, 2.50425159821, 4.50311787342, 6.50198411657, 8.50085033932, 10.4997165533, 12.4985827702, 14.4974490017, 16.4963152595, 18.4951815551, 20.4940479002, 22.4929143066, 24.4917807858, 26.4906473495, 28.4895140094, 30.488380777);

// Offsets and weights for n = 23, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_23[] = float[23] (0.0158572558637, 0.0338723065065, 0.0367131374703, 0.0394648878577, 0.0420739114357, 0.0444864291153, 0.0466503437274, 0.0485170953621, 0.0500434658737, 0.0511932393217, 0.0519386294298, 0.0522613955547, 0.0521535845943, 0.0516178567066, 0.0506673762143, 0.0493252739403, 0.0476237116354, 0.0456026013273, 0.0433080507681, 0.0407906194304, 0.0381034769055, 0.0353005567664, 0.0324347941928);
CONST_ARRAY float opt_gaussian_offsets_23[] = float[23] (-12.0, -10.4894127398, -8.49044537813, -6.49147809805, -4.49251089071, -2.49354374729, -0.494576658982, 1.50439038303, 3.50335738756, 5.50232436342, 7.50129131944, 9.50025826444, 11.4992252072, 13.4981921566, 15.4971591215, 17.4961261106, 19.4950931327, 21.4940601968, 23.4930273116, 25.4919944858, 27.4909617284, 29.4899290482, 31.4888964539);

// Offsets and weights for n = 24, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_24[] = float[24] (0.0151781193223, 0.0323321780903, 0.0349364627792, 0.0374662789601, 0.0398767590653, 0.0421227588364, 0.0441602397335, 0.0459476917322, 0.0474475330031, 0.0486274208977, 0.0494614105199, 0.0499309029722, 0.0500253348908, 0.0497425735707, 0.0490889970417, 0.0480792548951, 0.0467357223884, 0.0450876762325, 0.0431702344581, 0.0410231139437, 0.0386892669072, 0.0362134615119, 0.0336408715991, 0.0310157366487);
CONST_ARRAY float opt_gaussian_offsets_24[] = float[24] (-12.0, -10.4898407179, -8.49078554242, -6.49173043279, -4.49267538225, -2.49362038404, -0.494565431416, 1.50448948237, 3.50354436407, 5.50259922044, 7.50165405824, 9.50070888421, 11.4997637051, 13.4988185277, 15.4978733588, 17.496928205, 19.4959830732, 21.4950379701, 23.4940929025, 25.493147877, 27.4922029006, 29.4912579798, 31.4903131215, 33.4893683324);

// Offsets and weights for n = 25, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_25[] = float[25] (0.0145547717977, 0.0309256724585, 0.0333216402417, 0.0356548788588, 0.0378875858988, 0.0399816099167, 0.0418995150216, 0.0436056826279, 0.0450674056297, 0.0462559283339, 0.0471473860962, 0.047723601823, 0.0479727022219, 0.0478895246213, 0.0474757948889, 0.0467400678857, 0.0456974333241, 0.0443690011569, 0.04278119101, 0.0409648590605, 0.0389543026351, 0.0367861873003, 0.0344984431302, 0.032129176157, 0.0297156379033);
CONST_ARRAY float opt_gaussian_offsets_25[] = float[25] (-13.0, -11.4902356166, -9.49110336963, -7.49197117629, -5.49283903134, -3.49370692955, -1.49457486569, 0.504557165471, 2.50368916916, 4.50282115062, 6.50195311507, 8.50108506774, 10.5002170139, 12.4993489587, 14.4984809075, 16.4976128654, 18.4967448377, 20.4958768296, 22.4950088463, 24.4941408932, 26.4932729754, 28.4924050981, 30.4915372666, 32.4906694861, 34.4898017618);

// Offsets and weights for n = 26, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_26[] = float[26] (0.0139806095106, 0.0296361596261, 0.0318477401908, 0.0340061091799, 0.0360791996382, 0.0380345665842, 0.0398402151893, 0.0414654617847, 0.0428817957719, 0.0440637088489, 0.0449894579767, 0.0456417302531, 0.0460081813069, 0.0460818238265, 0.0458612491398, 0.0453506720284, 0.0445597967842, 0.0435035104568, 0.0422014168346, 0.0406772315419, 0.0389580643162, 0.0370736187825, 0.0350553426473, 0.0329355621081, 0.0307466334336, 0.028520142239);
CONST_ARRAY float opt_gaussian_offsets_26[] = float[26] (-13.0, -11.4906011073, -9.49140084797, -7.49220063267, -5.4930004573, -3.49380031775, -1.49460020994, 0.504599870223, 2.50379992684, 4.502999964, 6.5021999858, 8.50139999634, 10.5005999997, 12.4998, 14.4990000013, 16.4982000078, 18.4974000234, 20.4966000524, 22.4958000988, 24.4950001667, 26.4942002601, 28.4934003833, 30.4926005403, 32.4918007351, 34.4910009719, 36.4902012547);

// Offsets and weights for n = 27, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_27[] = float[27] (0.0134500314681, 0.028449654128, 0.0304972623514, 0.0324994402414, 0.0344288143118, 0.0362576299487, 0.0379584017792, 0.0395045923815, 0.040871296279, 0.0420359047813, 0.0429787269811, 0.0436835431173, 0.0441380685956, 0.0443343101221, 0.0442687995259, 0.0439426957131, 0.043361750565, 0.0425361401822, 0.0414801683926, 0.0402118545935, 0.0387524225201, 0.0371257101947, 0.0353575239501, 0.0334749609143, 0.0315057246655, 0.0294774579359, 0.0274171143604);
CONST_ARRAY float opt_gaussian_offsets_27[] = float[27] (-14.0, -12.4909403408, -10.4916797622, -8.49241922001, -6.493158711, -4.49389823193, -2.49463777955, -0.495377350649, 1.50388305803, 3.50314344971, 5.50240382763, 7.50166419504, 9.50092455516, 11.5001849112, 13.4994452665, 15.4987056242, 17.4979659876, 19.4972263598, 21.4964867442, 23.495747144, 25.4950075624, 27.4942680026, 29.4935284679, 31.4927889616, 33.4920494867, 35.4913100467, 37.4905706447);

// Offsets and weights for n = 28, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_28[] = float[28] (0.0129582560674, 0.0273543103165, 0.0292554660583, 0.0311176025635, 0.0329172158359, 0.0346304326621, 0.0362335258515, 0.0377034536229, 0.0390184062889, 0.0401583422803, 0.0411054951919, 0.0418448339636, 0.0423644595612, 0.0426559235313, 0.0427144565149, 0.0425390980829, 0.0421327229529, 0.0415019625886, 0.0406570251689, 0.0396114207574, 0.0383816020104, 0.0369865337755, 0.0354472073009, 0.0337861164192, 0.0320267139071, 0.030192866258, 0.0283083243587, 0.0263962261095);
CONST_ARRAY float opt_gaussian_offsets_28[] = float[28] (-14.0, -12.4912560356, -10.4919417129, -8.49262742053, -6.4933131559, -4.49399891644, -2.49468469955, -0.495370502671, 1.50394367679, 3.50325784141, 5.50257199378, 7.50188613646, 9.50120027204, 11.5005144031, 13.4998285322, 15.499142662, 17.498456795, 19.4977709338, 21.497085081, 23.4963992392, 25.4957134109, 27.4950275988, 29.4943418053, 31.4936560332, 33.4929702849, 35.4922845631, 37.4915988703, 39.4909132091);

// Offsets and weights for n = 29, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_29[] = float[29] (0.0125011765317, 0.0263400288238, 0.0281098505852, 0.0298459733379, 0.0315281054522, 0.0331356062206, 0.0346478974098, 0.036044895224, 0.0373074502411, 0.0384177819917, 0.0393598944759, 0.0401199590865, 0.040686652145, 0.0410514355414, 0.0412087707617, 0.0411562588012, 0.0408947010275, 0.0404280788327, 0.039763452797, 0.0389107849351, 0.037882690277, 0.0366941264423, 0.0353620318792, 0.0339049249866, 0.03234247735, 0.030695074782, 0.0289833797506, 0.0272279081406, 0.0254486321699);
CONST_ARRAY float opt_gaussian_offsets_29[] = float[29] (-15.0, -13.4915505493, -11.4921881357, -9.49282574751, -7.49346338263, -5.49410103902, -3.49473871461, -1.49537640731, 0.503985884951, 2.50334816424, 4.50271043263, 6.50207269221, 8.50143494504, 10.5007971932, 12.5001594388, 14.4995216838, 16.4988839304, 18.4982461807, 20.4976084366, 22.4969707003, 24.4963329739, 26.4956952594, 28.4950575589, 30.4944198745, 32.4937822083, 34.4931445623, 36.4925069386, 38.4918693392, 40.4912317663);

// Offsets and weights for n = 30, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_30[] = float[30] (0.0120752459112, 0.0253981466755, 0.0270497479603, 0.0286720947252, 0.0302475794896, 0.031758269856, 0.0331862397737, 0.0345139179849, 0.0357244443761, 0.0368020242498, 0.0377322701791, 0.038502521139, 0.0391021290372, 0.0395227035884, 0.0397583076624, 0.0398055967488, 0.0396638979611, 0.0393352259681, 0.0388242353293, 0.0381381108078, 0.0372863992743, 0.0362807887003, 0.0351348413894, 0.033863689954, 0.0324837055512, 0.0310121485206, 0.0294668117938, 0.0278656672835, 0.0262265249262, 0.0245667131829);
CONST_ARRAY float opt_gaussian_offsets_30[] = float[30] (-15.0, -13.4918259364, -11.4924203191, -9.49301472323, -7.49360914711, -5.49420358906, -3.49479804739, -1.49539252043, 0.504012993496, 2.50341849608, 4.502823989, 6.50222947393, 8.50163495256, 10.5010404266, 12.5004458976, 14.4998513674, 16.4992568376, 18.49866231, 20.4980677861, 22.4974732676, 24.4968787564, 26.4962842539, 28.4956897619, 30.4950952822, 32.4945008163, 34.4939063659, 36.4933119328, 38.4927175186, 40.492123125, 42.4915287536);

// Offsets and weights for n = 31, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_31[] = float[31] (0.0116773848279, 0.0245211910437, 0.0260660009978, 0.0275852924479, 0.0290637143118, 0.0304856161901, 0.0318353169301, 0.0330973876259, 0.0342569420705, 0.0352999271142, 0.0362134050695, 0.0369858202625, 0.0376072420704, 0.0380695773066, 0.0383667456063, 0.0384948125006, 0.038452076108, 0.0382391047728, 0.0378587244857, 0.0373159564788, 0.0366179069173, 0.0357736120795, 0.0347938437368, 0.0336908805939, 0.0324782525631, 0.0311704653064, 0.0297827128626, 0.0283305862735, 0.0268297859433, 0.0252958450278, 0.0237438704745);
CONST_ARRAY float opt_gaussian_offsets_31[] = float[31] (-16.0, -14.4920839948, -12.4926394207, -10.4931948647, -8.4937503255, -6.49430580175, -4.49486129205, -2.49541679504, -0.495972309343, 1.50347216641, 3.50291663358, 5.50236109356, 7.50180554771, 9.5012499974, 11.500694444, 13.5001388889, 15.4995833334, 17.499027779, 19.498472227, 21.4979166787, 23.4973611356, 25.496805599, 27.4962500703, 29.4956945509, 31.495139042, 33.4945835452, 35.4940280618, 37.4934725931, 39.4929171405, 41.4923617054, 43.4918062891);

// Offsets and weights for n = 32, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_32[] = float[32] (0.011304906882, 0.0237026819171, 0.0251507065416, 0.0265763713896, 0.0279662329755, 0.0293065739824, 0.0305836224684, 0.0317837831985, 0.0328938757947, 0.033901373955, 0.0347946397202, 0.0355631466938, 0.0361976862432, 0.0366905510441, 0.0370356908544, 0.0372288361197, 0.037267585878, 0.037151457434, 0.0368818963668, 0.0364622465804, 0.0358976812639, 0.0351950967552, 0.0343629723527, 0.0334112000569, 0.0323508890215, 0.0311941501124, 0.0299538664055, 0.0286434556815, 0.0272766310021, 0.0258671652733, 0.0244286653474, 0.0229743606882);
CONST_ARRAY float opt_gaussian_offsets_32[] = float[32] (-16.0, -14.492326305, -12.4928464819, -10.4933666743, -8.49388688111, -6.49440710113, -4.49492733326, -2.49544757637, -0.495967829348, 1.50351190895, 3.50299163964, 5.50247136385, 7.50195108271, 9.50143079734, 11.5009105089, 13.5003902184, 15.4998699272, 17.4993496362, 19.4988293466, 21.4983090595, 23.4977887761, 25.4972684975, 27.4967482248, 29.4962279592, 31.4957077017, 33.4951874535, 35.4946672158, 37.4941469895, 39.493626776, 41.4931065762, 43.4925863914, 45.4920662227);

// Offsets and weights for n = 33, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_33[] = float[33] (0.010955457899, 0.022936972726, 0.0242970090863, 0.0256373708328, 0.0269462357952, 0.0282115324444, 0.0294211199518, 0.0305629784405, 0.0316254053597, 0.0325972135674, 0.0334679264771, 0.0342279655323, 0.0348688253347, 0.0353832319562, 0.0357652803168, 0.0360105470026, 0.0361161755112, 0.0360809316269, 0.0359052274243, 0.0355911132491, 0.035142237893, 0.0345637780447, 0.0338623389239, 0.0330458287657, 0.0321233104888, 0.0311048344353, 0.0300012564944, 0.0288240461997, 0.0275850895258, 0.0262964910892, 0.0249703803037, 0.0236187257427, 0.0222531615586);
CONST_ARRAY float opt_gaussian_offsets_33[] = float[33] (-17.0, -15.4925542614, -13.4930424413, -11.4935306345, -9.49401884001, -7.49450705693, -5.49499528434, -3.49548352128, -1.49597176684, 0.503539979913, 2.50305171992, 4.5025634541, 6.5020751834, 8.50158690873, 10.501098631, 12.5006103513, 14.5001220703, 16.4996337891, 18.4991455086, 20.4986572298, 22.4981689535, 24.4976806807, 26.4971924123, 28.4967041493, 30.4962158926, 32.495727643, 34.4952394017, 36.4947511694, 38.4942629471, 40.4937747358, 42.4932865363, 44.4927983496, 46.4923101767);

// Offsets and weights for n = 34, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_34[] = float[34] (0.0106269661092, 0.0222191206788, 0.0234989336619, 0.0247613662628, 0.0259959812184, 0.0271921148783, 0.0283390259971, 0.029426053101, 0.0304427772918, 0.031379187067, 0.03222584155, 0.03297402843, 0.0336159129307, 0.0341446742532, 0.0345546261735, 0.0348413188147, 0.0350016190478, 0.0350337674884, 0.0349374106417, 0.0347136073722, 0.0343648095349, 0.0338948172612, 0.0333087100411, 0.0326127553496, 0.0318142971136, 0.0309216267959, 0.0299438402574, 0.0288906838477, 0.0277723933565, 0.0265995295291, 0.025382813813, 0.0241329678608, 0.0228605600791, 0.0215758621912);
CONST_ARRAY float opt_gaussian_offsets_34[] = float[34] (-17.0, -15.4927690992, -13.493228146, -11.4936872042, -9.49414627298, -7.49460535168, -5.49506443947, -3.49552353559, -1.49598263925, 0.503558250306, 2.50309913386, 4.5026400122, 6.50218088608, 8.50172175628, 10.5012626236, 12.5008034887, 14.5003443526, 16.4998852158, 18.4994260792, 20.4989669436, 22.4985078098, 24.4980486784, 26.4975895504, 28.4971304264, 30.4966713072, 32.4962121937, 34.4957530865, 36.4952939865, 38.4948348945, 40.4943758111, 42.4939167373, 44.4934576737, 46.4929986211, 48.4925395803);

// Offsets and weights for n = 35, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_35[] = float[35] (0.0103176010324, 0.0215447805499, 0.0227512495695, 0.0239423078106, 0.025108706565, 0.0262409919812, 0.0273296287144, 0.0283651308048, 0.0293381973431, 0.0302398502594, 0.0310615714112, 0.0317954360651, 0.0324342398575, 0.0329716163978, 0.0334021428322, 0.0337214309223, 0.033926201499, 0.034014340527, 0.0339849354379, 0.0338382908596, 0.0335759233627, 0.0332005353504, 0.0327159687203, 0.0321271394105, 0.0314399543874, 0.0306612130365, 0.0297984952565, 0.0288600388309, 0.027854608845, 0.0267913620359, 0.0256797089935, 0.0245291770894, 0.0233492768839, 0.0221493745731, 0.0209385727842);
CONST_ARRAY float opt_gaussian_offsets_35[] = float[35] (-18.0, -16.4929719162, -14.4934043618, -12.4938368174, -10.4942692821, -8.49470175541, -6.49513423665, -4.49556672518, -2.49599922033, -0.49643172148, 1.50313577204, 3.50270326086, 5.50227074563, 7.50183822701, 9.50140570564, 11.5009731822, 13.5005406572, 15.5001081315, 17.4996756056, 19.4992430802, 21.4988105559, 23.4983780334, 25.4979455133, 27.4975129963, 29.497080483, 31.4966479741, 33.4962154702, 35.495782972, 37.49535048, 39.4949179951, 41.4944855177, 43.4940530486, 45.4936205884, 47.4931881378, 49.4927556973);

// Offsets and weights for n = 36, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_36[] = float[36] (0.0100257393422, 0.0209101171194, 0.0220493585518, 0.0231748877373, 0.0242784805505, 0.0253517271725, 0.0263861353948, 0.0273732400312, 0.0283047165243, 0.0291724966555, 0.029968884136, 0.0306866677818, 0.0313192299543, 0.0318606479935, 0.0323057864723, 0.0326503782638, 0.0328910926329, 0.0330255888321, 0.0330525539969, 0.0329717244812, 0.0327838901489, 0.0324908815237, 0.0320955400894, 0.0316016724148, 0.031013989138, 0.0303380301802, 0.0295800778452, 0.028747059714, 0.027846443428, 0.0268861255931, 0.0258743171068, 0.0248194272242, 0.0237299486283, 0.02261434567, 0.0214809477837, 0.0203378498874);
CONST_ARRAY float opt_gaussian_offsets_36[] = float[36] (-18.0, -16.4931636913, -14.4935717828, -12.4939798828, -10.4943879908, -8.49479610628, -6.49520422871, -4.49561235753, -2.4960204922, -0.496428632166, 1.5031632231, 3.50275507416, 5.50234692154, 7.50193876579, 9.50153060746, 11.5011224471, 13.5007142852, 15.5003061224, 17.4998979592, 19.4994897961, 21.4990816337, 23.4986734725, 25.4982653131, 27.497857156, 29.4974490017, 31.4970408509, 33.496632704, 35.4962245616, 37.4958164242, 39.4954082924, 41.4950001667, 43.4945920476, 45.4941839358, 47.4937758317, 49.493367736, 51.492959649);

// Offsets and weights for n = 37, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_37[] = float[37] (0.00974993636734, 0.0203117325559, 0.0213892024529, 0.0224544310942, 0.0235000813023, 0.0245186478884, 0.0255025443957, 0.0264441950142, 0.0273361301596, 0.0281710840642, 0.0289420926191, 0.0296425896425, 0.0302664997198, 0.0308083257886, 0.0312632297024, 0.0316271041272, 0.0318966342731, 0.032069348168, 0.0321436544031, 0.0321188665476, 0.031995213706, 0.0317738369926, 0.0314567719985, 0.0310469176281, 0.0305479919715, 0.0299644761535, 0.0293015473444, 0.0285650023323, 0.0277611732343, 0.0268968370582, 0.0259791209177, 0.0250154047456, 0.0240132233523, 0.0229801696268, 0.0219238005913, 0.0208515478943, 0.0197706341665);
CONST_ARRAY float opt_gaussian_offsets_37[] = float[37] (-19.0, -17.4933453004, -15.4937310384, -13.4941167839, -11.4945025364, -9.49488829538, -7.4952740605, -5.49565983124, -3.49604560714, -1.49643138776, 0.503182827378, 2.50279703872, 4.50241124674, 6.50202545188, 8.50163965462, 10.5012538554, 12.5008680547, 14.5004822529, 16.5000964506, 18.4997106482, 20.4993248461, 22.4989390448, 24.4985532448, 26.4981674465, 28.4977816504, 30.4973958569, 32.4970100665, 34.4966242797, 36.4962384969, 38.4958527186, 40.4954669452, 42.4950811772, 44.4946954151, 46.4943096593, 48.4939239102, 50.4935381684, 52.4931524343);

// Offsets and weights for n = 38, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_38[] = float[38] (0.00948890217078, 0.0197466058518, 0.0207671865319, 0.0217768050027, 0.0227688949424, 0.0237367380186, 0.0246735370734, 0.0255724936997, 0.0264268890116, 0.0272301662959, 0.0279760141433, 0.0286584485977, 0.0292718928381, 0.0298112529127, 0.030271988092, 0.030650174481, 0.030942560647, 0.0311466141591, 0.0312605581081, 0.0312833968702, 0.0312149305926, 0.0310557581051, 0.0308072681993, 0.0304716194529, 0.0300517090085, 0.0295511309394, 0.028974125038, 0.0283255170485, 0.0276106515206, 0.0268353185907, 0.0260056760908, 0.025128168447, 0.0242094438539, 0.0232562712038, 0.0222754582054, 0.0212737720531, 0.0202578639043, 0.0192341982982);
CONST_ARRAY float opt_gaussian_offsets_38[] = float[38] (-19.0, -17.4935175291, -15.4938827012, -13.4942478798, -11.4946130645, -9.49497825506, -7.49534345092, -5.49570865176, -3.49607385718, -1.49643906678, 0.503195719814, 2.502830503, 4.50246528316, 6.5021000607, 8.50173483599, 10.5013696094, 12.5010043814, 14.5006391523, 16.5002739225, 18.4999086925, 20.4995434625, 22.499178233, 24.4988130044, 26.4984477771, 28.4980825514, 30.4977173278, 32.4973521066, 34.4969868882, 36.496621673, 38.4962564615, 40.4958912539, 42.4955260507, 44.4951608523, 46.4947956591, 48.4944304714, 50.4940652897, 52.4937001143, 54.4933349456);

// Offsets and weights for n = 39, relative to pixel center
CONST_ARRAY float opt_gaussian_weights_39[] = float[39] (0.00924148137305, 0.0192120420422, 0.0201801154313, 0.0211383429813, 0.0220808308543, 0.023001547634, 0.0238943863517, 0.0247532302506, 0.0255720213328, 0.0263448306384, 0.0270659291345, 0.0277298580395, 0.0283314973845, 0.0288661316105, 0.0293295110303, 0.0297179080354, 0.0300281670083, 0.0302577470078, 0.0304047564176, 0.030467978898, 0.0304468901444, 0.0303416651267, 0.0301531756723, 0.0298829784382, 0.0295332935044, 0.029106974001, 0.0286074673487, 0.0280387688511, 0.027405368511, 0.0267121920605, 0.0259645372878, 0.0251680068087, 0.0243284384733, 0.0234518346107, 0.0225442913003, 0.0216119288229, 0.0206608243792, 0.0196969480813, 0.0187261031213);
CONST_ARRAY float opt_gaussian_offsets_39[] = float[39] (-20.0, -18.4936810844, -16.4940272924, -14.4943735062, -12.4947197254, -10.4950659496, -8.49541217862, -6.495758412, -4.49610464945, -2.49645089063, -0.496797135222, 1.50285661712, 3.50251036672, 5.50216411391, 7.50181785903, 9.5014716024, 11.5011253444, 13.5007790852, 15.5004328254, 17.5000865651, 19.4997403047, 21.4993940446, 23.4990477851, 25.4987015265, 27.4983552691, 29.4980090133, 31.4976627594, 33.4973165078, 35.4969702587, 37.4966240125, 39.4962777696, 41.4959315302, 43.4955852948, 45.4952390636, 47.4948928369, 49.4945466151, 51.4942003986, 53.4938541877, 55.4935079826);
