# generated by datamodel-codegen:
#   filename:  schema/metadataIngestion/databaseServiceMetadataPipeline.json
#   timestamp: 2022-05-10T12:09:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ..security.credentials import awsCredentials, gcsCredentials
from ..type import filterPattern


class DatabaseMetadataConfigType(Enum):
    DatabaseMetadata = 'DatabaseMetadata'


class DbtBucketDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtBucketName: Optional[str] = Field(
        None,
        description='Name of the bucket where the dbt files are stored',
        title='DBT Bucket Name',
    )
    dbtObjectPrefix: Optional[str] = Field(
        None,
        description='Path of the folder where the dbt files are stored',
        title='DBT Object Prefix',
    )


class DbtLocalConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtCatalogFilePath: str = Field(
        ...,
        description='DBT catalog file path to extract dbt models with their column schemas.',
    )
    dbtManifestFilePath: str = Field(
        ...,
        description='DBT manifest file path to extract dbt models and associate with tables.',
    )


class DbtHttpConfig(BaseModel):
    class Config:
        extra = Extra.forbid

    dbtCatalogHttpPath: str = Field(
        ...,
        description='DBT catalog http file path to extract dbt models with their column schemas.',
    )
    dbtManifestHttpPath: str = Field(
        ...,
        description='DBT manifest http file path to extract dbt models and associate with tables.',
    )


class DbtS3Config(BaseModel):
    dbtSecurityConfig: Optional[awsCredentials.AWSCredentials] = Field(
        None, title='DBT S3 Security Config'
    )
    dbtPrefixConfig: Optional[DbtBucketDetails] = Field(None, title='DBT Prefix Config')


class DbtGCSConfig(BaseModel):
    dbtSecurityConfig: Optional[gcsCredentials.GCSCredentials] = Field(
        None, title='DBT GCS Security Config'
    )
    dbtPrefixConfig: Optional[DbtBucketDetails] = Field(None, title='DBT Prefix Config')


class DatabaseServiceMetadataPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DatabaseMetadataConfigType] = Field(
        DatabaseMetadataConfigType.DatabaseMetadata, description='Pipeline type'
    )
    markDeletedTables: Optional[bool] = Field(
        True,
        description='Optional configuration to soft delete tables in OpenMetadata if the source tables are deleted.',
    )
    includeTables: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for tables.',
    )
    includeViews: Optional[bool] = Field(
        True,
        description='Optional configuration to turn off fetching metadata for views.',
    )
    generateSampleData: Optional[bool] = Field(
        True,
        description='Option to turn on/off generating sample data during metadata extraction.',
    )
    sampleDataQuery: Optional[str] = Field(
        'select * from {}.{} limit 50', description='Sample data extraction query.'
    )
    enableDataProfiler: Optional[bool] = Field(
        False,
        description='Run data profiler as part of this metadata ingestion to get table profile data.',
    )
    schemaFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None,
        description='Regex to only fetch tables or databases that matches the pattern.',
    )
    tableFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex exclude tables or databases that matches the pattern.'
    )
    databaseFilterPattern: Optional[filterPattern.FilterPattern] = Field(
        None, description='Regex to only fetch databases that matches the pattern.'
    )
    dbtConfigSource: Optional[
        Union[DbtLocalConfig, DbtHttpConfig, DbtS3Config, DbtGCSConfig]
    ] = Field(
        None,
        description='Available sources to fetch DBT catalog and manifest files.',
        title='DBT Configuration Source',
    )
