# generated by datamodel-codegen:
#   filename:  schema/entity/services/connections/database/oracleConnection.json
#   timestamp: 2022-05-10T12:09:01+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class OracleType(Enum):
    Oracle = 'Oracle'


class OracleScheme(Enum):
    oracle_cx_oracle = 'oracle+cx_oracle'


class OracleConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[OracleType] = Field(
        OracleType.Oracle, description='Service Type', title='Service Type'
    )
    scheme: Optional[OracleScheme] = Field(
        OracleScheme.oracle_cx_oracle,
        description='SQLAlchemy driver scheme options.',
        title='Connection Scheme',
    )
    username: str = Field(
        ...,
        description='Username to connect to Oracle. This user should have privileges to read all the metadata in Oracle.',
        title='Username',
    )
    password: Optional[SecretStr] = Field(
        None, description='Password to connect to Oracle.', title='Password'
    )
    hostPort: str = Field(
        ..., description='Host and port of the Oracle service.', title='Host and Port'
    )
    database: Optional[str] = Field(
        None,
        description='Database of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single database. When left blank, OpenMetadata Ingestion attempts to scan all the databases.',
        title='Database',
    )
    oracleServiceName: Optional[str] = Field(
        None,
        description='Oracle Service Name to be passed. Note: either Database or Oracle service name can be sent, not both.',
        title='Oracle Service Name',
    )
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = Field(
        None, title='Connection Options'
    )
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = Field(
        None, title='Connection Arguments'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
    supportsProfiler: Optional[connectionBasicType.SupportsProfiler] = Field(
        None, title='Supports Profiler'
    )
