import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::ServiceCatalog::AcceptedPortfolioShare`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html
 * @external
 */
export interface CfnAcceptedPortfolioShareProps {
    /**
     * `AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::AcceptedPortfolioShare`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::AcceptedPortfolioShare
 */
export declare class CfnAcceptedPortfolioShare extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::AcceptedPortfolioShare";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAcceptedPortfolioShare;
    /**
     * `AWS::ServiceCatalog::AcceptedPortfolioShare.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::AcceptedPortfolioShare.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-acceptedportfolioshare.html#cfn-servicecatalog-acceptedportfolioshare-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::AcceptedPortfolioShare`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAcceptedPortfolioShareProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::CloudFormationProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html
 * @external
 */
export interface CfnCloudFormationProductProps {
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Owner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-owner
     * @external
     */
    readonly owner: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.ProvisioningArtifactParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactparameters
     * @external
     */
    readonly provisioningArtifactParameters: Array<CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Distributor`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-distributor
     * @external
     */
    readonly distributor?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.ReplaceProvisioningArtifacts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-replaceprovisioningartifacts
     * @external
     */
    readonly replaceProvisioningArtifacts?: boolean | cdk.IResolvable;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.SupportDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-supportdescription
     * @external
     */
    readonly supportDescription?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.SupportEmail`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-supportemail
     * @external
     */
    readonly supportEmail?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.SupportUrl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-supporturl
     * @external
     */
    readonly supportUrl?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::CloudFormationProduct
 */
export declare class CfnCloudFormationProduct extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::CloudFormationProduct";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCloudFormationProduct;
    /**
     * @external
     * @cloudformationAttribute ProductName
     */
    readonly attrProductName: string;
    /**
     * @external
     * @cloudformationAttribute ProvisioningArtifactIds
     */
    readonly attrProvisioningArtifactIds: string;
    /**
     * @external
     * @cloudformationAttribute ProvisioningArtifactNames
     */
    readonly attrProvisioningArtifactNames: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-name
     * @external
     */
    name: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Owner`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-owner
     * @external
     */
    owner: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.ProvisioningArtifactParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactparameters
     * @external
     */
    provisioningArtifactParameters: Array<CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Distributor`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-distributor
     * @external
     */
    distributor: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.ReplaceProvisioningArtifacts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-replaceprovisioningartifacts
     * @external
     */
    replaceProvisioningArtifacts: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.SupportDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-supportdescription
     * @external
     */
    supportDescription: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.SupportEmail`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-supportemail
     * @external
     */
    supportEmail: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.SupportUrl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-supporturl
     * @external
     */
    supportUrl: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProduct.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html#cfn-servicecatalog-cloudformationproduct-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ServiceCatalog::CloudFormationProduct`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCloudFormationProductProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationproduct.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::CloudFormationProduct
 */
export declare namespace CfnCloudFormationProduct {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html
     * @external
     */
    interface ProvisioningArtifactPropertiesProperty {
        /**
         * `CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty.Description`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-description
         * @external
         */
        readonly description?: string;
        /**
         * `CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty.DisableTemplateValidation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-disabletemplatevalidation
         * @external
         */
        readonly disableTemplateValidation?: boolean | cdk.IResolvable;
        /**
         * `CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty.Info`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-info
         * @external
         */
        readonly info: any | cdk.IResolvable;
        /**
         * `CfnCloudFormationProduct.ProvisioningArtifactPropertiesProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationproduct-provisioningartifactproperties.html#cfn-servicecatalog-cloudformationproduct-provisioningartifactproperties-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * Properties for defining a `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html
 * @external
 */
export interface CfnCloudFormationProvisionedProductProps {
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.NotificationArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-notificationarns
     * @external
     */
    readonly notificationArns?: string[];
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.PathId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-pathid
     * @external
     */
    readonly pathId?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.PathName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-pathname
     * @external
     */
    readonly pathName?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-productid
     * @external
     */
    readonly productId?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-productname
     * @external
     */
    readonly productName?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisionedProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisionedproductname
     * @external
     */
    readonly provisionedProductName?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningArtifactId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningartifactid
     * @external
     */
    readonly provisioningArtifactId?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningArtifactName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningartifactname
     * @external
     */
    readonly provisioningArtifactName?: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameters
     * @external
     */
    readonly provisioningParameters?: Array<CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningPreferences`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences
     * @external
     */
    readonly provisioningPreferences?: CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty | cdk.IResolvable;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::CloudFormationProvisionedProduct
 */
export declare class CfnCloudFormationProvisionedProduct extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::CloudFormationProvisionedProduct";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCloudFormationProvisionedProduct;
    /**
     * @external
     * @cloudformationAttribute CloudformationStackArn
     */
    readonly attrCloudformationStackArn: string;
    /**
     * @external
     * @cloudformationAttribute Outputs
     */
    readonly attrOutputs: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ProvisionedProductId
     */
    readonly attrProvisionedProductId: string;
    /**
     * @external
     * @cloudformationAttribute RecordId
     */
    readonly attrRecordId: string;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.NotificationArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-notificationarns
     * @external
     */
    notificationArns: string[] | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.PathId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-pathid
     * @external
     */
    pathId: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.PathName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-pathname
     * @external
     */
    pathName: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-productid
     * @external
     */
    productId: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-productname
     * @external
     */
    productName: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisionedProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisionedproductname
     * @external
     */
    provisionedProductName: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningArtifactId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningartifactid
     * @external
     */
    provisioningArtifactId: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningArtifactName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningartifactname
     * @external
     */
    provisioningArtifactName: string | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningParameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameters
     * @external
     */
    provisioningParameters: Array<CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.ProvisioningPreferences`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences
     * @external
     */
    provisioningPreferences: CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ServiceCatalog::CloudFormationProvisionedProduct.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html#cfn-servicecatalog-cloudformationprovisionedproduct-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnCloudFormationProvisionedProductProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::CloudFormationProvisionedProduct
 */
export declare namespace CfnCloudFormationProvisionedProduct {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html
     * @external
     */
    interface ProvisioningParameterProperty {
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningParameterProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningparameter.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningparameter-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::ServiceCatalog::CloudFormationProvisionedProduct`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-cloudformationprovisionedproduct.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::CloudFormationProvisionedProduct
 */
export declare namespace CfnCloudFormationProvisionedProduct {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html
     * @external
     */
    interface ProvisioningPreferencesProperty {
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetAccounts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetaccounts
         * @external
         */
        readonly stackSetAccounts?: string[];
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetFailureToleranceCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetfailuretolerancecount
         * @external
         */
        readonly stackSetFailureToleranceCount?: number;
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetFailureTolerancePercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetfailuretolerancepercentage
         * @external
         */
        readonly stackSetFailureTolerancePercentage?: number;
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetMaxConcurrencyCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetmaxconcurrencycount
         * @external
         */
        readonly stackSetMaxConcurrencyCount?: number;
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetMaxConcurrencyPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetmaxconcurrencypercentage
         * @external
         */
        readonly stackSetMaxConcurrencyPercentage?: number;
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetOperationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetoperationtype
         * @external
         */
        readonly stackSetOperationType?: string;
        /**
         * `CfnCloudFormationProvisionedProduct.ProvisioningPreferencesProperty.StackSetRegions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences.html#cfn-servicecatalog-cloudformationprovisionedproduct-provisioningpreferences-stacksetregions
         * @external
         */
        readonly stackSetRegions?: string[];
    }
}
/**
 * Properties for defining a `AWS::ServiceCatalog::LaunchNotificationConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html
 * @external
 */
export interface CfnLaunchNotificationConstraintProps {
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.NotificationArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-notificationarns
     * @external
     */
    readonly notificationArns: string[];
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-productid
     * @external
     */
    readonly productId: string;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::LaunchNotificationConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::LaunchNotificationConstraint
 */
export declare class CfnLaunchNotificationConstraint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::LaunchNotificationConstraint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchNotificationConstraint;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.NotificationArns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-notificationarns
     * @external
     */
    notificationArns: string[];
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-productid
     * @external
     */
    productId: string;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::LaunchNotificationConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchnotificationconstraint.html#cfn-servicecatalog-launchnotificationconstraint-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::LaunchNotificationConstraint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLaunchNotificationConstraintProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::LaunchRoleConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html
 * @external
 */
export interface CfnLaunchRoleConstraintProps {
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-productid
     * @external
     */
    readonly productId: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.LocalRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-localrolename
     * @external
     */
    readonly localRoleName?: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-rolearn
     * @external
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::LaunchRoleConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::LaunchRoleConstraint
 */
export declare class CfnLaunchRoleConstraint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::LaunchRoleConstraint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchRoleConstraint;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-productid
     * @external
     */
    productId: string;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.LocalRoleName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-localrolename
     * @external
     */
    localRoleName: string | undefined;
    /**
     * `AWS::ServiceCatalog::LaunchRoleConstraint.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchroleconstraint.html#cfn-servicecatalog-launchroleconstraint-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::LaunchRoleConstraint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLaunchRoleConstraintProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::LaunchTemplateConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html
 * @external
 */
export interface CfnLaunchTemplateConstraintProps {
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-productid
     * @external
     */
    readonly productId: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.Rules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-rules
     * @external
     */
    readonly rules: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::LaunchTemplateConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::LaunchTemplateConstraint
 */
export declare class CfnLaunchTemplateConstraint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::LaunchTemplateConstraint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLaunchTemplateConstraint;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-productid
     * @external
     */
    productId: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.Rules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-rules
     * @external
     */
    rules: string;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::LaunchTemplateConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-launchtemplateconstraint.html#cfn-servicecatalog-launchtemplateconstraint-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::LaunchTemplateConstraint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLaunchTemplateConstraintProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::Portfolio`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html
 * @external
 */
export interface CfnPortfolioProps {
    /**
     * `AWS::ServiceCatalog::Portfolio.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-displayname
     * @external
     */
    readonly displayName: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.ProviderName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-providername
     * @external
     */
    readonly providerName: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ServiceCatalog::Portfolio`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::Portfolio
 */
export declare class CfnPortfolio extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::Portfolio";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPortfolio;
    /**
     * @external
     * @cloudformationAttribute PortfolioName
     */
    readonly attrPortfolioName: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-displayname
     * @external
     */
    displayName: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.ProviderName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-providername
     * @external
     */
    providerName: string;
    /**
     * `AWS::ServiceCatalog::Portfolio.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::Portfolio.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::ServiceCatalog::Portfolio.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolio.html#cfn-servicecatalog-portfolio-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ServiceCatalog::Portfolio`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPortfolioProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::PortfolioPrincipalAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html
 * @external
 */
export interface CfnPortfolioPrincipalAssociationProps {
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.PrincipalARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-principalarn
     * @external
     */
    readonly principalArn: string;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.PrincipalType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-principaltype
     * @external
     */
    readonly principalType: string;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::PortfolioPrincipalAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::PortfolioPrincipalAssociation
 */
export declare class CfnPortfolioPrincipalAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::PortfolioPrincipalAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPortfolioPrincipalAssociation;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.PrincipalARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-principalarn
     * @external
     */
    principalArn: string;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.PrincipalType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-principaltype
     * @external
     */
    principalType: string;
    /**
     * `AWS::ServiceCatalog::PortfolioPrincipalAssociation.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioprincipalassociation.html#cfn-servicecatalog-portfolioprincipalassociation-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::PortfolioPrincipalAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPortfolioPrincipalAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::PortfolioProductAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html
 * @external
 */
export interface CfnPortfolioProductAssociationProps {
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-productid
     * @external
     */
    readonly productId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.SourcePortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-sourceportfolioid
     * @external
     */
    readonly sourcePortfolioId?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::PortfolioProductAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::PortfolioProductAssociation
 */
export declare class CfnPortfolioProductAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::PortfolioProductAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPortfolioProductAssociation;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-productid
     * @external
     */
    productId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::PortfolioProductAssociation.SourcePortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioproductassociation.html#cfn-servicecatalog-portfolioproductassociation-sourceportfolioid
     * @external
     */
    sourcePortfolioId: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::PortfolioProductAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPortfolioProductAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::PortfolioShare`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html
 * @external
 */
export interface CfnPortfolioShareProps {
    /**
     * `AWS::ServiceCatalog::PortfolioShare.AccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html#cfn-servicecatalog-portfolioshare-accountid
     * @external
     */
    readonly accountId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioShare.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html#cfn-servicecatalog-portfolioshare-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioShare.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html#cfn-servicecatalog-portfolioshare-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::PortfolioShare`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::PortfolioShare
 */
export declare class CfnPortfolioShare extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::PortfolioShare";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPortfolioShare;
    /**
     * `AWS::ServiceCatalog::PortfolioShare.AccountId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html#cfn-servicecatalog-portfolioshare-accountid
     * @external
     */
    accountId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioShare.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html#cfn-servicecatalog-portfolioshare-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::PortfolioShare.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-portfolioshare.html#cfn-servicecatalog-portfolioshare-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::PortfolioShare`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPortfolioShareProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::ResourceUpdateConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html
 * @external
 */
export interface CfnResourceUpdateConstraintProps {
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-productid
     * @external
     */
    readonly productId: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.TagUpdateOnProvisionedProduct`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-tagupdateonprovisionedproduct
     * @external
     */
    readonly tagUpdateOnProvisionedProduct: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-description
     * @external
     */
    readonly description?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::ResourceUpdateConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::ResourceUpdateConstraint
 */
export declare class CfnResourceUpdateConstraint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::ResourceUpdateConstraint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResourceUpdateConstraint;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-productid
     * @external
     */
    productId: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.TagUpdateOnProvisionedProduct`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-tagupdateonprovisionedproduct
     * @external
     */
    tagUpdateOnProvisionedProduct: string;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * `AWS::ServiceCatalog::ResourceUpdateConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html#cfn-servicecatalog-resourceupdateconstraint-description
     * @external
     */
    description: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::ResourceUpdateConstraint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceUpdateConstraintProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::StackSetConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html
 * @external
 */
export interface CfnStackSetConstraintProps {
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AccountList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-accountlist
     * @external
     */
    readonly accountList: string[];
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AdminRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-adminrole
     * @external
     */
    readonly adminRole: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-description
     * @external
     */
    readonly description: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.ExecutionRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-executionrole
     * @external
     */
    readonly executionRole: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-portfolioid
     * @external
     */
    readonly portfolioId: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-productid
     * @external
     */
    readonly productId: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.RegionList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-regionlist
     * @external
     */
    readonly regionList: string[];
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.StackInstanceControl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-stackinstancecontrol
     * @external
     */
    readonly stackInstanceControl: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-acceptlanguage
     * @external
     */
    readonly acceptLanguage?: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::StackSetConstraint`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::StackSetConstraint
 */
export declare class CfnStackSetConstraint extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::StackSetConstraint";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStackSetConstraint;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AccountList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-accountlist
     * @external
     */
    accountList: string[];
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AdminRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-adminrole
     * @external
     */
    adminRole: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-description
     * @external
     */
    description: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.ExecutionRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-executionrole
     * @external
     */
    executionRole: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.PortfolioId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-portfolioid
     * @external
     */
    portfolioId: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.ProductId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-productid
     * @external
     */
    productId: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.RegionList`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-regionlist
     * @external
     */
    regionList: string[];
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.StackInstanceControl`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-stackinstancecontrol
     * @external
     */
    stackInstanceControl: string;
    /**
     * `AWS::ServiceCatalog::StackSetConstraint.AcceptLanguage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-stacksetconstraint.html#cfn-servicecatalog-stacksetconstraint-acceptlanguage
     * @external
     */
    acceptLanguage: string | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::StackSetConstraint`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackSetConstraintProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::TagOption`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html
 * @external
 */
export interface CfnTagOptionProps {
    /**
     * `AWS::ServiceCatalog::TagOption.Key`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html#cfn-servicecatalog-tagoption-key
     * @external
     */
    readonly key: string;
    /**
     * `AWS::ServiceCatalog::TagOption.Value`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html#cfn-servicecatalog-tagoption-value
     * @external
     */
    readonly value: string;
    /**
     * `AWS::ServiceCatalog::TagOption.Active`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html#cfn-servicecatalog-tagoption-active
     * @external
     */
    readonly active?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::TagOption`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::TagOption
 */
export declare class CfnTagOption extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::TagOption";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTagOption;
    /**
     * `AWS::ServiceCatalog::TagOption.Key`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html#cfn-servicecatalog-tagoption-key
     * @external
     */
    key: string;
    /**
     * `AWS::ServiceCatalog::TagOption.Value`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html#cfn-servicecatalog-tagoption-value
     * @external
     */
    value: string;
    /**
     * `AWS::ServiceCatalog::TagOption.Active`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoption.html#cfn-servicecatalog-tagoption-active
     * @external
     */
    active: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ServiceCatalog::TagOption`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTagOptionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::ServiceCatalog::TagOptionAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoptionassociation.html
 * @external
 */
export interface CfnTagOptionAssociationProps {
    /**
     * `AWS::ServiceCatalog::TagOptionAssociation.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoptionassociation.html#cfn-servicecatalog-tagoptionassociation-resourceid
     * @external
     */
    readonly resourceId: string;
    /**
     * `AWS::ServiceCatalog::TagOptionAssociation.TagOptionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoptionassociation.html#cfn-servicecatalog-tagoptionassociation-tagoptionid
     * @external
     */
    readonly tagOptionId: string;
}
/**
 * A CloudFormation `AWS::ServiceCatalog::TagOptionAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoptionassociation.html
 * @external
 * @cloudformationResource AWS::ServiceCatalog::TagOptionAssociation
 */
export declare class CfnTagOptionAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ServiceCatalog::TagOptionAssociation";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTagOptionAssociation;
    /**
     * `AWS::ServiceCatalog::TagOptionAssociation.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoptionassociation.html#cfn-servicecatalog-tagoptionassociation-resourceid
     * @external
     */
    resourceId: string;
    /**
     * `AWS::ServiceCatalog::TagOptionAssociation.TagOptionId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-tagoptionassociation.html#cfn-servicecatalog-tagoptionassociation-tagoptionid
     * @external
     */
    tagOptionId: string;
    /**
     * Create a new `AWS::ServiceCatalog::TagOptionAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTagOptionAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
