# Generated by Django 2.2.7 on 2019-11-08 12:23

import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0012_auto_20191104_2000'),
    ]

    operations = [
        migrations.CreateModel(
            name='Blob',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='container_blob', serialize=False, to='core.Content')),
                ('digest', models.CharField(db_index=True, max_length=255)),
                ('media_type', models.CharField(choices=[('application/vnd.docker.container.image.v1+json', 'application/vnd.docker.container.image.v1+json'), ('application/vnd.docker.image.rootfs.diff.tar.gzip', 'application/vnd.docker.image.rootfs.diff.tar.gzip'), ('application/vnd.docker.image.rootfs.foreign.diff.tar.gzip', 'application/vnd.docker.image.rootfs.foreign.diff.tar.gzip')], max_length=80)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('digest',)},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='BlobManifest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
        ),
        migrations.CreateModel(
            name='ContainerRemote',
            fields=[
                ('remote_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='container_containerremote', serialize=False, to='core.Remote')),
                ('upstream_name', models.CharField(db_index=True, max_length=255)),
                ('include_foreign_layers', models.BooleanField(default=False)),
                ('whitelist_tags', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=255, null=True), null=True, size=None)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.remote',),
        ),
        migrations.CreateModel(
            name='Manifest',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='container_manifest', serialize=False, to='core.Content')),
                ('digest', models.CharField(db_index=True, max_length=255)),
                ('schema_version', models.IntegerField()),
                ('media_type', models.CharField(choices=[('application/vnd.docker.distribution.manifest.v1+json', 'application/vnd.docker.distribution.manifest.v1+json'), ('application/vnd.docker.distribution.manifest.v2+json', 'application/vnd.docker.distribution.manifest.v2+json'), ('application/vnd.docker.distribution.manifest.list.v2+json', 'application/vnd.docker.distribution.manifest.list.v2+json')], max_length=60)),
                ('blobs', models.ManyToManyField(related_name='container_manifest', through='container.BlobManifest', to='container.Blob')),
                ('config_blob', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='config_blob', to='container.Blob')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='ManifestListManifest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('architecture', models.CharField(max_length=255)),
                ('os', models.CharField(max_length=255)),
                ('os_version', models.CharField(blank=True, default='', max_length=255)),
                ('os_features', models.TextField(blank=True, default='')),
                ('features', models.TextField(blank=True, default='')),
                ('variant', models.CharField(blank=True, default='', max_length=255)),
                ('image_manifest', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='image_manifests', to='container.Manifest')),
                ('manifest_list', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='manifest_lists', to='container.Manifest')),
            ],
            options={
                'unique_together': {('image_manifest', 'manifest_list')},
            },
        ),
        migrations.AddField(
            model_name='manifest',
            name='listed_manifests',
            field=models.ManyToManyField(related_name='container_manifest', through='container.ManifestListManifest', to='container.Manifest'),
        ),
        migrations.CreateModel(
            name='ContainerDistribution',
            fields=[
                ('basedistribution_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='container_containerdistribution', serialize=False, to='core.BaseDistribution')),
                ('repository', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='container_containerdistribution', to='core.Repository')),
                ('repository_version', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='container_containerdistribution', to='core.RepositoryVersion')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.basedistribution',),
        ),
        migrations.AddField(
            model_name='blobmanifest',
            name='manifest',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='blob_manifests', to='container.Manifest'),
        ),
        migrations.AddField(
            model_name='blobmanifest',
            name='manifest_blob',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='manifest_blobs', to='container.Blob'),
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='container_tag', serialize=False, to='core.Content')),
                ('name', models.CharField(db_index=True, max_length=255)),
                ('tagged_manifest', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='tagged_manifests', to='container.Manifest')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('name', 'tagged_manifest')},
            },
            bases=('core.content',),
        ),
        migrations.AlterUniqueTogether(
            name='manifest',
            unique_together={('digest',)},
        ),
        migrations.AlterUniqueTogether(
            name='blobmanifest',
            unique_together={('manifest', 'manifest_blob')},
        ),
    ]
