# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

import msrest.serialization

from ._compute_management_client_enums import *


class AccessUri(msrest.serialization.Model):
    """A disk access SAS uri.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_sas: A SAS uri for accessing a disk.
    :vartype access_sas: str
    """

    _validation = {
        'access_sas': {'readonly': True},
    }

    _attribute_map = {
        'access_sas': {'key': 'accessSAS', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessUri, self).__init__(**kwargs)
        self.access_sas = None


class AdditionalCapabilities(msrest.serialization.Model):
    """Enables or disables a capability on the virtual machine or virtual machine scale set.

    :param ultra_ssd_enabled: The flag that enables or disables a capability to have one or more
     managed data disks with UltraSSD_LRS storage account type on the VM or VMSS. Managed disks with
     storage account type UltraSSD_LRS can be added to a virtual machine or virtual machine scale
     set only if this property is enabled.
    :type ultra_ssd_enabled: bool
    """

    _attribute_map = {
        'ultra_ssd_enabled': {'key': 'ultraSSDEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        ultra_ssd_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(AdditionalCapabilities, self).__init__(**kwargs)
        self.ultra_ssd_enabled = ultra_ssd_enabled


class AdditionalUnattendContent(msrest.serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.

    :param pass_name: The pass name. Currently, the only allowable value is OobeSystem. The only
     acceptable values to pass in are None and "OobeSystem". The default value is None.
    :type pass_name: str
    :param component_name: The component name. Currently, the only allowable value is
     Microsoft-Windows-Shell-Setup. The only acceptable values to pass in are None and
     "Microsoft-Windows-Shell-Setup". The default value is None.
    :type component_name: str
    :param setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Possible values include: "AutoLogon",
     "FirstLogonCommands".
    :type setting_name: str or ~azure.mgmt.compute.v2021_04_01.models.SettingNames
    :param content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :type content: str
    """

    _attribute_map = {
        'pass_name': {'key': 'passName', 'type': 'str'},
        'component_name': {'key': 'componentName', 'type': 'str'},
        'setting_name': {'key': 'settingName', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pass_name: Optional[str] = None,
        component_name: Optional[str] = None,
        setting_name: Optional[Union[str, "SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs
    ):
        super(AdditionalUnattendContent, self).__init__(**kwargs)
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content


class ApiEntityReference(msrest.serialization.Model):
    """The API entity reference.

    :param id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ApiEntityReference, self).__init__(**kwargs)
        self.id = id


class ApiError(msrest.serialization.Model):
    """Api error.

    :param details: The Api error details.
    :type details: list[~azure.mgmt.compute.v2021_04_01.models.ApiErrorBase]
    :param innererror: The Api inner error.
    :type innererror: ~azure.mgmt.compute.v2021_04_01.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["ApiErrorBase"]] = None,
        innererror: Optional["InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class AutomaticOSUpgradePolicy(msrest.serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :param enable_automatic_os_upgrade: Indicates whether OS upgrades should automatically be
     applied to scale set instances in a rolling fashion when a newer version of the OS image
     becomes available. Default value is false. :code:`<br>`:code:`<br>` If this is set to true for
     Windows based scale sets, `enableAutomaticUpdates
     <https://docs.microsoft.com/dotnet/api/microsoft.azure.management.compute.models.windowsconfiguration.enableautomaticupdates?view=azure-dotnet>`_
     is automatically set to false and cannot be set to true.
    :type enable_automatic_os_upgrade: bool
    :param disable_automatic_rollback: Whether OS image rollback feature should be disabled.
     Default value is false.
    :type disable_automatic_rollback: bool
    """

    _attribute_map = {
        'enable_automatic_os_upgrade': {'key': 'enableAutomaticOSUpgrade', 'type': 'bool'},
        'disable_automatic_rollback': {'key': 'disableAutomaticRollback', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        enable_automatic_os_upgrade: Optional[bool] = None,
        disable_automatic_rollback: Optional[bool] = None,
        **kwargs
    ):
        super(AutomaticOSUpgradePolicy, self).__init__(**kwargs)
        self.enable_automatic_os_upgrade = enable_automatic_os_upgrade
        self.disable_automatic_rollback = disable_automatic_rollback


class AutomaticOSUpgradeProperties(msrest.serialization.Model):
    """Describes automatic OS upgrade properties on the image.

    All required parameters must be populated in order to send to Azure.

    :param automatic_os_upgrade_supported: Required. Specifies whether automatic OS upgrade is
     supported on the image.
    :type automatic_os_upgrade_supported: bool
    """

    _validation = {
        'automatic_os_upgrade_supported': {'required': True},
    }

    _attribute_map = {
        'automatic_os_upgrade_supported': {'key': 'automaticOSUpgradeSupported', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        automatic_os_upgrade_supported: bool,
        **kwargs
    ):
        super(AutomaticOSUpgradeProperties, self).__init__(**kwargs)
        self.automatic_os_upgrade_supported = automatic_os_upgrade_supported


class AutomaticRepairsPolicy(msrest.serialization.Model):
    """Specifies the configuration parameters for automatic repairs on the virtual machine scale set.

    :param enabled: Specifies whether automatic repairs should be enabled on the virtual machine
     scale set. The default value is false.
    :type enabled: bool
    :param grace_period: The amount of time for which automatic repairs are suspended due to a
     state change on VM. The grace time starts after the state change has completed. This helps
     avoid premature or accidental repairs. The time duration should be specified in ISO 8601
     format. The minimum allowed grace period is 30 minutes (PT30M), which is also the default
     value. The maximum allowed grace period is 90 minutes (PT90M).
    :type grace_period: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'grace_period': {'key': 'gracePeriod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        grace_period: Optional[str] = None,
        **kwargs
    ):
        super(AutomaticRepairsPolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.grace_period = grace_period


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AvailabilitySet(Resource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see `Availability sets overview <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_. :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance and updates for Virtual Machines in Azure <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_ :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Sku of the availability set, only name is required to be set. See
     AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with
     managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is
     'Classic'.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in the availability set.
    :type virtual_machines: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["SubResource"]] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(AvailabilitySet, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None


class AvailabilitySetListResult(msrest.serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of availability sets.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.AvailabilitySet]
    :param next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailabilitySet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AvailabilitySet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AvailabilitySetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResource(msrest.serialization.Model):
    """The Update Resource model definition.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = tags


class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Sku of the availability set.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in the availability set.
    :type virtual_machines: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["SubResource"]] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(AvailabilitySetUpdate, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None


class AvailablePatchSummary(msrest.serialization.Model):
    """Describes the properties of an virtual machine instance view for available patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Possible values include: "Unknown", "InProgress", "Failed",
     "Succeeded", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_04_01.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'assessment_activity_id': {'readonly': True},
        'reboot_pending': {'readonly': True},
        'critical_and_security_patch_count': {'readonly': True},
        'other_patch_count': {'readonly': True},
        'start_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'assessment_activity_id': {'key': 'assessmentActivityId', 'type': 'str'},
        'reboot_pending': {'key': 'rebootPending', 'type': 'bool'},
        'critical_and_security_patch_count': {'key': 'criticalAndSecurityPatchCount', 'type': 'int'},
        'other_patch_count': {'key': 'otherPatchCount', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailablePatchSummary, self).__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None


class BillingProfile(msrest.serialization.Model):
    """Specifies the billing related details of a Azure Spot VM or VMSS. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.

    :param max_price: Specifies the maximum price you are willing to pay for a Azure Spot VM/VMSS.
     This price is in US Dollars. :code:`<br>`:code:`<br>` This price will be compared with the
     current Azure Spot price for the VM size. Also, the prices are compared at the time of
     create/update of Azure Spot VM/VMSS and the operation will only succeed if  the maxPrice is
     greater than the current Azure Spot price. :code:`<br>`:code:`<br>` The maxPrice will also be
     used for evicting a Azure Spot VM/VMSS if the current Azure Spot price goes beyond the maxPrice
     after creation of VM/VMSS. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` - Any decimal value greater than zero. Example: 0.01538
     :code:`<br>`:code:`<br>` -1 – indicates default price to be up-to on-demand.
     :code:`<br>`:code:`<br>` You can set the maxPrice to -1 to indicate that the Azure Spot VM/VMSS
     should not be evicted for price reasons. Also, the default max price is -1 if it is not
     provided by you. :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type max_price: float
    """

    _attribute_map = {
        'max_price': {'key': 'maxPrice', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        max_price: Optional[float] = None,
        **kwargs
    ):
        super(BillingProfile, self).__init__(**kwargs)
        self.max_price = max_price


class BootDiagnostics(msrest.serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the hypervisor.

    :param enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :type enabled: bool
    :param storage_uri: Uri of the storage account to use for placing the console output and
     screenshot. :code:`<br>`:code:`<br>`If storageUri is not specified while enabling boot
     diagnostics, managed storage will be used.
    :type storage_uri: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        storage_uri: Optional[str] = None,
        **kwargs
    ):
        super(BootDiagnostics, self).__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri


class BootDiagnosticsInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob Uri.
     :code:`<br>`:code:`<br>`NOTE: This will **not** be set if boot diagnostics is currently enabled
     with managed storage.
    :vartype serial_console_log_blob_uri: str
    :ivar status: The boot diagnostics status information for the VM. :code:`<br>`:code:`<br>`
     NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
    :vartype status: ~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus
    """

    _validation = {
        'console_screenshot_blob_uri': {'readonly': True},
        'serial_console_log_blob_uri': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'console_screenshot_blob_uri': {'key': 'consoleScreenshotBlobUri', 'type': 'str'},
        'serial_console_log_blob_uri': {'key': 'serialConsoleLogBlobUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BootDiagnosticsInstanceView, self).__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None
        self.status = None


class CapacityReservation(Resource):
    """Specifies information about the capacity reservation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. SKU of the resource for which capacity needs be reserved. The SKU name
     and capacity is required to be set. Currently VM Skus with the capability called
     'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs
     in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported
     values.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param zones: Availability Zone to use for this capacity reservation. The zone has to be single
     value and also should be part for the list of zones specified during the capacity reservation
     group creation. The zone can be assigned only during creation. If not provided, the reservation
     supports only non-zonal deployments. If provided, enforces VM/VMSS using this capacity
     reservation to be in same zone.
    :type zones: list[str]
    :ivar reservation_id: A unique id generated and assigned to the capacity reservation by the
     platform which does not change throughout the lifetime of the resource.
    :vartype reservation_id: str
    :ivar virtual_machines_associated: A list of all virtual machine resource ids that are
     associated with the capacity reservation.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar provisioning_time: The date time when the capacity reservation was last updated.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The Capacity reservation instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'reservation_id': {'readonly': True},
        'virtual_machines_associated': {'readonly': True},
        'provisioning_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
        'virtual_machines_associated': {'key': 'properties.virtualMachinesAssociated', 'type': '[SubResourceReadOnly]'},
        'provisioning_time': {'key': 'properties.provisioningTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'CapacityReservationInstanceView'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        **kwargs
    ):
        super(CapacityReservation, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.zones = zones
        self.reservation_id = None
        self.virtual_machines_associated = None
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None


class CapacityReservationGroup(Resource):
    """Specifies information about the capacity reservation group that the capacity reservations should be assigned to. :code:`<br>`:code:`<br>` Currently, a capacity reservation can only be added to a capacity reservation group at creation time. An existing capacity reservation cannot be added or moved to another capacity reservation group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param zones: Availability Zones to use for this capacity reservation group. The zones can be
     assigned only during creation. If not provided, the group supports only regional resources in
     the region. If provided, enforces each capacity reservation in the group to be in one of the
     zones.
    :type zones: list[str]
    :ivar capacity_reservations: A list of all capacity reservation resource ids that belong to
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar virtual_machines_associated: A list of references to all virtual machines associated to
     the capacity reservation group.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar instance_view: The capacity reservation group instance view which has the list of
     instance views for all the capacity reservations that belong to the capacity reservation group.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroupInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'capacity_reservations': {'readonly': True},
        'virtual_machines_associated': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'capacity_reservations': {'key': 'properties.capacityReservations', 'type': '[SubResourceReadOnly]'},
        'virtual_machines_associated': {'key': 'properties.virtualMachinesAssociated', 'type': '[SubResourceReadOnly]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'CapacityReservationGroupInstanceView'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        **kwargs
    ):
        super(CapacityReservationGroup, self).__init__(location=location, tags=tags, **kwargs)
        self.zones = zones
        self.capacity_reservations = None
        self.virtual_machines_associated = None
        self.instance_view = None


class CapacityReservationGroupInstanceView(msrest.serialization.Model):
    """CapacityReservationGroupInstanceView.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar capacity_reservations: List of instance view of the capacity reservations under the
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.v2021_04_01.models.CapacityReservationInstanceViewWithName]
    """

    _validation = {
        'capacity_reservations': {'readonly': True},
    }

    _attribute_map = {
        'capacity_reservations': {'key': 'capacityReservations', 'type': '[CapacityReservationInstanceViewWithName]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacityReservationGroupInstanceView, self).__init__(**kwargs)
        self.capacity_reservations = None


class CapacityReservationGroupListResult(msrest.serialization.Model):
    """The List capacity reservation group with resource group response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of capacity reservation groups.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroup]
    :param next_link: The URI to fetch the next page of capacity reservation groups. Call
     ListNext() with this URI to fetch the next page of capacity reservation groups.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapacityReservationGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CapacityReservationGroup"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CapacityReservationGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityReservationGroupUpdate(UpdateResource):
    """Specifies information about the capacity reservation group. Only tags can be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar capacity_reservations: A list of all capacity reservation resource ids that belong to
     capacity reservation group.
    :vartype capacity_reservations:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar virtual_machines_associated: A list of references to all virtual machines associated to
     the capacity reservation group.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar instance_view: The capacity reservation group instance view which has the list of
     instance views for all the capacity reservations that belong to the capacity reservation group.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationGroupInstanceView
    """

    _validation = {
        'capacity_reservations': {'readonly': True},
        'virtual_machines_associated': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'capacity_reservations': {'key': 'properties.capacityReservations', 'type': '[SubResourceReadOnly]'},
        'virtual_machines_associated': {'key': 'properties.virtualMachinesAssociated', 'type': '[SubResourceReadOnly]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'CapacityReservationGroupInstanceView'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(CapacityReservationGroupUpdate, self).__init__(tags=tags, **kwargs)
        self.capacity_reservations = None
        self.virtual_machines_associated = None
        self.instance_view = None


class CapacityReservationInstanceView(msrest.serialization.Model):
    """The instance view of a capacity reservation that provides as snapshot of the runtime properties of the capacity reservation that is managed by the platform and can change outside of control plane operations.

    :param utilization_info: Unutilized capacity of the capacity reservation.
    :type utilization_info: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationUtilization
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'utilization_info': {'key': 'utilizationInfo', 'type': 'CapacityReservationUtilization'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        utilization_info: Optional["CapacityReservationUtilization"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(CapacityReservationInstanceView, self).__init__(**kwargs)
        self.utilization_info = utilization_info
        self.statuses = statuses


class CapacityReservationInstanceViewWithName(CapacityReservationInstanceView):
    """The instance view of a capacity reservation that includes the name of the capacity reservation. It is used for the response to the instance view of a capacity reservation group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param utilization_info: Unutilized capacity of the capacity reservation.
    :type utilization_info: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationUtilization
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    :ivar name: The name of the capacity reservation.
    :vartype name: str
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'utilization_info': {'key': 'utilizationInfo', 'type': 'CapacityReservationUtilization'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        utilization_info: Optional["CapacityReservationUtilization"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(CapacityReservationInstanceViewWithName, self).__init__(utilization_info=utilization_info, statuses=statuses, **kwargs)
        self.name = None


class CapacityReservationListResult(msrest.serialization.Model):
    """The list capacity reservation operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of capacity reservations.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.CapacityReservation]
    :param next_link: The URI to fetch the next page of capacity reservations. Call ListNext() with
     this URI to fetch the next page of capacity reservations.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CapacityReservation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CapacityReservation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CapacityReservationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CapacityReservationProfile(msrest.serialization.Model):
    """The parameters of a capacity reservation Profile.

    :param capacity_reservation_group: Specifies the capacity reservation group resource id that
     should be used for allocating the virtual machine or scaleset vm instances provided enough
     capacity has been reserved. Please refer to https://aka.ms/CapacityReservation for more
     details.
    :type capacity_reservation_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    """

    _attribute_map = {
        'capacity_reservation_group': {'key': 'capacityReservationGroup', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        capacity_reservation_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(CapacityReservationProfile, self).__init__(**kwargs)
        self.capacity_reservation_group = capacity_reservation_group


class CapacityReservationUpdate(UpdateResource):
    """Specifies information about the capacity reservation. Only tags and sku.capacity can be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: SKU of the resource for which capacity needs be reserved. The SKU name and capacity
     is required to be set. Currently VM Skus with the capability called
     'CapacityReservationSupported' set to true are supported. Refer to List Microsoft.Compute SKUs
     in a region (https://docs.microsoft.com/rest/api/compute/resourceskus/list) for supported
     values.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :ivar reservation_id: A unique id generated and assigned to the capacity reservation by the
     platform which does not change throughout the lifetime of the resource.
    :vartype reservation_id: str
    :ivar virtual_machines_associated: A list of all virtual machine resource ids that are
     associated with the capacity reservation.
    :vartype virtual_machines_associated:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar provisioning_time: The date time when the capacity reservation was last updated.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The Capacity reservation instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationInstanceView
    """

    _validation = {
        'reservation_id': {'readonly': True},
        'virtual_machines_associated': {'readonly': True},
        'provisioning_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'reservation_id': {'key': 'properties.reservationId', 'type': 'str'},
        'virtual_machines_associated': {'key': 'properties.virtualMachinesAssociated', 'type': '[SubResourceReadOnly]'},
        'provisioning_time': {'key': 'properties.provisioningTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'CapacityReservationInstanceView'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        **kwargs
    ):
        super(CapacityReservationUpdate, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.reservation_id = None
        self.virtual_machines_associated = None
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None


class CapacityReservationUtilization(msrest.serialization.Model):
    """Represents the capacity reservation utilization in terms of resources allocated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machines_allocated: A list of all virtual machines resource ids allocated against
     the capacity reservation.
    :vartype virtual_machines_allocated:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    """

    _validation = {
        'virtual_machines_allocated': {'readonly': True},
    }

    _attribute_map = {
        'virtual_machines_allocated': {'key': 'virtualMachinesAllocated', 'type': '[SubResourceReadOnly]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CapacityReservationUtilization, self).__init__(**kwargs)
        self.virtual_machines_allocated = None


class ComputeOperationListResult(msrest.serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.compute.v2021_04_01.models.ComputeOperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ComputeOperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeOperationListResult, self).__init__(**kwargs)
        self.value = None


class ComputeOperationValue(msrest.serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeOperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class CreationData(msrest.serialization.Model):
    """Data used when creating a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param create_option: Required. This enumerates the possible sources of a disk's creation.
     Possible values include: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore", "Upload",
     "CopyStart".
    :type create_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskCreateOption
    :param storage_account_id: Required if createOption is Import. The Azure Resource Manager
     identifier of the storage account containing the blob to import as a disk.
    :type storage_account_id: str
    :param image_reference: Disk source information.
    :type image_reference: ~azure.mgmt.compute.v2021_04_01.models.ImageDiskReference
    :param gallery_image_reference: Required if creating from a Gallery Image. The id of the
     ImageDiskReference will be the ARM id of the shared galley image version from which to create a
     disk.
    :type gallery_image_reference: ~azure.mgmt.compute.v2021_04_01.models.ImageDiskReference
    :param source_uri: If createOption is Import, this is the URI of a blob to be imported into a
     managed disk.
    :type source_uri: str
    :param source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot
     or disk.
    :type source_resource_id: str
    :ivar source_unique_id: If this field is set, this is the unique id identifying the source of
     this resource.
    :vartype source_unique_id: str
    :param upload_size_bytes: If createOption is Upload, this is the size of the contents of the
     upload including the VHD footer. This value should be between 20972032 (20 MiB + 512 bytes for
     the VHD footer) and 35183298347520 bytes (32 TiB + 512 bytes for the VHD footer).
    :type upload_size_bytes: long
    :param logical_sector_size: Logical sector size in bytes for Ultra disks. Supported values are
     512 ad 4096. 4096 is the default.
    :type logical_sector_size: int
    """

    _validation = {
        'create_option': {'required': True},
        'source_unique_id': {'readonly': True},
    }

    _attribute_map = {
        'create_option': {'key': 'createOption', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'image_reference': {'key': 'imageReference', 'type': 'ImageDiskReference'},
        'gallery_image_reference': {'key': 'galleryImageReference', 'type': 'ImageDiskReference'},
        'source_uri': {'key': 'sourceUri', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
        'source_unique_id': {'key': 'sourceUniqueId', 'type': 'str'},
        'upload_size_bytes': {'key': 'uploadSizeBytes', 'type': 'long'},
        'logical_sector_size': {'key': 'logicalSectorSize', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "DiskCreateOption"],
        storage_account_id: Optional[str] = None,
        image_reference: Optional["ImageDiskReference"] = None,
        gallery_image_reference: Optional["ImageDiskReference"] = None,
        source_uri: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        upload_size_bytes: Optional[int] = None,
        logical_sector_size: Optional[int] = None,
        **kwargs
    ):
        super(CreationData, self).__init__(**kwargs)
        self.create_option = create_option
        self.storage_account_id = storage_account_id
        self.image_reference = image_reference
        self.gallery_image_reference = gallery_image_reference
        self.source_uri = source_uri
        self.source_resource_id = source_resource_id
        self.source_unique_id = None
        self.upload_size_bytes = upload_size_bytes
        self.logical_sector_size = logical_sector_size


class DataDisk(msrest.serialization.Model):
    """Describes a data disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2021_04_01.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :type image: ~azure.mgmt.compute.v2021_04_01.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Possible values include: "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.ManagedDiskParameters
    :param to_be_detached: Specifies whether the data disk is in process of detachment from the
     VirtualMachine/VirtualMachineScaleset.
    :type to_be_detached: bool
    :ivar disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_iops_read_write: long
    :ivar disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk when
     StorageAccountType is UltraSSD_LRS. Returned only for VirtualMachine ScaleSet VM disks. Can be
     updated only via updates to the VirtualMachine Scale Set.
    :vartype disk_m_bps_read_write: long
    :param detach_option: Specifies the detach behavior to be used while detaching a disk or which
     is already in the process of detachment from the virtual machine. Supported values:
     **ForceDetach**. :code:`<br>`:code:`<br>` detachOption: **ForceDetach** is applicable only for
     managed data disks. If a previous detachment attempt of the data disk did not complete due to
     an unexpected failure from the virtual machine and the disk is still not released then use
     force-detach as a last resort option to detach the disk forcibly from the VM. All writes might
     not have been flushed when using this detach behavior. :code:`<br>`:code:`<br>` This feature is
     still in preview mode and is not supported for VirtualMachineScaleSet. To force-detach a data
     disk update toBeDetached to 'true' along with setting detachOption: 'ForceDetach'. Possible
     values include: "ForceDetach".
    :type detach_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskDetachOptionTypes
    :param delete_option: Specifies whether data disk should be deleted or detached upon VM
     deletion.:code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this
     value is used, the data disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach**
     If this value is used, the data disk is retained after VM is deleted.:code:`<br>`:code:`<br>`
     The default value is set to **detach**. Possible values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskDeleteOptionTypes
    """

    _validation = {
        'lun': {'required': True},
        'create_option': {'required': True},
        'disk_iops_read_write': {'readonly': True},
        'disk_m_bps_read_write': {'readonly': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
        'to_be_detached': {'key': 'toBeDetached', 'type': 'bool'},
        'disk_iops_read_write': {'key': 'diskIOPSReadWrite', 'type': 'long'},
        'disk_m_bps_read_write': {'key': 'diskMBpsReadWrite', 'type': 'long'},
        'detach_option': {'key': 'detachOption', 'type': 'str'},
        'delete_option': {'key': 'deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["VirtualHardDisk"] = None,
        image: Optional["VirtualHardDisk"] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["ManagedDiskParameters"] = None,
        to_be_detached: Optional[bool] = None,
        detach_option: Optional[Union[str, "DiskDetachOptionTypes"]] = None,
        delete_option: Optional[Union[str, "DiskDeleteOptionTypes"]] = None,
        **kwargs
    ):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.to_be_detached = to_be_detached
        self.disk_iops_read_write = None
        self.disk_m_bps_read_write = None
        self.detach_option = detach_option
        self.delete_option = delete_option


class DataDiskImage(msrest.serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        'lun': {'readonly': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDiskImage, self).__init__(**kwargs)
        self.lun = None


class DedicatedHost(Resource):
    """Specifies information about the Dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Required. SKU of the dedicated host for Hardware Generation and VM family. Only
     name is required to be set. List Microsoft.Compute SKUs for a list of possible values.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :type platform_fault_domain: int
    :param auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :type auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :param license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Possible values include: "None", "Windows_Server_Hybrid", "Windows_Server_Perpetual".
    :type license_type: str or ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'platform_fault_domain': {'minimum': 0},
        'host_id': {'readonly': True},
        'virtual_machines': {'readonly': True},
        'provisioning_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_fault_domain': {'key': 'properties.platformFaultDomain', 'type': 'int'},
        'auto_replace_on_failure': {'key': 'properties.autoReplaceOnFailure', 'type': 'bool'},
        'host_id': {'key': 'properties.hostId', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResourceReadOnly]'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'provisioning_time': {'key': 'properties.provisioningTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostInstanceView'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "DedicatedHostLicenseTypes"]] = None,
        **kwargs
    ):
        super(DedicatedHost, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id = None
        self.virtual_machines = None
        self.license_type = license_type
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None


class DedicatedHostAllocatableVM(msrest.serialization.Model):
    """Represents the dedicated host unutilized capacity in terms of a specific VM size.

    :param vm_size: VM size in terms of which the unutilized capacity is represented.
    :type vm_size: str
    :param count: Maximum number of VMs of size vmSize that can fit in the dedicated host's
     remaining capacity.
    :type count: float
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'count': {'key': 'count', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[str] = None,
        count: Optional[float] = None,
        **kwargs
    ):
        super(DedicatedHostAllocatableVM, self).__init__(**kwargs)
        self.vm_size = vm_size
        self.count = count


class DedicatedHostAvailableCapacity(msrest.serialization.Model):
    """Dedicated host unutilized capacity.

    :param allocatable_v_ms: The unutilized capacity of the dedicated host represented in terms of
     each VM size that is allowed to be deployed to the dedicated host.
    :type allocatable_v_ms: list[~azure.mgmt.compute.v2021_04_01.models.DedicatedHostAllocatableVM]
    """

    _attribute_map = {
        'allocatable_v_ms': {'key': 'allocatableVMs', 'type': '[DedicatedHostAllocatableVM]'},
    }

    def __init__(
        self,
        *,
        allocatable_v_ms: Optional[List["DedicatedHostAllocatableVM"]] = None,
        **kwargs
    ):
        super(DedicatedHostAvailableCapacity, self).__init__(**kwargs)
        self.allocatable_v_ms = allocatable_v_ms


class DedicatedHostGroup(Resource):
    """Specifies information about the dedicated host group that the dedicated hosts should be assigned to. :code:`<br>`:code:`<br>` Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :type zones: list[str]
    :param platform_fault_domain_count: Number of fault domains that the host group can span.
    :type platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostGroupInstanceView
    :param support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :type support_automatic_placement: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'platform_fault_domain_count': {'minimum': 1},
        'hosts': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[SubResourceReadOnly]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostGroupInstanceView'},
        'support_automatic_placement': {'key': 'properties.supportAutomaticPlacement', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        **kwargs
    ):
        super(DedicatedHostGroup, self).__init__(location=location, tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = support_automatic_placement


class DedicatedHostGroupInstanceView(msrest.serialization.Model):
    """DedicatedHostGroupInstanceView.

    :param hosts: List of instance view of the dedicated hosts under the dedicated host group.
    :type hosts: list[~azure.mgmt.compute.v2021_04_01.models.DedicatedHostInstanceViewWithName]
    """

    _attribute_map = {
        'hosts': {'key': 'hosts', 'type': '[DedicatedHostInstanceViewWithName]'},
    }

    def __init__(
        self,
        *,
        hosts: Optional[List["DedicatedHostInstanceViewWithName"]] = None,
        **kwargs
    ):
        super(DedicatedHostGroupInstanceView, self).__init__(**kwargs)
        self.hosts = hosts


class DedicatedHostGroupListResult(msrest.serialization.Model):
    """The List Dedicated Host Group with resource group response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of dedicated host groups.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.DedicatedHostGroup]
    :param next_link: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with
     this URI to fetch the next page of Dedicated Host Groups.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DedicatedHostGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DedicatedHostGroup"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DedicatedHostGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostGroupUpdate(UpdateResource):
    """Specifies information about the dedicated host group that the dedicated host should be assigned to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param zones: Availability Zone to use for this host group. Only single zone is supported. The
     zone can be assigned only during creation. If not provided, the group supports all zones in the
     region. If provided, enforces each host in the group to be in the same zone.
    :type zones: list[str]
    :param platform_fault_domain_count: Number of fault domains that the host group can span.
    :type platform_fault_domain_count: int
    :ivar hosts: A list of references to all dedicated hosts in the dedicated host group.
    :vartype hosts: list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :ivar instance_view: The dedicated host group instance view, which has the list of instance
     view of the dedicated hosts under the dedicated host group.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostGroupInstanceView
    :param support_automatic_placement: Specifies whether virtual machines or virtual machine scale
     sets can be placed automatically on the dedicated host group. Automatic placement means
     resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host
     group. The value is defaulted to 'false' when not provided. :code:`<br>`:code:`<br>`Minimum
     api-version: 2020-06-01.
    :type support_automatic_placement: bool
    """

    _validation = {
        'platform_fault_domain_count': {'minimum': 1},
        'hosts': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'hosts': {'key': 'properties.hosts', 'type': '[SubResourceReadOnly]'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostGroupInstanceView'},
        'support_automatic_placement': {'key': 'properties.supportAutomaticPlacement', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        zones: Optional[List[str]] = None,
        platform_fault_domain_count: Optional[int] = None,
        support_automatic_placement: Optional[bool] = None,
        **kwargs
    ):
        super(DedicatedHostGroupUpdate, self).__init__(tags=tags, **kwargs)
        self.zones = zones
        self.platform_fault_domain_count = platform_fault_domain_count
        self.hosts = None
        self.instance_view = None
        self.support_automatic_placement = support_automatic_placement


class DedicatedHostInstanceView(msrest.serialization.Model):
    """The instance view of a dedicated host.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :param available_capacity: Unutilized capacity of the dedicated host.
    :type available_capacity: ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostAvailableCapacity
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'asset_id': {'readonly': True},
    }

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'DedicatedHostAvailableCapacity'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(DedicatedHostInstanceView, self).__init__(**kwargs)
        self.asset_id = None
        self.available_capacity = available_capacity
        self.statuses = statuses


class DedicatedHostInstanceViewWithName(DedicatedHostInstanceView):
    """The instance view of a dedicated host that includes the name of the dedicated host. It is used for the response to the instance view of a dedicated host group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_id: Specifies the unique id of the dedicated physical machine on which the
     dedicated host resides.
    :vartype asset_id: str
    :param available_capacity: Unutilized capacity of the dedicated host.
    :type available_capacity: ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostAvailableCapacity
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    :ivar name: The name of the dedicated host.
    :vartype name: str
    """

    _validation = {
        'asset_id': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
        'available_capacity': {'key': 'availableCapacity', 'type': 'DedicatedHostAvailableCapacity'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        available_capacity: Optional["DedicatedHostAvailableCapacity"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(DedicatedHostInstanceViewWithName, self).__init__(available_capacity=available_capacity, statuses=statuses, **kwargs)
        self.name = None


class DedicatedHostListResult(msrest.serialization.Model):
    """The list dedicated host operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of dedicated hosts.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.DedicatedHost]
    :param next_link: The URI to fetch the next page of dedicated hosts. Call ListNext() with this
     URI to fetch the next page of dedicated hosts.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DedicatedHost]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DedicatedHost"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DedicatedHostListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DedicatedHostUpdate(UpdateResource):
    """Specifies information about the dedicated host. Only tags, autoReplaceOnFailure and licenseType may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param platform_fault_domain: Fault domain of the dedicated host within a dedicated host group.
    :type platform_fault_domain: int
    :param auto_replace_on_failure: Specifies whether the dedicated host should be replaced
     automatically in case of a failure. The value is defaulted to 'true' when not provided.
    :type auto_replace_on_failure: bool
    :ivar host_id: A unique id generated and assigned to the dedicated host by the platform.
     :code:`<br>`:code:`<br>` Does not change throughout the lifetime of the host.
    :vartype host_id: str
    :ivar virtual_machines: A list of references to all virtual machines in the Dedicated Host.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2021_04_01.models.SubResourceReadOnly]
    :param license_type: Specifies the software license type that will be applied to the VMs
     deployed on the dedicated host. :code:`<br>`:code:`<br>` Possible values are:
     :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **Windows_Server_Hybrid**
     :code:`<br>`:code:`<br>` **Windows_Server_Perpetual** :code:`<br>`:code:`<br>` Default:
     **None**. Possible values include: "None", "Windows_Server_Hybrid", "Windows_Server_Perpetual".
    :type license_type: str or ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostLicenseTypes
    :ivar provisioning_time: The date when the host was first provisioned.
    :vartype provisioning_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The dedicated host instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.DedicatedHostInstanceView
    """

    _validation = {
        'platform_fault_domain': {'minimum': 0},
        'host_id': {'readonly': True},
        'virtual_machines': {'readonly': True},
        'provisioning_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'platform_fault_domain': {'key': 'properties.platformFaultDomain', 'type': 'int'},
        'auto_replace_on_failure': {'key': 'properties.autoReplaceOnFailure', 'type': 'bool'},
        'host_id': {'key': 'properties.hostId', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResourceReadOnly]'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'provisioning_time': {'key': 'properties.provisioningTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'DedicatedHostInstanceView'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        platform_fault_domain: Optional[int] = None,
        auto_replace_on_failure: Optional[bool] = None,
        license_type: Optional[Union[str, "DedicatedHostLicenseTypes"]] = None,
        **kwargs
    ):
        super(DedicatedHostUpdate, self).__init__(tags=tags, **kwargs)
        self.platform_fault_domain = platform_fault_domain
        self.auto_replace_on_failure = auto_replace_on_failure
        self.host_id = None
        self.virtual_machines = None
        self.license_type = license_type
        self.provisioning_time = None
        self.provisioning_state = None
        self.instance_view = None


class DiagnosticsProfile(msrest.serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.

    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2021_04_01.models.BootDiagnostics
    """

    _attribute_map = {
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnostics'},
    }

    def __init__(
        self,
        *,
        boot_diagnostics: Optional["BootDiagnostics"] = None,
        **kwargs
    ):
        super(DiagnosticsProfile, self).__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics


class DiffDiskSettings(msrest.serialization.Model):
    """Describes the parameters of ephemeral disk settings that can be specified for operating system disk. :code:`<br>`:code:`<br>` NOTE: The ephemeral disk settings can only be specified for managed disk.

    :param option: Specifies the ephemeral disk settings for operating system disk. Possible values
     include: "Local".
    :type option: str or ~azure.mgmt.compute.v2021_04_01.models.DiffDiskOptions
    :param placement: Specifies the ephemeral disk placement for operating system
     disk.:code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **CacheDisk**
     :code:`<br>`:code:`<br>` **ResourceDisk** :code:`<br>`:code:`<br>` Default: **CacheDisk** if
     one is configured for the VM size otherwise **ResourceDisk** is used.:code:`<br>`:code:`<br>`
     Refer to VM size documentation for Windows VM at
     https://docs.microsoft.com/azure/virtual-machines/windows/sizes and Linux VM at
     https://docs.microsoft.com/azure/virtual-machines/linux/sizes to check which VM sizes exposes a
     cache disk. Possible values include: "CacheDisk", "ResourceDisk".
    :type placement: str or ~azure.mgmt.compute.v2021_04_01.models.DiffDiskPlacement
    """

    _attribute_map = {
        'option': {'key': 'option', 'type': 'str'},
        'placement': {'key': 'placement', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        option: Optional[Union[str, "DiffDiskOptions"]] = None,
        placement: Optional[Union[str, "DiffDiskPlacement"]] = None,
        **kwargs
    ):
        super(DiffDiskSettings, self).__init__(**kwargs)
        self.option = option
        self.placement = placement


class DisallowedConfiguration(msrest.serialization.Model):
    """Specifies the disallowed configuration for a virtual machine image.

    :param vm_disk_type: VM disk types which are disallowed. Possible values include: "None",
     "Unmanaged".
    :type vm_disk_type: str or ~azure.mgmt.compute.v2021_04_01.models.VmDiskTypes
    """

    _attribute_map = {
        'vm_disk_type': {'key': 'vmDiskType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vm_disk_type: Optional[Union[str, "VmDiskTypes"]] = None,
        **kwargs
    ):
        super(DisallowedConfiguration, self).__init__(**kwargs)
        self.vm_disk_type = vm_disk_type


class Disk(Resource):
    """Disk resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar managed_by: A relative URI containing the ID of the VM that has the disk attached.
    :vartype managed_by: str
    :ivar managed_by_extended: List of relative URIs containing the IDs of the VMs that have the
     disk attached. maxShares should be set to a value greater than one for disks to allow attaching
     them to multiple VMs.
    :vartype managed_by_extended: list[str]
    :param sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS,
     UltraSSD_LRS, Premium_ZRS, or StandardSSD_ZRS.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.DiskSku
    :param zones: The Logical zone list for Disk.
    :type zones: list[str]
    :param extended_location: The extended location where the disk will be created. Extended
     location cannot be changed.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :param os_type: The Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGeneration
    :param purchase_plan: Purchase plan information for the the image from which the OS disk was
     created. E.g. - {name: 2019-Datacenter, publisher: MicrosoftWindowsServer, product:
     WindowsServer}.
    :type purchase_plan: ~azure.mgmt.compute.v2021_04_01.models.PurchasePlanAutoGenerated
    :param supported_capabilities: List of supported capabilities for the image from which the OS
     disk was created.
    :type supported_capabilities: ~azure.mgmt.compute.v2021_04_01.models.SupportedCapabilities
    :param creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :type creation_data: ~azure.mgmt.compute.v2021_04_01.models.CreationData
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read only.
    :vartype disk_size_bytes: long
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :param encryption_settings_collection: Encryption settings collection used for Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2021_04_01.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :param disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
     UltraSSD disks. One operation can transfer between 4k and 256k bytes.
    :type disk_iops_read_write: long
    :param disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
     disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :type disk_m_bps_read_write: long
    :param disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
     mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
    :type disk_iops_read_only: long
    :param disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
     mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
     the ISO notation, of powers of 10.
    :type disk_m_bps_read_only: long
    :ivar disk_state: The state of the disk. Possible values include: "Unattached", "Attached",
     "Reserved", "Frozen", "ActiveSAS", "ActiveSASFrozen", "ReadyToUpload", "ActiveUpload".
    :vartype disk_state: str or ~azure.mgmt.compute.v2021_04_01.models.DiskState
    :param encryption: Encryption property can be used to encrypt data at rest with customer
     managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2021_04_01.models.Encryption
    :param max_shares: The maximum number of VMs that can attach to the disk at the same time.
     Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :type max_shares: int
    :ivar share_info: Details of the list of all VMs that have the disk attached. maxShares should
     be set to a value greater than one for disks to allow attaching them to multiple VMs.
    :vartype share_info: list[~azure.mgmt.compute.v2021_04_01.models.ShareInfoElement]
    :param network_access_policy: Policy for accessing the disk via network. Possible values
     include: "AllowAll", "AllowPrivate", "DenyAll".
    :type network_access_policy: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkAccessPolicy
    :param disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :type disk_access_id: str
    :param tier: Performance tier of the disk (e.g, P4, S10) as described here:
     https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
     disks.
    :type tier: str
    :param bursting_enabled: Set to true to enable bursting beyond the provisioned performance
     target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
    :type bursting_enabled: bool
    :ivar property_updates_in_progress: Properties of the disk for which update is pending.
    :vartype property_updates_in_progress:
     ~azure.mgmt.compute.v2021_04_01.models.PropertyUpdatesInProgress
    :param supports_hibernation: Indicates the OS on a disk supports hibernation.
    :type supports_hibernation: bool
    :param security_profile: Contains the security related information for the resource.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.DiskSecurityProfile
    :param completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :type completion_percent: float
    :param public_network_access: Policy for controlling export on the disk. Possible values
     include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.compute.v2021_04_01.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_by': {'readonly': True},
        'managed_by_extended': {'readonly': True},
        'time_created': {'readonly': True},
        'disk_size_bytes': {'readonly': True},
        'unique_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'disk_state': {'readonly': True},
        'share_info': {'readonly': True},
        'property_updates_in_progress': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'managed_by_extended': {'key': 'managedByExtended', 'type': '[str]'},
        'sku': {'key': 'sku', 'type': 'DiskSku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'PurchasePlanAutoGenerated'},
        'supported_capabilities': {'key': 'properties.supportedCapabilities', 'type': 'SupportedCapabilities'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'disk_size_bytes': {'key': 'properties.diskSizeBytes', 'type': 'long'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'disk_iops_read_write': {'key': 'properties.diskIOPSReadWrite', 'type': 'long'},
        'disk_m_bps_read_write': {'key': 'properties.diskMBpsReadWrite', 'type': 'long'},
        'disk_iops_read_only': {'key': 'properties.diskIOPSReadOnly', 'type': 'long'},
        'disk_m_bps_read_only': {'key': 'properties.diskMBpsReadOnly', 'type': 'long'},
        'disk_state': {'key': 'properties.diskState', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'max_shares': {'key': 'properties.maxShares', 'type': 'int'},
        'share_info': {'key': 'properties.shareInfo', 'type': '[ShareInfoElement]'},
        'network_access_policy': {'key': 'properties.networkAccessPolicy', 'type': 'str'},
        'disk_access_id': {'key': 'properties.diskAccessId', 'type': 'str'},
        'tier': {'key': 'properties.tier', 'type': 'str'},
        'bursting_enabled': {'key': 'properties.burstingEnabled', 'type': 'bool'},
        'property_updates_in_progress': {'key': 'properties.propertyUpdatesInProgress', 'type': 'PropertyUpdatesInProgress'},
        'supports_hibernation': {'key': 'properties.supportsHibernation', 'type': 'bool'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'DiskSecurityProfile'},
        'completion_percent': {'key': 'properties.completionPercent', 'type': 'float'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["DiskSku"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGeneration"]] = None,
        purchase_plan: Optional["PurchasePlanAutoGenerated"] = None,
        supported_capabilities: Optional["SupportedCapabilities"] = None,
        creation_data: Optional["CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["EncryptionSettingsCollection"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        disk_iops_read_only: Optional[int] = None,
        disk_m_bps_read_only: Optional[int] = None,
        encryption: Optional["Encryption"] = None,
        max_shares: Optional[int] = None,
        network_access_policy: Optional[Union[str, "NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        tier: Optional[str] = None,
        bursting_enabled: Optional[bool] = None,
        supports_hibernation: Optional[bool] = None,
        security_profile: Optional["DiskSecurityProfile"] = None,
        completion_percent: Optional[float] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(Disk, self).__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.managed_by_extended = None
        self.sku = sku
        self.zones = zones
        self.extended_location = extended_location
        self.time_created = None
        self.os_type = os_type
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes = None
        self.unique_id = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state = None
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_m_bps_read_only = disk_m_bps_read_only
        self.disk_state = None
        self.encryption = encryption
        self.max_shares = max_shares
        self.share_info = None
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.tier = tier
        self.bursting_enabled = bursting_enabled
        self.property_updates_in_progress = None
        self.supports_hibernation = supports_hibernation
        self.security_profile = security_profile
        self.completion_percent = completion_percent
        self.public_network_access = public_network_access


class DiskAccess(Resource):
    """disk access resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param extended_location: The extended location where the disk access will be created. Extended
     location cannot be changed.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :ivar private_endpoint_connections: A readonly collection of private endpoint connections
     created on the disk. Currently only one endpoint connection is supported.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.compute.v2021_04_01.models.PrivateEndpointConnection]
    :ivar provisioning_state: The disk access resource provisioning state.
    :vartype provisioning_state: str
    :ivar time_created: The time when the disk access was created.
    :vartype time_created: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'private_endpoint_connections': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'time_created': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        **kwargs
    ):
        super(DiskAccess, self).__init__(location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.private_endpoint_connections = None
        self.provisioning_state = None
        self.time_created = None


class DiskAccessList(msrest.serialization.Model):
    """The List disk access operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of disk access resources.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.DiskAccess]
    :param next_link: The uri to fetch the next page of disk access resources. Call ListNext() with
     this to fetch the next page of disk access resources.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiskAccess]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DiskAccess"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DiskAccessList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskAccessUpdate(msrest.serialization.Model):
    """Used for updating a disk access resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(DiskAccessUpdate, self).__init__(**kwargs)
        self.tags = tags


class DiskEncryptionSet(Resource):
    """disk encryption set resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The managed identity for the disk encryption set. It should be given
     permission on the key vault before it can be used to encrypt disks.
    :type identity: ~azure.mgmt.compute.v2021_04_01.models.EncryptionSetIdentity
    :param encryption_type: The type of key used to encrypt the data of the disk. Possible values
     include: "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys".
    :type encryption_type: str or ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetType
    :param active_key: The key vault key which is currently used by this disk encryption set.
    :type active_key: ~azure.mgmt.compute.v2021_04_01.models.KeyForDiskEncryptionSet
    :ivar previous_keys: A readonly collection of key vault keys previously used by this disk
     encryption set while a key rotation is in progress. It will be empty if there is no ongoing key
     rotation.
    :vartype previous_keys: list[~azure.mgmt.compute.v2021_04_01.models.KeyForDiskEncryptionSet]
    :ivar provisioning_state: The disk encryption set provisioning state.
    :vartype provisioning_state: str
    :param rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     this disk encryption set to the latest key version.
    :type rotation_to_latest_key_version_enabled: bool
    :ivar last_key_rotation_timestamp: The time when the active key of this disk encryption set was
     updated.
    :vartype last_key_rotation_timestamp: ~datetime.datetime
    :ivar auto_key_rotation_error: The error that was encountered during auto-key rotation. If an
     error is present, then auto-key rotation will not be attempted until the error on this disk
     encryption set is fixed.
    :vartype auto_key_rotation_error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'previous_keys': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_key_rotation_timestamp': {'readonly': True},
        'auto_key_rotation_error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'EncryptionSetIdentity'},
        'encryption_type': {'key': 'properties.encryptionType', 'type': 'str'},
        'active_key': {'key': 'properties.activeKey', 'type': 'KeyForDiskEncryptionSet'},
        'previous_keys': {'key': 'properties.previousKeys', 'type': '[KeyForDiskEncryptionSet]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'rotation_to_latest_key_version_enabled': {'key': 'properties.rotationToLatestKeyVersionEnabled', 'type': 'bool'},
        'last_key_rotation_timestamp': {'key': 'properties.lastKeyRotationTimestamp', 'type': 'iso-8601'},
        'auto_key_rotation_error': {'key': 'properties.autoKeyRotationError', 'type': 'ApiError'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["EncryptionSetIdentity"] = None,
        encryption_type: Optional[Union[str, "DiskEncryptionSetType"]] = None,
        active_key: Optional["KeyForDiskEncryptionSet"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(DiskEncryptionSet, self).__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.encryption_type = encryption_type
        self.active_key = active_key
        self.previous_keys = None
        self.provisioning_state = None
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled
        self.last_key_rotation_timestamp = None
        self.auto_key_rotation_error = None


class DiskEncryptionSetList(msrest.serialization.Model):
    """The List disk encryption set operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of disk encryption sets.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSet]
    :param next_link: The uri to fetch the next page of disk encryption sets. Call ListNext() with
     this to fetch the next page of disk encryption sets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiskEncryptionSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DiskEncryptionSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DiskEncryptionSetList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SubResource(msrest.serialization.Model):
    """SubResource.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class DiskEncryptionSetParameters(SubResource):
    """Describes the parameter of customer managed disk encryption set resource id that can be specified for disk. :code:`<br>`:code:`<br>` NOTE: The disk encryption set resource id can only be specified for managed disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(DiskEncryptionSetParameters, self).__init__(id=id, **kwargs)


class DiskEncryptionSettings(msrest.serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :param disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :type disk_encryption_key: ~azure.mgmt.compute.v2021_04_01.models.KeyVaultSecretReference
    :param key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :type key_encryption_key: ~azure.mgmt.compute.v2021_04_01.models.KeyVaultKeyReference
    :param enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :type enabled: bool
    """

    _attribute_map = {
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultKeyReference'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(DiskEncryptionSettings, self).__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled


class DiskEncryptionSetUpdate(msrest.serialization.Model):
    """disk encryption set update resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param identity: The managed identity for the disk encryption set. It should be given
     permission on the key vault before it can be used to encrypt disks.
    :type identity: ~azure.mgmt.compute.v2021_04_01.models.EncryptionSetIdentity
    :param encryption_type: The type of key used to encrypt the data of the disk. Possible values
     include: "EncryptionAtRestWithCustomerKey", "EncryptionAtRestWithPlatformAndCustomerKeys".
    :type encryption_type: str or ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetType
    :param active_key: Key Vault Key Url to be used for server side encryption of Managed Disks and
     Snapshots.
    :type active_key: ~azure.mgmt.compute.v2021_04_01.models.KeyForDiskEncryptionSet
    :param rotation_to_latest_key_version_enabled: Set this flag to true to enable auto-updating of
     this disk encryption set to the latest key version.
    :type rotation_to_latest_key_version_enabled: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'EncryptionSetIdentity'},
        'encryption_type': {'key': 'properties.encryptionType', 'type': 'str'},
        'active_key': {'key': 'properties.activeKey', 'type': 'KeyForDiskEncryptionSet'},
        'rotation_to_latest_key_version_enabled': {'key': 'properties.rotationToLatestKeyVersionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["EncryptionSetIdentity"] = None,
        encryption_type: Optional[Union[str, "DiskEncryptionSetType"]] = None,
        active_key: Optional["KeyForDiskEncryptionSet"] = None,
        rotation_to_latest_key_version_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(DiskEncryptionSetUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.encryption_type = encryption_type
        self.active_key = active_key
        self.rotation_to_latest_key_version_enabled = rotation_to_latest_key_version_enabled


class DiskInstanceView(msrest.serialization.Model):
    """The instance view of the disk.

    :param name: The disk name.
    :type name: str
    :param encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type encryption_settings: list[~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSettings]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': '[DiskEncryptionSettings]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        encryption_settings: Optional[List["DiskEncryptionSettings"]] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(DiskInstanceView, self).__init__(**kwargs)
        self.name = name
        self.encryption_settings = encryption_settings
        self.statuses = statuses


class DiskList(msrest.serialization.Model):
    """The List Disks operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of disks.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.Disk]
    :param next_link: The uri to fetch the next page of disks. Call ListNext() with this to fetch
     the next page of disks.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Disk]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Disk"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DiskList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProxyOnlyResource(msrest.serialization.Model):
    """The ProxyOnly Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DiskRestorePoint(ProxyOnlyResource):
    """Properties of disk restore point.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time_created: The timestamp of restorePoint creation.
    :vartype time_created: ~datetime.datetime
    :ivar source_resource_id: arm id of source disk.
    :vartype source_resource_id: str
    :ivar os_type: The Operating System type. Possible values include: "Windows", "Linux".
    :vartype os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGeneration
    :param purchase_plan: Purchase plan information for the the image from which the OS disk was
     created.
    :type purchase_plan: ~azure.mgmt.compute.v2021_04_01.models.PurchasePlanAutoGenerated
    :param supported_capabilities: List of supported capabilities (like accelerated networking) for
     the image from which the OS disk was created.
    :type supported_capabilities: ~azure.mgmt.compute.v2021_04_01.models.SupportedCapabilities
    :ivar family_id: id of the backing snapshot's MIS family.
    :vartype family_id: str
    :ivar source_unique_id: unique incarnation id of the source disk.
    :vartype source_unique_id: str
    :ivar encryption: Encryption property can be used to encrypt data at rest with customer managed
     keys or platform managed keys.
    :vartype encryption: ~azure.mgmt.compute.v2021_04_01.models.Encryption
    :param supports_hibernation: Indicates the OS on a disk supports hibernation.
    :type supports_hibernation: bool
    :param network_access_policy: Policy for accessing the disk via network. Possible values
     include: "AllowAll", "AllowPrivate", "DenyAll".
    :type network_access_policy: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkAccessPolicy
    :param public_network_access: Policy for controlling export on the disk. Possible values
     include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.compute.v2021_04_01.models.PublicNetworkAccess
    :param disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :type disk_access_id: str
    :param completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :type completion_percent: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'time_created': {'readonly': True},
        'source_resource_id': {'readonly': True},
        'os_type': {'readonly': True},
        'family_id': {'readonly': True},
        'source_unique_id': {'readonly': True},
        'encryption': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'source_resource_id': {'key': 'properties.sourceResourceId', 'type': 'str'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'PurchasePlanAutoGenerated'},
        'supported_capabilities': {'key': 'properties.supportedCapabilities', 'type': 'SupportedCapabilities'},
        'family_id': {'key': 'properties.familyId', 'type': 'str'},
        'source_unique_id': {'key': 'properties.sourceUniqueId', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'supports_hibernation': {'key': 'properties.supportsHibernation', 'type': 'bool'},
        'network_access_policy': {'key': 'properties.networkAccessPolicy', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'disk_access_id': {'key': 'properties.diskAccessId', 'type': 'str'},
        'completion_percent': {'key': 'properties.completionPercent', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        hyper_v_generation: Optional[Union[str, "HyperVGeneration"]] = None,
        purchase_plan: Optional["PurchasePlanAutoGenerated"] = None,
        supported_capabilities: Optional["SupportedCapabilities"] = None,
        supports_hibernation: Optional[bool] = None,
        network_access_policy: Optional[Union[str, "NetworkAccessPolicy"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        disk_access_id: Optional[str] = None,
        completion_percent: Optional[float] = None,
        **kwargs
    ):
        super(DiskRestorePoint, self).__init__(**kwargs)
        self.time_created = None
        self.source_resource_id = None
        self.os_type = None
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.family_id = None
        self.source_unique_id = None
        self.encryption = None
        self.supports_hibernation = supports_hibernation
        self.network_access_policy = network_access_policy
        self.public_network_access = public_network_access
        self.disk_access_id = disk_access_id
        self.completion_percent = completion_percent


class DiskRestorePointList(msrest.serialization.Model):
    """The List Disk Restore Points operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of disk restore points.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.DiskRestorePoint]
    :param next_link: The uri to fetch the next page of disk restore points. Call ListNext() with
     this to fetch the next page of disk restore points.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiskRestorePoint]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DiskRestorePoint"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DiskRestorePointList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskSecurityProfile(msrest.serialization.Model):
    """Contains the security related information for the resource.

    :param security_type: Specifies the SecurityType of the VM. Applicable for OS disks only.
     Possible values include: "TrustedLaunch".
    :type security_type: str or ~azure.mgmt.compute.v2021_04_01.models.DiskSecurityTypes
    """

    _attribute_map = {
        'security_type': {'key': 'securityType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        security_type: Optional[Union[str, "DiskSecurityTypes"]] = None,
        **kwargs
    ):
        super(DiskSecurityProfile, self).__init__(**kwargs)
        self.security_type = security_type


class DiskSku(msrest.serialization.Model):
    """The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS, UltraSSD_LRS, Premium_ZRS, or StandardSSD_ZRS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The sku name. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS", "StandardSSD_ZRS".
    :type name: str or ~azure.mgmt.compute.v2021_04_01.models.DiskStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "DiskStorageAccountTypes"]] = None,
        **kwargs
    ):
        super(DiskSku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class DiskUpdate(msrest.serialization.Model):
    """Disk update resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The disks sku name. Can be Standard_LRS, Premium_LRS, StandardSSD_LRS,
     UltraSSD_LRS, Premium_ZRS, or StandardSSD_ZRS.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.DiskSku
    :param os_type: the Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2021_04_01.models.EncryptionSettingsCollection
    :param disk_iops_read_write: The number of IOPS allowed for this disk; only settable for
     UltraSSD disks. One operation can transfer between 4k and 256k bytes.
    :type disk_iops_read_write: long
    :param disk_m_bps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD
     disks. MBps means millions of bytes per second - MB here uses the ISO notation, of powers of
     10.
    :type disk_m_bps_read_write: long
    :param disk_iops_read_only: The total number of IOPS that will be allowed across all VMs
     mounting the shared disk as ReadOnly. One operation can transfer between 4k and 256k bytes.
    :type disk_iops_read_only: long
    :param disk_m_bps_read_only: The total throughput (MBps) that will be allowed across all VMs
     mounting the shared disk as ReadOnly. MBps means millions of bytes per second - MB here uses
     the ISO notation, of powers of 10.
    :type disk_m_bps_read_only: long
    :param max_shares: The maximum number of VMs that can attach to the disk at the same time.
     Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
    :type max_shares: int
    :param encryption: Encryption property can be used to encrypt data at rest with customer
     managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2021_04_01.models.Encryption
    :param network_access_policy: Policy for accessing the disk via network. Possible values
     include: "AllowAll", "AllowPrivate", "DenyAll".
    :type network_access_policy: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkAccessPolicy
    :param disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :type disk_access_id: str
    :param tier: Performance tier of the disk (e.g, P4, S10) as described here:
     https://azure.microsoft.com/en-us/pricing/details/managed-disks/. Does not apply to Ultra
     disks.
    :type tier: str
    :param bursting_enabled: Set to true to enable bursting beyond the provisioned performance
     target of the disk. Bursting is disabled by default. Does not apply to Ultra disks.
    :type bursting_enabled: bool
    :param purchase_plan: Purchase plan information to be added on the OS disk.
    :type purchase_plan: ~azure.mgmt.compute.v2021_04_01.models.PurchasePlanAutoGenerated
    :param supported_capabilities: List of supported capabilities (like accelerated networking) to
     be added on the OS disk.
    :type supported_capabilities: ~azure.mgmt.compute.v2021_04_01.models.SupportedCapabilities
    :ivar property_updates_in_progress: Properties of the disk for which update is pending.
    :vartype property_updates_in_progress:
     ~azure.mgmt.compute.v2021_04_01.models.PropertyUpdatesInProgress
    :param supports_hibernation: Indicates the OS on a disk supports hibernation.
    :type supports_hibernation: bool
    :param public_network_access: Policy for controlling export on the disk. Possible values
     include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.compute.v2021_04_01.models.PublicNetworkAccess
    """

    _validation = {
        'property_updates_in_progress': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'DiskSku'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'disk_iops_read_write': {'key': 'properties.diskIOPSReadWrite', 'type': 'long'},
        'disk_m_bps_read_write': {'key': 'properties.diskMBpsReadWrite', 'type': 'long'},
        'disk_iops_read_only': {'key': 'properties.diskIOPSReadOnly', 'type': 'long'},
        'disk_m_bps_read_only': {'key': 'properties.diskMBpsReadOnly', 'type': 'long'},
        'max_shares': {'key': 'properties.maxShares', 'type': 'int'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_access_policy': {'key': 'properties.networkAccessPolicy', 'type': 'str'},
        'disk_access_id': {'key': 'properties.diskAccessId', 'type': 'str'},
        'tier': {'key': 'properties.tier', 'type': 'str'},
        'bursting_enabled': {'key': 'properties.burstingEnabled', 'type': 'bool'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'PurchasePlanAutoGenerated'},
        'supported_capabilities': {'key': 'properties.supportedCapabilities', 'type': 'SupportedCapabilities'},
        'property_updates_in_progress': {'key': 'properties.propertyUpdatesInProgress', 'type': 'PropertyUpdatesInProgress'},
        'supports_hibernation': {'key': 'properties.supportsHibernation', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["DiskSku"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["EncryptionSettingsCollection"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        disk_iops_read_only: Optional[int] = None,
        disk_m_bps_read_only: Optional[int] = None,
        max_shares: Optional[int] = None,
        encryption: Optional["Encryption"] = None,
        network_access_policy: Optional[Union[str, "NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        tier: Optional[str] = None,
        bursting_enabled: Optional[bool] = None,
        purchase_plan: Optional["PurchasePlanAutoGenerated"] = None,
        supported_capabilities: Optional["SupportedCapabilities"] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(DiskUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write
        self.disk_iops_read_only = disk_iops_read_only
        self.disk_m_bps_read_only = disk_m_bps_read_only
        self.max_shares = max_shares
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.tier = tier
        self.bursting_enabled = bursting_enabled
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.property_updates_in_progress = None
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access


class Encryption(msrest.serialization.Model):
    """Encryption at rest settings for disk or snapshot.

    :param disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :type disk_encryption_set_id: str
    :param type: The type of key used to encrypt the data of the disk. Possible values include:
     "EncryptionAtRestWithPlatformKey", "EncryptionAtRestWithCustomerKey",
     "EncryptionAtRestWithPlatformAndCustomerKeys".
    :type type: str or ~azure.mgmt.compute.v2021_04_01.models.EncryptionType
    """

    _attribute_map = {
        'disk_encryption_set_id': {'key': 'diskEncryptionSetId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        disk_encryption_set_id: Optional[str] = None,
        type: Optional[Union[str, "EncryptionType"]] = None,
        **kwargs
    ):
        super(Encryption, self).__init__(**kwargs)
        self.disk_encryption_set_id = disk_encryption_set_id
        self.type = type


class EncryptionSetIdentity(msrest.serialization.Model):
    """The managed identity for the disk encryption set. It should be given permission on the key vault before it can be used to encrypt disks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: The type of Managed Identity used by the DiskEncryptionSet. Only SystemAssigned is
     supported for new creations. Disk Encryption Sets can be updated with Identity type None during
     migration of subscription to a new Azure Active Directory tenant; it will cause the encrypted
     resources to lose access to the keys. Possible values include: "SystemAssigned", "None".
    :type type: str or ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "DiskEncryptionSetIdentityType"]] = None,
        **kwargs
    ):
        super(EncryptionSetIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class EncryptionSettingsCollection(msrest.serialization.Model):
    """Encryption settings for disk or snapshot.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Set this flag to true and provide DiskEncryptionKey and optional
     KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
     KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged.
    :type enabled: bool
    :param encryption_settings: A collection of encryption settings, one for each disk volume.
    :type encryption_settings:
     list[~azure.mgmt.compute.v2021_04_01.models.EncryptionSettingsElement]
    :param encryption_settings_version: Describes what type of encryption is used for the disks.
     Once this field is set, it cannot be overwritten. '1.0' corresponds to Azure Disk Encryption
     with AAD app.'1.1' corresponds to Azure Disk Encryption.
    :type encryption_settings_version: str
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': '[EncryptionSettingsElement]'},
        'encryption_settings_version': {'key': 'encryptionSettingsVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        encryption_settings: Optional[List["EncryptionSettingsElement"]] = None,
        encryption_settings_version: Optional[str] = None,
        **kwargs
    ):
        super(EncryptionSettingsCollection, self).__init__(**kwargs)
        self.enabled = enabled
        self.encryption_settings = encryption_settings
        self.encryption_settings_version = encryption_settings_version


class EncryptionSettingsElement(msrest.serialization.Model):
    """Encryption settings for one disk volume.

    :param disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
    :type disk_encryption_key: ~azure.mgmt.compute.v2021_04_01.models.KeyVaultAndSecretReference
    :param key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
     KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
    :type key_encryption_key: ~azure.mgmt.compute.v2021_04_01.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultAndSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultAndKeyReference'},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["KeyVaultAndSecretReference"] = None,
        key_encryption_key: Optional["KeyVaultAndKeyReference"] = None,
        **kwargs
    ):
        super(EncryptionSettingsElement, self).__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key


class ExtendedLocation(msrest.serialization.Model):
    """The complex type of the extended location.

    :param name: The name of the extended location.
    :type name: str
    :param type: The type of the extended location. Possible values include: "EdgeZone".
    :type type: str or ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocationTypes
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[Union[str, "ExtendedLocationTypes"]] = None,
        **kwargs
    ):
        super(ExtendedLocation, self).__init__(**kwargs)
        self.name = name
        self.type = type


class GrantAccessData(msrest.serialization.Model):
    """Data used for requesting a SAS.

    All required parameters must be populated in order to send to Azure.

    :param access: Required.  Possible values include: "None", "Read", "Write".
    :type access: str or ~azure.mgmt.compute.v2021_04_01.models.AccessLevel
    :param duration_in_seconds: Required. Time duration in seconds until the SAS access expires.
    :type duration_in_seconds: int
    """

    _validation = {
        'access': {'required': True},
        'duration_in_seconds': {'required': True},
    }

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        access: Union[str, "AccessLevel"],
        duration_in_seconds: int,
        **kwargs
    ):
        super(GrantAccessData, self).__init__(**kwargs)
        self.access = access
        self.duration_in_seconds = duration_in_seconds


class HardwareProfile(msrest.serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :param vm_size: Specifies the size of the virtual machine. :code:`<br>`:code:`<br>` The enum
     data type is currently deprecated and will be removed by December 23rd 2023.
     :code:`<br>`:code:`<br>` Recommended way to get the list of available sizes is using these
     APIs: :code:`<br>`:code:`<br>` `List all available virtual machine sizes in an availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/rest/api/compute/resourceskus/list>`_ :code:`<br>`:code:`<br>`
     `List all available virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. For more
     information about virtual machine sizes, see `Sizes for virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/sizes>`_. :code:`<br>`:code:`<br>` The
     available VM sizes depend on region and availability set. Possible values include: "Basic_A0",
     "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0", "Standard_A1", "Standard_A2",
     "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8",
     "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2_v2",
     "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2", "Standard_A8m_v2",
     "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4", "Standard_D11",
     "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2", "Standard_D2_v2",
     "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3", "Standard_D4_v3",
     "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3", "Standard_D2s_v3",
     "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3", "Standard_D32s_v3",
     "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2", "Standard_D13_v2", "Standard_D14_v2",
     "Standard_D15_v2", "Standard_DS1", "Standard_DS2", "Standard_DS3", "Standard_DS4",
     "Standard_DS11", "Standard_DS12", "Standard_DS13", "Standard_DS14", "Standard_DS1_v2",
     "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2", "Standard_DS5_v2", "Standard_DS11_v2",
     "Standard_DS12_v2", "Standard_DS13_v2", "Standard_DS14_v2", "Standard_DS15_v2",
     "Standard_DS13-4_v2", "Standard_DS13-2_v2", "Standard_DS14-8_v2", "Standard_DS14-4_v2",
     "Standard_E2_v3", "Standard_E4_v3", "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3",
     "Standard_E64_v3", "Standard_E2s_v3", "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3",
     "Standard_E32s_v3", "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3",
     "Standard_E64-32s_v3", "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4",
     "Standard_F8", "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12",
     "Standard_NV24".
    :type vm_size: str or ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineSizeTypes
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "VirtualMachineSizeTypes"]] = None,
        **kwargs
    ):
        super(HardwareProfile, self).__init__(**kwargs)
        self.vm_size = vm_size


class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param extended_location: The extended location of the Image.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :param source_virtual_machine: The source virtual machine from which Image is created.
    :type source_virtual_machine: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2021_04_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :param hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
     from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
     user to specify the value, if the source is managed resource like disk or snapshot, we may
     require the user to specify the property if we cannot deduce it from the source managed
     resource. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGenerationTypes
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'source_virtual_machine': {'key': 'properties.sourceVirtualMachine', 'type': 'SubResource'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'ImageStorageProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        source_virtual_machine: Optional["SubResource"] = None,
        storage_profile: Optional["ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGenerationTypes"]] = None,
        **kwargs
    ):
        super(Image, self).__init__(location=location, tags=tags, **kwargs)
        self.extended_location = extended_location
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None
        self.hyper_v_generation = hyper_v_generation


class ImageDisk(msrest.serialization.Model):
    """Describes a image disk.

    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2021_04_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'DiskEncryptionSetParameters'},
    }

    def __init__(
        self,
        *,
        snapshot: Optional["SubResource"] = None,
        managed_disk: Optional["SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["DiskEncryptionSetParameters"] = None,
        **kwargs
    ):
        super(ImageDisk, self).__init__(**kwargs)
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set


class ImageDataDisk(ImageDisk):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2021_04_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetParameters
    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    """

    _validation = {
        'lun': {'required': True},
    }

    _attribute_map = {
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'DiskEncryptionSetParameters'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["SubResource"] = None,
        managed_disk: Optional["SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["DiskEncryptionSetParameters"] = None,
        **kwargs
    ):
        super(ImageDataDisk, self).__init__(snapshot=snapshot, managed_disk=managed_disk, blob_uri=blob_uri, caching=caching, disk_size_gb=disk_size_gb, storage_account_type=storage_account_type, disk_encryption_set=disk_encryption_set, **kwargs)
        self.lun = lun


class ImageDiskReference(msrest.serialization.Model):
    """The source image used for creating the disk.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A relative uri containing either a Platform Image Repository or user image
     reference.
    :type id: str
    :param lun: If the disk is created from an image's data disk, this is an index that indicates
     which of the data disks in the image to use. For OS disks, this field is null.
    :type lun: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        id: str,
        lun: Optional[int] = None,
        **kwargs
    ):
        super(ImageDiskReference, self).__init__(**kwargs)
        self.id = id
        self.lun = lun


class ImageListResult(msrest.serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of Images.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.Image]
    :param next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Image]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Image"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ImageListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageOSDisk(ImageDisk):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to Azure.

    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2021_04_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed image disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetParameters
    :param os_type: Required. This property allows you to specify the type of the OS that is
     included in the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param os_state: Required. The OS State. Possible values include: "Generalized", "Specialized".
    :type os_state: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemStateTypes
    """

    _validation = {
        'os_type': {'required': True},
        'os_state': {'required': True},
    }

    _attribute_map = {
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'DiskEncryptionSetParameters'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_state': {'key': 'osState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "OperatingSystemTypes"],
        os_state: Union[str, "OperatingSystemStateTypes"],
        snapshot: Optional["SubResource"] = None,
        managed_disk: Optional["SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["DiskEncryptionSetParameters"] = None,
        **kwargs
    ):
        super(ImageOSDisk, self).__init__(snapshot=snapshot, managed_disk=managed_disk, blob_uri=blob_uri, caching=caching, disk_size_gb=disk_size_gb, storage_account_type=storage_account_type, disk_encryption_set=disk_encryption_set, **kwargs)
        self.os_type = os_type
        self.os_state = os_state


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Id.
    :type id: str
    :param publisher: The image publisher.
    :type publisher: str
    :param offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :type offer: str
    :param sku: The image SKU.
    :type sku: str
    :param version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :type version: str
    :ivar exact_version: Specifies in decimal numbers, the version of platform image or marketplace
     image used to create the virtual machine. This readonly field differs from 'version', only if
     the value specified in 'version' field is 'latest'.
    :vartype exact_version: str
    """

    _validation = {
        'exact_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'exact_version': {'key': 'exactVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ImageReference, self).__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version
        self.exact_version = None


class ImageStorageProfile(msrest.serialization.Model):
    """Describes a storage profile.

    :param os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :type os_disk: ~azure.mgmt.compute.v2021_04_01.models.ImageOSDisk
    :param data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :type data_disks: list[~azure.mgmt.compute.v2021_04_01.models.ImageDataDisk]
    :param zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :type zone_resilient: bool
    """

    _attribute_map = {
        'os_disk': {'key': 'osDisk', 'type': 'ImageOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[ImageDataDisk]'},
        'zone_resilient': {'key': 'zoneResilient', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["ImageOSDisk"] = None,
        data_disks: Optional[List["ImageDataDisk"]] = None,
        zone_resilient: Optional[bool] = None,
        **kwargs
    ):
        super(ImageStorageProfile, self).__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.zone_resilient = zone_resilient


class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source_virtual_machine: The source virtual machine from which Image is created.
    :type source_virtual_machine: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2021_04_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :param hyper_v_generation: Specifies the HyperVGenerationType of the VirtualMachine created
     from the image. From API Version 2019-03-01 if the image source is a blob, then we need the
     user to specify the value, if the source is managed resource like disk or snapshot, we may
     require the user to specify the property if we cannot deduce it from the source managed
     resource. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGenerationTypes
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'source_virtual_machine': {'key': 'properties.sourceVirtualMachine', 'type': 'SubResource'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'ImageStorageProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["SubResource"] = None,
        storage_profile: Optional["ImageStorageProfile"] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGenerationTypes"]] = None,
        **kwargs
    ):
        super(ImageUpdate, self).__init__(tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None
        self.hyper_v_generation = hyper_v_generation


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exceptiontype: Optional[str] = None,
        errordetail: Optional[str] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceViewStatus(msrest.serialization.Model):
    """Instance view status.

    :param code: The status code.
    :type code: str
    :param level: The level code. Possible values include: "Info", "Warning", "Error".
    :type level: str or ~azure.mgmt.compute.v2021_04_01.models.StatusLevelTypes
    :param display_status: The short localizable label for the status.
    :type display_status: str
    :param message: The detailed status message, including for alerts and error messages.
    :type message: str
    :param time: The time of the status.
    :type time: ~datetime.datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(InstanceViewStatus, self).__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class KeyForDiskEncryptionSet(msrest.serialization.Model):
    """Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Resource id of the KeyVault containing the key or secret. This property is
     optional and cannot be used if the KeyVault subscription is not the same as the Disk Encryption
     Set subscription.
    :type source_vault: ~azure.mgmt.compute.v2021_04_01.models.SourceVault
    :param key_url: Required. Fully versioned Key Url pointing to a key in KeyVault. Version
     segment of the Url is required regardless of rotationToLatestKeyVersionEnabled value.
    :type key_url: str
    """

    _validation = {
        'key_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'key_url': {'key': 'keyUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_url: str,
        source_vault: Optional["SourceVault"] = None,
        **kwargs
    ):
        super(KeyForDiskEncryptionSet, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndKeyReference(msrest.serialization.Model):
    """Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. Resource id of the KeyVault containing the key or secret.
    :type source_vault: ~azure.mgmt.compute.v2021_04_01.models.SourceVault
    :param key_url: Required. Url pointing to a key or secret in KeyVault.
    :type key_url: str
    """

    _validation = {
        'source_vault': {'required': True},
        'key_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'key_url': {'key': 'keyUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_vault: "SourceVault",
        key_url: str,
        **kwargs
    ):
        super(KeyVaultAndKeyReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndSecretReference(msrest.serialization.Model):
    """Key Vault Secret Url and vault id of the encryption key.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. Resource id of the KeyVault containing the key or secret.
    :type source_vault: ~azure.mgmt.compute.v2021_04_01.models.SourceVault
    :param secret_url: Required. Url pointing to a key or secret in KeyVault.
    :type secret_url: str
    """

    _validation = {
        'source_vault': {'required': True},
        'secret_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_vault: "SourceVault",
        secret_url: str,
        **kwargs
    ):
        super(KeyVaultAndSecretReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class KeyVaultKeyReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :param key_url: Required. The URL referencing a key encryption key in Key Vault.
    :type key_url: str
    :param source_vault: Required. The relative URL of the Key Vault containing the key.
    :type source_vault: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    """

    _validation = {
        'key_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        key_url: str,
        source_vault: "SubResource",
        **kwargs
    ):
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultSecretReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :param secret_url: Required. The URL referencing a secret in a Key Vault.
    :type secret_url: str
    :param source_vault: Required. The relative URL of the Key Vault containing the secret.
    :type source_vault: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    """

    _validation = {
        'secret_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        secret_url: str,
        source_vault: "SubResource",
        **kwargs
    ):
        super(KeyVaultSecretReference, self).__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault


class LastPatchInstallationSummary(msrest.serialization.Model):
    """Describes the properties of the last installed patch summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Possible values include: "Unknown", "InProgress", "Failed",
     "Succeeded", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_04_01.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar maintenance_window_exceeded: Describes whether the operation ran out of time before it
     completed all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar not_selected_patch_count: The number of all available patches but not going to be
     installed because it didn't match a classification or inclusion list entry.
    :vartype not_selected_patch_count: int
    :ivar excluded_patch_count: The number of all available patches but excluded explicitly by a
     customer-specified exclusion list match.
    :vartype excluded_patch_count: int
    :ivar pending_patch_count: The number of all available patches expected to be installed over
     the course of the patch installation operation.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The count of patches that successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The count of patches that failed installation.
    :vartype failed_patch_count: int
    :ivar start_time: The UTC timestamp when the operation began.
    :vartype start_time: ~datetime.datetime
    :ivar last_modified_time: The UTC timestamp when the operation began.
    :vartype last_modified_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'installation_activity_id': {'readonly': True},
        'maintenance_window_exceeded': {'readonly': True},
        'not_selected_patch_count': {'readonly': True},
        'excluded_patch_count': {'readonly': True},
        'pending_patch_count': {'readonly': True},
        'installed_patch_count': {'readonly': True},
        'failed_patch_count': {'readonly': True},
        'start_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'installation_activity_id': {'key': 'installationActivityId', 'type': 'str'},
        'maintenance_window_exceeded': {'key': 'maintenanceWindowExceeded', 'type': 'bool'},
        'not_selected_patch_count': {'key': 'notSelectedPatchCount', 'type': 'int'},
        'excluded_patch_count': {'key': 'excludedPatchCount', 'type': 'int'},
        'pending_patch_count': {'key': 'pendingPatchCount', 'type': 'int'},
        'installed_patch_count': {'key': 'installedPatchCount', 'type': 'int'},
        'failed_patch_count': {'key': 'failedPatchCount', 'type': 'int'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'lastModifiedTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LastPatchInstallationSummary, self).__init__(**kwargs)
        self.status = None
        self.installation_activity_id = None
        self.maintenance_window_exceeded = None
        self.not_selected_patch_count = None
        self.excluded_patch_count = None
        self.pending_patch_count = None
        self.installed_patch_count = None
        self.failed_patch_count = None
        self.start_time = None
        self.last_modified_time = None
        self.error = None


class LinuxConfiguration(msrest.serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.

    :param disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :type disable_password_authentication: bool
    :param ssh: Specifies the ssh key configuration for a Linux OS.
    :type ssh: ~azure.mgmt.compute.v2021_04_01.models.SshConfiguration
    :param provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :type provision_vm_agent: bool
    :param patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Linux.
    :type patch_settings: ~azure.mgmt.compute.v2021_04_01.models.LinuxPatchSettings
    """

    _attribute_map = {
        'disable_password_authentication': {'key': 'disablePasswordAuthentication', 'type': 'bool'},
        'ssh': {'key': 'ssh', 'type': 'SshConfiguration'},
        'provision_vm_agent': {'key': 'provisionVMAgent', 'type': 'bool'},
        'patch_settings': {'key': 'patchSettings', 'type': 'LinuxPatchSettings'},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["SshConfiguration"] = None,
        provision_vm_agent: Optional[bool] = None,
        patch_settings: Optional["LinuxPatchSettings"] = None,
        **kwargs
    ):
        super(LinuxConfiguration, self).__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh
        self.provision_vm_agent = provision_vm_agent
        self.patch_settings = patch_settings


class LinuxParameters(msrest.serialization.Model):
    """Input for InstallPatches on a Linux VM, as directly received by the API.

    :param classifications_to_include: The update classifications to select when installing patches
     for Linux.
    :type classifications_to_include: list[str or
     ~azure.mgmt.compute.v2021_04_01.models.VMGuestPatchClassificationLinux]
    :param package_name_masks_to_include: packages to include in the patch operation. Format:
     packageName_packageVersion.
    :type package_name_masks_to_include: list[str]
    :param package_name_masks_to_exclude: packages to exclude in the patch operation. Format:
     packageName_packageVersion.
    :type package_name_masks_to_exclude: list[str]
    :param maintenance_run_id: This is used as a maintenance run identifier for Auto VM Guest
     Patching in Linux.
    :type maintenance_run_id: str
    """

    _attribute_map = {
        'classifications_to_include': {'key': 'classificationsToInclude', 'type': '[str]'},
        'package_name_masks_to_include': {'key': 'packageNameMasksToInclude', 'type': '[str]'},
        'package_name_masks_to_exclude': {'key': 'packageNameMasksToExclude', 'type': '[str]'},
        'maintenance_run_id': {'key': 'maintenanceRunId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        classifications_to_include: Optional[List[Union[str, "VMGuestPatchClassificationLinux"]]] = None,
        package_name_masks_to_include: Optional[List[str]] = None,
        package_name_masks_to_exclude: Optional[List[str]] = None,
        maintenance_run_id: Optional[str] = None,
        **kwargs
    ):
        super(LinuxParameters, self).__init__(**kwargs)
        self.classifications_to_include = classifications_to_include
        self.package_name_masks_to_include = package_name_masks_to_include
        self.package_name_masks_to_exclude = package_name_masks_to_exclude
        self.maintenance_run_id = maintenance_run_id


class LinuxPatchSettings(msrest.serialization.Model):
    """Specifies settings related to VM Guest Patching on Linux.

    :param patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **ImageDefault** - The
     virtual machine's default patching configuration is used. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - The virtual machine will be automatically updated by the platform.
     The property provisionVMAgent must be true. Possible values include: "ImageDefault",
     "AutomaticByPlatform".
    :type patch_mode: str or ~azure.mgmt.compute.v2021_04_01.models.LinuxVMGuestPatchMode
    :param assessment_mode: Specifies the mode of VM Guest Patch Assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You control the timing of patch assessments on a virtual machine. :code:`<br
     />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
     assessments. The property provisionVMAgent must be true. Possible values include:
     "ImageDefault", "AutomaticByPlatform".
    :type assessment_mode: str or ~azure.mgmt.compute.v2021_04_01.models.LinuxPatchAssessmentMode
    """

    _attribute_map = {
        'patch_mode': {'key': 'patchMode', 'type': 'str'},
        'assessment_mode': {'key': 'assessmentMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "LinuxVMGuestPatchMode"]] = None,
        assessment_mode: Optional[Union[str, "LinuxPatchAssessmentMode"]] = None,
        **kwargs
    ):
        super(LinuxPatchSettings, self).__init__(**kwargs)
        self.patch_mode = patch_mode
        self.assessment_mode = assessment_mode


class ListUsagesResult(msrest.serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of compute resource usages.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.Usage]
    :param next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Usage"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListUsagesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsInputBase(msrest.serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param group_by_client_application_id: Group query result by Client Application ID.
    :type group_by_client_application_id: bool
    :param group_by_user_agent: Group query result by User Agent.
    :type group_by_user_agent: bool
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'group_by_client_application_id': {'key': 'groupByClientApplicationId', 'type': 'bool'},
        'group_by_user_agent': {'key': 'groupByUserAgent', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs
    ):
        super(LogAnalyticsInputBase, self).__init__(**kwargs)
        self.blob_container_sas_uri = blob_container_sas_uri
        self.from_time = from_time
        self.to_time = to_time
        self.group_by_throttle_policy = group_by_throttle_policy
        self.group_by_operation_name = group_by_operation_name
        self.group_by_resource_name = group_by_resource_name
        self.group_by_client_application_id = group_by_client_application_id
        self.group_by_user_agent = group_by_user_agent


class LogAnalyticsOperationResult(msrest.serialization.Model):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.v2021_04_01.models.LogAnalyticsOutput
    """

    _validation = {
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'LogAnalyticsOutput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsOperationResult, self).__init__(**kwargs)
        self.properties = None


class LogAnalyticsOutput(msrest.serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        'output': {'readonly': True},
    }

    _attribute_map = {
        'output': {'key': 'output', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsOutput, self).__init__(**kwargs)
        self.output = None


class MaintenanceRedeployStatus(msrest.serialization.Model):
    """Maintenance Operation Status.

    :param is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :type is_customer_initiated_maintenance_allowed: bool
    :param pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :type pre_maintenance_window_start_time: ~datetime.datetime
    :param pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :type pre_maintenance_window_end_time: ~datetime.datetime
    :param maintenance_window_start_time: Start Time for the Maintenance Window.
    :type maintenance_window_start_time: ~datetime.datetime
    :param maintenance_window_end_time: End Time for the Maintenance Window.
    :type maintenance_window_end_time: ~datetime.datetime
    :param last_operation_result_code: The Last Maintenance Operation Result Code. Possible values
     include: "None", "RetryLater", "MaintenanceAborted", "MaintenanceCompleted".
    :type last_operation_result_code: str or
     ~azure.mgmt.compute.v2021_04_01.models.MaintenanceOperationResultCodeTypes
    :param last_operation_message: Message returned for the last Maintenance Operation.
    :type last_operation_message: str
    """

    _attribute_map = {
        'is_customer_initiated_maintenance_allowed': {'key': 'isCustomerInitiatedMaintenanceAllowed', 'type': 'bool'},
        'pre_maintenance_window_start_time': {'key': 'preMaintenanceWindowStartTime', 'type': 'iso-8601'},
        'pre_maintenance_window_end_time': {'key': 'preMaintenanceWindowEndTime', 'type': 'iso-8601'},
        'maintenance_window_start_time': {'key': 'maintenanceWindowStartTime', 'type': 'iso-8601'},
        'maintenance_window_end_time': {'key': 'maintenanceWindowEndTime', 'type': 'iso-8601'},
        'last_operation_result_code': {'key': 'lastOperationResultCode', 'type': 'str'},
        'last_operation_message': {'key': 'lastOperationMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_customer_initiated_maintenance_allowed: Optional[bool] = None,
        pre_maintenance_window_start_time: Optional[datetime.datetime] = None,
        pre_maintenance_window_end_time: Optional[datetime.datetime] = None,
        maintenance_window_start_time: Optional[datetime.datetime] = None,
        maintenance_window_end_time: Optional[datetime.datetime] = None,
        last_operation_result_code: Optional[Union[str, "MaintenanceOperationResultCodeTypes"]] = None,
        last_operation_message: Optional[str] = None,
        **kwargs
    ):
        super(MaintenanceRedeployStatus, self).__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = is_customer_initiated_maintenance_allowed
        self.pre_maintenance_window_start_time = pre_maintenance_window_start_time
        self.pre_maintenance_window_end_time = pre_maintenance_window_end_time
        self.maintenance_window_start_time = maintenance_window_start_time
        self.maintenance_window_end_time = maintenance_window_end_time
        self.last_operation_result_code = last_operation_result_code
        self.last_operation_message = last_operation_message


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :param id: Resource Id.
    :type id: str
    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2021_04_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'DiskEncryptionSetParameters'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["DiskEncryptionSetParameters"] = None,
        **kwargs
    ):
        super(ManagedDiskParameters, self).__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :param id: Resource Id.
    :type id: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param delete_option: Specify what happens to the network interface when the VM is deleted.
     Possible values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        **kwargs
    ):
        super(NetworkInterfaceReference, self).__init__(id=id, **kwargs)
        self.primary = primary
        self.delete_option = delete_option


class NetworkProfile(msrest.serialization.Model):
    """Specifies the network interfaces or the networking configuration of the virtual machine.

    :param network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :type network_interfaces:
     list[~azure.mgmt.compute.v2021_04_01.models.NetworkInterfaceReference]
    :param network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations. Possible values include:
     "2020-11-01".
    :type network_api_version: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkApiVersion
    :param network_interface_configurations: Specifies the networking configurations that will be
     used to create the virtual machine networking resources.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineNetworkInterfaceConfiguration]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[NetworkInterfaceReference]'},
        'network_api_version': {'key': 'networkApiVersion', 'type': 'str'},
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineNetworkInterfaceConfiguration]'},
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List["NetworkInterfaceReference"]] = None,
        network_api_version: Optional[Union[str, "NetworkApiVersion"]] = None,
        network_interface_configurations: Optional[List["VirtualMachineNetworkInterfaceConfiguration"]] = None,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = network_interfaces
        self.network_api_version = network_api_version
        self.network_interface_configurations = network_interface_configurations


class OrchestrationServiceStateInput(msrest.serialization.Model):
    """The input for OrchestrationServiceState.

    All required parameters must be populated in order to send to Azure.

    :param service_name: Required. The name of the service. Possible values include:
     "AutomaticRepairs", "DummyOrchestrationServiceName".
    :type service_name: str or ~azure.mgmt.compute.v2021_04_01.models.OrchestrationServiceNames
    :param action: Required. The action to be performed. Possible values include: "Resume",
     "Suspend".
    :type action: str or ~azure.mgmt.compute.v2021_04_01.models.OrchestrationServiceStateAction
    """

    _validation = {
        'service_name': {'required': True},
        'action': {'required': True},
    }

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        service_name: Union[str, "OrchestrationServiceNames"],
        action: Union[str, "OrchestrationServiceStateAction"],
        **kwargs
    ):
        super(OrchestrationServiceStateInput, self).__init__(**kwargs)
        self.service_name = service_name
        self.action = action


class OrchestrationServiceSummary(msrest.serialization.Model):
    """Summary for an orchestration service of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_name: The name of the service. Possible values include: "AutomaticRepairs",
     "DummyOrchestrationServiceName".
    :vartype service_name: str or ~azure.mgmt.compute.v2021_04_01.models.OrchestrationServiceNames
    :ivar service_state: The current state of the service. Possible values include: "NotRunning",
     "Running", "Suspended".
    :vartype service_state: str or ~azure.mgmt.compute.v2021_04_01.models.OrchestrationServiceState
    """

    _validation = {
        'service_name': {'readonly': True},
        'service_state': {'readonly': True},
    }

    _attribute_map = {
        'service_name': {'key': 'serviceName', 'type': 'str'},
        'service_state': {'key': 'serviceState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrchestrationServiceSummary, self).__init__(**kwargs)
        self.service_name = None
        self.service_state = None


class OSDisk(msrest.serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.

    All required parameters must be populated in order to send to Azure.

    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type encryption_settings: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSettings
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2021_04_01.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :type image: ~azure.mgmt.compute.v2021_04_01.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None** for Standard
     storage. **ReadOnly** for Premium storage. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param diff_disk_settings: Specifies the ephemeral Disk Settings for the operating system disk
     used by the virtual machine.
    :type diff_disk_settings: ~azure.mgmt.compute.v2021_04_01.models.DiffDiskSettings
    :param create_option: Required. Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Possible values include: "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.ManagedDiskParameters
    :param delete_option: Specifies whether OS Disk should be deleted or detached upon VM deletion.
     :code:`<br>`:code:`<br>` Possible values: :code:`<br>`:code:`<br>` **Delete** If this value is
     used, the OS disk is deleted when VM is deleted.:code:`<br>`:code:`<br>` **Detach** If this
     value is used, the os disk is retained after VM is deleted. :code:`<br>`:code:`<br>` The
     default value is set to **detach**. For an ephemeral OS Disk, the default value is set to
     **Delete**. User cannot change the delete option for ephemeral OS Disk. Possible values
     include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskDeleteOptionTypes
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': 'DiskEncryptionSettings'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'diff_disk_settings': {'key': 'diffDiskSettings', 'type': 'DiffDiskSettings'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
        'delete_option': {'key': 'deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        encryption_settings: Optional["DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["VirtualHardDisk"] = None,
        image: Optional["VirtualHardDisk"] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["ManagedDiskParameters"] = None,
        delete_option: Optional[Union[str, "DiskDeleteOptionTypes"]] = None,
        **kwargs
    ):
        super(OSDisk, self).__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.diff_disk_settings = diff_disk_settings
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.delete_option = delete_option


class OSDiskImage(msrest.serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :param operating_system: Required. The operating system of the osDiskImage. Possible values
     include: "Windows", "Linux".
    :type operating_system: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    """

    _validation = {
        'operating_system': {'required': True},
    }

    _attribute_map = {
        'operating_system': {'key': 'operatingSystem', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operating_system: Union[str, "OperatingSystemTypes"],
        **kwargs
    ):
        super(OSDiskImage, self).__init__(**kwargs)
        self.operating_system = operating_system


class OSProfile(msrest.serialization.Model):
    """Specifies the operating system settings for the virtual machine. Some of the settings cannot be changed once VM is provisioned.

    :param computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/azure-resource-manager/management/resource-name-rules>`_.
    :type computer_name: str
    :param admin_username: Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` This property cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
     :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
     "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
     characters.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` **Note: Do not pass any
     secrets or passwords in customData property** :code:`<br>`:code:`<br>` This property cannot be
     updated after the VM is created. :code:`<br>`:code:`<br>` customData is passed to the VM to be
     saved as a file, for more information see `Custom Data on Azure VMs
     <https://azure.microsoft.com/blog/custom-data-and-cloud-init-on-windows-azure/>`_
     :code:`<br>`:code:`<br>` For using cloud-init for your Linux VM, see `Using cloud-init to
     customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :type windows_configuration: ~azure.mgmt.compute.v2021_04_01.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :type linux_configuration: ~azure.mgmt.compute.v2021_04_01.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed onto the virtual
     machine. To install certificates on a virtual machine it is recommended to use the `Azure Key
     Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :type secrets: list[~azure.mgmt.compute.v2021_04_01.models.VaultSecretGroup]
    :param allow_extension_operations: Specifies whether extension operations should be allowed on
     the virtual machine. :code:`<br>`:code:`<br>`This may only be set to False when no extensions
     are present on the virtual machine.
    :type allow_extension_operations: bool
    :param require_guest_provision_signal: Specifies whether the guest provision signal is required
     to infer provision success of the virtual machine.  **Note: This property is for private
     testing only, and all customers must not set the property to false.**.
    :type require_guest_provision_signal: bool
    """

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
        'allow_extension_operations': {'key': 'allowExtensionOperations', 'type': 'bool'},
        'require_guest_provision_signal': {'key': 'requireGuestProvisionSignal', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        linux_configuration: Optional["LinuxConfiguration"] = None,
        secrets: Optional[List["VaultSecretGroup"]] = None,
        allow_extension_operations: Optional[bool] = None,
        require_guest_provision_signal: Optional[bool] = None,
        **kwargs
    ):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets
        self.allow_extension_operations = allow_extension_operations
        self.require_guest_provision_signal = require_guest_provision_signal


class PatchInstallationDetail(msrest.serialization.Model):
    """Information about a specific patch that was encountered during an installation action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version string of the package. It may conform to Semantic Versioning. Only
     applies to Linux.
    :vartype version: str
    :ivar kb_id: The KBID of the patch. Only applies to Windows patches.
    :vartype kb_id: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar installation_state: The state of the patch after the installation operation completed.
     Possible values include: "Unknown", "Installed", "Failed", "Excluded", "NotSelected",
     "Pending".
    :vartype installation_state: str or
     ~azure.mgmt.compute.v2021_04_01.models.PatchInstallationState
    """

    _validation = {
        'patch_id': {'readonly': True},
        'name': {'readonly': True},
        'version': {'readonly': True},
        'kb_id': {'readonly': True},
        'classifications': {'readonly': True},
        'installation_state': {'readonly': True},
    }

    _attribute_map = {
        'patch_id': {'key': 'patchId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'kb_id': {'key': 'kbId', 'type': 'str'},
        'classifications': {'key': 'classifications', 'type': '[str]'},
        'installation_state': {'key': 'installationState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchInstallationDetail, self).__init__(**kwargs)
        self.patch_id = None
        self.name = None
        self.version = None
        self.kb_id = None
        self.classifications = None
        self.installation_state = None


class PatchSettings(msrest.serialization.Model):
    """Specifies settings related to VM Guest Patching on Windows.

    :param patch_mode: Specifies the mode of VM Guest Patching to IaaS virtual machine or virtual
     machines associated to virtual machine scale set with OrchestrationMode as Flexible.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of patches to a virtual machine. You do this by applying patches manually
     inside the VM. In this mode, automatic updates are disabled; the property
     WindowsConfiguration.enableAutomaticUpdates must be false:code:`<br />`:code:`<br />`
     **AutomaticByOS** - The virtual machine will automatically be updated by the OS. The property
     WindowsConfiguration.enableAutomaticUpdates must be true. :code:`<br />`:code:`<br />`
     **AutomaticByPlatform** - the virtual machine will automatically updated by the platform. The
     properties provisionVMAgent and WindowsConfiguration.enableAutomaticUpdates must be true.
     Possible values include: "Manual", "AutomaticByOS", "AutomaticByPlatform".
    :type patch_mode: str or ~azure.mgmt.compute.v2021_04_01.models.WindowsVMGuestPatchMode
    :param enable_hotpatching: Enables customers to patch their Azure VMs without requiring a
     reboot. For enableHotpatching, the 'provisionVMAgent' must be set to true and 'patchMode' must
     be set to 'AutomaticByPlatform'.
    :type enable_hotpatching: bool
    :param assessment_mode: Specifies the mode of VM Guest patch assessment for the IaaS virtual
     machine.:code:`<br />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />`
     **ImageDefault** - You control the timing of patch assessments on a virtual machine.:code:`<br
     />`:code:`<br />` **AutomaticByPlatform** - The platform will trigger periodic patch
     assessments. The property provisionVMAgent must be true. Possible values include:
     "ImageDefault", "AutomaticByPlatform".
    :type assessment_mode: str or ~azure.mgmt.compute.v2021_04_01.models.WindowsPatchAssessmentMode
    """

    _attribute_map = {
        'patch_mode': {'key': 'patchMode', 'type': 'str'},
        'enable_hotpatching': {'key': 'enableHotpatching', 'type': 'bool'},
        'assessment_mode': {'key': 'assessmentMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        patch_mode: Optional[Union[str, "WindowsVMGuestPatchMode"]] = None,
        enable_hotpatching: Optional[bool] = None,
        assessment_mode: Optional[Union[str, "WindowsPatchAssessmentMode"]] = None,
        **kwargs
    ):
        super(PatchSettings, self).__init__(**kwargs)
        self.patch_mode = patch_mode
        self.enable_hotpatching = enable_hotpatching
        self.assessment_mode = assessment_mode


class Plan(msrest.serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :type product: str
    :param promotion_code: The promotion code.
    :type promotion_code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(msrest.serialization.Model):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: private endpoint connection Id.
    :vartype id: str
    :ivar name: private endpoint connection name.
    :vartype name: str
    :ivar type: private endpoint connection type.
    :vartype type: str
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.compute.v2021_04_01.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between DiskAccess and Virtual Network.
    :type private_link_service_connection_state:
     ~azure.mgmt.compute.v2021_04_01.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.compute.v2021_04_01.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'private_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.private_endpoint = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private endpoint connections.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.PrivateEndpointConnection]
    :param next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
     fetch the next page of snapshots.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(msrest.serialization.Model):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: private link resource Id.
    :vartype id: str
    :ivar name: private link resource name.
    :vartype name: str
    :ivar type: private link resource type.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or
     ~azure.mgmt.compute.v2021_04_01.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class PropertyUpdatesInProgress(msrest.serialization.Model):
    """Properties of the disk for which update is pending.

    :param target_tier: The target performance tier of the disk if a tier change operation is in
     progress.
    :type target_tier: str
    """

    _attribute_map = {
        'target_tier': {'key': 'targetTier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_tier: Optional[str] = None,
        **kwargs
    ):
        super(PropertyUpdatesInProgress, self).__init__(**kwargs)
        self.target_tier = target_tier


class ProximityPlacementGroup(Resource):
    """Specifies information about the proximity placement group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param proximity_placement_group_type: Specifies the type of the proximity placement group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
     resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
     future use. Possible values include: "Standard", "Ultra".
    :type proximity_placement_group_type: str or
     ~azure.mgmt.compute.v2021_04_01.models.ProximityPlacementGroupType
    :ivar virtual_machines: A list of references to all virtual machines in the proximity placement
     group.
    :vartype virtual_machines:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceWithColocationStatus]
    :ivar virtual_machine_scale_sets: A list of references to all virtual machine scale sets in the
     proximity placement group.
    :vartype virtual_machine_scale_sets:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceWithColocationStatus]
    :ivar availability_sets: A list of references to all availability sets in the proximity
     placement group.
    :vartype availability_sets:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResourceWithColocationStatus]
    :param colocation_status: Describes colocation status of the Proximity Placement Group.
    :type colocation_status: ~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'virtual_machines': {'readonly': True},
        'virtual_machine_scale_sets': {'readonly': True},
        'availability_sets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'proximity_placement_group_type': {'key': 'properties.proximityPlacementGroupType', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResourceWithColocationStatus]'},
        'virtual_machine_scale_sets': {'key': 'properties.virtualMachineScaleSets', 'type': '[SubResourceWithColocationStatus]'},
        'availability_sets': {'key': 'properties.availabilitySets', 'type': '[SubResourceWithColocationStatus]'},
        'colocation_status': {'key': 'properties.colocationStatus', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        proximity_placement_group_type: Optional[Union[str, "ProximityPlacementGroupType"]] = None,
        colocation_status: Optional["InstanceViewStatus"] = None,
        **kwargs
    ):
        super(ProximityPlacementGroup, self).__init__(location=location, tags=tags, **kwargs)
        self.proximity_placement_group_type = proximity_placement_group_type
        self.virtual_machines = None
        self.virtual_machine_scale_sets = None
        self.availability_sets = None
        self.colocation_status = colocation_status


class ProximityPlacementGroupListResult(msrest.serialization.Model):
    """The List Proximity Placement Group operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of proximity placement groups.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.ProximityPlacementGroup]
    :param next_link: The URI to fetch the next page of proximity placement groups.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProximityPlacementGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProximityPlacementGroup"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProximityPlacementGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProximityPlacementGroupUpdate(UpdateResource):
    """Specifies information about the proximity placement group.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProximityPlacementGroupUpdate, self).__init__(tags=tags, **kwargs)


class ProxyResource(msrest.serialization.Model):
    """The resource model definition for an Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class PublicIPAddressSku(msrest.serialization.Model):
    """Describes the public IP Sku.

    :param name: Specify public IP sku name. Possible values include: "Basic", "Standard".
    :type name: str or ~azure.mgmt.compute.v2021_04_01.models.PublicIPAddressSkuName
    :param tier: Specify public IP sku tier. Possible values include: "Regional", "Global".
    :type tier: str or ~azure.mgmt.compute.v2021_04_01.models.PublicIPAddressSkuTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "PublicIPAddressSkuName"]] = None,
        tier: Optional[Union[str, "PublicIPAddressSkuTier"]] = None,
        **kwargs
    ):
        super(PublicIPAddressSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class PurchasePlan(msrest.serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The publisher ID.
    :type publisher: str
    :param name: Required. The plan ID.
    :type name: str
    :param product: Required. Specifies the product of the image from the marketplace. This is the
     same value as Offer under the imageReference element.
    :type product: str
    """

    _validation = {
        'publisher': {'required': True},
        'name': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: str,
        name: str,
        product: str,
        **kwargs
    ):
        super(PurchasePlan, self).__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product


class PurchasePlanAutoGenerated(msrest.serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The plan ID.
    :type name: str
    :param publisher: Required. The publisher ID.
    :type publisher: str
    :param product: Required. Specifies the product of the image from the marketplace. This is the
     same value as Offer under the imageReference element.
    :type product: str
    :param promotion_code: The Offer Promotion Code.
    :type promotion_code: str
    """

    _validation = {
        'name': {'required': True},
        'publisher': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        publisher: str,
        product: str,
        promotion_code: Optional[str] = None,
        **kwargs
    ):
        super(PurchasePlanAutoGenerated, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class RecoveryWalkResponse(msrest.serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        'walk_performed': {'readonly': True},
        'next_platform_update_domain': {'readonly': True},
    }

    _attribute_map = {
        'walk_performed': {'key': 'walkPerformed', 'type': 'bool'},
        'next_platform_update_domain': {'key': 'nextPlatformUpdateDomain', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryWalkResponse, self).__init__(**kwargs)
        self.walk_performed = None
        self.next_platform_update_domain = None


class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param group_by_client_application_id: Group query result by Client Application ID.
    :type group_by_client_application_id: bool
    :param group_by_user_agent: Group query result by User Agent.
    :type group_by_user_agent: bool
    :param interval_length: Required. Interval value in minutes used to create LogAnalytics call
     rate logs. Possible values include: "ThreeMins", "FiveMins", "ThirtyMins", "SixtyMins".
    :type interval_length: str or ~azure.mgmt.compute.v2021_04_01.models.IntervalInMins
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
        'interval_length': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'group_by_client_application_id': {'key': 'groupByClientApplicationId', 'type': 'bool'},
        'group_by_user_agent': {'key': 'groupByUserAgent', 'type': 'bool'},
        'interval_length': {'key': 'intervalLength', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        interval_length: Union[str, "IntervalInMins"],
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs
    ):
        super(RequestRateByIntervalInput, self).__init__(blob_container_sas_uri=blob_container_sas_uri, from_time=from_time, to_time=to_time, group_by_throttle_policy=group_by_throttle_policy, group_by_operation_name=group_by_operation_name, group_by_resource_name=group_by_resource_name, group_by_client_application_id=group_by_client_application_id, group_by_user_agent=group_by_user_agent, **kwargs)
        self.interval_length = interval_length


class ResourceUriList(msrest.serialization.Model):
    """The List resources which are encrypted with the disk encryption set.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of IDs or Owner IDs of resources which are encrypted with the
     disk encryption set.
    :type value: list[str]
    :param next_link: The uri to fetch the next page of encrypted resources. Call ListNext() with
     this to fetch the next page of encrypted resources.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[str]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List[str],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ResourceUriList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RestorePoint(ProxyResource):
    """Restore Point details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param exclude_disks: List of disk resource ids that the customer wishes to exclude from the
     restore point. If no disks are specified, all disks will be included.
    :type exclude_disks: list[~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference]
    :ivar source_metadata: Gets the details of the VM captured at the time of the restore point
     creation.
    :vartype source_metadata: ~azure.mgmt.compute.v2021_04_01.models.RestorePointSourceMetadata
    :ivar provisioning_state: Gets the provisioning state of the restore point.
    :vartype provisioning_state: str
    :ivar consistency_mode: Gets the consistency mode for the restore point. Please refer to
     https://aka.ms/RestorePoints for more details. Possible values include: "CrashConsistent",
     "FileSystemConsistent", "ApplicationConsistent".
    :vartype consistency_mode: str or ~azure.mgmt.compute.v2021_04_01.models.ConsistencyModeTypes
    :ivar provisioning_details: Gets the provisioning details set by the server during Create
     restore point operation.
    :vartype provisioning_details:
     ~azure.mgmt.compute.v2021_04_01.models.RestorePointProvisioningDetails
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'source_metadata': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'consistency_mode': {'readonly': True},
        'provisioning_details': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'exclude_disks': {'key': 'properties.excludeDisks', 'type': '[ApiEntityReference]'},
        'source_metadata': {'key': 'properties.sourceMetadata', 'type': 'RestorePointSourceMetadata'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'consistency_mode': {'key': 'properties.consistencyMode', 'type': 'str'},
        'provisioning_details': {'key': 'properties.provisioningDetails', 'type': 'RestorePointProvisioningDetails'},
    }

    def __init__(
        self,
        *,
        exclude_disks: Optional[List["ApiEntityReference"]] = None,
        **kwargs
    ):
        super(RestorePoint, self).__init__(**kwargs)
        self.exclude_disks = exclude_disks
        self.source_metadata = None
        self.provisioning_state = None
        self.consistency_mode = None
        self.provisioning_details = None


class RestorePointCollection(Resource):
    """Create or update Restore Point collection parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source: The properties of the source resource that this restore point collection is
     created from.
    :type source: ~azure.mgmt.compute.v2021_04_01.models.RestorePointCollectionSourceProperties
    :ivar provisioning_state: The provisioning state of the restore point collection.
    :vartype provisioning_state: str
    :ivar restore_point_collection_id: The unique id of the restore point collection.
    :vartype restore_point_collection_id: str
    :ivar restore_points: A list containing all restore points created under this restore point
     collection.
    :vartype restore_points: list[~azure.mgmt.compute.v2021_04_01.models.RestorePoint]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'restore_point_collection_id': {'readonly': True},
        'restore_points': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'RestorePointCollectionSourceProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'restore_point_collection_id': {'key': 'properties.restorePointCollectionId', 'type': 'str'},
        'restore_points': {'key': 'properties.restorePoints', 'type': '[RestorePoint]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["RestorePointCollectionSourceProperties"] = None,
        **kwargs
    ):
        super(RestorePointCollection, self).__init__(location=location, tags=tags, **kwargs)
        self.source = source
        self.provisioning_state = None
        self.restore_point_collection_id = None
        self.restore_points = None


class RestorePointCollectionListResult(msrest.serialization.Model):
    """The List restore point collection operation response.

    :param value: Gets the list of restore point collections.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.RestorePointCollection]
    :param next_link: The uri to fetch the next page of RestorePointCollections. Call ListNext()
     with this to fetch the next page of RestorePointCollections.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RestorePointCollection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RestorePointCollection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RestorePointCollectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RestorePointCollectionSourceProperties(msrest.serialization.Model):
    """The properties of the source resource that this restore point collection is created from.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the source resource used to create this restore point collection.
    :vartype location: str
    :param id: Resource Id of the source resource used to create this restore point collection.
    :type id: str
    """

    _validation = {
        'location': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(RestorePointCollectionSourceProperties, self).__init__(**kwargs)
        self.location = None
        self.id = id


class RestorePointCollectionUpdate(UpdateResource):
    """Update Restore Point collection parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source: The properties of the source resource that this restore point collection is
     created from.
    :type source: ~azure.mgmt.compute.v2021_04_01.models.RestorePointCollectionSourceProperties
    :ivar provisioning_state: The provisioning state of the restore point collection.
    :vartype provisioning_state: str
    :ivar restore_point_collection_id: The unique id of the restore point collection.
    :vartype restore_point_collection_id: str
    :ivar restore_points: A list containing all restore points created under this restore point
     collection.
    :vartype restore_points: list[~azure.mgmt.compute.v2021_04_01.models.RestorePoint]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'restore_point_collection_id': {'readonly': True},
        'restore_points': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'RestorePointCollectionSourceProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'restore_point_collection_id': {'key': 'properties.restorePointCollectionId', 'type': 'str'},
        'restore_points': {'key': 'properties.restorePoints', 'type': '[RestorePoint]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["RestorePointCollectionSourceProperties"] = None,
        **kwargs
    ):
        super(RestorePointCollectionUpdate, self).__init__(tags=tags, **kwargs)
        self.source = source
        self.provisioning_state = None
        self.restore_point_collection_id = None
        self.restore_points = None


class RestorePointProvisioningDetails(msrest.serialization.Model):
    """Restore Point Provisioning details.

    :param creation_time: Gets the creation time of the restore point.
    :type creation_time: ~datetime.datetime
    :param total_used_size_in_bytes: Gets the total size of the data in all the disks which are
     part of the restore point.
    :type total_used_size_in_bytes: long
    :param status_code: Gets the status of the Create restore point operation.
    :type status_code: int
    :param status_message: Gets the status message of the Create restore point operation.
    :type status_message: str
    """

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'total_used_size_in_bytes': {'key': 'totalUsedSizeInBytes', 'type': 'long'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        creation_time: Optional[datetime.datetime] = None,
        total_used_size_in_bytes: Optional[int] = None,
        status_code: Optional[int] = None,
        status_message: Optional[str] = None,
        **kwargs
    ):
        super(RestorePointProvisioningDetails, self).__init__(**kwargs)
        self.creation_time = creation_time
        self.total_used_size_in_bytes = total_used_size_in_bytes
        self.status_code = status_code
        self.status_message = status_message


class RestorePointSourceMetadata(msrest.serialization.Model):
    """Describes the properties of the Virtual Machine for which the restore point was created. The properties provided are a subset and the snapshot of the overall Virtual Machine properties captured at the time of the restore point creation.

    :param hardware_profile: Gets the hardware profile.
    :type hardware_profile: ~azure.mgmt.compute.v2021_04_01.models.HardwareProfile
    :param storage_profile: Gets the storage profile.
    :type storage_profile:
     ~azure.mgmt.compute.v2021_04_01.models.RestorePointSourceVMStorageProfile
    :param os_profile: Gets the OS profile.
    :type os_profile: ~azure.mgmt.compute.v2021_04_01.models.OSProfile
    :param diagnostics_profile: Gets the diagnostics profile.
    :type diagnostics_profile: ~azure.mgmt.compute.v2021_04_01.models.DiagnosticsProfile
    :param license_type: Gets the license type, which is for bring your own license scenario.
    :type license_type: str
    :param vm_id: Gets the virtual machine unique id.
    :type vm_id: str
    :param security_profile: Gets the security profile.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.SecurityProfile
    :param location: Location of the VM from which the restore point was created.
    :type location: str
    """

    _attribute_map = {
        'hardware_profile': {'key': 'hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'RestorePointSourceVMStorageProfile'},
        'os_profile': {'key': 'osProfile', 'type': 'OSProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["RestorePointSourceVMStorageProfile"] = None,
        os_profile: Optional["OSProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        license_type: Optional[str] = None,
        vm_id: Optional[str] = None,
        security_profile: Optional["SecurityProfile"] = None,
        location: Optional[str] = None,
        **kwargs
    ):
        super(RestorePointSourceMetadata, self).__init__(**kwargs)
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.diagnostics_profile = diagnostics_profile
        self.license_type = license_type
        self.vm_id = vm_id
        self.security_profile = security_profile
        self.location = location


class RestorePointSourceVMDataDisk(msrest.serialization.Model):
    """Describes a data disk.

    :param lun: Gets the logical unit number.
    :type lun: int
    :param name: Gets the disk name.
    :type name: str
    :param caching: Gets the caching type. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param disk_size_gb: Gets the initial disk size in GB for blank data disks, and the new desired
     size for existing OS and Data disks.
    :type disk_size_gb: int
    :param managed_disk: Gets the managed disk details.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.ManagedDiskParameters
    :param disk_restore_point: Gets the disk restore point Id.
    :type disk_restore_point: ~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference
    """

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
        'disk_restore_point': {'key': 'diskRestorePoint', 'type': 'ApiEntityReference'},
    }

    def __init__(
        self,
        *,
        lun: Optional[int] = None,
        name: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["ManagedDiskParameters"] = None,
        disk_restore_point: Optional["ApiEntityReference"] = None,
        **kwargs
    ):
        super(RestorePointSourceVMDataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_restore_point = disk_restore_point


class RestorePointSourceVMOSDisk(msrest.serialization.Model):
    """Describes an Operating System disk.

    :param os_type: Gets the Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemType
    :param encryption_settings: Gets the disk encryption settings.
    :type encryption_settings: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSettings
    :param name: Gets the disk name.
    :type name: str
    :param caching: Gets the caching type. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param disk_size_gb: Gets the disk size in GB.
    :type disk_size_gb: int
    :param managed_disk: Gets the managed disk details.
    :type managed_disk: ~azure.mgmt.compute.v2021_04_01.models.ManagedDiskParameters
    :param disk_restore_point: Gets the disk restore point Id.
    :type disk_restore_point: ~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference
    """

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': 'DiskEncryptionSettings'},
        'name': {'key': 'name', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
        'disk_restore_point': {'key': 'diskRestorePoint', 'type': 'ApiEntityReference'},
    }

    def __init__(
        self,
        *,
        os_type: Optional[Union[str, "OperatingSystemType"]] = None,
        encryption_settings: Optional["DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["ManagedDiskParameters"] = None,
        disk_restore_point: Optional["ApiEntityReference"] = None,
        **kwargs
    ):
        super(RestorePointSourceVMOSDisk, self).__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_restore_point = disk_restore_point


class RestorePointSourceVMStorageProfile(msrest.serialization.Model):
    """Describes the storage profile.

    :param os_disk: Gets the OS disk of the VM captured at the time of the restore point creation.
    :type os_disk: ~azure.mgmt.compute.v2021_04_01.models.RestorePointSourceVMOSDisk
    :param data_disks: Gets the data disks of the VM captured at the time of the restore point
     creation.
    :type data_disks: list[~azure.mgmt.compute.v2021_04_01.models.RestorePointSourceVMDataDisk]
    """

    _attribute_map = {
        'os_disk': {'key': 'osDisk', 'type': 'RestorePointSourceVMOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[RestorePointSourceVMDataDisk]'},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["RestorePointSourceVMOSDisk"] = None,
        data_disks: Optional[List["RestorePointSourceVMDataDisk"]] = None,
        **kwargs
    ):
        super(RestorePointSourceVMStorageProfile, self).__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks


class RetrieveBootDiagnosticsDataResult(msrest.serialization.Model):
    """The SAS URIs of the console screenshot and serial log blobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The serial console log blob URI.
    :vartype serial_console_log_blob_uri: str
    """

    _validation = {
        'console_screenshot_blob_uri': {'readonly': True},
        'serial_console_log_blob_uri': {'readonly': True},
    }

    _attribute_map = {
        'console_screenshot_blob_uri': {'key': 'consoleScreenshotBlobUri', 'type': 'str'},
        'serial_console_log_blob_uri': {'key': 'serialConsoleLogBlobUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetrieveBootDiagnosticsDataResult, self).__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None


class RollbackStatusInfo(msrest.serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'successfully_rolledback_instance_count': {'readonly': True},
        'failed_rolledback_instance_count': {'readonly': True},
        'rollback_error': {'readonly': True},
    }

    _attribute_map = {
        'successfully_rolledback_instance_count': {'key': 'successfullyRolledbackInstanceCount', 'type': 'int'},
        'failed_rolledback_instance_count': {'key': 'failedRolledbackInstanceCount', 'type': 'int'},
        'rollback_error': {'key': 'rollbackError', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollbackStatusInfo, self).__init__(**kwargs)
        self.successfully_rolledback_instance_count = None
        self.failed_rolledback_instance_count = None
        self.rollback_error = None


class RollingUpgradePolicy(msrest.serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :param max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :type max_batch_instance_percent: int
    :param max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :type max_unhealthy_instance_percent: int
    :param max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :type max_unhealthy_upgraded_instance_percent: int
    :param pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :type pause_time_between_batches: str
    :param enable_cross_zone_upgrade: Allow VMSS to ignore AZ boundaries when constructing upgrade
     batches. Take into consideration the Update Domain and maxBatchInstancePercent to determine the
     batch size.
    :type enable_cross_zone_upgrade: bool
    :param prioritize_unhealthy_instances: Upgrade all unhealthy instances in a scale set before
     any healthy instances.
    :type prioritize_unhealthy_instances: bool
    """

    _validation = {
        'max_batch_instance_percent': {'maximum': 100, 'minimum': 5},
        'max_unhealthy_instance_percent': {'maximum': 100, 'minimum': 5},
        'max_unhealthy_upgraded_instance_percent': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_batch_instance_percent': {'key': 'maxBatchInstancePercent', 'type': 'int'},
        'max_unhealthy_instance_percent': {'key': 'maxUnhealthyInstancePercent', 'type': 'int'},
        'max_unhealthy_upgraded_instance_percent': {'key': 'maxUnhealthyUpgradedInstancePercent', 'type': 'int'},
        'pause_time_between_batches': {'key': 'pauseTimeBetweenBatches', 'type': 'str'},
        'enable_cross_zone_upgrade': {'key': 'enableCrossZoneUpgrade', 'type': 'bool'},
        'prioritize_unhealthy_instances': {'key': 'prioritizeUnhealthyInstances', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        enable_cross_zone_upgrade: Optional[bool] = None,
        prioritize_unhealthy_instances: Optional[bool] = None,
        **kwargs
    ):
        super(RollingUpgradePolicy, self).__init__(**kwargs)
        self.max_batch_instance_percent = max_batch_instance_percent
        self.max_unhealthy_instance_percent = max_unhealthy_instance_percent
        self.max_unhealthy_upgraded_instance_percent = max_unhealthy_upgraded_instance_percent
        self.pause_time_between_batches = pause_time_between_batches
        self.enable_cross_zone_upgrade = enable_cross_zone_upgrade
        self.prioritize_unhealthy_instances = prioritize_unhealthy_instances


class RollingUpgradeProgressInfo(msrest.serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        'successful_instance_count': {'readonly': True},
        'failed_instance_count': {'readonly': True},
        'in_progress_instance_count': {'readonly': True},
        'pending_instance_count': {'readonly': True},
    }

    _attribute_map = {
        'successful_instance_count': {'key': 'successfulInstanceCount', 'type': 'int'},
        'failed_instance_count': {'key': 'failedInstanceCount', 'type': 'int'},
        'in_progress_instance_count': {'key': 'inProgressInstanceCount', 'type': 'int'},
        'pending_instance_count': {'key': 'pendingInstanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeProgressInfo, self).__init__(**kwargs)
        self.successful_instance_count = None
        self.failed_instance_count = None
        self.in_progress_instance_count = None
        self.pending_instance_count = None


class RollingUpgradeRunningStatus(msrest.serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Possible values include:
     "RollingForward", "Cancelled", "Completed", "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Possible values include:
     "Start", "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'start_time': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_action': {'key': 'lastAction', 'type': 'str'},
        'last_action_time': {'key': 'lastActionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeRunningStatus, self).__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.last_action = None
        self.last_action_time = None


class RollingUpgradeStatusInfo(Resource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'policy': {'readonly': True},
        'running_status': {'readonly': True},
        'progress': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'policy': {'key': 'properties.policy', 'type': 'RollingUpgradePolicy'},
        'running_status': {'key': 'properties.runningStatus', 'type': 'RollingUpgradeRunningStatus'},
        'progress': {'key': 'properties.progress', 'type': 'RollingUpgradeProgressInfo'},
        'error': {'key': 'properties.error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(RollingUpgradeStatusInfo, self).__init__(location=location, tags=tags, **kwargs)
        self.policy = None
        self.running_status = None
        self.progress = None
        self.error = None


class RunCommandDocumentBase(msrest.serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required. The VM run command schema.
    :type schema: str
    :param id: Required. The VM run command id.
    :type id: str
    :param os_type: Required. The Operating System type. Possible values include: "Windows",
     "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param label: Required. The VM run command label.
    :type label: str
    :param description: Required. The VM run command description.
    :type description: str
    """

    _validation = {
        'schema': {'required': True},
        'id': {'required': True},
        'os_type': {'required': True},
        'label': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': '$schema', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,
        os_type: Union[str, "OperatingSystemTypes"],
        label: str,
        description: str,
        **kwargs
    ):
        super(RunCommandDocumentBase, self).__init__(**kwargs)
        self.schema = schema
        self.id = id
        self.os_type = os_type
        self.label = label
        self.description = description


class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required. The VM run command schema.
    :type schema: str
    :param id: Required. The VM run command id.
    :type id: str
    :param os_type: Required. The Operating System type. Possible values include: "Windows",
     "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param label: Required. The VM run command label.
    :type label: str
    :param description: Required. The VM run command description.
    :type description: str
    :param script: Required. The script to be executed.
    :type script: list[str]
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2021_04_01.models.RunCommandParameterDefinition]
    """

    _validation = {
        'schema': {'required': True},
        'id': {'required': True},
        'os_type': {'required': True},
        'label': {'required': True},
        'description': {'required': True},
        'script': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': '$schema', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'script': {'key': 'script', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': '[RunCommandParameterDefinition]'},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,
        os_type: Union[str, "OperatingSystemTypes"],
        label: str,
        description: str,
        script: List[str],
        parameters: Optional[List["RunCommandParameterDefinition"]] = None,
        **kwargs
    ):
        super(RunCommandDocument, self).__init__(schema=schema, id=id, os_type=os_type, label=label, description=description, **kwargs)
        self.script = script
        self.parameters = parameters


class RunCommandInput(msrest.serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param command_id: Required. The run command id.
    :type command_id: str
    :param script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :type script: list[str]
    :param parameters: The run command parameters.
    :type parameters: list[~azure.mgmt.compute.v2021_04_01.models.RunCommandInputParameter]
    """

    _validation = {
        'command_id': {'required': True},
    }

    _attribute_map = {
        'command_id': {'key': 'commandId', 'type': 'str'},
        'script': {'key': 'script', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': '[RunCommandInputParameter]'},
    }

    def __init__(
        self,
        *,
        command_id: str,
        script: Optional[List[str]] = None,
        parameters: Optional[List["RunCommandInputParameter"]] = None,
        **kwargs
    ):
        super(RunCommandInput, self).__init__(**kwargs)
        self.command_id = command_id
        self.script = script
        self.parameters = parameters


class RunCommandInputParameter(msrest.serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param value: Required. The run command parameter value.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(RunCommandInputParameter, self).__init__(**kwargs)
        self.name = name
        self.value = value


class RunCommandListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine run commands.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.RunCommandDocumentBase]
    :param next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RunCommandDocumentBase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["RunCommandDocumentBase"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RunCommandListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunCommandParameterDefinition(msrest.serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param type: Required. The run command parameter type.
    :type type: str
    :param default_value: The run command parameter default value.
    :type default_value: str
    :param required: The run command parameter required.
    :type required: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: str,
        default_value: Optional[str] = None,
        required: Optional[bool] = False,
        **kwargs
    ):
        super(RunCommandParameterDefinition, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.default_value = default_value
        self.required = required


class RunCommandResult(msrest.serialization.Model):
    """RunCommandResult.

    :param value: Run command operation response.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(RunCommandResult, self).__init__(**kwargs)
        self.value = value


class ScaleInPolicy(msrest.serialization.Model):
    """Describes a scale-in policy for a virtual machine scale set.

    :param rules: The rules to be followed when scaling-in a virtual machine scale set.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Default** When a
     virtual machine scale set is scaled in, the scale set will first be balanced across zones if it
     is a zonal scale set. Then, it will be balanced across Fault Domains as far as possible. Within
     each Fault Domain, the virtual machines chosen for removal will be the newest ones that are not
     protected from scale-in. :code:`<br>`:code:`<br>` **OldestVM** When a virtual machine scale set
     is being scaled-in, the oldest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the oldest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>` **NewestVM** When a virtual machine scale set is
     being scaled-in, the newest virtual machines that are not protected from scale-in will be
     chosen for removal. For zonal virtual machine scale sets, the scale set will first be balanced
     across zones. Within each zone, the newest virtual machines that are not protected will be
     chosen for removal. :code:`<br>`:code:`<br>`.
    :type rules: list[str or
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetScaleInRules]
    """

    _attribute_map = {
        'rules': {'key': 'rules', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        rules: Optional[List[Union[str, "VirtualMachineScaleSetScaleInRules"]]] = None,
        **kwargs
    ):
        super(ScaleInPolicy, self).__init__(**kwargs)
        self.rules = rules


class ScheduledEventsProfile(msrest.serialization.Model):
    """ScheduledEventsProfile.

    :param terminate_notification_profile: Specifies Terminate Scheduled Event related
     configurations.
    :type terminate_notification_profile:
     ~azure.mgmt.compute.v2021_04_01.models.TerminateNotificationProfile
    """

    _attribute_map = {
        'terminate_notification_profile': {'key': 'terminateNotificationProfile', 'type': 'TerminateNotificationProfile'},
    }

    def __init__(
        self,
        *,
        terminate_notification_profile: Optional["TerminateNotificationProfile"] = None,
        **kwargs
    ):
        super(ScheduledEventsProfile, self).__init__(**kwargs)
        self.terminate_notification_profile = terminate_notification_profile


class SecurityProfile(msrest.serialization.Model):
    """Specifies the Security profile settings for the virtual machine or virtual machine scale set.

    :param uefi_settings: Specifies the security settings like secure boot and vTPM used while
     creating the virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :type uefi_settings: ~azure.mgmt.compute.v2021_04_01.models.UefiSettings
    :param encryption_at_host: This property can be used by user in the request to enable or
     disable the Host Encryption for the virtual machine or virtual machine scale set. This will
     enable the encryption for all the disks including Resource/Temp disk at host itself.
     :code:`<br>`:code:`<br>` Default: The Encryption at host will be disabled unless this property
     is set to true for the resource.
    :type encryption_at_host: bool
    :param security_type: Specifies the SecurityType of the virtual machine. It is set as
     TrustedLaunch to enable UefiSettings. :code:`<br>`:code:`<br>` Default: UefiSettings will not
     be enabled unless this property is set as TrustedLaunch. Possible values include:
     "TrustedLaunch".
    :type security_type: str or ~azure.mgmt.compute.v2021_04_01.models.SecurityTypes
    """

    _attribute_map = {
        'uefi_settings': {'key': 'uefiSettings', 'type': 'UefiSettings'},
        'encryption_at_host': {'key': 'encryptionAtHost', 'type': 'bool'},
        'security_type': {'key': 'securityType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uefi_settings: Optional["UefiSettings"] = None,
        encryption_at_host: Optional[bool] = None,
        security_type: Optional[Union[str, "SecurityTypes"]] = None,
        **kwargs
    ):
        super(SecurityProfile, self).__init__(**kwargs)
        self.uefi_settings = uefi_settings
        self.encryption_at_host = encryption_at_host
        self.security_type = security_type


class ShareInfoElement(msrest.serialization.Model):
    """ShareInfoElement.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vm_uri: A relative URI containing the ID of the VM that has the disk attached.
    :vartype vm_uri: str
    """

    _validation = {
        'vm_uri': {'readonly': True},
    }

    _attribute_map = {
        'vm_uri': {'key': 'vmUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShareInfoElement, self).__init__(**kwargs)
        self.vm_uri = None


class Sku(msrest.serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.

    :param name: The sku name.
    :type name: str
    :param tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :type tier: str
    :param capacity: Specifies the number of virtual machines in the scale set.
    :type capacity: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class Snapshot(Resource):
    """Snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar managed_by: Unused. Always Null.
    :vartype managed_by: str
    :param sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is
     an optional parameter for incremental snapshot and the default behavior is the SKU will be set
     to the same sku as the previous snapshot.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.SnapshotSku
    :param extended_location: The extended location where the snapshot will be created. Extended
     location cannot be changed.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :ivar time_created: The time when the snapshot was created.
    :vartype time_created: ~datetime.datetime
    :param os_type: The Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param hyper_v_generation: The hypervisor generation of the Virtual Machine. Applicable to OS
     disks only. Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGeneration
    :param purchase_plan: Purchase plan information for the image from which the source disk for
     the snapshot was originally created.
    :type purchase_plan: ~azure.mgmt.compute.v2021_04_01.models.PurchasePlanAutoGenerated
    :param supported_capabilities: List of supported capabilities (like Accelerated Networking) for
     the image from which the source disk from the snapshot was originally created.
    :type supported_capabilities: ~azure.mgmt.compute.v2021_04_01.models.SupportedCapabilities
    :param creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :type creation_data: ~azure.mgmt.compute.v2021_04_01.models.CreationData
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :ivar disk_size_bytes: The size of the disk in bytes. This field is read only.
    :vartype disk_size_bytes: long
    :ivar disk_state: The state of the snapshot. Possible values include: "Unattached", "Attached",
     "Reserved", "Frozen", "ActiveSAS", "ActiveSASFrozen", "ReadyToUpload", "ActiveUpload".
    :vartype disk_state: str or ~azure.mgmt.compute.v2021_04_01.models.DiskState
    :ivar unique_id: Unique Guid identifying the resource.
    :vartype unique_id: str
    :param encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2021_04_01.models.EncryptionSettingsCollection
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    :param incremental: Whether a snapshot is incremental. Incremental snapshots on the same disk
     occupy less space than full snapshots and can be diffed.
    :type incremental: bool
    :param encryption: Encryption property can be used to encrypt data at rest with customer
     managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2021_04_01.models.Encryption
    :param network_access_policy: Policy for accessing the disk via network. Possible values
     include: "AllowAll", "AllowPrivate", "DenyAll".
    :type network_access_policy: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkAccessPolicy
    :param disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :type disk_access_id: str
    :param supports_hibernation: Indicates the OS on a snapshot supports hibernation.
    :type supports_hibernation: bool
    :param public_network_access: Policy for controlling export on the disk. Possible values
     include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.compute.v2021_04_01.models.PublicNetworkAccess
    :param completion_percent: Percentage complete for the background copy when a resource is
     created via the CopyStart operation.
    :type completion_percent: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_by': {'readonly': True},
        'time_created': {'readonly': True},
        'disk_size_bytes': {'readonly': True},
        'disk_state': {'readonly': True},
        'unique_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SnapshotSku'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'purchase_plan': {'key': 'properties.purchasePlan', 'type': 'PurchasePlanAutoGenerated'},
        'supported_capabilities': {'key': 'properties.supportedCapabilities', 'type': 'SupportedCapabilities'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'disk_size_bytes': {'key': 'properties.diskSizeBytes', 'type': 'long'},
        'disk_state': {'key': 'properties.diskState', 'type': 'str'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'incremental': {'key': 'properties.incremental', 'type': 'bool'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_access_policy': {'key': 'properties.networkAccessPolicy', 'type': 'str'},
        'disk_access_id': {'key': 'properties.diskAccessId', 'type': 'str'},
        'supports_hibernation': {'key': 'properties.supportsHibernation', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'completion_percent': {'key': 'properties.completionPercent', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SnapshotSku"] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGeneration"]] = None,
        purchase_plan: Optional["PurchasePlanAutoGenerated"] = None,
        supported_capabilities: Optional["SupportedCapabilities"] = None,
        creation_data: Optional["CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["EncryptionSettingsCollection"] = None,
        incremental: Optional[bool] = None,
        encryption: Optional["Encryption"] = None,
        network_access_policy: Optional[Union[str, "NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        completion_percent: Optional[float] = None,
        **kwargs
    ):
        super(Snapshot, self).__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.sku = sku
        self.extended_location = extended_location
        self.time_created = None
        self.os_type = os_type
        self.hyper_v_generation = hyper_v_generation
        self.purchase_plan = purchase_plan
        self.supported_capabilities = supported_capabilities
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.disk_size_bytes = None
        self.disk_state = None
        self.unique_id = None
        self.encryption_settings_collection = encryption_settings_collection
        self.provisioning_state = None
        self.incremental = incremental
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access
        self.completion_percent = completion_percent


class SnapshotList(msrest.serialization.Model):
    """The List Snapshots operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of snapshots.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.Snapshot]
    :param next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
     fetch the next page of snapshots.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Snapshot"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SnapshotList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SnapshotSku(msrest.serialization.Model):
    """The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The sku name. Possible values include: "Standard_LRS", "Premium_LRS",
     "Standard_ZRS".
    :type name: str or ~azure.mgmt.compute.v2021_04_01.models.SnapshotStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SnapshotStorageAccountTypes"]] = None,
        **kwargs
    ):
        super(SnapshotSku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class SnapshotUpdate(msrest.serialization.Model):
    """Snapshot update resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is
     an optional parameter for incremental snapshot and the default behavior is the SKU will be set
     to the same sku as the previous snapshot.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.SnapshotSku
    :param os_type: the Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the disk to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings_collection: Encryption settings collection used be Azure Disk
     Encryption, can contain multiple encryption settings per disk or snapshot.
    :type encryption_settings_collection:
     ~azure.mgmt.compute.v2021_04_01.models.EncryptionSettingsCollection
    :param encryption: Encryption property can be used to encrypt data at rest with customer
     managed keys or platform managed keys.
    :type encryption: ~azure.mgmt.compute.v2021_04_01.models.Encryption
    :param network_access_policy: Policy for accessing the disk via network. Possible values
     include: "AllowAll", "AllowPrivate", "DenyAll".
    :type network_access_policy: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkAccessPolicy
    :param disk_access_id: ARM id of the DiskAccess resource for using private endpoints on disks.
    :type disk_access_id: str
    :param supports_hibernation: Indicates the OS on a snapshot supports hibernation.
    :type supports_hibernation: bool
    :param public_network_access: Policy for controlling export on the disk. Possible values
     include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.compute.v2021_04_01.models.PublicNetworkAccess
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SnapshotSku'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings_collection': {'key': 'properties.encryptionSettingsCollection', 'type': 'EncryptionSettingsCollection'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'network_access_policy': {'key': 'properties.networkAccessPolicy', 'type': 'str'},
        'disk_access_id': {'key': 'properties.diskAccessId', 'type': 'str'},
        'supports_hibernation': {'key': 'properties.supportsHibernation', 'type': 'bool'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SnapshotSku"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings_collection: Optional["EncryptionSettingsCollection"] = None,
        encryption: Optional["Encryption"] = None,
        network_access_policy: Optional[Union[str, "NetworkAccessPolicy"]] = None,
        disk_access_id: Optional[str] = None,
        supports_hibernation: Optional[bool] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(SnapshotUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings_collection = encryption_settings_collection
        self.encryption = encryption
        self.network_access_policy = network_access_policy
        self.disk_access_id = disk_access_id
        self.supports_hibernation = supports_hibernation
        self.public_network_access = public_network_access


class SourceVault(msrest.serialization.Model):
    """The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SourceVault, self).__init__(**kwargs)
        self.id = id


class SpotRestorePolicy(msrest.serialization.Model):
    """Specifies the Spot-Try-Restore properties for the virtual machine scale set. :code:`<br>`:code:`<br>` With this property customer can enable or disable automatic restore of the evicted Spot VMSS VM instances opportunistically based on capacity availability and pricing constraint.

    :param enabled: Enables the Spot-Try-Restore feature where evicted VMSS SPOT instances will be
     tried to be restored opportunistically based on capacity availability and pricing constraints.
    :type enabled: bool
    :param restore_timeout: Timeout value expressed as an ISO 8601 time duration after which the
     platform will not try to restore the VMSS SPOT instances.
    :type restore_timeout: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'restore_timeout': {'key': 'restoreTimeout', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        restore_timeout: Optional[str] = None,
        **kwargs
    ):
        super(SpotRestorePolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.restore_timeout = restore_timeout


class SshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :param public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :type public_keys: list[~azure.mgmt.compute.v2021_04_01.models.SshPublicKey]
    """

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[SshPublicKey]'},
    }

    def __init__(
        self,
        *,
        public_keys: Optional[List["SshPublicKey"]] = None,
        **kwargs
    ):
        super(SshConfiguration, self).__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.

    :param path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :type path: str
    :param key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in
     Azure]https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
    :type key_data: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        key_data: Optional[str] = None,
        **kwargs
    ):
        super(SshPublicKey, self).__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class SshPublicKeyGenerateKeyPairResult(msrest.serialization.Model):
    """Response from generation of an SSH key pair.

    All required parameters must be populated in order to send to Azure.

    :param private_key: Required. Private key portion of the key pair used to authenticate to a
     virtual machine through ssh. The private key is returned in RFC3447 format and should be
     treated as a secret.
    :type private_key: str
    :param public_key: Required. Public key portion of the key pair used to authenticate to a
     virtual machine through ssh. The public key is in ssh-rsa format.
    :type public_key: str
    :param id: Required. The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{SshPublicKeyName}.
    :type id: str
    """

    _validation = {
        'private_key': {'required': True},
        'public_key': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'public_key': {'key': 'publicKey', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_key: str,
        public_key: str,
        id: str,
        **kwargs
    ):
        super(SshPublicKeyGenerateKeyPairResult, self).__init__(**kwargs)
        self.private_key = private_key
        self.public_key = public_key
        self.id = id


class SshPublicKeyResource(Resource):
    """Specifies information about the SSH public key.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param public_key: SSH public key used to authenticate to a virtual machine through ssh. If
     this property is not initially provided when the resource is created, the publicKey property
     will be populated when generateKeyPair is called. If the public key is provided upon resource
     creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :type public_key: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        public_key: Optional[str] = None,
        **kwargs
    ):
        super(SshPublicKeyResource, self).__init__(location=location, tags=tags, **kwargs)
        self.public_key = public_key


class SshPublicKeysGroupListResult(msrest.serialization.Model):
    """The list SSH public keys operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of SSH public keys.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.SshPublicKeyResource]
    :param next_link: The URI to fetch the next page of SSH public keys. Call ListNext() with this
     URI to fetch the next page of SSH public keys.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SshPublicKeyResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["SshPublicKeyResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SshPublicKeysGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SshPublicKeyUpdateResource(UpdateResource):
    """Specifies information about the SSH public key.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param public_key: SSH public key used to authenticate to a virtual machine through ssh. If
     this property is not initially provided when the resource is created, the publicKey property
     will be populated when generateKeyPair is called. If the public key is provided upon resource
     creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
    :type public_key: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        public_key: Optional[str] = None,
        **kwargs
    ):
        super(SshPublicKeyUpdateResource, self).__init__(tags=tags, **kwargs)
        self.public_key = public_key


class StorageProfile(msrest.serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :param image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :type image_reference: ~azure.mgmt.compute.v2021_04_01.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :type os_disk: ~azure.mgmt.compute.v2021_04_01.models.OSDisk
    :param data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :type data_disks: list[~azure.mgmt.compute.v2021_04_01.models.DataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["ImageReference"] = None,
        os_disk: Optional["OSDisk"] = None,
        data_disks: Optional[List["DataDisk"]] = None,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class SubResourceReadOnly(msrest.serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResourceReadOnly, self).__init__(**kwargs)
        self.id = None


class SubResourceWithColocationStatus(SubResource):
    """SubResourceWithColocationStatus.

    :param id: Resource Id.
    :type id: str
    :param colocation_status: Describes colocation status of a resource in the Proximity Placement
     Group.
    :type colocation_status: ~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'colocation_status': {'key': 'colocationStatus', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        colocation_status: Optional["InstanceViewStatus"] = None,
        **kwargs
    ):
        super(SubResourceWithColocationStatus, self).__init__(id=id, **kwargs)
        self.colocation_status = colocation_status


class SupportedCapabilities(msrest.serialization.Model):
    """List of supported capabilities (like accelerated networking) persisted on the disk resource for VM use.

    :param accelerated_network: True if the image from which the OS disk is created supports
     accelerated networking.
    :type accelerated_network: bool
    """

    _attribute_map = {
        'accelerated_network': {'key': 'acceleratedNetwork', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        accelerated_network: Optional[bool] = None,
        **kwargs
    ):
        super(SupportedCapabilities, self).__init__(**kwargs)
        self.accelerated_network = accelerated_network


class TerminateNotificationProfile(msrest.serialization.Model):
    """TerminateNotificationProfile.

    :param not_before_timeout: Configurable length of time a Virtual Machine being deleted will
     have to potentially approve the Terminate Scheduled Event before the event is auto approved
     (timed out). The configuration must be specified in ISO 8601 format, the default value is 5
     minutes (PT5M).
    :type not_before_timeout: str
    :param enable: Specifies whether the Terminate Scheduled event is enabled or disabled.
    :type enable: bool
    """

    _attribute_map = {
        'not_before_timeout': {'key': 'notBeforeTimeout', 'type': 'str'},
        'enable': {'key': 'enable', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        not_before_timeout: Optional[str] = None,
        enable: Optional[bool] = None,
        **kwargs
    ):
        super(TerminateNotificationProfile, self).__init__(**kwargs)
        self.not_before_timeout = not_before_timeout
        self.enable = enable


class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param group_by_client_application_id: Group query result by Client Application ID.
    :type group_by_client_application_id: bool
    :param group_by_user_agent: Group query result by User Agent.
    :type group_by_user_agent: bool
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'group_by_client_application_id': {'key': 'groupByClientApplicationId', 'type': 'bool'},
        'group_by_user_agent': {'key': 'groupByUserAgent', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        group_by_client_application_id: Optional[bool] = None,
        group_by_user_agent: Optional[bool] = None,
        **kwargs
    ):
        super(ThrottledRequestsInput, self).__init__(blob_container_sas_uri=blob_container_sas_uri, from_time=from_time, to_time=to_time, group_by_throttle_policy=group_by_throttle_policy, group_by_operation_name=group_by_operation_name, group_by_resource_name=group_by_resource_name, group_by_client_application_id=group_by_client_application_id, group_by_user_agent=group_by_user_agent, **kwargs)


class UefiSettings(msrest.serialization.Model):
    """Specifies the security settings like secure boot and vTPM used while creating the virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.

    :param secure_boot_enabled: Specifies whether secure boot should be enabled on the virtual
     machine. :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :type secure_boot_enabled: bool
    :param v_tpm_enabled: Specifies whether vTPM should be enabled on the virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2020-12-01.
    :type v_tpm_enabled: bool
    """

    _attribute_map = {
        'secure_boot_enabled': {'key': 'secureBootEnabled', 'type': 'bool'},
        'v_tpm_enabled': {'key': 'vTpmEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        secure_boot_enabled: Optional[bool] = None,
        v_tpm_enabled: Optional[bool] = None,
        **kwargs
    ):
        super(UefiSettings, self).__init__(**kwargs)
        self.secure_boot_enabled = secure_boot_enabled
        self.v_tpm_enabled = v_tpm_enabled


class UpgradeOperationHistoricalStatusInfo(msrest.serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties:
     ~azure.mgmt.compute.v2021_04_01.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        'properties': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpgradeOperationHistoricalStatusInfoProperties'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoricalStatusInfo, self).__init__(**kwargs)
        self.properties = None
        self.type = None
        self.location = None


class UpgradeOperationHistoricalStatusInfoProperties(msrest.serialization.Model):
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.v2021_04_01.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Possible values include: "Unknown", "User",
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.v2021_04_01.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.v2021_04_01.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.v2021_04_01.models.RollbackStatusInfo
    """

    _validation = {
        'running_status': {'readonly': True},
        'progress': {'readonly': True},
        'error': {'readonly': True},
        'started_by': {'readonly': True},
        'target_image_reference': {'readonly': True},
        'rollback_info': {'readonly': True},
    }

    _attribute_map = {
        'running_status': {'key': 'runningStatus', 'type': 'UpgradeOperationHistoryStatus'},
        'progress': {'key': 'progress', 'type': 'RollingUpgradeProgressInfo'},
        'error': {'key': 'error', 'type': 'ApiError'},
        'started_by': {'key': 'startedBy', 'type': 'str'},
        'target_image_reference': {'key': 'targetImageReference', 'type': 'ImageReference'},
        'rollback_info': {'key': 'rollbackInfo', 'type': 'RollbackStatusInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoricalStatusInfoProperties, self).__init__(**kwargs)
        self.running_status = None
        self.progress = None
        self.error = None
        self.started_by = None
        self.target_image_reference = None
        self.rollback_info = None


class UpgradeOperationHistoryStatus(msrest.serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Possible values include:
     "RollingForward", "Cancelled", "Completed", "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2021_04_01.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoryStatus, self).__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.end_time = None


class UpgradePolicy(msrest.serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :param mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Possible values include: "Automatic",
     "Manual", "Rolling".
    :type mode: str or ~azure.mgmt.compute.v2021_04_01.models.UpgradeMode
    :param rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :type rolling_upgrade_policy: ~azure.mgmt.compute.v2021_04_01.models.RollingUpgradePolicy
    :param automatic_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :type automatic_os_upgrade_policy:
     ~azure.mgmt.compute.v2021_04_01.models.AutomaticOSUpgradePolicy
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'rolling_upgrade_policy': {'key': 'rollingUpgradePolicy', 'type': 'RollingUpgradePolicy'},
        'automatic_os_upgrade_policy': {'key': 'automaticOSUpgradePolicy', 'type': 'AutomaticOSUpgradePolicy'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "UpgradeMode"]] = None,
        rolling_upgrade_policy: Optional["RollingUpgradePolicy"] = None,
        automatic_os_upgrade_policy: Optional["AutomaticOSUpgradePolicy"] = None,
        **kwargs
    ):
        super(UpgradePolicy, self).__init__(**kwargs)
        self.mode = mode
        self.rolling_upgrade_policy = rolling_upgrade_policy
        self.automatic_os_upgrade_policy = automatic_os_upgrade_policy


class Usage(msrest.serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: An enum describing the unit of usage measurement. Has constant value: "Count".
    :vartype unit: str
    :param current_value: Required. The current usage of the resource.
    :type current_value: int
    :param limit: Required. The maximum permitted usage of the resource.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.compute.v2021_04_01.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(
        self,
        *,
        current_value: int,
        limit: int,
        name: "UsageName",
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(msrest.serialization.Model):
    """The Usage Names.

    :param value: The name of the resource.
    :type value: str
    :param localized_value: The localized name of the resource.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UserAssignedIdentitiesValue(msrest.serialization.Model):
    """UserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VaultCertificate(msrest.serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.

    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
     virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
     `Azure Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :type certificate_url: str
    :param certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
     for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
     these files are .pem formatted.
    :type certificate_store: str
    """

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'certificate_store': {'key': 'certificateStore', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_url: Optional[str] = None,
        certificate_store: Optional[str] = None,
        **kwargs
    ):
        super(VaultCertificate, self).__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(msrest.serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :param source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :type source_vault: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :type vault_certificates: list[~azure.mgmt.compute.v2021_04_01.models.VaultCertificate]
    """

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[VaultCertificate]'},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["SubResource"] = None,
        vault_certificates: Optional[List["VaultCertificate"]] = None,
        **kwargs
    ):
        super(VaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VirtualHardDisk(msrest.serialization.Model):
    """Describes the uri of a disk.

    :param uri: Specifies the virtual hard disk's uri.
    :type uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(VirtualHardDisk, self).__init__(**kwargs)
        self.uri = uri


class VirtualMachine(Resource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2021_04_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtension]
    :param identity: The identity of the virtual machine, if configured.
    :type identity: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineIdentity
    :param zones: The virtual machine zones.
    :type zones: list[str]
    :param extended_location: The extended location of the Virtual Machine.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2021_04_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2021_04_01.models.StorageProfile
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :type additional_capabilities: ~azure.mgmt.compute.v2021_04_01.models.AdditionalCapabilities
    :param os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :type os_profile: ~azure.mgmt.compute.v2021_04_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2021_04_01.models.NetworkProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.SecurityProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2021_04_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :type availability_set: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param virtual_machine_scale_set: Specifies information about the virtual machine scale set
     that the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :type virtual_machine_scale_set: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param priority: Specifies the priority for the virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Possible values include: "Regular",
     "Low", "Spot".
    :type priority: str or ~azure.mgmt.compute.v2021_04_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Possible values include: "Deallocate",
     "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineEvictionPolicyTypes
    :param billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2021_04_01.models.BillingProfile
    :param host: Specifies information about the dedicated host that the virtual machine resides
     in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :type host: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param host_group: Specifies information about the dedicated host group that the virtual
     machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :type host_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :param extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :type extensions_time_budget: str
    :param platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault
     domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
     property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
     referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
     updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
     in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
    :type platform_fault_domain: int
    :param scheduled_events_profile: Specifies Scheduled Event related configurations.
    :type scheduled_events_profile: ~azure.mgmt.compute.v2021_04_01.models.ScheduledEventsProfile
    :param user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :type user_data: str
    :param capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :type capacity_reservation: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'resources': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'virtual_machine_scale_set': {'key': 'properties.virtualMachineScaleSet', 'type': 'SubResource'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'priority': {'key': 'properties.priority', 'type': 'str'},
        'eviction_policy': {'key': 'properties.evictionPolicy', 'type': 'str'},
        'billing_profile': {'key': 'properties.billingProfile', 'type': 'BillingProfile'},
        'host': {'key': 'properties.host', 'type': 'SubResource'},
        'host_group': {'key': 'properties.hostGroup', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'extensions_time_budget': {'key': 'properties.extensionsTimeBudget', 'type': 'str'},
        'platform_fault_domain': {'key': 'properties.platformFaultDomain', 'type': 'int'},
        'scheduled_events_profile': {'key': 'properties.scheduledEventsProfile', 'type': 'ScheduledEventsProfile'},
        'user_data': {'key': 'properties.userData', 'type': 'str'},
        'capacity_reservation': {'key': 'properties.capacityReservation', 'type': 'CapacityReservationProfile'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["StorageProfile"] = None,
        additional_capabilities: Optional["AdditionalCapabilities"] = None,
        os_profile: Optional["OSProfile"] = None,
        network_profile: Optional["NetworkProfile"] = None,
        security_profile: Optional["SecurityProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        availability_set: Optional["SubResource"] = None,
        virtual_machine_scale_set: Optional["SubResource"] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        priority: Optional[Union[str, "VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["BillingProfile"] = None,
        host: Optional["SubResource"] = None,
        host_group: Optional["SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["CapacityReservationProfile"] = None,
        **kwargs
    ):
        super(VirtualMachine, self).__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.resources = None
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.virtual_machine_scale_set = virtual_machine_scale_set
        self.proximity_placement_group = proximity_placement_group
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.host = host
        self.host_group = host_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None
        self.extensions_time_budget = extensions_time_budget
        self.platform_fault_domain = platform_fault_domain
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation


class VirtualMachineAgentInstanceView(msrest.serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :param vm_agent_version: The VM Agent full version.
    :type vm_agent_version: str
    :param extension_handlers: The virtual machine extension handler instance view.
    :type extension_handlers:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtensionHandlerInstanceView]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'vm_agent_version': {'key': 'vmAgentVersion', 'type': 'str'},
        'extension_handlers': {'key': 'extensionHandlers', 'type': '[VirtualMachineExtensionHandlerInstanceView]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        vm_agent_version: Optional[str] = None,
        extension_handlers: Optional[List["VirtualMachineExtensionHandlerInstanceView"]] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineAgentInstanceView, self).__init__(**kwargs)
        self.vm_agent_version = vm_agent_version
        self.extension_handlers = extension_handlers
        self.statuses = statuses


class VirtualMachineAssessPatchesResult(msrest.serialization.Model):
    """Describes the properties of an AssessPatches result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Unknown", "Failed", "Succeeded",
     or "CompletedWithWarnings.". Possible values include: "Unknown", "InProgress", "Failed",
     "Succeeded", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_04_01.models.PatchOperationStatus
    :ivar assessment_activity_id: The activity ID of the operation that produced this result. It is
     used to correlate across CRP and extension logs.
    :vartype assessment_activity_id: str
    :ivar reboot_pending: The overall reboot status of the VM. It will be true when partially
     installed patches require a reboot to complete installation but the reboot has not yet
     occurred.
    :vartype reboot_pending: bool
    :ivar critical_and_security_patch_count: The number of critical or security patches that have
     been detected as available and not yet installed.
    :vartype critical_and_security_patch_count: int
    :ivar other_patch_count: The number of all available patches excluding critical and security.
    :vartype other_patch_count: int
    :ivar start_date_time: The UTC timestamp when the operation began.
    :vartype start_date_time: ~datetime.datetime
    :ivar available_patches: The list of patches that have been detected as available for
     installation.
    :vartype available_patches:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineSoftwarePatchProperties]
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'assessment_activity_id': {'readonly': True},
        'reboot_pending': {'readonly': True},
        'critical_and_security_patch_count': {'readonly': True},
        'other_patch_count': {'readonly': True},
        'start_date_time': {'readonly': True},
        'available_patches': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'assessment_activity_id': {'key': 'assessmentActivityId', 'type': 'str'},
        'reboot_pending': {'key': 'rebootPending', 'type': 'bool'},
        'critical_and_security_patch_count': {'key': 'criticalAndSecurityPatchCount', 'type': 'int'},
        'other_patch_count': {'key': 'otherPatchCount', 'type': 'int'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'available_patches': {'key': 'availablePatches', 'type': '[VirtualMachineSoftwarePatchProperties]'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineAssessPatchesResult, self).__init__(**kwargs)
        self.status = None
        self.assessment_activity_id = None
        self.reboot_pending = None
        self.critical_and_security_patch_count = None
        self.other_patch_count = None
        self.start_date_time = None
        self.available_patches = None
        self.error = None


class VirtualMachineCaptureParameters(msrest.serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param vhd_prefix: Required. The captured virtual hard disk's name prefix.
    :type vhd_prefix: str
    :param destination_container_name: Required. The destination container name.
    :type destination_container_name: str
    :param overwrite_vhds: Required. Specifies whether to overwrite the destination virtual hard
     disk, in case of conflict.
    :type overwrite_vhds: bool
    """

    _validation = {
        'vhd_prefix': {'required': True},
        'destination_container_name': {'required': True},
        'overwrite_vhds': {'required': True},
    }

    _attribute_map = {
        'vhd_prefix': {'key': 'vhdPrefix', 'type': 'str'},
        'destination_container_name': {'key': 'destinationContainerName', 'type': 'str'},
        'overwrite_vhds': {'key': 'overwriteVhds', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        vhd_prefix: str,
        destination_container_name: str,
        overwrite_vhds: bool,
        **kwargs
    ):
        super(VirtualMachineCaptureParameters, self).__init__(**kwargs)
        self.vhd_prefix = vhd_prefix
        self.destination_container_name = destination_container_name
        self.overwrite_vhds = overwrite_vhds


class VirtualMachineCaptureResult(SubResource):
    """Output of virtual machine capture operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Id.
    :type id: str
    :ivar schema: the schema of the captured virtual machine.
    :vartype schema: str
    :ivar content_version: the version of the content.
    :vartype content_version: str
    :ivar parameters: parameters of the captured virtual machine.
    :vartype parameters: any
    :ivar resources: a list of resource items of the captured virtual machine.
    :vartype resources: list[any]
    """

    _validation = {
        'schema': {'readonly': True},
        'content_version': {'readonly': True},
        'parameters': {'readonly': True},
        'resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'schema': {'key': '$schema', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineCaptureResult, self).__init__(id=id, **kwargs)
        self.schema = None
        self.content_version = None
        self.parameters = None
        self.resources = None


class VirtualMachineExtension(Resource):
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The virtual machine extension instance view.
    :type instance_view: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineExtensionInstanceView'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        instance_view: Optional["VirtualMachineExtensionInstanceView"] = None,
        **kwargs
    ):
        super(VirtualMachineExtension, self).__init__(location=location, tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class VirtualMachineExtensionHandlerInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine extension handler.

    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param status: The extension handler status.
    :type status: ~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["InstanceViewStatus"] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionHandlerInstanceView, self).__init__(**kwargs)
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param operating_system: The operating system this extension supports.
    :type operating_system: str
    :param compute_role: The type of role (IaaS or PaaS) this extension supports.
    :type compute_role: str
    :param handler_schema: The schema defined by publisher, where extension consumers should
     provide settings in a matching schema.
    :type handler_schema: str
    :param vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :type vm_scale_set_enabled: bool
    :param supports_multiple_extensions: Whether the handler can support multiple extensions.
    :type supports_multiple_extensions: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'operating_system': {'key': 'properties.operatingSystem', 'type': 'str'},
        'compute_role': {'key': 'properties.computeRole', 'type': 'str'},
        'handler_schema': {'key': 'properties.handlerSchema', 'type': 'str'},
        'vm_scale_set_enabled': {'key': 'properties.vmScaleSetEnabled', 'type': 'bool'},
        'supports_multiple_extensions': {'key': 'properties.supportsMultipleExtensions', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        operating_system: Optional[str] = None,
        compute_role: Optional[str] = None,
        handler_schema: Optional[str] = None,
        vm_scale_set_enabled: Optional[bool] = None,
        supports_multiple_extensions: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionImage, self).__init__(location=location, tags=tags, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions


class VirtualMachineExtensionInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine extension.

    :param name: The virtual machine extension name.
    :type name: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param substatuses: The resource status information.
    :type substatuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'substatuses': {'key': 'substatuses', 'type': '[InstanceViewStatus]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        substatuses: Optional[List["InstanceViewStatus"]] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.substatuses = substatuses
        self.statuses = statuses


class VirtualMachineExtensionsListResult(msrest.serialization.Model):
    """The List Extension operation response.

    :param value: The list of extensions.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtension]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineExtension]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualMachineExtension"]] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionsListResult, self).__init__(**kwargs)
        self.value = value


class VirtualMachineExtensionUpdate(UpdateResource):
    """Describes a Virtual Machine Extension.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionUpdate, self).__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings


class VirtualMachineHealthStatus(msrest.serialization.Model):
    """The health status of the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The health status information for the VM.
    :vartype status: ~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineHealthStatus, self).__init__(**kwargs)
        self.status = None


class VirtualMachineIdentity(msrest.serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the virtual machine. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Possible
     values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.compute.v2021_04_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the Virtual
     Machine. The user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.compute.v2021_04_01.models.UserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{UserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "UserAssignedIdentitiesValue"]] = None,
        **kwargs
    ):
        super(VirtualMachineIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: A set of tags. Specifies the tags that are assigned to the virtual machine. For
     more information about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :type tags: dict[str, str]
    :param extended_location: The extended location of the Virtual Machine.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        **kwargs
    ):
        super(VirtualMachineImageResource, self).__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.tags = tags
        self.extended_location = extended_location


class VirtualMachineImage(VirtualMachineImageResource):
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: A set of tags. Specifies the tags that are assigned to the virtual machine. For
     more information about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :type tags: dict[str, str]
    :param extended_location: The extended location of the Virtual Machine.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :param plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :type plan: ~azure.mgmt.compute.v2021_04_01.models.PurchasePlan
    :param os_disk_image: Contains the os disk image information.
    :type os_disk_image: ~azure.mgmt.compute.v2021_04_01.models.OSDiskImage
    :param data_disk_images:
    :type data_disk_images: list[~azure.mgmt.compute.v2021_04_01.models.DataDiskImage]
    :param automatic_os_upgrade_properties: Describes automatic OS upgrade properties on the image.
    :type automatic_os_upgrade_properties:
     ~azure.mgmt.compute.v2021_04_01.models.AutomaticOSUpgradeProperties
    :param hyper_v_generation: Specifies the HyperVGeneration Type. Possible values include: "V1",
     "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGenerationTypes
    :param disallowed: Specifies disallowed configuration for the VirtualMachine created from the
     image.
    :type disallowed: ~azure.mgmt.compute.v2021_04_01.models.DisallowedConfiguration
    :param features:
    :type features: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineImageFeature]
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'plan': {'key': 'properties.plan', 'type': 'PurchasePlan'},
        'os_disk_image': {'key': 'properties.osDiskImage', 'type': 'OSDiskImage'},
        'data_disk_images': {'key': 'properties.dataDiskImages', 'type': '[DataDiskImage]'},
        'automatic_os_upgrade_properties': {'key': 'properties.automaticOSUpgradeProperties', 'type': 'AutomaticOSUpgradeProperties'},
        'hyper_v_generation': {'key': 'properties.hyperVGeneration', 'type': 'str'},
        'disallowed': {'key': 'properties.disallowed', 'type': 'DisallowedConfiguration'},
        'features': {'key': 'properties.features', 'type': '[VirtualMachineImageFeature]'},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        plan: Optional["PurchasePlan"] = None,
        os_disk_image: Optional["OSDiskImage"] = None,
        data_disk_images: Optional[List["DataDiskImage"]] = None,
        automatic_os_upgrade_properties: Optional["AutomaticOSUpgradeProperties"] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGenerationTypes"]] = None,
        disallowed: Optional["DisallowedConfiguration"] = None,
        features: Optional[List["VirtualMachineImageFeature"]] = None,
        **kwargs
    ):
        super(VirtualMachineImage, self).__init__(id=id, name=name, location=location, tags=tags, extended_location=extended_location, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images
        self.automatic_os_upgrade_properties = automatic_os_upgrade_properties
        self.hyper_v_generation = hyper_v_generation
        self.disallowed = disallowed
        self.features = features


class VirtualMachineImageFeature(msrest.serialization.Model):
    """Specifies additional capabilities supported by the image.

    :param name: The name of the feature.
    :type name: str
    :param value: The corresponding value for the feature.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineImageFeature, self).__init__(**kwargs)
        self.name = name
        self.value = value


class VirtualMachineInstallPatchesParameters(msrest.serialization.Model):
    """Input for InstallPatches as directly received by the API.

    All required parameters must be populated in order to send to Azure.

    :param maximum_duration: Required. Specifies the maximum amount of time that the operation will
     run. It must be an ISO 8601-compliant duration string such as PT4H (4 hours).
    :type maximum_duration: str
    :param reboot_setting: Required. Defines when it is acceptable to reboot a VM during a software
     update operation. Possible values include: "IfRequired", "Never", "Always".
    :type reboot_setting: str or ~azure.mgmt.compute.v2021_04_01.models.VMGuestPatchRebootSetting
    :param windows_parameters: Input for InstallPatches on a Windows VM, as directly received by
     the API.
    :type windows_parameters: ~azure.mgmt.compute.v2021_04_01.models.WindowsParameters
    :param linux_parameters: Input for InstallPatches on a Linux VM, as directly received by the
     API.
    :type linux_parameters: ~azure.mgmt.compute.v2021_04_01.models.LinuxParameters
    """

    _validation = {
        'maximum_duration': {'required': True},
        'reboot_setting': {'required': True},
    }

    _attribute_map = {
        'maximum_duration': {'key': 'maximumDuration', 'type': 'str'},
        'reboot_setting': {'key': 'rebootSetting', 'type': 'str'},
        'windows_parameters': {'key': 'windowsParameters', 'type': 'WindowsParameters'},
        'linux_parameters': {'key': 'linuxParameters', 'type': 'LinuxParameters'},
    }

    def __init__(
        self,
        *,
        maximum_duration: str,
        reboot_setting: Union[str, "VMGuestPatchRebootSetting"],
        windows_parameters: Optional["WindowsParameters"] = None,
        linux_parameters: Optional["LinuxParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineInstallPatchesParameters, self).__init__(**kwargs)
        self.maximum_duration = maximum_duration
        self.reboot_setting = reboot_setting
        self.windows_parameters = windows_parameters
        self.linux_parameters = linux_parameters


class VirtualMachineInstallPatchesResult(msrest.serialization.Model):
    """The result summary of an installation operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The overall success or failure status of the operation. It remains "InProgress"
     until the operation completes. At that point it will become "Failed", "Succeeded", "Unknown" or
     "CompletedWithWarnings.". Possible values include: "Unknown", "InProgress", "Failed",
     "Succeeded", "CompletedWithWarnings".
    :vartype status: str or ~azure.mgmt.compute.v2021_04_01.models.PatchOperationStatus
    :ivar installation_activity_id: The activity ID of the operation that produced this result. It
     is used to correlate across CRP and extension logs.
    :vartype installation_activity_id: str
    :ivar reboot_status: The reboot state of the VM following completion of the operation. Possible
     values include: "Unknown", "NotNeeded", "Required", "Started", "Failed", "Completed".
    :vartype reboot_status: str or ~azure.mgmt.compute.v2021_04_01.models.VMGuestPatchRebootStatus
    :ivar maintenance_window_exceeded: Whether the operation ran out of time before it completed
     all its intended actions.
    :vartype maintenance_window_exceeded: bool
    :ivar excluded_patch_count: The number of patches that were not installed due to the user
     blocking their installation.
    :vartype excluded_patch_count: int
    :ivar not_selected_patch_count: The number of patches that were detected as available for
     install, but did not meet the operation's criteria.
    :vartype not_selected_patch_count: int
    :ivar pending_patch_count: The number of patches that were identified as meeting the
     installation criteria, but were not able to be installed. Typically this happens when
     maintenanceWindowExceeded == true.
    :vartype pending_patch_count: int
    :ivar installed_patch_count: The number of patches successfully installed.
    :vartype installed_patch_count: int
    :ivar failed_patch_count: The number of patches that could not be installed due to some issue.
     See errors for details.
    :vartype failed_patch_count: int
    :ivar patches: The patches that were installed during the operation.
    :vartype patches: list[~azure.mgmt.compute.v2021_04_01.models.PatchInstallationDetail]
    :ivar start_date_time: The UTC timestamp when the operation began.
    :vartype start_date_time: ~datetime.datetime
    :ivar error: The errors that were encountered during execution of the operation. The details
     array contains the list of them.
    :vartype error: ~azure.mgmt.compute.v2021_04_01.models.ApiError
    """

    _validation = {
        'status': {'readonly': True},
        'installation_activity_id': {'readonly': True},
        'reboot_status': {'readonly': True},
        'maintenance_window_exceeded': {'readonly': True},
        'excluded_patch_count': {'readonly': True},
        'not_selected_patch_count': {'readonly': True},
        'pending_patch_count': {'readonly': True},
        'installed_patch_count': {'readonly': True},
        'failed_patch_count': {'readonly': True},
        'patches': {'readonly': True},
        'start_date_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'installation_activity_id': {'key': 'installationActivityId', 'type': 'str'},
        'reboot_status': {'key': 'rebootStatus', 'type': 'str'},
        'maintenance_window_exceeded': {'key': 'maintenanceWindowExceeded', 'type': 'bool'},
        'excluded_patch_count': {'key': 'excludedPatchCount', 'type': 'int'},
        'not_selected_patch_count': {'key': 'notSelectedPatchCount', 'type': 'int'},
        'pending_patch_count': {'key': 'pendingPatchCount', 'type': 'int'},
        'installed_patch_count': {'key': 'installedPatchCount', 'type': 'int'},
        'failed_patch_count': {'key': 'failedPatchCount', 'type': 'int'},
        'patches': {'key': 'patches', 'type': '[PatchInstallationDetail]'},
        'start_date_time': {'key': 'startDateTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineInstallPatchesResult, self).__init__(**kwargs)
        self.status = None
        self.installation_activity_id = None
        self.reboot_status = None
        self.maintenance_window_exceeded = None
        self.excluded_patch_count = None
        self.not_selected_patch_count = None
        self.pending_patch_count = None
        self.installed_patch_count = None
        self.failed_patch_count = None
        self.patches = None
        self.start_date_time = None
        self.error = None


class VirtualMachineInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param platform_update_domain: Specifies the update domain of the virtual machine.
    :type platform_update_domain: int
    :param platform_fault_domain: Specifies the fault domain of the virtual machine.
    :type platform_fault_domain: int
    :param computer_name: The computer name assigned to the virtual machine.
    :type computer_name: str
    :param os_name: The Operating System running on the virtual machine.
    :type os_name: str
    :param os_version: The version of Operating System running on the virtual machine.
    :type os_version: str
    :param hyper_v_generation: Specifies the HyperVGeneration Type associated with a resource.
     Possible values include: "V1", "V2".
    :type hyper_v_generation: str or ~azure.mgmt.compute.v2021_04_01.models.HyperVGenerationType
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineAgentInstanceView
    :param maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :type maintenance_redeploy_status:
     ~azure.mgmt.compute.v2021_04_01.models.MaintenanceRedeployStatus
    :param disks: The virtual machine disk information.
    :type disks: list[~azure.mgmt.compute.v2021_04_01.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineHealthStatus
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2021_04_01.models.BootDiagnosticsInstanceView
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    :param patch_status: [Preview Feature] The status of virtual machine patch operations.
    :type patch_status: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachinePatchStatus
    """

    _validation = {
        'vm_health': {'readonly': True},
        'assigned_host': {'readonly': True},
    }

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'hyper_v_generation': {'key': 'hyperVGeneration', 'type': 'str'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'maintenance_redeploy_status': {'key': 'maintenanceRedeployStatus', 'type': 'MaintenanceRedeployStatus'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'vm_health': {'key': 'vmHealth', 'type': 'VirtualMachineHealthStatus'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'assigned_host': {'key': 'assignedHost', 'type': 'str'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'patch_status': {'key': 'patchStatus', 'type': 'VirtualMachinePatchStatus'},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        computer_name: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        hyper_v_generation: Optional[Union[str, "HyperVGenerationType"]] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["MaintenanceRedeployStatus"] = None,
        disks: Optional[List["DiskInstanceView"]] = None,
        extensions: Optional[List["VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        patch_status: Optional["VirtualMachinePatchStatus"] = None,
        **kwargs
    ):
        super(VirtualMachineInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.computer_name = computer_name
        self.os_name = os_name
        self.os_version = os_version
        self.hyper_v_generation = hyper_v_generation
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.assigned_host = None
        self.statuses = statuses
        self.patch_status = patch_status


class VirtualMachineIpTag(msrest.serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :param ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineIpTag, self).__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class VirtualMachineListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machines.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachine]
    :param next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachine"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineNetworkInterfaceConfiguration(msrest.serialization.Model):
    """Describes a virtual machine network interface configurations.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The network interface configuration name.
    :type name: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param delete_option: Specify what happens to the network interface when the VM is deleted.
     Possible values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :type enable_fpga: bool
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration
    :param ip_configurations: Specifies the IP configurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineNetworkInterfaceIPConfiguration]
    :param dscp_configuration:
    :type dscp_configuration: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_fpga': {'key': 'properties.enableFpga', 'type': 'bool'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineNetworkInterfaceDnsSettingsConfiguration'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineNetworkInterfaceIPConfiguration]'},
        'dscp_configuration': {'key': 'properties.dscpConfiguration', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        name: str,
        primary: Optional[bool] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        network_security_group: Optional["SubResource"] = None,
        dns_settings: Optional["VirtualMachineNetworkInterfaceDnsSettingsConfiguration"] = None,
        ip_configurations: Optional[List["VirtualMachineNetworkInterfaceIPConfiguration"]] = None,
        dscp_configuration: Optional["SubResource"] = None,
        **kwargs
    ):
        super(VirtualMachineNetworkInterfaceConfiguration, self).__init__(**kwargs)
        self.name = name
        self.primary = primary
        self.delete_option = delete_option
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_fpga = enable_fpga
        self.enable_ip_forwarding = enable_ip_forwarding
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.dscp_configuration = dscp_configuration


class VirtualMachineNetworkInterfaceDnsSettingsConfiguration(msrest.serialization.Model):
    """Describes a virtual machines network configuration's DNS settings.

    :param dns_servers: List of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineNetworkInterfaceDnsSettingsConfiguration, self).__init__(**kwargs)
        self.dns_servers = dns_servers


class VirtualMachineNetworkInterfaceIPConfiguration(msrest.serialization.Model):
    """Describes a virtual machine network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The IP configuration name.
    :type name: str
    :param subnet: Specifies the identifier of the subnet.
    :type subnet: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachinePublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2021_04_01.models.IPVersions
    :param application_security_groups: Specifies an array of references to application security
     group.
    :type application_security_groups: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A virtual machine can reference backend address pools of
     multiple application gateways. Multiple virtual machines cannot use the same application
     gateway.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A virtual machine can reference backend address pools of one public
     and one internal load balancer. [Multiple virtual machines cannot use the same basic sku load
     balancer].
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'SubResource'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachinePublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[SubResource]'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        name: str,
        subnet: Optional["SubResource"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["VirtualMachinePublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "IPVersions"]] = None,
        application_security_groups: Optional[List["SubResource"]] = None,
        application_gateway_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        super(VirtualMachineNetworkInterfaceIPConfiguration, self).__init__(**kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_security_groups = application_security_groups
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools


class VirtualMachinePatchStatus(msrest.serialization.Model):
    """The status of virtual machine patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param available_patch_summary: The available patch summary of the latest assessment operation
     for the virtual machine.
    :type available_patch_summary: ~azure.mgmt.compute.v2021_04_01.models.AvailablePatchSummary
    :param last_patch_installation_summary: The installation summary of the latest installation
     operation for the virtual machine.
    :type last_patch_installation_summary:
     ~azure.mgmt.compute.v2021_04_01.models.LastPatchInstallationSummary
    :ivar configuration_statuses: The enablement status of the specified patchMode.
    :vartype configuration_statuses:
     list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'configuration_statuses': {'readonly': True},
    }

    _attribute_map = {
        'available_patch_summary': {'key': 'availablePatchSummary', 'type': 'AvailablePatchSummary'},
        'last_patch_installation_summary': {'key': 'lastPatchInstallationSummary', 'type': 'LastPatchInstallationSummary'},
        'configuration_statuses': {'key': 'configurationStatuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        available_patch_summary: Optional["AvailablePatchSummary"] = None,
        last_patch_installation_summary: Optional["LastPatchInstallationSummary"] = None,
        **kwargs
    ):
        super(VirtualMachinePatchStatus, self).__init__(**kwargs)
        self.available_patch_summary = available_patch_summary
        self.last_patch_installation_summary = last_patch_installation_summary
        self.configuration_statuses = None


class VirtualMachinePublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The publicIP address configuration name.
    :type name: str
    :param sku: Describes the public IP Sku.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.PublicIPAddressSku
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param delete_option: Specify what happens to the public IP address when the VM is deleted.
     Possible values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachinePublicIPAddressDnsSettingsConfiguration
    :param ip_tags: The list of IP tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineIpTag]
    :param public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :type public_ip_prefix: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type public_ip_address_version: str or ~azure.mgmt.compute.v2021_04_01.models.IPVersions
    :param public_ip_allocation_method: Specify the public IP allocation type. Possible values
     include: "Dynamic", "Static".
    :type public_ip_allocation_method: str or
     ~azure.mgmt.compute.v2021_04_01.models.PublicIPAllocationMethod
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'PublicIPAddressSku'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachinePublicIPAddressDnsSettingsConfiguration'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[VirtualMachineIpTag]'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'public_ip_allocation_method': {'key': 'properties.publicIPAllocationMethod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        sku: Optional["PublicIPAddressSku"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        dns_settings: Optional["VirtualMachinePublicIPAddressDnsSettingsConfiguration"] = None,
        ip_tags: Optional[List["VirtualMachineIpTag"]] = None,
        public_ip_prefix: Optional["SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "IPVersions"]] = None,
        public_ip_allocation_method: Optional[Union[str, "PublicIPAllocationMethod"]] = None,
        **kwargs
    ):
        super(VirtualMachinePublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = name
        self.sku = sku
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.delete_option = delete_option
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags
        self.public_ip_prefix = public_ip_prefix
        self.public_ip_address_version = public_ip_address_version
        self.public_ip_allocation_method = public_ip_allocation_method


class VirtualMachinePublicIPAddressDnsSettingsConfiguration(msrest.serialization.Model):
    """Describes a virtual machines network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :param domain_name_label: Required. The Domain name label prefix of the PublicIPAddress
     resources that will be created. The generated name label is the concatenation of the domain
     name label and vm network profile unique ID.
    :type domain_name_label: str
    """

    _validation = {
        'domain_name_label': {'required': True},
    }

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name_label: str,
        **kwargs
    ):
        super(VirtualMachinePublicIPAddressDnsSettingsConfiguration, self).__init__(**kwargs)
        self.domain_name_label = domain_name_label


class VirtualMachineReimageParameters(msrest.serialization.Model):
    """Parameters for Reimaging Virtual Machine. NOTE: Virtual Machine OS disk will always be reimaged.

    :param temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :type temp_disk: bool
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        temp_disk: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineReimageParameters, self).__init__(**kwargs)
        self.temp_disk = temp_disk


class VirtualMachineRunCommand(Resource):
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source: The source of the run command script.
    :type source: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineRunCommandScriptSource
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2021_04_01.models.RunCommandInputParameter]
    :param protected_parameters: The parameters used by the script.
    :type protected_parameters:
     list[~azure.mgmt.compute.v2021_04_01.models.RunCommandInputParameter]
    :param async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :type async_execution: bool
    :param run_as_user: Specifies the user account on the VM when executing the run command.
    :type run_as_user: str
    :param run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :type run_as_password: str
    :param timeout_in_seconds: The timeout in seconds to execute the run command.
    :type timeout_in_seconds: int
    :param output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :type output_blob_uri: str
    :param error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :type error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'VirtualMachineRunCommandScriptSource'},
        'parameters': {'key': 'properties.parameters', 'type': '[RunCommandInputParameter]'},
        'protected_parameters': {'key': 'properties.protectedParameters', 'type': '[RunCommandInputParameter]'},
        'async_execution': {'key': 'properties.asyncExecution', 'type': 'bool'},
        'run_as_user': {'key': 'properties.runAsUser', 'type': 'str'},
        'run_as_password': {'key': 'properties.runAsPassword', 'type': 'str'},
        'timeout_in_seconds': {'key': 'properties.timeoutInSeconds', 'type': 'int'},
        'output_blob_uri': {'key': 'properties.outputBlobUri', 'type': 'str'},
        'error_blob_uri': {'key': 'properties.errorBlobUri', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineRunCommandInstanceView'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["VirtualMachineRunCommandScriptSource"] = None,
        parameters: Optional[List["RunCommandInputParameter"]] = None,
        protected_parameters: Optional[List["RunCommandInputParameter"]] = None,
        async_execution: Optional[bool] = False,
        run_as_user: Optional[str] = None,
        run_as_password: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        output_blob_uri: Optional[str] = None,
        error_blob_uri: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineRunCommand, self).__init__(location=location, tags=tags, **kwargs)
        self.source = source
        self.parameters = parameters
        self.protected_parameters = protected_parameters
        self.async_execution = async_execution
        self.run_as_user = run_as_user
        self.run_as_password = run_as_password
        self.timeout_in_seconds = timeout_in_seconds
        self.output_blob_uri = output_blob_uri
        self.error_blob_uri = error_blob_uri
        self.provisioning_state = None
        self.instance_view = None


class VirtualMachineRunCommandInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine run command.

    :param execution_state: Script execution status. Possible values include: "Unknown", "Pending",
     "Running", "Failed", "Succeeded", "TimedOut", "Canceled".
    :type execution_state: str or ~azure.mgmt.compute.v2021_04_01.models.ExecutionState
    :param execution_message: Communicate script configuration errors or execution messages.
    :type execution_message: str
    :param exit_code: Exit code returned from script execution.
    :type exit_code: int
    :param output: Script output stream.
    :type output: str
    :param error: Script error stream.
    :type error: str
    :param start_time: Script start time.
    :type start_time: ~datetime.datetime
    :param end_time: Script end time.
    :type end_time: ~datetime.datetime
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'execution_state': {'key': 'executionState', 'type': 'str'},
        'execution_message': {'key': 'executionMessage', 'type': 'str'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'output': {'key': 'output', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        execution_state: Optional[Union[str, "ExecutionState"]] = None,
        execution_message: Optional[str] = None,
        exit_code: Optional[int] = None,
        output: Optional[str] = None,
        error: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineRunCommandInstanceView, self).__init__(**kwargs)
        self.execution_state = execution_state
        self.execution_message = execution_message
        self.exit_code = exit_code
        self.output = output
        self.error = error
        self.start_time = start_time
        self.end_time = end_time
        self.statuses = statuses


class VirtualMachineRunCommandScriptSource(msrest.serialization.Model):
    """Describes the script sources for run command.

    :param script: Specifies the script content to be executed on the VM.
    :type script: str
    :param script_uri: Specifies the script download location.
    :type script_uri: str
    :param command_id: Specifies a commandId of predefined built-in script.
    :type command_id: str
    """

    _attribute_map = {
        'script': {'key': 'script', 'type': 'str'},
        'script_uri': {'key': 'scriptUri', 'type': 'str'},
        'command_id': {'key': 'commandId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        script: Optional[str] = None,
        script_uri: Optional[str] = None,
        command_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineRunCommandScriptSource, self).__init__(**kwargs)
        self.script = script
        self.script_uri = script_uri
        self.command_id = command_id


class VirtualMachineRunCommandsListResult(msrest.serialization.Model):
    """The List run command operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of run commands.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineRunCommand]
    :param next_link: The uri to fetch the next page of run commands.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineRunCommand]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineRunCommand"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineRunCommandsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineRunCommandUpdate(UpdateResource):
    """Describes a Virtual Machine run command.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source: The source of the run command script.
    :type source: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineRunCommandScriptSource
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2021_04_01.models.RunCommandInputParameter]
    :param protected_parameters: The parameters used by the script.
    :type protected_parameters:
     list[~azure.mgmt.compute.v2021_04_01.models.RunCommandInputParameter]
    :param async_execution: Optional. If set to true, provisioning will complete as soon as the
     script starts and will not wait for script to complete.
    :type async_execution: bool
    :param run_as_user: Specifies the user account on the VM when executing the run command.
    :type run_as_user: str
    :param run_as_password: Specifies the user account password on the VM when executing the run
     command.
    :type run_as_password: str
    :param timeout_in_seconds: The timeout in seconds to execute the run command.
    :type timeout_in_seconds: int
    :param output_blob_uri: Specifies the Azure storage blob where script output stream will be
     uploaded.
    :type output_blob_uri: str
    :param error_blob_uri: Specifies the Azure storage blob where script error stream will be
     uploaded.
    :type error_blob_uri: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine run command instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineRunCommandInstanceView
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'source': {'key': 'properties.source', 'type': 'VirtualMachineRunCommandScriptSource'},
        'parameters': {'key': 'properties.parameters', 'type': '[RunCommandInputParameter]'},
        'protected_parameters': {'key': 'properties.protectedParameters', 'type': '[RunCommandInputParameter]'},
        'async_execution': {'key': 'properties.asyncExecution', 'type': 'bool'},
        'run_as_user': {'key': 'properties.runAsUser', 'type': 'str'},
        'run_as_password': {'key': 'properties.runAsPassword', 'type': 'str'},
        'timeout_in_seconds': {'key': 'properties.timeoutInSeconds', 'type': 'int'},
        'output_blob_uri': {'key': 'properties.outputBlobUri', 'type': 'str'},
        'error_blob_uri': {'key': 'properties.errorBlobUri', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineRunCommandInstanceView'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source: Optional["VirtualMachineRunCommandScriptSource"] = None,
        parameters: Optional[List["RunCommandInputParameter"]] = None,
        protected_parameters: Optional[List["RunCommandInputParameter"]] = None,
        async_execution: Optional[bool] = False,
        run_as_user: Optional[str] = None,
        run_as_password: Optional[str] = None,
        timeout_in_seconds: Optional[int] = None,
        output_blob_uri: Optional[str] = None,
        error_blob_uri: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineRunCommandUpdate, self).__init__(tags=tags, **kwargs)
        self.source = source
        self.parameters = parameters
        self.protected_parameters = protected_parameters
        self.async_execution = async_execution
        self.run_as_user = run_as_user
        self.run_as_password = run_as_password
        self.timeout_in_seconds = timeout_in_seconds
        self.output_blob_uri = output_blob_uri
        self.error_blob_uri = error_blob_uri
        self.provisioning_state = None
        self.instance_view = None


class VirtualMachineScaleSet(Resource):
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2021_04_01.models.Plan
    :param identity: The identity of the virtual machine scale set, if configured.
    :type identity: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetIdentity
    :param zones: The virtual machine scale set zones. NOTE: Availability zones can only be set
     when you create the scale set.
    :type zones: list[str]
    :param extended_location: The extended location of the Virtual Machine Scale Set.
    :type extended_location: ~azure.mgmt.compute.v2021_04_01.models.ExtendedLocation
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2021_04_01.models.UpgradePolicy
    :param automatic_repairs_policy: Policy for automatic repairs.
    :type automatic_repairs_policy: ~azure.mgmt.compute.v2021_04_01.models.AutomaticRepairsPolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param overprovision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :type overprovision: bool
    :param do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :type do_not_run_extensions_on_overprovisioned_v_ms: bool
    :ivar unique_id: Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
    :vartype unique_id: str
    :param single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :type single_placement_group: bool
    :param zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones
     in case there is zone outage. zoneBalance property can only be set if the zones property of the
     scale set contains more than one zone. If there are no zones or only one zone specified, then
     zoneBalance property should not be set.
    :type zone_balance: bool
    :param platform_fault_domain_count: Fault Domain count for each placement group.
    :type platform_fault_domain_count: int
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
     api-version: 2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param host_group: Specifies information about the dedicated host group that the virtual
     machine scale set resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
    :type host_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :type additional_capabilities: ~azure.mgmt.compute.v2021_04_01.models.AdditionalCapabilities
    :param scale_in_policy: Specifies the scale-in policy that decides which virtual machines are
     chosen for removal when a Virtual Machine Scale Set is scaled-in.
    :type scale_in_policy: ~azure.mgmt.compute.v2021_04_01.models.ScaleInPolicy
    :param orchestration_mode: Specifies the orchestration mode for the virtual machine scale set.
     Possible values include: "Uniform", "Flexible".
    :type orchestration_mode: str or ~azure.mgmt.compute.v2021_04_01.models.OrchestrationMode
    :param spot_restore_policy: Specifies the Spot Restore properties for the virtual machine scale
     set.
    :type spot_restore_policy: ~azure.mgmt.compute.v2021_04_01.models.SpotRestorePolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'unique_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineScaleSetIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'extended_location': {'key': 'extendedLocation', 'type': 'ExtendedLocation'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'automatic_repairs_policy': {'key': 'properties.automaticRepairsPolicy', 'type': 'AutomaticRepairsPolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetVMProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'overprovision': {'key': 'properties.overprovision', 'type': 'bool'},
        'do_not_run_extensions_on_overprovisioned_v_ms': {'key': 'properties.doNotRunExtensionsOnOverprovisionedVMs', 'type': 'bool'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'single_placement_group': {'key': 'properties.singlePlacementGroup', 'type': 'bool'},
        'zone_balance': {'key': 'properties.zoneBalance', 'type': 'bool'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'host_group': {'key': 'properties.hostGroup', 'type': 'SubResource'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'scale_in_policy': {'key': 'properties.scaleInPolicy', 'type': 'ScaleInPolicy'},
        'orchestration_mode': {'key': 'properties.orchestrationMode', 'type': 'str'},
        'spot_restore_policy': {'key': 'properties.spotRestorePolicy', 'type': 'SpotRestorePolicy'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineScaleSetIdentity"] = None,
        zones: Optional[List[str]] = None,
        extended_location: Optional["ExtendedLocation"] = None,
        upgrade_policy: Optional["UpgradePolicy"] = None,
        automatic_repairs_policy: Optional["AutomaticRepairsPolicy"] = None,
        virtual_machine_profile: Optional["VirtualMachineScaleSetVMProfile"] = None,
        overprovision: Optional[bool] = None,
        do_not_run_extensions_on_overprovisioned_v_ms: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        zone_balance: Optional[bool] = None,
        platform_fault_domain_count: Optional[int] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        host_group: Optional["SubResource"] = None,
        additional_capabilities: Optional["AdditionalCapabilities"] = None,
        scale_in_policy: Optional["ScaleInPolicy"] = None,
        orchestration_mode: Optional[Union[str, "OrchestrationMode"]] = None,
        spot_restore_policy: Optional["SpotRestorePolicy"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSet, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.extended_location = extended_location
        self.upgrade_policy = upgrade_policy
        self.automatic_repairs_policy = automatic_repairs_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.provisioning_state = None
        self.overprovision = overprovision
        self.do_not_run_extensions_on_overprovisioned_v_ms = do_not_run_extensions_on_overprovisioned_v_ms
        self.unique_id = None
        self.single_placement_group = single_placement_group
        self.zone_balance = zone_balance
        self.platform_fault_domain_count = platform_fault_domain_count
        self.proximity_placement_group = proximity_placement_group
        self.host_group = host_group
        self.additional_capabilities = additional_capabilities
        self.scale_in_policy = scale_in_policy
        self.orchestration_mode = orchestration_mode
        self.spot_restore_policy = spot_restore_policy


class VirtualMachineScaleSetDataDisk(msrest.serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to Azure.

    :param name: The disk name.
    :type name: str
    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. The create option. Possible values include: "FromImage",
     "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetManagedDiskParameters
    :param disk_iops_read_write: Specifies the Read-Write IOPS for the managed disk. Should be used
     only when StorageAccountType is UltraSSD_LRS. If not specified, a default value would be
     assigned based on diskSizeGB.
    :type disk_iops_read_write: long
    :param disk_m_bps_read_write: Specifies the bandwidth in MB per second for the managed disk.
     Should be used only when StorageAccountType is UltraSSD_LRS. If not specified, a default value
     would be assigned based on diskSizeGB.
    :type disk_m_bps_read_write: long
    """

    _validation = {
        'lun': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
        'disk_iops_read_write': {'key': 'diskIOPSReadWrite', 'type': 'long'},
        'disk_m_bps_read_write': {'key': 'diskMBpsReadWrite', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["VirtualMachineScaleSetManagedDiskParameters"] = None,
        disk_iops_read_write: Optional[int] = None,
        disk_m_bps_read_write: Optional[int] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetDataDisk, self).__init__(**kwargs)
        self.name = name
        self.lun = lun
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk
        self.disk_iops_read_write = disk_iops_read_write
        self.disk_m_bps_read_write = disk_m_bps_read_write


class VirtualMachineScaleSetExtension(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: The name of the extension.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :type provision_after_extensions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provision_after_extensions': {'key': 'properties.provisionAfterExtensions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        provision_after_extensions: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtension, self).__init__(**kwargs)
        self.name = name
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.provision_after_extensions = provision_after_extensions


class VirtualMachineScaleSetExtensionListResult(msrest.serialization.Model):
    """The List VM scale set extension operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of VM scale set extensions.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetExtension]
    :param next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
     with this to fetch the next page of VM scale set extensions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetExtension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSetExtension"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetExtensionProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :param extensions: The virtual machine scale set child extension resources.
    :type extensions: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetExtension]
    :param extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :type extensions_time_budget: str
    """

    _attribute_map = {
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetExtension]'},
        'extensions_time_budget': {'key': 'extensionsTimeBudget', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extensions: Optional[List["VirtualMachineScaleSetExtension"]] = None,
        extensions_time_budget: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionProfile, self).__init__(**kwargs)
        self.extensions = extensions
        self.extensions_time_budget = extensions_time_budget


class VirtualMachineScaleSetExtensionUpdate(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param provision_after_extensions: Collection of extension names after which this extension
     needs to be provisioned.
    :type provision_after_extensions: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'provision_after_extensions': {'key': 'properties.provisionAfterExtensions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        provision_after_extensions: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionUpdate, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.provision_after_extensions = provision_after_extensions


class VirtualMachineScaleSetIdentity(msrest.serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity. This property will
     only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the virtual machine scale set. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
     assigned identities. The type 'None' will remove any identities from the virtual machine scale
     set. Possible values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned",
     "None".
    :type type: str or ~azure.mgmt.compute.v2021_04_01.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with the virtual
     machine scale set. The user identity dictionary key references will be ARM resource ids in the
     form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue(msrest.serialization.Model):
    """VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetIdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class VirtualMachineScaleSetInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVMExtensionsSummary]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    :ivar orchestration_services: The orchestration services information.
    :vartype orchestration_services:
     list[~azure.mgmt.compute.v2021_04_01.models.OrchestrationServiceSummary]
    """

    _validation = {
        'virtual_machine': {'readonly': True},
        'extensions': {'readonly': True},
        'orchestration_services': {'readonly': True},
    }

    _attribute_map = {
        'virtual_machine': {'key': 'virtualMachine', 'type': 'VirtualMachineScaleSetInstanceViewStatusesSummary'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetVMExtensionsSummary]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'orchestration_services': {'key': 'orchestrationServices', 'type': '[OrchestrationServiceSummary]'},
    }

    def __init__(
        self,
        *,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetInstanceView, self).__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = statuses
        self.orchestration_services = None


class VirtualMachineScaleSetInstanceViewStatusesSummary(msrest.serialization.Model):
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetInstanceViewStatusesSummary, self).__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The IP configuration name.
    :type name: str
    :param subnet: Specifies the identifier of the subnet.
    :type subnet: ~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2021_04_01.models.IPVersion
    :param application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A scale set can reference backend address pools of
     multiple application gateways. Multiple scale sets cannot use the same application gateway.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param application_security_groups: Specifies an array of references to application security
     group.
    :type application_security_groups: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A scale set can reference backend address pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools
     of the load balancers. A scale set can reference inbound nat pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same basic sku load balancer.
    :type load_balancer_inbound_nat_pools: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachineScaleSetPublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,
        subnet: Optional["ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["VirtualMachineScaleSetPublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["SubResource"]] = None,
        application_security_groups: Optional[List["SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.application_security_groups = application_security_groups
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetIpTag(msrest.serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :param ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetIpTag, self).__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class VirtualMachineScaleSetListOSUpgradeHistory(msrest.serialization.Model):
    """List of Virtual Machine Scale Set OS Upgrade History operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of OS upgrades performed on the virtual machine scale set.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.UpgradeOperationHistoricalStatusInfo]
    :param next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
     this to fetch the next page of history of upgrades.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpgradeOperationHistoricalStatusInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["UpgradeOperationHistoricalStatusInfo"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListOSUpgradeHistory, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSet]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListSkusResult(msrest.serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of skus available for the virtual machine scale set.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetSku]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSetSku"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListSkusResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListWithLinkResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSet]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListWithLinkResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetManagedDiskParameters(msrest.serialization.Model):
    """Describes the parameters of a ScaleSet managed disk.

    :param storage_account_type: Specifies the storage account type for the managed disk. NOTE:
     UltraSSD_LRS can only be used with data disks, it cannot be used with OS Disk. Possible values
     include: "Standard_LRS", "Premium_LRS", "StandardSSD_LRS", "UltraSSD_LRS", "Premium_ZRS",
     "StandardSSD_ZRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2021_04_01.models.StorageAccountTypes
    :param disk_encryption_set: Specifies the customer managed disk encryption set resource id for
     the managed disk.
    :type disk_encryption_set: ~azure.mgmt.compute.v2021_04_01.models.DiskEncryptionSetParameters
    """

    _attribute_map = {
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
        'disk_encryption_set': {'key': 'diskEncryptionSet', 'type': 'DiskEncryptionSetParameters'},
    }

    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        disk_encryption_set: Optional["DiskEncryptionSetParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetManagedDiskParameters, self).__init__(**kwargs)
        self.storage_account_type = storage_account_type
        self.disk_encryption_set = disk_encryption_set


class VirtualMachineScaleSetNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The network configuration name.
    :type name: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :type enable_fpga: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :param ip_configurations: Specifies the IP configurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetIPConfiguration]
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    :param delete_option: Specify what happens to the network interface when the VM is deleted.
     Possible values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_fpga': {'key': 'properties.enableFpga', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetIPConfiguration]'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["SubResource"] = None,
        dns_settings: Optional["VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["VirtualMachineScaleSetIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_fpga = enable_fpga
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding
        self.delete_option = delete_option


class VirtualMachineScaleSetNetworkConfigurationDnsSettings(msrest.serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :param dns_servers: List of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkConfigurationDnsSettings, self).__init__(**kwargs)
        self.dns_servers = dns_servers


class VirtualMachineScaleSetNetworkProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set network profile.

    :param health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :type health_probe: ~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference
    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetNetworkConfiguration]
    :param network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
     orchestration mode 'Flexible'. Possible values include: "2020-11-01".
    :type network_api_version: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkApiVersion
    """

    _attribute_map = {
        'health_probe': {'key': 'healthProbe', 'type': 'ApiEntityReference'},
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetNetworkConfiguration]'},
        'network_api_version': {'key': 'networkApiVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["VirtualMachineScaleSetNetworkConfiguration"]] = None,
        network_api_version: Optional[Union[str, "NetworkApiVersion"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkProfile, self).__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations
        self.network_api_version = network_api_version


class VirtualMachineScaleSetOSDisk(msrest.serialization.Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :param name: The disk name.
    :type name: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Possible values include:
     "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2021_04_01.models.DiskCreateOptionTypes
    :param diff_disk_settings: Specifies the ephemeral disk Settings for the operating system disk
     used by the virtual machine scale set.
    :type diff_disk_settings: ~azure.mgmt.compute.v2021_04_01.models.DiffDiskSettings
    :param disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2021_04_01.models.OperatingSystemTypes
    :param image: Specifies information about the unmanaged user image to base the scale set on.
    :type image: ~azure.mgmt.compute.v2021_04_01.models.VirtualHardDisk
    :param vhd_containers: Specifies the container urls that are used to store operating system
     disks for the scale set.
    :type vhd_containers: list[str]
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'diff_disk_settings': {'key': 'diffDiskSettings', 'type': 'DiffDiskSettings'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        diff_disk_settings: Optional["DiffDiskSettings"] = None,
        disk_size_gb: Optional[int] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        image: Optional["VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetOSDisk, self).__init__(**kwargs)
        self.name = name
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.diff_disk_settings = diff_disk_settings
        self.disk_size_gb = disk_size_gb
        self.os_type = os_type
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetOSProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :param computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :type computer_name_prefix: str
    :param admin_username: Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
     :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
     "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
     characters.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/reset-rdp>`_
     :code:`<br>`:code:`<br>` For resetting root password, see `Manage users, SSH, and check or
     repair disks on Azure Linux VMs using the VMAccess Extension
     <https://docs.microsoft.com/troubleshoot/azure/virtual-machines/troubleshoot-ssh-connection>`_.
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/linux/using-cloud-init>`_.
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :type windows_configuration: ~azure.mgmt.compute.v2021_04_01.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions
     <https://docs.microsoft.com/azure/virtual-machines/linux/endorsed-distros>`_.
    :type linux_configuration: ~azure.mgmt.compute.v2021_04_01.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed onto the virtual
     machines in the scale set. To install certificates on a virtual machine it is recommended to
     use the `Azure Key Vault virtual machine extension for Linux
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the `Azure
     Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :type secrets: list[~azure.mgmt.compute.v2021_04_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'computer_name_prefix': {'key': 'computerNamePrefix', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        linux_configuration: Optional["LinuxConfiguration"] = None,
        secrets: Optional[List["VaultSecretGroup"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetOSProfile, self).__init__(**kwargs)
        self.computer_name_prefix = computer_name_prefix
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetPublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The publicIP address configuration name.
    :type name: str
    :param sku: Describes the public IP Sku.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.PublicIPAddressSku
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :param ip_tags: The list of IP tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetIpTag]
    :param public_ip_prefix: The PublicIPPrefix from which to allocate publicIP addresses.
    :type public_ip_prefix: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param public_ip_address_version: Available from Api-Version 2019-07-01 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4. Possible values
     are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type public_ip_address_version: str or ~azure.mgmt.compute.v2021_04_01.models.IPVersion
    :param delete_option: Specify what happens to the public IP when the VM is deleted. Possible
     values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'PublicIPAddressSku'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[VirtualMachineScaleSetIpTag]'},
        'public_ip_prefix': {'key': 'properties.publicIPPrefix', 'type': 'SubResource'},
        'public_ip_address_version': {'key': 'properties.publicIPAddressVersion', 'type': 'str'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        sku: Optional["PublicIPAddressSku"] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        ip_tags: Optional[List["VirtualMachineScaleSetIpTag"]] = None,
        public_ip_prefix: Optional["SubResource"] = None,
        public_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetPublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = name
        self.sku = sku
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags
        self.public_ip_prefix = public_ip_prefix
        self.public_ip_address_version = public_ip_address_version
        self.delete_option = delete_option


class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(msrest.serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :param domain_name_label: Required. The Domain name label.The concatenation of the domain name
     label and vm index will be the domain name labels of the PublicIPAddress resources that will be
     created.
    :type domain_name_label: str
    """

    _validation = {
        'domain_name_label': {'required': True},
    }

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name_label: str,
        **kwargs
    ):
        super(VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = domain_name_label


class VirtualMachineScaleSetVMReimageParameters(VirtualMachineReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :param temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :type temp_disk: bool
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        temp_disk: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMReimageParameters, self).__init__(temp_disk=temp_disk, **kwargs)


class VirtualMachineScaleSetReimageParameters(VirtualMachineScaleSetVMReimageParameters):
    """Describes a Virtual Machine Scale Set VM Reimage Parameters.

    :param temp_disk: Specifies whether to reimage temp disk. Default value: false. Note: This temp
     disk reimage parameter is only supported for VM/VMSS with Ephemeral OS disk.
    :type temp_disk: bool
    :param instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'temp_disk': {'key': 'tempDisk', 'type': 'bool'},
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        temp_disk: Optional[bool] = None,
        instance_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetReimageParameters, self).__init__(temp_disk=temp_disk, **kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetSku(msrest.serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'capacity': {'key': 'capacity', 'type': 'VirtualMachineScaleSetSkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetSku, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: long
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: long
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: long
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "Automatic",
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default_capacity': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default_capacity': {'key': 'defaultCapacity', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :type image_reference: ~azure.mgmt.compute.v2021_04_01.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :type os_disk: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetOSDisk
    :param data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview>`_.
    :type data_disks: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[VirtualMachineScaleSetDataDisk]'},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["ImageReference"] = None,
        os_disk: Optional["VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetStorageProfile, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdate(UpdateResource):
    """Describes a Virtual Machine Scale Set.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
     images.
    :type plan: ~azure.mgmt.compute.v2021_04_01.models.Plan
    :param identity: The identity of the virtual machine scale set, if configured.
    :type identity: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetIdentity
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2021_04_01.models.UpgradePolicy
    :param automatic_repairs_policy: Policy for automatic repairs.
    :type automatic_repairs_policy: ~azure.mgmt.compute.v2021_04_01.models.AutomaticRepairsPolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateVMProfile
    :param overprovision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :type overprovision: bool
    :param do_not_run_extensions_on_overprovisioned_v_ms: When Overprovision is enabled, extensions
     are launched only on the requested number of VMs which are finally kept. This property will
     hence ensure that the extensions do not run on the extra overprovisioned VMs.
    :type do_not_run_extensions_on_overprovisioned_v_ms: bool
    :param single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :type single_placement_group: bool
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     Virtual Machines in the Virtual Machine Scale Set. For instance: whether the Virtual Machines
     have the capability to support attaching managed data disks with UltraSSD_LRS storage account
     type.
    :type additional_capabilities: ~azure.mgmt.compute.v2021_04_01.models.AdditionalCapabilities
    :param scale_in_policy: Specifies the scale-in policy that decides which virtual machines are
     chosen for removal when a Virtual Machine Scale Set is scaled-in.
    :type scale_in_policy: ~azure.mgmt.compute.v2021_04_01.models.ScaleInPolicy
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum
     api-version: 2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineScaleSetIdentity'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'automatic_repairs_policy': {'key': 'properties.automaticRepairsPolicy', 'type': 'AutomaticRepairsPolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetUpdateVMProfile'},
        'overprovision': {'key': 'properties.overprovision', 'type': 'bool'},
        'do_not_run_extensions_on_overprovisioned_v_ms': {'key': 'properties.doNotRunExtensionsOnOverprovisionedVMs', 'type': 'bool'},
        'single_placement_group': {'key': 'properties.singlePlacementGroup', 'type': 'bool'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'scale_in_policy': {'key': 'properties.scaleInPolicy', 'type': 'ScaleInPolicy'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineScaleSetIdentity"] = None,
        upgrade_policy: Optional["UpgradePolicy"] = None,
        automatic_repairs_policy: Optional["AutomaticRepairsPolicy"] = None,
        virtual_machine_profile: Optional["VirtualMachineScaleSetUpdateVMProfile"] = None,
        overprovision: Optional[bool] = None,
        do_not_run_extensions_on_overprovisioned_v_ms: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        additional_capabilities: Optional["AdditionalCapabilities"] = None,
        scale_in_policy: Optional["ScaleInPolicy"] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdate, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.upgrade_policy = upgrade_policy
        self.automatic_repairs_policy = automatic_repairs_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.overprovision = overprovision
        self.do_not_run_extensions_on_overprovisioned_v_ms = do_not_run_extensions_on_overprovisioned_v_ms
        self.single_placement_group = single_placement_group
        self.additional_capabilities = additional_capabilities
        self.scale_in_policy = scale_in_policy
        self.proximity_placement_group = proximity_placement_group


class VirtualMachineScaleSetUpdateIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration. NOTE: The subnet of a scale set may be modified as long as the original subnet and the new subnet are in the same virtual network.

    :param id: Resource Id.
    :type id: str
    :param name: The IP configuration name.
    :type name: str
    :param subnet: The subnet.
    :type subnet: ~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference
    :param primary: Specifies the primary IP Configuration in case the network interface has more
     than one IP Configuration.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2021_04_01.models.IPVersion
    :param application_gateway_backend_address_pools: The application gateway backend address
     pools.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param application_security_groups: Specifies an array of references to application security
     group.
    :type application_security_groups: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param load_balancer_backend_address_pools: The load balancer backend address pools.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    :param load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :type load_balancer_inbound_nat_pools: list[~azure.mgmt.compute.v2021_04_01.models.SubResource]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachineScaleSetUpdatePublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'application_security_groups': {'key': 'properties.applicationSecurityGroups', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        subnet: Optional["ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["VirtualMachineScaleSetUpdatePublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["SubResource"]] = None,
        application_security_groups: Optional[List["SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.application_security_groups = application_security_groups
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetUpdateNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    :param id: Resource Id.
    :type id: str
    :param name: The network configuration name.
    :type name: str
    :param primary: Whether this is a primary NIC on a virtual machine.
    :type primary: bool
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param enable_fpga: Specifies whether the network interface is FPGA networking-enabled.
    :type enable_fpga: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :param ip_configurations: The virtual machine scale set IP Configuration.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    :param delete_option: Specify what happens to the network interface when the VM is deleted.
     Possible values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'enable_fpga': {'key': 'properties.enableFpga', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetUpdateIPConfiguration]'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        enable_fpga: Optional[bool] = None,
        network_security_group: Optional["SubResource"] = None,
        dns_settings: Optional["VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["VirtualMachineScaleSetUpdateIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateNetworkConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.enable_fpga = enable_fpga
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding
        self.delete_option = delete_option


class VirtualMachineScaleSetUpdateNetworkProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set network profile.

    :param health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :type health_probe: ~azure.mgmt.compute.v2021_04_01.models.ApiEntityReference
    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
    :param network_api_version: specifies the Microsoft.Network API version used when creating
     networking resources in the Network Interface Configurations for Virtual Machine Scale Set with
     orchestration mode 'Flexible'. Possible values include: "2020-11-01".
    :type network_api_version: str or ~azure.mgmt.compute.v2021_04_01.models.NetworkApiVersion
    """

    _attribute_map = {
        'health_probe': {'key': 'healthProbe', 'type': 'ApiEntityReference'},
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetUpdateNetworkConfiguration]'},
        'network_api_version': {'key': 'networkApiVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["VirtualMachineScaleSetUpdateNetworkConfiguration"]] = None,
        network_api_version: Optional[Union[str, "NetworkApiVersion"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateNetworkProfile, self).__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations
        self.network_api_version = network_api_version


class VirtualMachineScaleSetUpdateOSDisk(msrest.serialization.Model):
    """Describes virtual machine scale set operating system disk Update Object. This should be used for Updating VMSS OS Disk.

    :param caching: The caching type. Possible values include: "None", "ReadOnly", "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2021_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :type image: ~azure.mgmt.compute.v2021_04_01.models.VirtualHardDisk
    :param vhd_containers: The list of virtual hard disk container uris.
    :type vhd_containers: list[str]
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _attribute_map = {
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        image: Optional["VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateOSDisk, self).__init__(**kwargs)
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.disk_size_gb = disk_size_gb
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetUpdateOSProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :param custom_data: A base-64 encoded string of custom data.
    :type custom_data: str
    :param windows_configuration: The Windows Configuration of the OS profile.
    :type windows_configuration: ~azure.mgmt.compute.v2021_04_01.models.WindowsConfiguration
    :param linux_configuration: The Linux Configuration of the OS profile.
    :type linux_configuration: ~azure.mgmt.compute.v2021_04_01.models.LinuxConfiguration
    :param secrets: The List of certificates for addition to the VM.
    :type secrets: list[~azure.mgmt.compute.v2021_04_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        *,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        linux_configuration: Optional["LinuxConfiguration"] = None,
        secrets: Optional[List["VaultSecretGroup"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateOSProfile, self).__init__(**kwargs)
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetUpdatePublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    :param name: The publicIP address configuration name.
    :type name: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :param delete_option: Specify what happens to the public IP when the VM is deleted. Possible
     values include: "Delete", "Detach".
    :type delete_option: str or ~azure.mgmt.compute.v2021_04_01.models.DeleteOptions
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings'},
        'delete_option': {'key': 'properties.deleteOption', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        delete_option: Optional[Union[str, "DeleteOptions"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdatePublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.delete_option = delete_option


class VirtualMachineScaleSetUpdateStorageProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: The image reference.
    :type image_reference: ~azure.mgmt.compute.v2021_04_01.models.ImageReference
    :param os_disk: The OS disk.
    :type os_disk: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateOSDisk
    :param data_disks: The data disks.
    :type data_disks: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetUpdateOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[VirtualMachineScaleSetDataDisk]'},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["ImageReference"] = None,
        os_disk: Optional["VirtualMachineScaleSetUpdateOSDisk"] = None,
        data_disks: Optional[List["VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateStorageProfile, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdateVMProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: The virtual machine scale set OS profile.
    :type os_profile: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateOSProfile
    :param storage_profile: The virtual machine scale set storage profile.
    :type storage_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateStorageProfile
    :param network_profile: The virtual machine scale set network profile.
    :type network_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetUpdateNetworkProfile
    :param security_profile: The virtual machine scale set Security profile.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.SecurityProfile
    :param diagnostics_profile: The virtual machine scale set diagnostics profile.
    :type diagnostics_profile: ~azure.mgmt.compute.v2021_04_01.models.DiagnosticsProfile
    :param extension_profile: The virtual machine scale set extension profile.
    :type extension_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetExtensionProfile
    :param license_type: The license type, which is for bring your own license scenario.
    :type license_type: str
    :param billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2021_04_01.models.BillingProfile
    :param scheduled_events_profile: Specifies Scheduled Event related configurations.
    :type scheduled_events_profile: ~azure.mgmt.compute.v2021_04_01.models.ScheduledEventsProfile
    :param user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :type user_data: str
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetUpdateOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetUpdateStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetUpdateNetworkProfile'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'billing_profile': {'key': 'billingProfile', 'type': 'BillingProfile'},
        'scheduled_events_profile': {'key': 'scheduledEventsProfile', 'type': 'ScheduledEventsProfile'},
        'user_data': {'key': 'userData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["VirtualMachineScaleSetUpdateOSProfile"] = None,
        storage_profile: Optional["VirtualMachineScaleSetUpdateStorageProfile"] = None,
        network_profile: Optional["VirtualMachineScaleSetUpdateNetworkProfile"] = None,
        security_profile: Optional["SecurityProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        extension_profile: Optional["VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        billing_profile: Optional["BillingProfile"] = None,
        scheduled_events_profile: Optional["ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateVMProfile, self).__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.billing_profile = billing_profile
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data


class VirtualMachineScaleSetVM(Resource):
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2021_04_01.models.Sku
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2021_04_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtension]
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVMInstanceView
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2021_04_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2021_04_01.models.StorageProfile
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine in the scale set. For instance: whether the virtual machine has the capability
     to support attaching managed data disks with UltraSSD_LRS storage account type.
    :type additional_capabilities: ~azure.mgmt.compute.v2021_04_01.models.AdditionalCapabilities
    :param os_profile: Specifies the operating system settings for the virtual machine.
    :type os_profile: ~azure.mgmt.compute.v2021_04_01.models.OSProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.SecurityProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2021_04_01.models.NetworkProfile
    :param network_profile_configuration: Specifies the network profile configuration of the
     virtual machine.
    :type network_profile_configuration:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVMNetworkProfileConfiguration
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2021_04_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar model_definition_applied: Specifies whether the model applied to the virtual machine is
     the model of the virtual machine scale set or the customized model for the virtual machine.
    :vartype model_definition_applied: str
    :param protection_policy: Specifies the protection policy of the virtual machine.
    :type protection_policy:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVMProtectionPolicy
    :param user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :type user_data: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'instance_id': {'readonly': True},
        'sku': {'readonly': True},
        'resources': {'readonly': True},
        'zones': {'readonly': True},
        'latest_model_applied': {'readonly': True},
        'vm_id': {'readonly': True},
        'instance_view': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'model_definition_applied': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'latest_model_applied': {'key': 'properties.latestModelApplied', 'type': 'bool'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineScaleSetVMInstanceView'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'SecurityProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'network_profile_configuration': {'key': 'properties.networkProfileConfiguration', 'type': 'VirtualMachineScaleSetVMNetworkProfileConfiguration'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'model_definition_applied': {'key': 'properties.modelDefinitionApplied', 'type': 'str'},
        'protection_policy': {'key': 'properties.protectionPolicy', 'type': 'VirtualMachineScaleSetVMProtectionPolicy'},
        'user_data': {'key': 'properties.userData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["StorageProfile"] = None,
        additional_capabilities: Optional["AdditionalCapabilities"] = None,
        os_profile: Optional["OSProfile"] = None,
        security_profile: Optional["SecurityProfile"] = None,
        network_profile: Optional["NetworkProfile"] = None,
        network_profile_configuration: Optional["VirtualMachineScaleSetVMNetworkProfileConfiguration"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        availability_set: Optional["SubResource"] = None,
        license_type: Optional[str] = None,
        protection_policy: Optional["VirtualMachineScaleSetVMProtectionPolicy"] = None,
        user_data: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVM, self).__init__(location=location, tags=tags, **kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = plan
        self.resources = None
        self.zones = None
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.security_profile = security_profile
        self.network_profile = network_profile
        self.network_profile_configuration = network_profile_configuration
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.license_type = license_type
        self.model_definition_applied = None
        self.protection_policy = protection_policy
        self.user_data = user_data


class VirtualMachineScaleSetVMExtension(SubResourceReadOnly):
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The virtual machine extension instance view.
    :type instance_view: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineExtensionInstanceView'},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        instance_view: Optional["VirtualMachineExtensionInstanceView"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtension, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class VirtualMachineScaleSetVMExtensionsListResult(msrest.serialization.Model):
    """The List VMSS VM Extension operation response.

    :param value: The list of VMSS VM extensions.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVMExtension]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetVMExtension]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualMachineScaleSetVMExtension"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionsListResult, self).__init__(**kwargs)
        self.value = value


class VirtualMachineScaleSetVMExtensionsSummary(msrest.serialization.Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'name': {'readonly': True},
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionsSummary, self).__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMExtensionUpdate(SubResourceReadOnly):
    """Describes a VMSS VM Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: The name of the extension.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param enable_automatic_upgrade: Indicates whether the extension should be automatically
     upgraded by the platform if there is a newer version of the extension available.
    :type enable_automatic_upgrade: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: any
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: any
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'enable_automatic_upgrade': {'key': 'properties.enableAutomaticUpgrade', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        enable_automatic_upgrade: Optional[bool] = None,
        settings: Optional[Any] = None,
        protected_settings: Optional[Any] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionUpdate, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.enable_automatic_upgrade = enable_automatic_upgrade
        self.settings = settings
        self.protected_settings = protected_settings


class VirtualMachineScaleSetVMInstanceIDs(msrest.serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :param instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        instance_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceIDs, self).__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceRequiredIDs(msrest.serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :param instance_ids: Required. The virtual machine scale set instance ids.
    :type instance_ids: list[str]
    """

    _validation = {
        'instance_ids': {'required': True},
    }

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        instance_ids: List[str],
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceRequiredIDs, self).__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine scale set VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param platform_update_domain: The Update Domain count.
    :type platform_update_domain: int
    :param platform_fault_domain: The Fault Domain count.
    :type platform_fault_domain: int
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineAgentInstanceView
    :param maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :type maintenance_redeploy_status:
     ~azure.mgmt.compute.v2021_04_01.models.MaintenanceRedeployStatus
    :param disks: The disks information.
    :type disks: list[~azure.mgmt.compute.v2021_04_01.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineHealthStatus
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2021_04_01.models.BootDiagnosticsInstanceView
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2021_04_01.models.InstanceViewStatus]
    :ivar assigned_host: Resource id of the dedicated host, on which the virtual machine is
     allocated through automatic placement, when the virtual machine is associated with a dedicated
     host group that has automatic placement enabled. :code:`<br>`:code:`<br>`Minimum api-version:
     2020-06-01.
    :vartype assigned_host: str
    :param placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :type placement_group_id: str
    """

    _validation = {
        'vm_health': {'readonly': True},
        'assigned_host': {'readonly': True},
    }

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'maintenance_redeploy_status': {'key': 'maintenanceRedeployStatus', 'type': 'MaintenanceRedeployStatus'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'vm_health': {'key': 'vmHealth', 'type': 'VirtualMachineHealthStatus'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'assigned_host': {'key': 'assignedHost', 'type': 'str'},
        'placement_group_id': {'key': 'placementGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["MaintenanceRedeployStatus"] = None,
        disks: Optional[List["DiskInstanceView"]] = None,
        extensions: Optional[List["VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        placement_group_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses
        self.assigned_host = None
        self.placement_group_id = placement_group_id


class VirtualMachineScaleSetVMListResult(msrest.serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets VMs.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetVM]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetVM]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSetVM"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetVMNetworkProfileConfiguration(msrest.serialization.Model):
    """Describes a virtual machine scale set VM network profile.

    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetNetworkConfiguration]'},
    }

    def __init__(
        self,
        *,
        network_interface_configurations: Optional[List["VirtualMachineScaleSetNetworkConfiguration"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMNetworkProfileConfiguration, self).__init__(**kwargs)
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetVMProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: Specifies the operating system settings for the virtual machines in the
     scale set.
    :type os_profile: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetOSProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetStorageProfile
    :param network_profile: Specifies properties of the network interfaces of the virtual machines
     in the scale set.
    :type network_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetNetworkProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machines in the scale set.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.SecurityProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2021_04_01.models.DiagnosticsProfile
    :param extension_profile: Specifies a collection of settings for extensions installed on
     virtual machines in the scale set.
    :type extension_profile:
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineScaleSetExtensionProfile
    :param license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :param priority: Specifies the priority for the virtual machines in the scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Possible values include:
     "Regular", "Low", "Spot".
    :type priority: str or ~azure.mgmt.compute.v2021_04_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Possible values include: "Deallocate",
     "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineEvictionPolicyTypes
    :param billing_profile: Specifies the billing related details of a Azure Spot VMSS.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2021_04_01.models.BillingProfile
    :param scheduled_events_profile: Specifies Scheduled Event related configurations.
    :type scheduled_events_profile: ~azure.mgmt.compute.v2021_04_01.models.ScheduledEventsProfile
    :param user_data: UserData for the virtual machines in the scale set, which must be base-64
     encoded. Customer should not pass any secrets in here. :code:`<br>`:code:`<br>`Minimum
     api-version: 2021-03-01.
    :type user_data: str
    :param capacity_reservation: Specifies the capacity reservation related details of a scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :type capacity_reservation: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationProfile
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetNetworkProfile'},
        'security_profile': {'key': 'securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'str'},
        'eviction_policy': {'key': 'evictionPolicy', 'type': 'str'},
        'billing_profile': {'key': 'billingProfile', 'type': 'BillingProfile'},
        'scheduled_events_profile': {'key': 'scheduledEventsProfile', 'type': 'ScheduledEventsProfile'},
        'user_data': {'key': 'userData', 'type': 'str'},
        'capacity_reservation': {'key': 'capacityReservation', 'type': 'CapacityReservationProfile'},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["VirtualMachineScaleSetNetworkProfile"] = None,
        security_profile: Optional["SecurityProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        extension_profile: Optional["VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        priority: Optional[Union[str, "VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["BillingProfile"] = None,
        scheduled_events_profile: Optional["ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["CapacityReservationProfile"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMProfile, self).__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation


class VirtualMachineScaleSetVMProtectionPolicy(msrest.serialization.Model):
    """The protection policy of a virtual machine scale set VM.

    :param protect_from_scale_in: Indicates that the virtual machine scale set VM shouldn't be
     considered for deletion during a scale-in operation.
    :type protect_from_scale_in: bool
    :param protect_from_scale_set_actions: Indicates that model updates or actions (including
     scale-in) initiated on the virtual machine scale set should not be applied to the virtual
     machine scale set VM.
    :type protect_from_scale_set_actions: bool
    """

    _attribute_map = {
        'protect_from_scale_in': {'key': 'protectFromScaleIn', 'type': 'bool'},
        'protect_from_scale_set_actions': {'key': 'protectFromScaleSetActions', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        protect_from_scale_in: Optional[bool] = None,
        protect_from_scale_set_actions: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMProtectionPolicy, self).__init__(**kwargs)
        self.protect_from_scale_in = protect_from_scale_in
        self.protect_from_scale_set_actions = protect_from_scale_set_actions


class VirtualMachineSize(msrest.serialization.Model):
    """Describes the properties of a VM size.

    :param name: The name of the virtual machine size.
    :type name: str
    :param number_of_cores: The number of cores supported by the virtual machine size. For
     Constrained vCPU capable VM sizes, this number represents the total vCPUs of quota that the VM
     uses. For accurate vCPU count, please refer to
     https://docs.microsoft.com/azure/virtual-machines/constrained-vcpu or
     https://docs.microsoft.com/rest/api/compute/resourceskus/list.
    :type number_of_cores: int
    :param os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :type os_disk_size_in_mb: int
    :param resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :type resource_disk_size_in_mb: int
    :param memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :type memory_in_mb: int
    :param max_data_disk_count: The maximum number of data disks that can be attached to the
     virtual machine size.
    :type max_data_disk_count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'os_disk_size_in_mb': {'key': 'osDiskSizeInMB', 'type': 'int'},
        'resource_disk_size_in_mb': {'key': 'resourceDiskSizeInMB', 'type': 'int'},
        'memory_in_mb': {'key': 'memoryInMB', 'type': 'int'},
        'max_data_disk_count': {'key': 'maxDataDiskCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_cores: Optional[int] = None,
        os_disk_size_in_mb: Optional[int] = None,
        resource_disk_size_in_mb: Optional[int] = None,
        memory_in_mb: Optional[int] = None,
        max_data_disk_count: Optional[int] = None,
        **kwargs
    ):
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = name
        self.number_of_cores = number_of_cores
        self.os_disk_size_in_mb = os_disk_size_in_mb
        self.resource_disk_size_in_mb = resource_disk_size_in_mb
        self.memory_in_mb = memory_in_mb
        self.max_data_disk_count = max_data_disk_count


class VirtualMachineSizeListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    :param value: The list of virtual machine sizes.
    :type value: list[~azure.mgmt.compute.v2021_04_01.models.VirtualMachineSize]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineSize]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualMachineSize"]] = None,
        **kwargs
    ):
        super(VirtualMachineSizeListResult, self).__init__(**kwargs)
        self.value = value


class VirtualMachineSoftwarePatchProperties(msrest.serialization.Model):
    """Describes the properties of a Virtual Machine software patch.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar patch_id: A unique identifier for the patch.
    :vartype patch_id: str
    :ivar name: The friendly name of the patch.
    :vartype name: str
    :ivar version: The version number of the patch. This property applies only to Linux patches.
    :vartype version: str
    :ivar kb_id: The KBID of the patch. Only applies to Windows patches.
    :vartype kb_id: str
    :ivar classifications: The classification(s) of the patch as provided by the patch publisher.
    :vartype classifications: list[str]
    :ivar reboot_behavior: Describes the reboot requirements of the patch. Possible values include:
     "Unknown", "NeverReboots", "AlwaysRequiresReboot", "CanRequestReboot".
    :vartype reboot_behavior: str or
     ~azure.mgmt.compute.v2021_04_01.models.VMGuestPatchRebootBehavior
    :ivar activity_id: The activity ID of the operation that produced this result. It is used to
     correlate across CRP and extension logs.
    :vartype activity_id: str
    :ivar published_date: The UTC timestamp when the repository published this patch.
    :vartype published_date: ~datetime.datetime
    :ivar last_modified_date_time: The UTC timestamp of the last update to this patch record.
    :vartype last_modified_date_time: ~datetime.datetime
    :ivar assessment_state: Describes the availability of a given patch. Possible values include:
     "Unknown", "Available".
    :vartype assessment_state: str or ~azure.mgmt.compute.v2021_04_01.models.PatchAssessmentState
    """

    _validation = {
        'patch_id': {'readonly': True},
        'name': {'readonly': True},
        'version': {'readonly': True},
        'kb_id': {'readonly': True},
        'classifications': {'readonly': True},
        'reboot_behavior': {'readonly': True},
        'activity_id': {'readonly': True},
        'published_date': {'readonly': True},
        'last_modified_date_time': {'readonly': True},
        'assessment_state': {'readonly': True},
    }

    _attribute_map = {
        'patch_id': {'key': 'patchId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'kb_id': {'key': 'kbId', 'type': 'str'},
        'classifications': {'key': 'classifications', 'type': '[str]'},
        'reboot_behavior': {'key': 'rebootBehavior', 'type': 'str'},
        'activity_id': {'key': 'activityId', 'type': 'str'},
        'published_date': {'key': 'publishedDate', 'type': 'iso-8601'},
        'last_modified_date_time': {'key': 'lastModifiedDateTime', 'type': 'iso-8601'},
        'assessment_state': {'key': 'assessmentState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSoftwarePatchProperties, self).__init__(**kwargs)
        self.patch_id = None
        self.name = None
        self.version = None
        self.kb_id = None
        self.classifications = None
        self.reboot_behavior = None
        self.activity_id = None
        self.published_date = None
        self.last_modified_date_time = None
        self.assessment_state = None


class VirtualMachineStatusCodeCount(msrest.serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        'code': {'readonly': True},
        'count': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineStatusCodeCount, self).__init__(**kwargs)
        self.code = None
        self.count = None


class VirtualMachineUpdate(UpdateResource):
    """Describes a Virtual Machine Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2021_04_01.models.Plan
    :param identity: The identity of the virtual machine, if configured.
    :type identity: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineIdentity
    :param zones: The virtual machine zones.
    :type zones: list[str]
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2021_04_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2021_04_01.models.StorageProfile
    :param additional_capabilities: Specifies additional capabilities enabled or disabled on the
     virtual machine.
    :type additional_capabilities: ~azure.mgmt.compute.v2021_04_01.models.AdditionalCapabilities
    :param os_profile: Specifies the operating system settings used while creating the virtual
     machine. Some of the settings cannot be changed once VM is provisioned.
    :type os_profile: ~azure.mgmt.compute.v2021_04_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2021_04_01.models.NetworkProfile
    :param security_profile: Specifies the Security related profile settings for the virtual
     machine.
    :type security_profile: ~azure.mgmt.compute.v2021_04_01.models.SecurityProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2021_04_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Availability sets overview
     <https://docs.microsoft.com/azure/virtual-machines/availability-set-overview>`_.
     :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Maintenance
     and updates for Virtual Machines in Azure
     <https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. The availability set to which the VM is being added should be under the same resource
     group as the availability set resource. An existing VM cannot be added to an availability set.
     :code:`<br>`:code:`<br>`This property cannot exist along with a non-null
     properties.virtualMachineScaleSet reference.
    :type availability_set: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param virtual_machine_scale_set: Specifies information about the virtual machine scale set
     that the virtual machine should be assigned to. Virtual machines specified in the same virtual
     machine scale set are allocated to different nodes to maximize availability. Currently, a VM
     can only be added to virtual machine scale set at creation time. An existing VM cannot be added
     to a virtual machine scale set. :code:`<br>`:code:`<br>`This property cannot exist along with a
     non-null properties.availabilitySet reference. :code:`<br>`:code:`<br>`Minimum api‐version:
     2019‐03‐01.
    :type virtual_machine_scale_set: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param priority: Specifies the priority for the virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01. Possible values include: "Regular",
     "Low", "Spot".
    :type priority: str or ~azure.mgmt.compute.v2021_04_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for the Azure Spot virtual machine and
     Azure Spot scale set. :code:`<br>`:code:`<br>`For Azure Spot virtual machines, both
     'Deallocate' and 'Delete' are supported and the minimum api-version is 2019-03-01.
     :code:`<br>`:code:`<br>`For Azure Spot scale sets, both 'Deallocate' and 'Delete' are supported
     and the minimum api-version is 2017-10-30-preview. Possible values include: "Deallocate",
     "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineEvictionPolicyTypes
    :param billing_profile: Specifies the billing related details of a Azure Spot virtual machine.
     :code:`<br>`:code:`<br>`Minimum api-version: 2019-03-01.
    :type billing_profile: ~azure.mgmt.compute.v2021_04_01.models.BillingProfile
    :param host: Specifies information about the dedicated host that the virtual machine resides
     in. :code:`<br>`:code:`<br>`Minimum api-version: 2018-10-01.
    :type host: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :param host_group: Specifies information about the dedicated host group that the virtual
     machine resides in. :code:`<br>`:code:`<br>`Minimum api-version: 2020-06-01.
     :code:`<br>`:code:`<br>`NOTE: User cannot specify both host and hostGroup properties.
    :type host_group: ~azure.mgmt.compute.v2021_04_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2021_04_01.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used was licensed
     on-premises. :code:`<br>`:code:`<br>` Possible values for Windows Server operating system are:
     :code:`<br>`:code:`<br>` Windows_Client :code:`<br>`:code:`<br>` Windows_Server
     :code:`<br>`:code:`<br>` Possible values for Linux Server operating system are:
     :code:`<br>`:code:`<br>` RHEL_BYOS (for RHEL) :code:`<br>`:code:`<br>` SLES_BYOS (for SUSE)
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/windows/hybrid-use-benefit-licensing>`_
     :code:`<br>`:code:`<br>` `Azure Hybrid Use Benefit for Linux Server
     <https://docs.microsoft.com/azure/virtual-machines/linux/azure-hybrid-benefit-linux>`_
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    :param extensions_time_budget: Specifies the time alloted for all extensions to start. The time
     duration should be between 15 minutes and 120 minutes (inclusive) and should be specified in
     ISO 8601 format. The default value is 90 minutes (PT1H30M). :code:`<br>`:code:`<br>` Minimum
     api-version: 2020-06-01.
    :type extensions_time_budget: str
    :param platform_fault_domain: Specifies the scale set logical fault domain into which the
     Virtual Machine will be created. By default, the Virtual Machine will by automatically assigned
     to a fault domain that best maintains balance across available fault
     domains.:code:`<br>`:code:`<li>`This is applicable only if the 'virtualMachineScaleSet'
     property of this Virtual Machine is set.:code:`<li>`The Virtual Machine Scale Set that is
     referenced, must have 'platformFaultDomainCount' &gt; 1.:code:`<li>`This property cannot be
     updated once the Virtual Machine is created.:code:`<li>`Fault domain assignment can be viewed
     in the Virtual Machine Instance View.:code:`<br>`:code:`<br>`Minimum api‐version: 2020‐12‐01.
    :type platform_fault_domain: int
    :param scheduled_events_profile: Specifies Scheduled Event related configurations.
    :type scheduled_events_profile: ~azure.mgmt.compute.v2021_04_01.models.ScheduledEventsProfile
    :param user_data: UserData for the VM, which must be base-64 encoded. Customer should not pass
     any secrets in here. :code:`<br>`:code:`<br>`Minimum api-version: 2021-03-01.
    :type user_data: str
    :param capacity_reservation: Specifies information about the capacity reservation that is used
     to allocate virtual machine. :code:`<br>`:code:`<br>`Minimum api-version: 2021-04-01.
    :type capacity_reservation: ~azure.mgmt.compute.v2021_04_01.models.CapacityReservationProfile
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'additional_capabilities': {'key': 'properties.additionalCapabilities', 'type': 'AdditionalCapabilities'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'security_profile': {'key': 'properties.securityProfile', 'type': 'SecurityProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'virtual_machine_scale_set': {'key': 'properties.virtualMachineScaleSet', 'type': 'SubResource'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'priority': {'key': 'properties.priority', 'type': 'str'},
        'eviction_policy': {'key': 'properties.evictionPolicy', 'type': 'str'},
        'billing_profile': {'key': 'properties.billingProfile', 'type': 'BillingProfile'},
        'host': {'key': 'properties.host', 'type': 'SubResource'},
        'host_group': {'key': 'properties.hostGroup', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'extensions_time_budget': {'key': 'properties.extensionsTimeBudget', 'type': 'str'},
        'platform_fault_domain': {'key': 'properties.platformFaultDomain', 'type': 'int'},
        'scheduled_events_profile': {'key': 'properties.scheduledEventsProfile', 'type': 'ScheduledEventsProfile'},
        'user_data': {'key': 'properties.userData', 'type': 'str'},
        'capacity_reservation': {'key': 'properties.capacityReservation', 'type': 'CapacityReservationProfile'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["StorageProfile"] = None,
        additional_capabilities: Optional["AdditionalCapabilities"] = None,
        os_profile: Optional["OSProfile"] = None,
        network_profile: Optional["NetworkProfile"] = None,
        security_profile: Optional["SecurityProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        availability_set: Optional["SubResource"] = None,
        virtual_machine_scale_set: Optional["SubResource"] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        priority: Optional[Union[str, "VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "VirtualMachineEvictionPolicyTypes"]] = None,
        billing_profile: Optional["BillingProfile"] = None,
        host: Optional["SubResource"] = None,
        host_group: Optional["SubResource"] = None,
        license_type: Optional[str] = None,
        extensions_time_budget: Optional[str] = None,
        platform_fault_domain: Optional[int] = None,
        scheduled_events_profile: Optional["ScheduledEventsProfile"] = None,
        user_data: Optional[str] = None,
        capacity_reservation: Optional["CapacityReservationProfile"] = None,
        **kwargs
    ):
        super(VirtualMachineUpdate, self).__init__(tags=tags, **kwargs)
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.additional_capabilities = additional_capabilities
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.security_profile = security_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.virtual_machine_scale_set = virtual_machine_scale_set
        self.proximity_placement_group = proximity_placement_group
        self.priority = priority
        self.eviction_policy = eviction_policy
        self.billing_profile = billing_profile
        self.host = host
        self.host_group = host_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None
        self.extensions_time_budget = extensions_time_budget
        self.platform_fault_domain = platform_fault_domain
        self.scheduled_events_profile = scheduled_events_profile
        self.user_data = user_data
        self.capacity_reservation = capacity_reservation


class VMScaleSetConvertToSinglePlacementGroupInput(msrest.serialization.Model):
    """VMScaleSetConvertToSinglePlacementGroupInput.

    :param active_placement_group_id: Id of the placement group in which you want future virtual
     machine instances to be placed. To query placement group Id, please use Virtual Machine Scale
     Set VMs - Get API. If not provided, the platform will choose one with maximum number of virtual
     machine instances.
    :type active_placement_group_id: str
    """

    _attribute_map = {
        'active_placement_group_id': {'key': 'activePlacementGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        active_placement_group_id: Optional[str] = None,
        **kwargs
    ):
        super(VMScaleSetConvertToSinglePlacementGroupInput, self).__init__(**kwargs)
        self.active_placement_group_id = active_placement_group_id


class WindowsConfiguration(msrest.serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :param provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :type provision_vm_agent: bool
    :param enable_automatic_updates: Indicates whether Automatic Updates is enabled for the Windows
     virtual machine. Default value is true. :code:`<br>`:code:`<br>` For virtual machine scale
     sets, this property can be updated and updates will take effect on OS reprovisioning.
    :type enable_automatic_updates: bool
    :param time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
     :code:`<br>`:code:`<br>` Possible values can be `TimeZoneInfo.Id
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.id?#System_TimeZoneInfo_Id>`_ value
     from time zones returned by `TimeZoneInfo.GetSystemTimeZones
     <https://docs.microsoft.com/dotnet/api/system.timezoneinfo.getsystemtimezones>`_.
    :type time_zone: str
    :param additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :type additional_unattend_content:
     list[~azure.mgmt.compute.v2021_04_01.models.AdditionalUnattendContent]
    :param patch_settings: [Preview Feature] Specifies settings related to VM Guest Patching on
     Windows.
    :type patch_settings: ~azure.mgmt.compute.v2021_04_01.models.PatchSettings
    :param win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :type win_rm: ~azure.mgmt.compute.v2021_04_01.models.WinRMConfiguration
    """

    _attribute_map = {
        'provision_vm_agent': {'key': 'provisionVMAgent', 'type': 'bool'},
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'additional_unattend_content': {'key': 'additionalUnattendContent', 'type': '[AdditionalUnattendContent]'},
        'patch_settings': {'key': 'patchSettings', 'type': 'PatchSettings'},
        'win_rm': {'key': 'winRM', 'type': 'WinRMConfiguration'},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["AdditionalUnattendContent"]] = None,
        patch_settings: Optional["PatchSettings"] = None,
        win_rm: Optional["WinRMConfiguration"] = None,
        **kwargs
    ):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.enable_automatic_updates = enable_automatic_updates
        self.time_zone = time_zone
        self.additional_unattend_content = additional_unattend_content
        self.patch_settings = patch_settings
        self.win_rm = win_rm


class WindowsParameters(msrest.serialization.Model):
    """Input for InstallPatches on a Windows VM, as directly received by the API.

    :param classifications_to_include: The update classifications to select when installing patches
     for Windows.
    :type classifications_to_include: list[str or
     ~azure.mgmt.compute.v2021_04_01.models.VMGuestPatchClassificationWindows]
    :param kb_numbers_to_include: Kbs to include in the patch operation.
    :type kb_numbers_to_include: list[str]
    :param kb_numbers_to_exclude: Kbs to exclude in the patch operation.
    :type kb_numbers_to_exclude: list[str]
    :param exclude_kbs_requiring_reboot: Filters out Kbs that don't have an
     InstallationRebootBehavior of 'NeverReboots' when this is set to true.
    :type exclude_kbs_requiring_reboot: bool
    :param max_patch_publish_date: This is used to install patches that were published on or before
     this given max published date.
    :type max_patch_publish_date: ~datetime.datetime
    """

    _attribute_map = {
        'classifications_to_include': {'key': 'classificationsToInclude', 'type': '[str]'},
        'kb_numbers_to_include': {'key': 'kbNumbersToInclude', 'type': '[str]'},
        'kb_numbers_to_exclude': {'key': 'kbNumbersToExclude', 'type': '[str]'},
        'exclude_kbs_requiring_reboot': {'key': 'excludeKbsRequiringReboot', 'type': 'bool'},
        'max_patch_publish_date': {'key': 'maxPatchPublishDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        classifications_to_include: Optional[List[Union[str, "VMGuestPatchClassificationWindows"]]] = None,
        kb_numbers_to_include: Optional[List[str]] = None,
        kb_numbers_to_exclude: Optional[List[str]] = None,
        exclude_kbs_requiring_reboot: Optional[bool] = None,
        max_patch_publish_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(WindowsParameters, self).__init__(**kwargs)
        self.classifications_to_include = classifications_to_include
        self.kb_numbers_to_include = kb_numbers_to_include
        self.kb_numbers_to_exclude = kb_numbers_to_exclude
        self.exclude_kbs_requiring_reboot = exclude_kbs_requiring_reboot
        self.max_patch_publish_date = max_patch_publish_date


class WinRMConfiguration(msrest.serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :param listeners: The list of Windows Remote Management listeners.
    :type listeners: list[~azure.mgmt.compute.v2021_04_01.models.WinRMListener]
    """

    _attribute_map = {
        'listeners': {'key': 'listeners', 'type': '[WinRMListener]'},
    }

    def __init__(
        self,
        *,
        listeners: Optional[List["WinRMListener"]] = None,
        **kwargs
    ):
        super(WinRMConfiguration, self).__init__(**kwargs)
        self.listeners = listeners


class WinRMListener(msrest.serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :param protocol: Specifies the protocol of WinRM listener. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.compute.v2021_04_01.models.ProtocolTypes
    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`
     "data":":code:`<Base64-encoded-certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`
     "password":":code:`<pfx-file-password>`":code:`<br>`} :code:`<br>` To install certificates on a
     virtual machine it is recommended to use the `Azure Key Vault virtual machine extension for
     Linux <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-linux>`_ or the
     `Azure Key Vault virtual machine extension for Windows
     <https://docs.microsoft.com/azure/virtual-machines/extensions/key-vault-windows>`_.
    :type certificate_url: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
        **kwargs
    ):
        super(WinRMListener, self).__init__(**kwargs)
        self.protocol = protocol
        self.certificate_url = certificate_url
