# Generated by Django 2.0.9 on 2020-03-12 17:31

from django.db import migrations, models
import django.db.models.deletion
from django.conf import settings

class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Attribute',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order', models.PositiveIntegerField(db_index=True, editable=False, verbose_name='order')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, verbose_name='Code')),
                ('type', models.PositiveSmallIntegerField(choices=[(1, 'Text'), (2, 'Integer'), (3, 'True / False'), (5, 'Options')], default=1, verbose_name='Type')),
                ('is_required', models.BooleanField(default=False, help_text='You will not be able to update record without filling this field', verbose_name='Required')),
                ('is_visible', models.BooleanField(default=True, help_text='Display this attribute for users', verbose_name='Is visible')),
                ('is_filter', models.BooleanField(default=False, help_text='Display this attribute in records filter', verbose_name='Is filter')),
                ('categories', models.ManyToManyField(blank=True, related_name='attributes', to=settings.ATTRIBUTES_CATEGORY_MODEL, verbose_name='Categories')),
            ],
            options={
                'verbose_name': 'Attribute',
                'verbose_name_plural': 'Attributes',
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='AttributeOption',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('attr', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='options', to='attributes.Attribute', verbose_name='Attribute')),
            ],
            options={
                'verbose_name': 'Attribute option',
                'verbose_name_plural': 'Attribute options',
            },
        ),
        migrations.CreateModel(
            name='AttributeValue',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value_text', models.TextField(blank=True, null=True)),
                ('value_int', models.IntegerField(blank=True, null=True)),
                ('value_bool', models.NullBooleanField()),
                ('attr', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='values', to='attributes.Attribute')),
                ('entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='attr_values', to=settings.ATTRIBUTES_ENTRY_MODEL)),
                ('value_option', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='attr_values', to='attributes.AttributeOption')),
            ],
            options={
                'ordering': ('attr__order',),
            },
        ),
        migrations.AlterUniqueTogether(
            name='attributevalue',
            unique_together={('attr', 'entry')},
        ),
        migrations.AlterUniqueTogether(
            name='attributeoption',
            unique_together={('attr', 'name')},
        ),
    ]
