# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/domoDashboardConnection.json
#   timestamp: 2023-02-09T16:49:52+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field

from metadata.ingestion.models.custom_pydantic import CustomSecretStr

from .. import connectionBasicType


class DomoDashboardType(Enum):
    DomoDashboard = 'DomoDashboard'


class DomoDashboardConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DomoDashboardType] = Field(
        DomoDashboardType.DomoDashboard,
        description='Service Type',
        title='Service Type',
    )
    clientId: str = Field(..., description='Client ID for DOMO', title='Client ID')
    secretToken: CustomSecretStr = Field(
        ..., description='Secret Token to connect DOMO', title='Secret Token'
    )
    accessToken: Optional[str] = Field(
        None, description='Access token to connect to to DOMO', title='Access Token'
    )
    apiHost: Optional[str] = Field(
        'api.domo.com',
        description='API Host to connect to DOMO instance',
        title='API Host',
    )
    sandboxDomain: AnyUrl = Field(
        ..., description='Connect to Sandbox Domain', title='Sandbox Domain'
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
