# generated by datamodel-codegen:
#   filename:  api/services/ingestionPipelines/testServiceConnection.json
#   timestamp: 2023-02-09T16:49:52+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ....entity.services import (
    dashboardService,
    databaseService,
    messagingService,
    metadataService,
    mlmodelService,
    pipelineService,
)
from ....security.secrets import secretsManagerProvider


class ConnectionType(Enum):
    Database = 'Database'
    Dashboard = 'Dashboard'
    Messaging = 'Messaging'
    Pipeline = 'Pipeline'
    MlModel = 'MlModel'
    Metadata = 'Metadata'


class TestServiceConnectionRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    connection: Optional[
        Union[
            databaseService.DatabaseConnection,
            dashboardService.DashboardConnection,
            messagingService.MessagingConnection,
            pipelineService.PipelineConnection,
            mlmodelService.MlModelConnection,
            metadataService.MetadataConnection,
        ]
    ] = Field(None, description='Connection object.')
    connectionType: Optional[ConnectionType] = Field(
        None, description='Type of service such as Database, Dashboard, Messaging, etc.'
    )
    secretsManagerProvider: Optional[
        secretsManagerProvider.SecretsManagerProvider
    ] = secretsManagerProvider.SecretsManagerProvider.noop
