/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.visitor;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.renderer.visitor.IDrawVisitor;

@TestClass(value="org.openscience.cdk.renderer.visitor.AbstractAWTDrawVisitorTest")
public abstract class AbstractAWTDrawVisitor
implements IDrawVisitor {
    protected AffineTransform transform = null;

    @TestMethod(value="testTransformPoint")
    public int[] transformPoint(double xCoord, double yCoord) {
        double[] src = new double[]{xCoord, yCoord};
        double[] dest = new double[2];
        this.transform.transform(src, 0, dest, 0, 1);
        return new int[]{(int)dest[0], (int)dest[1]};
    }

    @TestMethod(value="testGetTextBounds")
    protected Rectangle2D getTextBounds(String text, double xCoord, double yCoord, Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D bounds = fontMetrics.getStringBounds(text, graphics);
        double widthPad = 3.0;
        double heightPad = 1.0;
        double width = bounds.getWidth() + widthPad;
        double height = bounds.getHeight() + heightPad;
        int[] point = this.transformPoint(xCoord, yCoord);
        return new Rectangle2D.Double((double)point[0] - width / 2.0, (double)point[1] - height / 2.0, width, height);
    }

    @TestMethod(value="testGetTextBasePoint")
    protected Point getTextBasePoint(String text, double xCoord, double yCoord, Graphics2D graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D stringBounds = fontMetrics.getStringBounds(text, graphics);
        int[] point = this.transformPoint(xCoord, yCoord);
        int baseX = (int)((double)point[0] - stringBounds.getWidth() / 2.0);
        int baseY = (int)((double)point[1] + ((double)fontMetrics.getAscent() - stringBounds.getHeight() / 2.0));
        return new Point(baseX, baseY);
    }

    @TestMethod(value="testSetAffineTransformation")
    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }
}

