/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import nu.xom.MalformedURIException;
import nu.xom.Verifier;

class URIUtil {
    URIUtil() {
    }

    static boolean isOpaque(String uri) {
        int colon = uri.indexOf(58);
        if (uri.substring(colon + 1).startsWith("/")) {
            return false;
        }
        return Verifier.isAlpha(uri.charAt(0));
    }

    static boolean isAbsolute(String uri) {
        int colon = uri.indexOf(58);
        return colon >= 1;
    }

    static String absolutize(String baseURI, String spec) {
        if ("".equals(baseURI) || baseURI == null) {
            return spec;
        }
        ParsedURI base = new ParsedURI(baseURI);
        if (base.path.endsWith("/..")) {
            base.path = base.path + '/';
        }
        ParsedURI R = new ParsedURI(spec);
        ParsedURI T = new ParsedURI();
        if (R.authority != null) {
            T.authority = R.authority;
            T.query = R.query;
            T.path = URIUtil.removeDotSegments(R.path);
        } else {
            if ("".equals(R.path)) {
                T.path = base.path;
                T.query = R.query != null ? R.query : base.query;
            } else {
                if (R.path.startsWith("/")) {
                    T.path = URIUtil.removeDotSegments(R.path);
                } else {
                    T.path = URIUtil.merge(base, R.path);
                    T.path = URIUtil.removeDotSegments(T.path);
                }
                T.query = R.query;
            }
            T.authority = base.authority;
        }
        T.scheme = base.scheme;
        T.fragment = R.fragment;
        return T.toString();
    }

    private static String merge(ParsedURI base, String relativePath) {
        if (base.authority != null && "".equals(base.path) && !"".equals(base.authority)) {
            return "/" + relativePath;
        }
        int lastSlash = base.path.lastIndexOf(47);
        if (lastSlash == -1) {
            return relativePath;
        }
        String topPath = base.path.substring(0, lastSlash + 1);
        return topPath + relativePath;
    }

    private static String removeDotSegments(String path) {
        String output = "";
        while (path.length() > 0) {
            int lastSlash;
            if (path.startsWith("/./")) {
                path = '/' + path.substring(3);
                continue;
            }
            if (path.equals("/.")) {
                path = "/";
                continue;
            }
            if (path.startsWith("/../")) {
                path = '/' + path.substring(4);
                lastSlash = output.lastIndexOf(47);
                if (lastSlash == -1) continue;
                output = output.substring(0, lastSlash);
                continue;
            }
            if (path.equals("/..")) {
                path = "/";
                lastSlash = output.lastIndexOf(47);
                if (lastSlash == -1) continue;
                output = output.substring(0, lastSlash);
                continue;
            }
            int nextSlash = path.indexOf(47);
            if (nextSlash == 0) {
                nextSlash = path.indexOf(47, 1);
            }
            if (nextSlash == -1) {
                output = output + path;
                path = "";
                continue;
            }
            output = output + path.substring(0, nextSlash);
            path = path.substring(nextSlash);
        }
        return output;
    }

    static String toURI(String iri) {
        int length = iri.length();
        StringBuffer uri = new StringBuffer(length);
        block97: for (int i = 0; i < length; ++i) {
            char c = iri.charAt(i);
            switch (c) {
                case ' ': {
                    uri.append("%20");
                    continue block97;
                }
                case '!': {
                    uri.append(c);
                    continue block97;
                }
                case '\"': {
                    uri.append("%22");
                    continue block97;
                }
                case '#': {
                    uri.append(c);
                    continue block97;
                }
                case '$': {
                    uri.append(c);
                    continue block97;
                }
                case '%': {
                    uri.append(c);
                    continue block97;
                }
                case '&': {
                    uri.append(c);
                    continue block97;
                }
                case '\'': {
                    uri.append(c);
                    continue block97;
                }
                case '(': {
                    uri.append(c);
                    continue block97;
                }
                case ')': {
                    uri.append(c);
                    continue block97;
                }
                case '*': {
                    uri.append(c);
                    continue block97;
                }
                case '+': {
                    uri.append(c);
                    continue block97;
                }
                case ',': {
                    uri.append(c);
                    continue block97;
                }
                case '-': {
                    uri.append(c);
                    continue block97;
                }
                case '.': {
                    uri.append(c);
                    continue block97;
                }
                case '/': {
                    uri.append(c);
                    continue block97;
                }
                case '0': {
                    uri.append(c);
                    continue block97;
                }
                case '1': {
                    uri.append(c);
                    continue block97;
                }
                case '2': {
                    uri.append(c);
                    continue block97;
                }
                case '3': {
                    uri.append(c);
                    continue block97;
                }
                case '4': {
                    uri.append(c);
                    continue block97;
                }
                case '5': {
                    uri.append(c);
                    continue block97;
                }
                case '6': {
                    uri.append(c);
                    continue block97;
                }
                case '7': {
                    uri.append(c);
                    continue block97;
                }
                case '8': {
                    uri.append(c);
                    continue block97;
                }
                case '9': {
                    uri.append(c);
                    continue block97;
                }
                case ':': {
                    uri.append(c);
                    continue block97;
                }
                case ';': {
                    uri.append(c);
                    continue block97;
                }
                case '<': {
                    uri.append("%3C");
                    continue block97;
                }
                case '=': {
                    uri.append(c);
                    continue block97;
                }
                case '>': {
                    uri.append("%3E");
                    continue block97;
                }
                case '?': {
                    uri.append(c);
                    continue block97;
                }
                case '@': {
                    uri.append(c);
                    continue block97;
                }
                case 'A': {
                    uri.append(c);
                    continue block97;
                }
                case 'B': {
                    uri.append(c);
                    continue block97;
                }
                case 'C': {
                    uri.append(c);
                    continue block97;
                }
                case 'D': {
                    uri.append(c);
                    continue block97;
                }
                case 'E': {
                    uri.append(c);
                    continue block97;
                }
                case 'F': {
                    uri.append(c);
                    continue block97;
                }
                case 'G': {
                    uri.append(c);
                    continue block97;
                }
                case 'H': {
                    uri.append(c);
                    continue block97;
                }
                case 'I': {
                    uri.append(c);
                    continue block97;
                }
                case 'J': {
                    uri.append(c);
                    continue block97;
                }
                case 'K': {
                    uri.append(c);
                    continue block97;
                }
                case 'L': {
                    uri.append(c);
                    continue block97;
                }
                case 'M': {
                    uri.append(c);
                    continue block97;
                }
                case 'N': {
                    uri.append(c);
                    continue block97;
                }
                case 'O': {
                    uri.append(c);
                    continue block97;
                }
                case 'P': {
                    uri.append(c);
                    continue block97;
                }
                case 'Q': {
                    uri.append(c);
                    continue block97;
                }
                case 'R': {
                    uri.append(c);
                    continue block97;
                }
                case 'S': {
                    uri.append(c);
                    continue block97;
                }
                case 'T': {
                    uri.append(c);
                    continue block97;
                }
                case 'U': {
                    uri.append(c);
                    continue block97;
                }
                case 'V': {
                    uri.append(c);
                    continue block97;
                }
                case 'W': {
                    uri.append(c);
                    continue block97;
                }
                case 'X': {
                    uri.append(c);
                    continue block97;
                }
                case 'Y': {
                    uri.append(c);
                    continue block97;
                }
                case 'Z': {
                    uri.append(c);
                    continue block97;
                }
                case '[': {
                    uri.append(c);
                    continue block97;
                }
                case '\\': {
                    uri.append("%5C");
                    continue block97;
                }
                case ']': {
                    uri.append(c);
                    continue block97;
                }
                case '^': {
                    uri.append("%5E");
                    continue block97;
                }
                case '_': {
                    uri.append(c);
                    continue block97;
                }
                case '`': {
                    uri.append("%60");
                    continue block97;
                }
                case 'a': {
                    uri.append(c);
                    continue block97;
                }
                case 'b': {
                    uri.append(c);
                    continue block97;
                }
                case 'c': {
                    uri.append(c);
                    continue block97;
                }
                case 'd': {
                    uri.append(c);
                    continue block97;
                }
                case 'e': {
                    uri.append(c);
                    continue block97;
                }
                case 'f': {
                    uri.append(c);
                    continue block97;
                }
                case 'g': {
                    uri.append(c);
                    continue block97;
                }
                case 'h': {
                    uri.append(c);
                    continue block97;
                }
                case 'i': {
                    uri.append(c);
                    continue block97;
                }
                case 'j': {
                    uri.append(c);
                    continue block97;
                }
                case 'k': {
                    uri.append(c);
                    continue block97;
                }
                case 'l': {
                    uri.append(c);
                    continue block97;
                }
                case 'm': {
                    uri.append(c);
                    continue block97;
                }
                case 'n': {
                    uri.append(c);
                    continue block97;
                }
                case 'o': {
                    uri.append(c);
                    continue block97;
                }
                case 'p': {
                    uri.append(c);
                    continue block97;
                }
                case 'q': {
                    uri.append(c);
                    continue block97;
                }
                case 'r': {
                    uri.append(c);
                    continue block97;
                }
                case 's': {
                    uri.append(c);
                    continue block97;
                }
                case 't': {
                    uri.append(c);
                    continue block97;
                }
                case 'u': {
                    uri.append(c);
                    continue block97;
                }
                case 'v': {
                    uri.append(c);
                    continue block97;
                }
                case 'w': {
                    uri.append(c);
                    continue block97;
                }
                case 'x': {
                    uri.append(c);
                    continue block97;
                }
                case 'y': {
                    uri.append(c);
                    continue block97;
                }
                case 'z': {
                    uri.append(c);
                    continue block97;
                }
                case '{': {
                    uri.append("%7B");
                    continue block97;
                }
                case '|': {
                    uri.append("%7C");
                    continue block97;
                }
                case '}': {
                    uri.append("%7D");
                    continue block97;
                }
                case '~': {
                    uri.append(c);
                    continue block97;
                }
                default: {
                    uri.append(URIUtil.percentEscape(c));
                }
            }
        }
        return uri.toString();
    }

    static String percentEscape(char c) {
        StringBuffer result = new StringBuffer(3);
        String s = String.valueOf(c);
        try {
            byte[] data = s.getBytes("UTF8");
            for (int i = 0; i < data.length; ++i) {
                result.append('%');
                String hex = Integer.toHexString(data[i]).toUpperCase();
                if (c < '\u0010') {
                    result.append('0');
                    result.append(hex);
                    continue;
                }
                result.append(hex.substring(hex.length() - 2));
            }
            return result.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Broken VM: does not recognize UTF-8 encoding");
        }
    }

    static String relativize(String base, String abs) {
        try {
            ParsedURI parsedBase = new ParsedURI(base);
            ParsedURI parsedAbs = new ParsedURI(abs);
            if (parsedBase.scheme.equals(parsedAbs.scheme) && parsedBase.authority.equals(parsedAbs.authority)) {
                String basePath = parsedBase.path;
                String relPath = parsedAbs.path;
                while (basePath.length() > 1) {
                    if (!relPath.startsWith(basePath = basePath.substring(0, basePath.lastIndexOf(47)))) continue;
                    return relPath.substring(basePath.length() + 1);
                }
                return relPath;
            }
            return abs;
        }
        catch (Exception ex) {
            return abs;
        }
    }

    static class ParsedURI {
        String scheme;
        String schemeSpecificPart;
        String query;
        String fragment;
        String authority;
        String path = "";

        ParsedURI(String spec) {
            int colon = spec.indexOf(58);
            int sharp = spec.lastIndexOf(35);
            int question = sharp == -1 ? spec.indexOf(63) : spec.substring(0, sharp).indexOf(63);
            if (colon != -1) {
                this.scheme = spec.substring(0, colon);
            }
            if (question == -1 && sharp == -1) {
                this.schemeSpecificPart = spec.substring(colon + 1);
            } else if (question != -1) {
                if (question < colon) {
                    MalformedURIException ex = new MalformedURIException("Unparseable URI");
                    ex.setData(spec);
                    throw ex;
                }
                this.schemeSpecificPart = spec.substring(colon + 1, question);
            } else {
                if (sharp < colon) {
                    MalformedURIException ex = new MalformedURIException("Unparseable URI");
                    ex.setData(spec);
                    throw ex;
                }
                this.schemeSpecificPart = spec.substring(colon + 1, sharp);
            }
            if (sharp != -1) {
                this.fragment = spec.substring(sharp + 1);
            }
            if (question != -1) {
                this.query = sharp == -1 ? spec.substring(question + 1) : spec.substring(question + 1, sharp);
            }
            if (this.schemeSpecificPart.startsWith("//")) {
                int authorityBegin = 2;
                int authorityEnd = this.schemeSpecificPart.indexOf(47, authorityBegin);
                if (authorityEnd == -1) {
                    this.authority = this.schemeSpecificPart.substring(2);
                    this.path = "";
                } else {
                    this.authority = this.schemeSpecificPart.substring(authorityBegin, authorityEnd);
                    this.path = this.schemeSpecificPart.substring(authorityEnd);
                }
            } else {
                this.path = this.schemeSpecificPart;
            }
        }

        ParsedURI() {
        }

        public String toString() {
            StringBuffer result = new StringBuffer(30);
            if (this.scheme != null) {
                result.append(this.scheme);
                result.append(':');
            }
            if (this.schemeSpecificPart != null) {
                result.append(this.schemeSpecificPart);
            } else {
                result.append("//");
                if (this.authority != null) {
                    result.append(this.authority);
                }
                result.append(this.path);
            }
            if (this.query != null) {
                result.append('?');
                result.append(this.query);
            }
            if (this.fragment != null) {
                result.append('#');
                result.append(this.fragment);
            }
            return result.toString();
        }
    }
}

