/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.ICUData;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ICUResourceBundleReader
implements ICUBinary.Authenticate {
    private static final byte[] DATA_FORMAT_ID = new byte[]{82, 101, 115, 66};
    private static final byte[] DATA_FORMAT_VERSION = new byte[]{1, 1, 0, 0};
    private byte[] version;
    private static final String ICU_RESOURCE_SUFFIX = ".res";
    private static final int URES_INDEX_LENGTH = 0;
    private static final int URES_INDEX_STRINGS_TOP = 1;
    private static final int URES_INDEX_RESOURCES_TOP = 2;
    private static final int URES_INDEX_BUNDLE_TOP = 3;
    private static final int URES_INDEX_MAX_TABLE_LENGTH = 4;
    private static final int URES_INDEX_TOP = 5;
    private static final boolean DEBUG = false;
    private byte[] data;

    private ICUResourceBundleReader(InputStream stream, String resolvedName) {
        BufferedInputStream bs = new BufferedInputStream(stream);
        try {
            this.version = ICUBinary.readHeader(bs, DATA_FORMAT_ID, this);
            this.data = ICUResourceBundleReader.readData(bs);
            stream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Data file " + resolvedName + " is corrupt.", ex);
        }
    }

    public static ICUResourceBundleReader getReader(String baseName, String localeName, ClassLoader root) {
        String resolvedName = ICUResourceBundleReader.getFullName(baseName, localeName);
        InputStream stream = ICUData.getStream(root, resolvedName);
        if (stream == null) {
            return null;
        }
        ICUResourceBundleReader reader = new ICUResourceBundleReader(stream, resolvedName);
        return reader;
    }

    private static byte[] readData(InputStream stream) throws IOException {
        DataInputStream ds = new DataInputStream(stream);
        ds.mark(24);
        int[] indexes = new int[5];
        ds.readInt();
        for (int i = 1; i < 5; ++i) {
            indexes[i] = ds.readInt();
        }
        ds.reset();
        int length = indexes[3] * 4;
        byte[] data = new byte[length];
        ds.readFully(data);
        return data;
    }

    public static String getFullName(String baseName, String localeName) {
        if (baseName.indexOf(46) == -1) {
            if (baseName.charAt(baseName.length() - 1) != '/') {
                return baseName + "/" + localeName + ICU_RESOURCE_SUFFIX;
            }
            return baseName + localeName + ICU_RESOURCE_SUFFIX;
        }
        baseName = baseName.replace('.', '/');
        if (localeName.length() == 0) {
            return baseName + ICU_RESOURCE_SUFFIX;
        }
        return baseName + "_" + localeName + ICU_RESOURCE_SUFFIX;
    }

    public VersionInfo getVersion() {
        return VersionInfo.getInstance(this.version[0], this.version[1], this.version[2], this.version[3]);
    }

    public boolean isDataVersionAcceptable(byte[] version2) {
        return version2[0] == DATA_FORMAT_VERSION[0] && version2[1] == DATA_FORMAT_VERSION[1] && version2[2] == DATA_FORMAT_VERSION[2] && version2[3] == DATA_FORMAT_VERSION[3];
    }

    public byte[] getData() {
        return this.data;
    }
}

