/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

public class ParsingException
extends Exception {
    private static final long serialVersionUID = -5185450480590174490L;
    private Throwable cause;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private String uri;
    private boolean causeSet = false;

    public ParsingException(String message, Throwable cause) {
        super(message);
        this.initCause(cause);
    }

    public ParsingException(String message, String uri, Throwable cause) {
        super(message);
        this.uri = uri;
        this.initCause(cause);
    }

    public ParsingException(String message, int lineNumber, int columnNumber) {
        this(message, null, lineNumber, columnNumber, null);
    }

    public ParsingException(String message, String uri, int lineNumber, int columnNumber) {
        this(message, uri, lineNumber, columnNumber, null);
    }

    public ParsingException(String message, String uri, int lineNumber, int columnNumber, Throwable cause) {
        super(message);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.uri = uri;
        this.initCause(cause);
    }

    public ParsingException(String message, int lineNumber, int columnNumber, Throwable cause) {
        super(message);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.initCause(cause);
    }

    public ParsingException(String message) {
        super(message);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getURI() {
        return this.uri;
    }

    public final Throwable initCause(Throwable cause) {
        if (this.causeSet) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.cause = cause;
        this.causeSet = true;
        return this;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        if (this.lineNumber >= 0) {
            result.append(" at line ");
            result.append(this.lineNumber);
            result.append(", column ");
            result.append(this.columnNumber);
        }
        if (this.uri != null) {
            result.append(" in ");
            result.append(this.uri);
        }
        return result.toString();
    }
}

