/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;

public class ImplicitHCountAtom
extends SMARTSAtom {
    private static final long serialVersionUID = 6752937431492584928L;

    public ImplicitHCountAtom(int hCount) {
        this.setImplicitHydrogenCount(hCount);
    }

    private int getIMPH(IAtom atom) {
        if (atom.getImplicitHydrogenCount() == CDKConstants.UNSET) {
            return 0;
        }
        return atom.getImplicitHydrogenCount();
    }

    public boolean matches(IAtom atom) {
        return this.getIMPH(atom) != 0 && this.getIMPH(atom) == this.getIMPH(this);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("ImplicitHCountAtom(");
        s.append(this.hashCode() + ", ");
        s.append("IH:" + this.getIMPH(this));
        s.append(")");
        return s.toString();
    }
}

