"""Repeat the following paper for `MRAS`:
    Hu, J., Fu, M.C. and Marcus, S.I., 2007.
    A model reference adaptive search method for global optimization.
    Operations Research, 55(3), pp.549-568.
    https://pubsonline.informs.org/doi/abs/10.1287/opre.1060.0367

    Luckily our Python code could repeat the data generated by the original paper *nearly well*.
    Therefore, we argue that its repeatability could be **well-documented**.
"""
import time

import numpy as np

from pypop7.benchmarks.base_functions import griewank
from pypop7.optimizers.cem.mras import MRAS as Solver


if __name__ == '__main__':
    start_run = time.time()
    ndim_problem = 20

    problem = {'fitness_function': griewank,
               'ndim_problem': ndim_problem,
               'lower_boundary': -50*np.ones((ndim_problem,)),
               'upper_boundary': 50*np.ones((ndim_problem,))}
    options = {'max_function_evaluations': 400000,
               'seed_rng': 0,
               'sigma': np.sqrt(500),
               'verbose': 20,
               'saving_fitness': 2000}
    solver = Solver(problem, options)
    results = solver.optimize()
    print(results)  # 3.87685168e-01 vs 4e7e−03 (from the original paper)
    print('*** Runtime: {:7.5e}'.format(time.time() - start_run))
