#!/usr/bin/env python
# -*- coding: utf-8 -*-


class QiwiError(Exception):
    pass


class QiwiServerError(Exception):
    pass


class PaymentHistoryError(Exception):
    pass


exception_codes = {'400': 'Ошибка синтаксиса запроса (неправильный формат данных)',
                   '401': 'Неверный токен или истек срок действия токена API',
                   '403': 'Нет прав на данный запрос (недостаточно разрешений у токена API)',
                   '423': 'Слишком много запросов, сервис временно недоступен',
                   '500': 'Внутренняя ошибка сервиса (превышена длина URL веб-хука, проблемы с инфраструктурой,'
                          ' недоступность каких-либо ресурсов и т.д.'
                   }


def main_exception(response):
    # TODO make check method for choice errors dict
    if response.status_code == 500:
        raise QiwiServerError()
    if response.status_code == 404:
        try:
            response = response.json()
            return response['description']
            # response['serviceName'], response['errorCode'],
        except AttributeError:
            return response
    return exception_codes.get(str(response.status_code)) or {response.status_code: f'Неизвестная ошибка: {response}'}


# Следующие ошибки возвращаются на запросы истории платежей и информации о транзакции в параметре errorCode ответа:

# 0 	OK
# 3 	Техническая ошибка, нельзя отправить запрос провайдеру
# 4 	Неверный формат счета/телефона
# 5 	Номер не принадлежит оператору
# 8 	Прием платежа запрещен по техническим причинам
# 131 	Платежи на выбранного провайдера запрещено проводить из данной страны.
# 202 	Ошибка в параметрах запроса
# 220 	Недостаточно средств
# 241 	Сумма платежа меньше минимальной
# 242 	Сумма платежа больше максимальной
# 319 	Платеж невозможен
# 500 	По техническим причинам этот платеж не может быть выполнен. Для совершения платежа обратитесь, пожалуйста, в свой обслуживающий банк
# 522 	Неверный номер или срок действия карты получателя
# 547 	Ошибка в сроке действия карты получателя
# 548 	Истек срок действия карты получателя
# 561 	Платеж отвергнут оператором банка получателя
# 702 	Платеж не проведен из-за ограничений у получателя. Подробности по телефону: 8-800-707-77-59
# 705 	Ежемесячный лимит платежей и переводов для статуса Стандарт - 200 000 р. Для увеличения лимита пройдите идентификацию.
# 746 	Превышен лимит по платежам в пользу провайдера
# 852 	Превышен лимит по платежам в пользу провайдера
# 893 	Срок действия перевода истек
# 1050 	Превышен лимит на операции, либо превышен дневной лимит на переводы на карты Visa/MasterCard

def payment_history_exception(response):
    return exception_codes.get('response.status_code') or {response.status_code: 'Неизвестная ошибка'}
