"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ParameterGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const rds_generated_1 = require("./rds.generated");
/**
 * A parameter group.
 *
 * Represents both a cluster parameter group,
 * and an instance parameter group.
 *
 * @stability stable
 * @resource AWS::RDS::DBParameterGroup
 */
class ParameterGroup extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        const family = props.engine.parameterGroupFamily;
        if (!family) {
            throw new Error("ParameterGroup cannot be used with an engine that doesn't specify a version");
        }
        this.family = family;
        this.description = props.description;
        this.parameters = (_b = props.parameters) !== null && _b !== void 0 ? _b : {};
    }
    /**
     * Imports a parameter group.
     *
     * @stability stable
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            bindToCluster(_options) {
                return { parameterGroupName };
            }
            bindToInstance(_options) {
                return { parameterGroupName };
            }
            addParameter(_key, _value) {
                return false;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Method called when this Parameter Group is used when defining a database cluster.
     *
     * @stability stable
     */
    bindToCluster(_options) {
        if (!this.clusterCfnGroup) {
            const id = this.instanceCfnGroup ? 'ClusterParameterGroup' : 'Resource';
            this.clusterCfnGroup = new rds_generated_1.CfnDBClusterParameterGroup(this, id, {
                description: this.description || `Cluster parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.clusterCfnGroup.ref,
        };
    }
    /**
     * Method called when this Parameter Group is used when defining a database instance.
     *
     * @stability stable
     */
    bindToInstance(_options) {
        if (!this.instanceCfnGroup) {
            const id = this.clusterCfnGroup ? 'InstanceParameterGroup' : 'Resource';
            this.instanceCfnGroup = new rds_generated_1.CfnDBParameterGroup(this, id, {
                description: this.description || `Parameter group for ${this.family}`,
                family: this.family,
                parameters: core_1.Lazy.any({ produce: () => this.parameters }),
            });
        }
        return {
            parameterGroupName: this.instanceCfnGroup.ref,
        };
    }
    /**
     * Add a parameter to this parameter group.
     *
     * @param key The key of the parameter to be added.
     * @param value The value of the parameter to be added.
     * @stability stable
     */
    addParameter(key, value) {
        this.parameters[key] = value;
        return true;
    }
}
exports.ParameterGroup = ParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ParameterGroup[_a] = { fqn: "@aws-cdk/aws-rds.ParameterGroup", version: "1.95.1" };
//# sourceMappingURL=data:application/json;base64,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