# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ServiceUserIdPermissionsBody(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'containers': 'list[str]',
        'data': 'list[str]',
        'users': 'list[str]',
        'ontology': 'list[str]'
    }

    attribute_map = {
        'containers': 'containers',
        'data': 'data',
        'users': 'users',
        'ontology': 'ontology'
    }

    def __init__(self, containers=None, data=None, users=None, ontology=None):  # noqa: E501
        """ServiceUserIdPermissionsBody - a model defined in Swagger"""  # noqa: E501
        self._containers = None
        self._data = None
        self._users = None
        self._ontology = None
        self.discriminator = None
        self.containers = containers
        self.data = data
        self.users = users
        self.ontology = ontology

    @property
    def containers(self):
        """Gets the containers of this ServiceUserIdPermissionsBody.  # noqa: E501


        :return: The containers of this ServiceUserIdPermissionsBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._containers

    @containers.setter
    def containers(self, containers):
        """Sets the containers of this ServiceUserIdPermissionsBody.


        :param containers: The containers of this ServiceUserIdPermissionsBody.  # noqa: E501
        :type: list[str]
        """
        if containers is None:
            raise ValueError("Invalid value for `containers`, must not be `None`")  # noqa: E501

        self._containers = containers

    @property
    def data(self):
        """Gets the data of this ServiceUserIdPermissionsBody.  # noqa: E501


        :return: The data of this ServiceUserIdPermissionsBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this ServiceUserIdPermissionsBody.


        :param data: The data of this ServiceUserIdPermissionsBody.  # noqa: E501
        :type: list[str]
        """
        if data is None:
            raise ValueError("Invalid value for `data`, must not be `None`")  # noqa: E501

        self._data = data

    @property
    def users(self):
        """Gets the users of this ServiceUserIdPermissionsBody.  # noqa: E501


        :return: The users of this ServiceUserIdPermissionsBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this ServiceUserIdPermissionsBody.


        :param users: The users of this ServiceUserIdPermissionsBody.  # noqa: E501
        :type: list[str]
        """
        if users is None:
            raise ValueError("Invalid value for `users`, must not be `None`")  # noqa: E501

        self._users = users

    @property
    def ontology(self):
        """Gets the ontology of this ServiceUserIdPermissionsBody.  # noqa: E501


        :return: The ontology of this ServiceUserIdPermissionsBody.  # noqa: E501
        :rtype: list[str]
        """
        return self._ontology

    @ontology.setter
    def ontology(self, ontology):
        """Sets the ontology of this ServiceUserIdPermissionsBody.


        :param ontology: The ontology of this ServiceUserIdPermissionsBody.  # noqa: E501
        :type: list[str]
        """
        if ontology is None:
            raise ValueError("Invalid value for `ontology`, must not be `None`")  # noqa: E501

        self._ontology = ontology

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServiceUserIdPermissionsBody, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServiceUserIdPermissionsBody):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
