# coding: utf-8

"""
    Deep Lynx

    The construction of megaprojects has consistently demonstrated challenges for project managers in regard to meeting cost, schedule, and performance requirements. Megaproject construction challenges are common place within megaprojects with many active projects in the United States failing to meet cost and schedule efforts by significant margins. Currently, engineering teams operate in siloed tools and disparate teams where connections across design, procurement, and construction systems are translated manually or over brittle point-to-point integrations. The manual nature of data exchange increases the risk of silent errors in the reactor design, with each silent error cascading across the design. These cascading errors lead to uncontrollable risk during construction, resulting in significant delays and cost overruns. Deep Lynx allows for an integrated platform during design and operations of mega projects.  The Deep Lynx Core API delivers a few main features.  1. Provides a set of methods and endpoints for manipulating data in an object oriented database. This allows us to store complex datatypes as records and then to compile them into actual, modifiable objects at run-time. Users can store taxonomies or ontologies in a readable format.  2. Provides methods for storing and retrieving data in a graph database. This data is structured and validated against the aformentioned object oriented database before storage.  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class RSAStatusResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'attempt_response_code': 'str',
        'attempt_reason_code': 'str',
        'subject_name': 'str',
        'authn_policy_id': 'str',
        'session_attributes': 'list[str]',
        'successful_methods': 'list[str]',
        'attempt_expires': 'str'
    }

    attribute_map = {
        'attempt_response_code': 'attemptResponseCode',
        'attempt_reason_code': 'attemptReasonCode',
        'subject_name': 'subjectName',
        'authn_policy_id': 'authnPolicyId',
        'session_attributes': 'sessionAttributes',
        'successful_methods': 'successfulMethods',
        'attempt_expires': 'attemptExpires'
    }

    def __init__(self, attempt_response_code=None, attempt_reason_code=None, subject_name=None, authn_policy_id=None, session_attributes=None, successful_methods=None, attempt_expires=None):  # noqa: E501
        """RSAStatusResponse - a model defined in Swagger"""  # noqa: E501
        self._attempt_response_code = None
        self._attempt_reason_code = None
        self._subject_name = None
        self._authn_policy_id = None
        self._session_attributes = None
        self._successful_methods = None
        self._attempt_expires = None
        self.discriminator = None
        if attempt_response_code is not None:
            self.attempt_response_code = attempt_response_code
        if attempt_reason_code is not None:
            self.attempt_reason_code = attempt_reason_code
        if subject_name is not None:
            self.subject_name = subject_name
        if authn_policy_id is not None:
            self.authn_policy_id = authn_policy_id
        if session_attributes is not None:
            self.session_attributes = session_attributes
        if successful_methods is not None:
            self.successful_methods = successful_methods
        if attempt_expires is not None:
            self.attempt_expires = attempt_expires

    @property
    def attempt_response_code(self):
        """Gets the attempt_response_code of this RSAStatusResponse.  # noqa: E501


        :return: The attempt_response_code of this RSAStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._attempt_response_code

    @attempt_response_code.setter
    def attempt_response_code(self, attempt_response_code):
        """Sets the attempt_response_code of this RSAStatusResponse.


        :param attempt_response_code: The attempt_response_code of this RSAStatusResponse.  # noqa: E501
        :type: str
        """

        self._attempt_response_code = attempt_response_code

    @property
    def attempt_reason_code(self):
        """Gets the attempt_reason_code of this RSAStatusResponse.  # noqa: E501


        :return: The attempt_reason_code of this RSAStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._attempt_reason_code

    @attempt_reason_code.setter
    def attempt_reason_code(self, attempt_reason_code):
        """Sets the attempt_reason_code of this RSAStatusResponse.


        :param attempt_reason_code: The attempt_reason_code of this RSAStatusResponse.  # noqa: E501
        :type: str
        """

        self._attempt_reason_code = attempt_reason_code

    @property
    def subject_name(self):
        """Gets the subject_name of this RSAStatusResponse.  # noqa: E501


        :return: The subject_name of this RSAStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._subject_name

    @subject_name.setter
    def subject_name(self, subject_name):
        """Sets the subject_name of this RSAStatusResponse.


        :param subject_name: The subject_name of this RSAStatusResponse.  # noqa: E501
        :type: str
        """

        self._subject_name = subject_name

    @property
    def authn_policy_id(self):
        """Gets the authn_policy_id of this RSAStatusResponse.  # noqa: E501


        :return: The authn_policy_id of this RSAStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._authn_policy_id

    @authn_policy_id.setter
    def authn_policy_id(self, authn_policy_id):
        """Sets the authn_policy_id of this RSAStatusResponse.


        :param authn_policy_id: The authn_policy_id of this RSAStatusResponse.  # noqa: E501
        :type: str
        """

        self._authn_policy_id = authn_policy_id

    @property
    def session_attributes(self):
        """Gets the session_attributes of this RSAStatusResponse.  # noqa: E501


        :return: The session_attributes of this RSAStatusResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._session_attributes

    @session_attributes.setter
    def session_attributes(self, session_attributes):
        """Sets the session_attributes of this RSAStatusResponse.


        :param session_attributes: The session_attributes of this RSAStatusResponse.  # noqa: E501
        :type: list[str]
        """

        self._session_attributes = session_attributes

    @property
    def successful_methods(self):
        """Gets the successful_methods of this RSAStatusResponse.  # noqa: E501


        :return: The successful_methods of this RSAStatusResponse.  # noqa: E501
        :rtype: list[str]
        """
        return self._successful_methods

    @successful_methods.setter
    def successful_methods(self, successful_methods):
        """Sets the successful_methods of this RSAStatusResponse.


        :param successful_methods: The successful_methods of this RSAStatusResponse.  # noqa: E501
        :type: list[str]
        """

        self._successful_methods = successful_methods

    @property
    def attempt_expires(self):
        """Gets the attempt_expires of this RSAStatusResponse.  # noqa: E501


        :return: The attempt_expires of this RSAStatusResponse.  # noqa: E501
        :rtype: str
        """
        return self._attempt_expires

    @attempt_expires.setter
    def attempt_expires(self, attempt_expires):
        """Sets the attempt_expires of this RSAStatusResponse.


        :param attempt_expires: The attempt_expires of this RSAStatusResponse.  # noqa: E501
        :type: str
        """

        self._attempt_expires = attempt_expires

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RSAStatusResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RSAStatusResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
