##
# File: PdbxReportCategoryStyle.py
# Date: 7-July-2013
#
# Updates:
#
#   14-July-2013 jdw taylor
#    20-Feb-2016  ep  Add ORCID
#    5-Mar-2018  jdw Py2-Py3 and refactor for Python Packaging
##
"""
Report style details for PDBx data categories.

"""
from __future__ import absolute_import
__docformat__ = "restructuredtext en"
__author__ = "John Westbrook"
__email__ = "john.westbrook@rcsb.org"
__license__ = "Apache 2.0"



from mmcif_utils.style.PdbxCategoryStyleBase import PdbxCategoryStyleBase


class PdbxReportCategoryStyle(PdbxCategoryStyleBase):
    _styleId = "PDBX_REPORT_V1"
    _categoryInfo = [
        ('audit_contact_author', 'table'),
        ('pdbx_contact_author', 'table'),
        ('pdbx_SG_project', 'table'),
        ('audit_author', 'table'),
        ('pdbx_database_status', 'table'),
        ('pdbx_depui_status_flags', 'table'),
        ('pdbx_database_proc', 'table'),
        ('pdbx_database_related', 'table'),
        ('database_PDB_rev', 'table'),
        ('pdbx_database_PDB_obs_spr', 'table'),
        ('pdbx_database_PDB_remark', 'table'),
        ('struct_ref', 'table'),
        ('struct_keywords', 'table'),
        ('pdbx_struct_assembly', 'table'),
        ('pdbx_struct_oper_list', 'table'),
        ('pdbx_point_symmetry', 'table'),
        ('pdbx_helical_symmetry', 'table'),
        ('struct_biol', 'table'),
        ('exptl_crystal_grow', 'table'),
        ('exptl_crystal_grow_comp', 'table'),
        ('exptl_crystal', 'table'),
        ('cell', 'table'),
        ('symmetry', 'table'),
        ('diffrn_source', 'table'),
        ('diffrn_detector', 'table'),
        ('diffrn', 'table'),
        ('diffrn_radiation', 'table'),
        ('reflns', 'table'),
        ('reflns_shell', 'table'),
        ('refine', 'table'),
        ('refine_ls_restr', 'table'),
        ('atom_sites', 'table'),
        ('database_PDB_caveat', 'table'),
        ('database_PDB_matrix', 'table'),
        ('database_PDB_remark', 'table'),
        ('exptl', 'table'),
        ('pdbx_reflns_twin', 'table'),
        ('struct_biol_keywords', 'table'),
        ('struct_ncs_dom', 'table'),
        ('struct_ncs_dom_lim', 'table'),
        ('struct_ncs_ens_gen', 'table'),
        ('struct_site', 'table'),
        ('struct_site_keywords', 'table'),
        ('struct_ref_seq', 'table'),
        ('struct_ref_seq_dif', 'table'),
        ('software', 'table'),
        ('entry', 'table'),
        ('pdbx_unobs_or_zero_occ_residues', 'table'),
        ('pdbx_entry_details', 'table'),
        ('pdbx_version', 'table'),
        ('atom_sites', 'table'),
        ('citation', 'table'),
        ('citation_author', 'table'),
        ('computing', 'table'),
        ('database', 'table'),
        ('database_2', 'table'),
        ('entity', 'table'),
        ('entity_keywords', 'table'),
        ('entity_name_com', 'table'),
        ('entity_name_sys', 'table'),
        ('entity_poly_seq', 'table'),
        ('entity_poly', 'table'),
        ('entity_src_gen', 'table'),
        ('entity_src_nat', 'table'),
        ('pdbx_coord', 'table'),
        ('pdbx_nonstandard_list', 'table'),
        ('pdbx_entity_src_syn', 'table'),
        ('pdbx_missing_residue_list', 'table'),
        ('pdbx_struct_link', 'table'),
        ('pdbx_struct_ncs_gen', 'table'),
        ('refine_hist', 'table'),
        ('struct', 'table'),
        ('struct_asym', 'table'),
        ('struct_biol_gen', 'table'),
        ('struct_conf', 'table'),
        ('struct_conf_type', 'table'),
        ('pdbx_struct_mod_residue', 'table'),
        ('struct_conn', 'table'),
        ('struct_conn_type', 'table'),
        ('struct_ncs_oper', 'table'),
        ('struct_sheet', 'table'),
        ('struct_sheet_order', 'table'),
        ('struct_sheet_range', 'table'),
        ('pdbx_struct_sheet_hbond', 'table'),
        ('diffrn_radiation_wavelength', 'table'),
        ('chem_comp', 'table'),
        ('struct_mon_prot_cis', 'table'),
        ('pdbx_coordinate_model', 'table'),
        ('pdbx_validate_rmsd_angle', 'table'),
        ('pdbx_validate_torsion', 'table'),
        ('pdbx_entity_nonpoly', 'table'),
        ('atom_site', 'table'),
        ('pdbx_entity_instance_feature', 'table'),
        ('pdbx_binding_assay', 'table')
    ]
    _cDict = {
        'audit_contact_author': [
            ('_audit_contact_author.name', '%s', 'str', ''),
            ('_audit_contact_author.address', '%s', 'str', ''),
            ('_audit_contact_author.phone', '%s', 'str', ''),
            ('_audit_contact_author.fax', '%s', 'str', ''),
            ('_audit_contact_author.email', '%s', 'str', '')
        ],
        'pdbx_binding_assay': [
            ('_pdbx_binding_assay.id', '%s', 'str', ''),
            ('_pdbx_binding_assay.assay_type', '%s', 'str', ''),
            ('_pdbx_binding_assay.assay_value_type', '%s', 'str', ''),
            ('_pdbx_binding_assay.assay_value', '%s', 'str', ''),
            ('_pdbx_binding_assay.assay_value_pH', '%s', 'str', ''),
            ('_pdbx_binding_assay.assay_temperature', '%s', 'str', ''),
            ('_pdbx_binding_assay.details', '%s', 'str', ''),
            ('_pdbx_binding_assay.auth_comp_id', '%s', 'str', ''),
            ('_pdbx_binding_assay.target_sequence_one_letter_code', '%s', 'str', ''),
            ('_pdbx_binding_assay.ligand_descriptor_type', '%s', 'str', ''),
            ('_pdbx_binding_assay.ligand_descriptor', '%s', 'str', ''),
        ],

        'pdbx_contact_author': [
            ('_pdbx_contact_author.id', '%s', 'str', ''),
            ('_pdbx_contact_author.name_salutation', '%s', 'str', ''),
            ('_pdbx_contact_author.name_first', '%s', 'str', ''),
            ('_pdbx_contact_author.name_last', '%s', 'str', ''),
            ('_pdbx_contact_author.name_mi', '%s', 'str', ''),
            ('_pdbx_contact_author.role', '%s', 'str', ''),
            ('_pdbx_contact_author.email', '%s', 'str', ''),
            ('_pdbx_contact_author.phone', '%s', 'str', ''),
            ('_pdbx_contact_author.fax', '%s', 'str', ''),
            ('_pdbx_contact_author.address_1', '%s', 'str', ''),
            ('_pdbx_contact_author.address_2', '%s', 'str', ''),
            ('_pdbx_contact_author.address_3', '%s', 'str', ''),
            ('_pdbx_contact_author.city', '%s', 'str', ''),
            ('_pdbx_contact_author.state_province', '%s', 'str', ''),
            ('_pdbx_contact_author.postal_code', '%s', 'str', ''),
            ('_pdbx_contact_author.country', '%s', 'str', ''),
            ('_pdbx_contact_author.organization_type', '%s', 'str', ''),
            ('_pdbx_contact_author.continent', '%s', 'str', ''),
            ('_pdbx_contact_author.identifier_ORCID', '%s', 'str', '')
        ],
        'pdbx_SG_project': [
            ('_pdbx_SG_project.id', '%s', 'str', ''),
            ('_pdbx_SG_project.project_name', '%s', 'str', ''),
            ('_pdbx_SG_project.full_name_of_center', '%s', 'str', ''),
            ('_pdbx_SG_project.initial_of_center', '%s', 'str', '')
        ],
        'audit_author': [
            ('_audit_author.name', '%s', 'str', ''),
            ('_audit_author.pdbx_ordinal', '%s', 'str', ''),
            ('_audit_author.identifier_ORCID', '%s', 'str', '')
        ],

        'pdbx_database_status': [
            ('_pdbx_database_status.status_code', '%s', 'str', ''),
            ('_pdbx_database_status.entry_id', '%s', 'str', ''),
            ('_pdbx_database_status.pdbx_tid', '%s', 'str', ''),
            ('_pdbx_database_status.status_coordinates_in_NDB', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_deposit_form', '%s', 'str', ''),
            ('_pdbx_database_status.date_deposition_form', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_coordinates', '%s', 'str', ''),
            ('_pdbx_database_status.date_coordinates', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_struct_fact', '%s', 'str', ''),
            ('_pdbx_database_status.date_struct_fact', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_internal_approval', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_manuscript', '%s', 'str', ''),
            ('_pdbx_database_status.date_manuscript', '%s', 'str', ''),
            ('_pdbx_database_status.name_depositor', '%s', 'str', ''),
            ('_pdbx_database_status.pdbx_annotator', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_author_approval', '%s', 'str', ''),
            ('_pdbx_database_status.date_author_approval', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_initial_deposition_date', '%s', 'str', ''),
            ('_pdbx_database_status.date_submitted', '%s', 'str', ''),
            ('_pdbx_database_status.author_release_status_code', '%s', 'str', ''),
            ('_pdbx_database_status.date_revised', '%s', 'str', ''),
            ('_pdbx_database_status.revision_id', '%s', 'str', ''),
            ('_pdbx_database_status.replaced_entry_id', '%s', 'str', ''),
            ('_pdbx_database_status.revision_description', '%s', 'str', ''),
            ('_pdbx_database_status.date_of_NDB_release', '%s', 'str', ''),
            ('_pdbx_database_status.date_released_to_PDB', '%s', 'str', ''),
            ('_pdbx_database_status.date_of_PDB_release', '%s', 'str', ''),
            ('_pdbx_database_status.date_hold_coordinates', '%s', 'str', ''),
            ('_pdbx_database_status.date_hold_struct_fact', '%s', 'str', ''),
            ('_pdbx_database_status.hold_for_publication', '%s', 'str', ''),
            ('_pdbx_database_status.date_hold_nmr_constraints', '%s', 'str', ''),
            ('_pdbx_database_status.dep_release_code_coordinates', '%s', 'str', ''),
            ('_pdbx_database_status.dep_release_code_struct_fact', '%s', 'str', ''),
            ('_pdbx_database_status.dep_release_code_nmr_constraints', '%s', 'str', ''),
            ('_pdbx_database_status.dep_release_code_sequence', '%s', 'str', ''),
            ('_pdbx_database_status.pdb_date_of_author_approval', '%s', 'str', ''),
            ('_pdbx_database_status.deposit_site', '%s', 'str', ''),
            ('_pdbx_database_status.process_site', '%s', 'str', ''),
            ('_pdbx_database_status.date_of_sf_release', '%s', 'str', ''),
            ('_pdbx_database_status.date_of_mr_release', '%s', 'str', ''),
            ('_pdbx_database_status.status_code_sf', '%s', 'str', ''),
            ('_pdbx_database_status.status_code_mr', '%s', 'str', ''),
            ('_pdbx_database_status.SG_entry', '%s', 'str', ''),
            ('_pdbx_database_status.date_hold_chemical_shifts', '%s', 'str', ''),
            ('_pdbx_database_status.date_chemical_shifts', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_chemical_shifts', '%s', 'str', ''),
            ('_pdbx_database_status.dep_release_code_chemical_shifts', '%s', 'str', ''),
            ('_pdbx_database_status.date_of_cs_release', '%s', 'str', ''),
            ('_pdbx_database_status.status_code_cs', '%s', 'str', ''),
            ('_pdbx_database_status.author_approval_type', '%s', 'str', ''),
            ('_pdbx_database_status.date_nmr_constraints', '%s', 'str', ''),
            ('_pdbx_database_status.recvd_nmr_constraints', '%s', 'str', ''),
            ('_pdbx_database_status.skip_PDB_REMARK_500', '%s', 'str', ''),
            ('_pdbx_database_status.skip_PDB_REMARK', '%s', 'str', ''),
            ('_pdbx_database_status.title_suppression', '%s', 'str', ''),
            ('_pdbx_database_status.methods_development_category', '%s', 'str', '')
        ],
        'pdbx_database_proc': [
            ('_pdbx_database_proc.entry_id', '%s', 'str', ''),
            ('_pdbx_database_proc.cycle_id', '%s', 'str', ''),
            ('_pdbx_database_proc.date_begin_cycle', '%s', 'str', ''),
            ('_pdbx_database_proc.date_end_cycle', '%s', 'str', ''),
            ('_pdbx_database_proc.details', '%s', 'str', '')
        ],
        'pdbx_database_related': [
            ('_pdbx_database_related.db_name', '%s', 'str', ''),
            ('_pdbx_database_related.db_id', '%s', 'str', ''),
            ('_pdbx_database_related.details', '%s', 'str', ''),
            ('_pdbx_database_related.content_type', '%s', 'str', '')
        ],
        'pdbx_depui_status_flags': [
            # A subset of interesting flags
            ('_pdbx_depui_status_flags.dep_dataset_id', '%s', 'str', ''),
            ('_pdbx_depui_status_flags.post_rel_replacement_reason', '%s', 'str', ''),
            ('_pdbx_depui_status_flags.post_rel_replacement_reason_details', '%s', 'str', '')
        ],
        'database_PDB_rev': [
            ('_database_PDB_rev.num', '%s', 'str', ''),
            ('_database_PDB_rev.date', '%s', 'str', ''),
            ('_database_PDB_rev.date_original', '%s', 'str', ''),
            ('_database_PDB_rev.status', '%s', 'str', ''),
            ('_database_PDB_rev.replaces', '%s', 'str', ''),
            ('_database_PDB_rev.mod_type', '%s', 'str', ''),
            ('_database_PDB_rev.pdbx_record_revised_1', '%s', 'str', ''),
            ('_database_PDB_rev.pdbx_record_revised_2', '%s', 'str', ''),
            ('_database_PDB_rev.pdbx_record_revised_3', '%s', 'str', ''),
            ('_database_PDB_rev.pdbx_record_revised_4', '%s', 'str', ''),
            ('_database_PDB_rev_record.rev_num', '%s', 'str', ''),
            ('_database_PDB_rev_record.type', '%s', 'str', ''),
            ('_database_PDB_rev_record.details', '%s', 'str', '')
        ],
        'pdbx_database_PDB_obs_spr': [
            ('_pdbx_database_PDB_obs_spr.id', '%s', 'str', ''),
            ('_pdbx_database_PDB_obs_spr.date', '%s', 'str', ''),
            ('_pdbx_database_PDB_obs_spr.pdb_id', '%s', 'str', ''),
            ('_pdbx_database_PDB_obs_spr.replace_pdb_id', '%s', 'str', '')
        ],
        'pdbx_database_PDB_remark': [
            ('_pdbx_database_PDB_remark.id', '%s', 'str', ''),
            ('_pdbx_database_PDB_remark.text', '%s', 'str', '')
        ],
        'pdbx_entity_instance_feature': [
            ('_pdbx_entity_instance_feature.ordinal', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.asym_id', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.auth_asym_id', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.auth_comp_id', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.auth_seq_num', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.comp_id', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.details', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.feature_type', '%s', 'str', ''),
            ('_pdbx_entity_instance_feature.seq_num', '%s', 'str', '')
        ],
        'struct_ref': [
            ('_struct_ref.id', '%s', 'str', ''),
            ('_struct_ref.db_name', '%s', 'str', ''),
            ('_struct_ref.db_code', '%s', 'str', ''),
            ('_struct_ref.pdbx_db_accession', '%s', 'str', ''),
            ('_struct_ref.entity_id', '%s', 'str', ''),
            ('_struct_ref.pdbx_seq_one_letter_code', '%s', 'str', ''),
            ('_struct_ref.pdbx_align_begin', '%s', 'str', ''),
            ('_struct_ref.pdbx_pdb_start', '%s', 'str', ''),
            ('_struct_ref.pdbx_pdb_end', '%s', 'str', ''),
            ('_struct_ref.biol_id', '%s', 'str', '')
        ],

        'struct_keywords': [
            ('_struct_keywords.entry_id', '%s', 'str', ''),
            ('_struct_keywords.pdbx_keywords', '%s', 'str', ''),
            ('_struct_keywords.text', '%s', 'str', '')
        ],
        'pdbx_struct_assembly': [
            ('_pdbx_struct_assembly.id', '%s', 'str', ''),
            ('_pdbx_struct_assembly.details', '%s', 'str', ''),
            ('_pdbx_struct_assembly.method_details', '%s', 'str', ''),
            ('_pdbx_struct_assembly.oligomeric_details', '%s', 'str', ''),
            ('_pdbx_struct_assembly.oligomeric_count', '%s', 'str', ''),
            ('_pdbx_struct_assembly_gen.assembly_id', '%s', 'str', ''),
            ('_pdbx_struct_assembly_gen.oper_expression', '%s', 'str', ''),
            ('_pdbx_struct_assembly_gen.asym_id_list', '%s', 'str', ''),
            ('_pdbx_struct_assembly_prop.biol_id', '%s', 'str', ''),
            ('_pdbx_struct_assembly_prop.type', '%s', 'str', ''),
            ('_pdbx_struct_assembly_prop.value', '%s', 'str', ''),
            ('_pdbx_struct_assembly_prop.details', '%s', 'str', '')
        ],
        'pdbx_struct_oper_list': [
            ('_pdbx_struct_oper_list.id', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.type', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.name', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.symmetry_operation', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[1][1]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[1][2]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[1][3]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.vector[1]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[2][1]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[2][2]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[2][3]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.vector[2]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[3][1]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[3][2]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.matrix[3][3]', '%s', 'str', ''),
            ('_pdbx_struct_oper_list.vector[3]', '%s', 'str', '')
        ],
        'pdbx_point_symmetry': [
            ('_pdbx_point_symmetry.entry_id', '%s', 'str', ''),
            ('_pdbx_point_symmetry.Schoenflies_symbol', '%s', 'str', ''),
            ('_pdbx_point_symmetry.circular_symmetry', '%s', 'str', ''),
            ('_pdbx_point_symmetry.H-M_notation', '%s', 'str', '')
        ],
        'pdbx_helical_symmetry': [
            ('_pdbx_helical_symmetry.entry_id', '%s', 'str', ''),
            ('_pdbx_helical_symmetry.number_of_operations', '%s', 'str', ''),
            ('_pdbx_helical_symmetry.rotation_per_n_subunits', '%s', 'str', ''),
            ('_pdbx_helical_symmetry.rise_per_n_subunits', '%s', 'str', ''),
            ('_pdbx_helical_symmetry.n_subunits_divisor', '%s', 'str', ''),
            ('_pdbx_helical_symmetry.dyad_axis', '%s', 'str', ''),
            ('_pdbx_helical_symmetry.circular_symmetry', '%s', 'str', '')
        ],
        'struct_biol': [
            ('_struct_biol.id', '%s', 'str', ''),
            ('_struct_biol.pdbx_description', '%s', 'str', ''),
            ('_struct_biol.details', '%s', 'str', '')
        ],
        'exptl_crystal_grow': [
            ('_exptl_crystal_grow.crystal_id', '%s', 'str', ''),
            ('_exptl_crystal_grow.method', '%s', 'str', ''),
            ('_exptl_crystal_grow.temp', '%s', 'str', ''),
            ('_exptl_crystal_grow.temp_details', '%s', 'str', ''),
            ('_exptl_crystal_grow.pH', '%s', 'str', ''),
            ('_exptl_crystal_grow.pdbx_details', '%s', 'str', ''),
            ('_exptl_crystal_grow.pdbx_pH_range', '%s', 'str', '')
        ],
        'exptl_crystal_grow_comp': [
            ('_exptl_crystal_grow_comp.crystal_id', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.id', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.sol_id', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.name', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.volume', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.conc', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.details', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.pdbx_bath', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.pdbx_salt', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.pdbx_soak_salt', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.pdbx_soak_solv', '%s', 'str', ''),
            ('_exptl_crystal_grow_comp.pdbx_solv', '%s', 'str', '')
        ],
        'exptl_crystal': [
            ('_exptl_crystal.id', '%s', 'str', ''),
            ('_exptl_crystal.density_meas', '%s', 'str', ''),
            ('_exptl_crystal.density_Matthews', '%s', 'str', ''),
            ('_exptl_crystal.density_percent_sol', '%s', 'str', ''),
            ('_exptl_crystal.description', '%s', 'str', ''),
            ('_exptl_crystal.F_000', '%s', 'str', ''),
            ('_exptl_crystal.preparation', '%s', 'str', '')
        ],
        'cell': [
            ('_cell.entry_id', '%s', 'str', ''),
            ('_cell.length_a', '%s', 'str', ''),
            ('_cell.length_b', '%s', 'str', ''),
            ('_cell.length_c', '%s', 'str', ''),
            ('_cell.angle_alpha', '%s', 'str', ''),
            ('_cell.angle_beta', '%s', 'str', ''),
            ('_cell.angle_gamma', '%s', 'str', ''),
            ('_cell.Z_PDB', '%s', 'str', ''),
            ('_cell.pdbx_unique_axis', '%s', 'str', ''),
            ('_cell.length_a_esd', '%s', 'str', ''),
            ('_cell.length_b_esd', '%s', 'str', ''),
            ('_cell.length_c_esd', '%s', 'str', ''),
            ('_cell.angle_alpha_esd', '%s', 'str', ''),
            ('_cell.angle_beta_esd', '%s', 'str', ''),
            ('_cell.angle_gamma_esd', '%s', 'str', '')
        ],
        'symmetry': [
            ('_symmetry.entry_id', '%s', 'str', ''),
            ('_symmetry.space_group_name_H-M', '%s', 'str', ''),
            ('_symmetry.pdbx_full_space_group_name_H-M', '%s', 'str', ''),
            ('_symmetry.cell_setting', '%s', 'str', ''),
            ('_symmetry.Int_Tables_number', '%s', 'str', ''),
            ('_symmetry.space_group_name_Hall', '%s', 'str', '')
        ],
        'diffrn_source': [
            ('_diffrn_source.diffrn_id', '%s', 'str', ''),
            ('_diffrn_source.pdbx_synchrotron_y_n', '%s', 'str', ''),
            ('_diffrn_source.source', '%s', 'str', ''),
            ('_diffrn_source.type', '%s', 'str', ''),
            ('_diffrn_source.pdbx_synchrotron_site', '%s', 'str', ''),
            ('_diffrn_source.pdbx_synchrotron_beamline', '%s', 'str', ''),
            ('_diffrn_source.pdbx_wavelength', '%s', 'str', ''),
            ('_diffrn_source.pdbx_wavelength_list', '%s', 'str', '')
        ],
        'diffrn_detector': [
            ('_diffrn_detector.diffrn_id', '%s', 'str', ''),
            ('_diffrn_detector.detector', '%s', 'str', ''),
            ('_diffrn_detector.type', '%s', 'str', ''),
            ('_diffrn_detector.pdbx_collection_date', '%s', 'str', ''),
            ('_diffrn_detector.details', '%s', 'str', '')
        ],
        'diffrn': [
            ('_diffrn.id', '%s', 'str', ''),
            ('_diffrn.ambient_temp', '%s', 'str', ''),
            ('_diffrn.ambient_temp_details', '%s', 'str', ''),
            ('_diffrn.crystal_id', '%s', 'str', '')
        ],
        'diffrn_radiation': [
            ('_diffrn_radiation.diffrn_id', '%s', 'str', ''),
            ('_diffrn_radiation.wavelength_id', '%s', 'str', ''),
            ('_diffrn_radiation.pdbx_monochromatic_or_laue_m_l', '%s', 'str', ''),
            ('_diffrn_radiation.monochromator', '%s', 'str', ''),
            ('_diffrn_radiation.pdbx_diffrn_protocol', '%s', 'str', ''),
            ('_diffrn_radiation.pdbx_scattering_type', '%s', 'str', '')
        ],
        'reflns': [
            ('_reflns.entry_id', '%s', 'str', ''),
            ('_reflns.observed_criterion_sigma_I', '%s', 'str', ''),
            ('_reflns.observed_criterion_sigma_F', '%s', 'str', ''),
            ('_reflns.d_resolution_low', '%s', 'str', ''),
            ('_reflns.d_resolution_high', '%s', 'str', ''),
            ('_reflns.number_obs', '%s', 'str', ''),
            ('_reflns.number_all', '%s', 'str', ''),
            ('_reflns.percent_possible_obs', '%s', 'str', ''),
            ('_reflns.pdbx_Rmerge_I_obs', '%s', 'str', ''),
            ('_reflns.pdbx_Rsym_value', '%s', 'str', ''),
            ('_reflns.pdbx_netI_over_sigmaI', '%s', 'str', ''),
            ('_reflns.B_iso_Wilson_estimate', '%s', 'str', ''),
            ('_reflns.pdbx_redundancy', '%s', 'str', ''),
            ('_reflns.R_free_details', '%s', 'str', ''),
            ('_reflns.limit_h_max', '%s', 'str', ''),
            ('_reflns.limit_h_min', '%s', 'str', ''),
            ('_reflns.limit_k_max', '%s', 'str', ''),
            ('_reflns.limit_k_min', '%s', 'str', ''),
            ('_reflns.limit_l_max', '%s', 'str', ''),
            ('_reflns.limit_l_min', '%s', 'str', ''),
            ('_reflns.observed_criterion_F_max', '%s', 'str', ''),
            ('_reflns.observed_criterion_F_min', '%s', 'str', ''),
            ('_reflns.pdbx_chi_squared', '%s', 'str', ''),
            ('_reflns.pdbx_scaling_rejects', '%s', 'str', ''),
            ('_reflns.pdbx_ordinal', '%s', 'str', ''),
            ('_reflns.pdbx_diffrn_id', '%s', 'str', '')],

        'reflns_shell': [
            ('_reflns_shell.d_res_high', '%s', 'str', ''),
            ('_reflns_shell.d_res_low', '%s', 'str', ''),
            ('_reflns_shell.percent_possible_all', '%s', 'str', ''),
            ('_reflns_shell.Rmerge_I_obs', '%s', 'str', ''),
            ('_reflns_shell.pdbx_Rsym_value', '%s', 'str', ''),
            ('_reflns_shell.meanI_over_sigI_obs', '%s', 'str', ''),
            ('_reflns_shell.pdbx_redundancy', '%s', 'str', ''),
            ('_reflns_shell.percent_possible_obs', '%s', 'str', ''),
            ('_reflns_shell.number_unique_all', '%s', 'str', ''),
            ('_reflns_shell.number_measured_all', '%s', 'str', ''),
            ('_reflns_shell.number_measured_obs', '%s', 'str', ''),
            ('_reflns_shell.number_unique_obs', '%s', 'str', ''),
            ('_reflns_shell.pdbx_chi_squared', '%s', 'str', ''),
            ('_reflns_shell.pdbx_ordinal', '%s', 'str', ''),
            ('_reflns_shell.pdbx_diffrn_id', '%s', 'str', '')
        ],
        'refine': [
            ('_refine.entry_id', '%s', 'str', ''),
            ('_refine.ls_number_reflns_obs', '%s', 'str', ''),
            ('_refine.ls_number_reflns_all', '%s', 'str', ''),
            ('_refine.pdbx_ls_sigma_I', '%s', 'str', ''),
            ('_refine.pdbx_ls_sigma_F', '%s', 'str', ''),
            ('_refine.pdbx_data_cutoff_high_absF', '%s', 'str', ''),
            ('_refine.pdbx_data_cutoff_low_absF', '%s', 'str', ''),
            ('_refine.pdbx_data_cutoff_high_rms_absF', '%s', 'str', ''),
            ('_refine.ls_d_res_low', '%s', 'str', ''),
            ('_refine.ls_d_res_high', '%s', 'str', ''),
            ('_refine.ls_percent_reflns_obs', '%s', 'str', ''),
            ('_refine.ls_R_factor_obs', '%s', 'str', ''),
            ('_refine.ls_R_factor_all', '%s', 'str', ''),
            ('_refine.ls_R_factor_R_work', '%s', 'str', ''),
            ('_refine.ls_R_factor_R_free', '%s', 'str', ''),
            ('_refine.ls_R_factor_R_free_error', '%s', 'str', ''),
            ('_refine.ls_R_factor_R_free_error_details', '%s', 'str', ''),
            ('_refine.ls_percent_reflns_R_free', '%s', 'str', ''),
            ('_refine.ls_number_reflns_R_free', '%s', 'str', ''),
            ('_refine.ls_number_parameters', '%s', 'str', ''),
            ('_refine.ls_number_restraints', '%s', 'str', ''),
            ('_refine.occupancy_min', '%s', 'str', ''),
            ('_refine.occupancy_max', '%s', 'str', ''),
            ('_refine.correlation_coeff_Fo_to_Fc', '%s', 'str', ''),
            ('_refine.correlation_coeff_Fo_to_Fc_free', '%s', 'str', ''),
            ('_refine.B_iso_mean', '%s', 'str', ''),
            ('_refine.aniso_B[1][1]', '%s', 'str', ''),
            ('_refine.aniso_B[2][2]', '%s', 'str', ''),
            ('_refine.aniso_B[3][3]', '%s', 'str', ''),
            ('_refine.aniso_B[1][2]', '%s', 'str', ''),
            ('_refine.aniso_B[1][3]', '%s', 'str', ''),
            ('_refine.aniso_B[2][3]', '%s', 'str', ''),
            ('_refine.solvent_model_details', '%s', 'str', ''),
            ('_refine.solvent_model_param_ksol', '%s', 'str', ''),
            ('_refine.solvent_model_param_bsol', '%s', 'str', ''),
            ('_refine.ccp4_solvent_vdw_probe_radii', '%s', 'str', ''),
            ('_refine.ccp4_solvent_ion_probe_radii', '%s', 'str', ''),
            ('_refine.ccp4_solvent_shrinkage_radii', '%s', 'str', ''),
            ('_refine.pdbx_ls_cross_valid_method', '%s', 'str', ''),
            ('_refine.details', '%s', 'str', ''),
            ('_refine.pdbx_starting_model', '%s', 'str', ''),
            ('_refine.pdbx_method_to_determine_struct', '%s', 'str', ''),
            ('_refine.pdbx_isotropic_thermal_model', '%s', 'str', ''),
            ('_refine.pdbx_stereochemistry_target_values', '%s', 'str', ''),
            ('_refine.pdbx_stereochem_target_val_spec_case', '%s', 'str', ''),
            ('_refine.pdbx_R_Free_selection_details', '%s', 'str', ''),
            ('_refine.pdbx_overall_ESU_R', '%s', 'str', ''),
            ('_refine.pdbx_overall_ESU_R_Free', '%s', 'str', ''),
            ('_refine.overall_SU_ML', '%s', 'str', ''),
            ('_refine.pdbx_overall_phase_error', '%s', 'str', ''),
            ('_refine.overall_SU_B', '%s', 'str', ''),
            ('_refine.overall_SU_R_Cruickshank_DPI', '%s', 'str', ''),
            ('_refine.ls_redundancy_reflns_obs', '%s', 'str', ''),
            ('_refine.B_iso_min', '%s', 'str', ''),
            ('_refine.B_iso_max', '%s', 'str', ''),
            ('_refine.overall_SU_R_free', '%s', 'str', ''),
            ('_refine.ls_wR_factor_R_free', '%s', 'str', ''),
            ('_refine.ls_wR_factor_R_work', '%s', 'str', ''),
            ('_refine.overall_FOM_free_R_set', '%s', 'str', ''),
            ('_refine.overall_FOM_work_R_set', '%s', 'str', ''),
            ('_refine.pdbx_diffrn_id', '%s', 'str', ''),
            ('_refine.pdbx_refine_id', '%s', 'str', ''),
            ('_refine.pdbx_adp_type', '%s', 'str', '')
        ],
        'refine_ls_restr': [
            ('_refine_ls_restr.type', '%s', 'str', ''),
            ('_refine_ls_restr.dev_ideal', '%s', 'str', ''),
            ('_refine_ls_restr.dev_ideal_target', '%s', 'str', ''),
            ('_refine_ls_restr.weight', '%s', 'str', ''),
            ('_refine_ls_restr.number', '%s', 'str', ''),
            ('_refine_ls_restr.pdbx_restraint_function', '%s', 'str', ''),
            ('_refine_ls_restr.pdbx_refine_id', '%s', 'str', '')
        ],
        'refine_ls_shell': [
            ('_refine_ls_shell.pdbx_total_number_of_bins_used', '%s', 'str', ''),
            ('_refine_ls_shell.d_res_high', '%s', 'str', ''),
            ('_refine_ls_shell.d_res_low', '%s', 'str', ''),
            ('_refine_ls_shell.number_reflns_R_work', '%s', 'str', ''),
            ('_refine_ls_shell.R_factor_R_work', '%s', 'str', ''),
            ('_refine_ls_shell.percent_reflns_obs', '%s', 'str', ''),
            ('_refine_ls_shell.R_factor_R_free', '%s', 'str', ''),
            ('_refine_ls_shell.R_factor_R_free_error', '%s', 'str', ''),
            ('_refine_ls_shell.percent_reflns_R_free', '%s', 'str', ''),
            ('_refine_ls_shell.number_reflns_R_free', '%s', 'str', ''),
            ('_refine_ls_shell.number_reflns_all', '%s', 'str', ''),
            ('_refine_ls_shell.R_factor_all', '%s', 'str', ''),
            ('_refine_ls_shell.number_reflns_obs', '%s', 'str', ''),
            ('_refine_ls_shell.redundancy_reflns_obs', '%s', 'str', ''),
            ('_refine_ls_shell.pdbx_refine_id', '%s', 'str', '')
        ],
        'atom_sites': [
            ('_atom_sites_footnote.id', '%s', 'str', ''),
            ('_atom_sites_footnote.text', '%s', 'str', '')
        ],
        'database_PDB_caveat': [
            ('_database_PDB_caveat.id', '%s', 'str', ''),
            ('_database_PDB_caveat.text', '%s', 'str', '')
        ],

        'database_PDB_matrix': [
            ('_database_PDB_matrix.entry_id', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[1][1]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[1][2]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[1][3]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[2][1]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[2][2]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[2][3]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[3][1]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[3][2]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx[3][3]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx_vector[1]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx_vector[2]', '%s', 'str', ''),
            ('_database_PDB_matrix.origx_vector[3]', '%s', 'str', '')
        ],
        'database_PDB_remark': [
            ('_database_PDB_remark.id', '%s', 'str', ''),
            ('_database_PDB_remark.text', '%s', 'str', '')
        ],
        'exptl': [
            ('_exptl.entry_id', '%s', 'str', ''),
            ('_exptl.method', '%s', 'str', ''),
            ('_exptl.crystals_number', '%s', 'str', '')
        ],
        'pdbx_reflns_twin': [
            ('_pdbx_reflns_twin.domain_id', '%s', 'str', ''),
            ('_pdbx_reflns_twin.crystal_id', '%s', 'str', ''),
            ('_pdbx_reflns_twin.diffrn_id', '%s', 'str', ''),
            ('_pdbx_reflns_twin.type', '%s', 'str', ''),
            ('_pdbx_reflns_twin.operator', '%s', 'str', ''),
            ('_pdbx_reflns_twin.fraction', '%s', 'str', '')
        ],
        'struct_biol_keywords': [
            ('_struct_biol_keywords.biol_id', '%s', 'str', ''),
            ('_struct_biol_keywords.text', '%s', 'str', '')
        ],
        'struct_ncs_dom': [
            ('_struct_ncs_dom.id', '%s', 'str', ''),
            ('_struct_ncs_dom.details', '%s', 'str', ''),
            ('_struct_ncs_dom.pdbx_ens_id', '%s', 'str', '')
        ],
        'struct_ncs_dom_lim': [
            ('_struct_ncs_dom_lim.dom_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.beg_auth_asym_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.beg_auth_seq_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.end_auth_asym_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.end_auth_seq_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.pdbx_component_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.pdbx_refine_code', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.beg_label_asym_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.beg_label_comp_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.beg_label_seq_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.beg_label_alt_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.end_label_asym_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.end_label_comp_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.end_label_seq_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.end_label_alt_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.pdbx_ens_id', '%s', 'str', ''),
            ('_struct_ncs_dom_lim.selection_details', '%s', 'str', '')
        ],
        'struct_ncs_ens_gen': [
            ('_struct_ncs_ens_gen.dom_id_1', '%s', 'str', ''),
            ('_struct_ncs_ens_gen.dom_id_2', '%s', 'str', ''),
            ('_struct_ncs_ens_gen.ens_id', '%s', 'str', ''),
            ('_struct_ncs_ens_gen.oper_id', '%s', 'str', '')
        ],
        'struct_site': [
            ('_struct_site.id', '%s', 'str', ''),
            ('_struct_site.pdbx_evidence_code', '%s', 'str', ''),
            ('_struct_site.details', '%s', 'str', '')
        ],
        'struct_site_keywords': [
            ('_struct_site_keywords.site_id', '%s', 'str', ''),
            ('_struct_site_keywords.text', '%s', 'str', '')
        ],
        'struct_ref_seq': [
            ('_struct_ref_seq.align_id', '%s', 'str', ''),
            ('_struct_ref_seq.ref_id', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_pdb_id_code', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_chain_id', '%s', 'str', ''),
            ('_struct_ref_seq.seq_align_beg', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_seq_align_beg_ins_code', '%s', 'str', ''),
            ('_struct_ref_seq.seq_align_end', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_seq_align_end_ins_code', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_db_accession', '%s', 'str', ''),
            ('_struct_ref_seq.db_align_beg', '%s', 'str', ''),
            ('_struct_ref_seq.db_align_end', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_auth_seq_align_beg', '%s', 'str', ''),
            ('_struct_ref_seq.pdbx_auth_seq_align_end', '%s', 'str', '')
        ],
        'struct_ref_seq_dif': [
            ('_struct_ref_seq_dif.align_id', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_pdb_id_code', '%s', 'str', ''),
            ('_struct_ref_seq_dif.mon_id', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_pdb_chain_id', '%s', 'str', ''),
            ('_struct_ref_seq_dif.seq_num', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_pdb_ins_code', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_seq_db_name', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_seq_db_accession_code', '%s', 'str', ''),
            ('_struct_ref_seq_dif.db_mon_id', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_seq_db_seq_num', '%s', 'str', ''),
            ('_struct_ref_seq_dif.details', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_auth_seq_num', '%s', 'str', ''),
            ('_struct_ref_seq_dif.pdbx_ordinal', '%s', 'str', '')
        ],
        'software': [
            ('_software.name', '%s', 'str', ''),
            ('_software.classification', '%s', 'str', ''),
            ('_software.version', '%s', 'str', ''),
            ('_software.citation_id', '%s', 'str', ''),
            ('_software.pdbx_ordinal', '%s', 'str', ''),
        ],

        'entry': [
            ('_entry.id', '%s', 'str', '')
        ],
        'pdbx_unobs_or_zero_occ_residues': [
            ('_pdbx_unobs_or_zero_occ_residues.id', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.polymer_flag', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.occupancy_flag', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.PDB_model_num', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.auth_asym_id', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.auth_comp_id', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.auth_seq_id', '%s', 'str', ''),
            ('_pdbx_unobs_or_zero_occ_residues.PDB_ins_code', '%s', 'str', '')
        ],
        'pdbx_entry_details': [
            ('_pdbx_entry_details.entry_id', '%s', 'str', ''),
            ('_pdbx_entry_details.nonpolymer_details', '%s', 'str', ''),
            ('_pdbx_entry_details.sequence_details', '%s', 'str', ''),
            ('_pdbx_entry_details.compound_details', '%s', 'str', ''),
            ('_pdbx_entry_details.source_details', '%s', 'str', '')
        ],
        'pdbx_version': [
            ('_pdbx_version.entry_id', '%s', 'str', ''),
            ('_pdbx_version.revision_date', '%s', 'str', ''),
            ('_pdbx_version.major_version', '%s', 'str', ''),
            ('_pdbx_version.minor_version', '%s', 'str', ''),
            ('_pdbx_version.revision_type', '%s', 'str', ''),
            ('_pdbx_version.details', '%s', 'str', '')
        ],
        'atom_sites': [
            ('_atom_sites.entry_id', '%s', 'str', ''),
            ('_atom_sites.cartn_transform_axes', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[1][1]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[1][2]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[1][3]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[2][1]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[2][2]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[2][3]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[3][1]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[3][2]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_matrix[3][3]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_vector[1]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_vector[2]', '%s', 'str', ''),
            ('_atom_sites.fract_transf_vector[3]', '%s', 'str', '')
        ],
        'citation': [
            ('_citation.id', '%s', 'str', ''),
            ('_citation.title', '%s', 'str', ''),
            ('_citation.journal_abbrev', '%s', 'str', ''),
            ('_citation.journal_volume', '%s', 'str', ''),
            ('_citation.page_first', '%s', 'str', ''),
            ('_citation.page_last', '%s', 'str', ''),
            ('_citation.year', '%s', 'str', ''),
            ('_citation.journal_id_ASTM', '%s', 'str', ''),
            ('_citation.country', '%s', 'str', ''),
            ('_citation.journal_id_ISSN', '%s', 'str', ''),
            ('_citation.journal_id_CSD', '%s', 'str', ''),
            ('_citation.book_publisher', '%s', 'str', ''),
            ('_citation.pdbx_database_id_PubMed', '%s', 'str', ''),
            ('_citation.pdbx_database_id_DOI', '%s', 'str', '')
        ],

        'citation_author': [
            ('_citation_author.citation_id', '%s', 'str', ''),
            ('_citation_author.name', '%s', 'str', ''),
            ('_citation_author.ordinal', '%s', 'str', '')
        ],
        'computing': [
            ('_computing.entry_id', '%s', 'str', ''),
            ('_computing.pdbx_data_reduction_ii', '%s', 'str', ''),
            ('_computing.pdbx_data_reduction_ds', '%s', 'str', ''),
            ('_computing.data_collection', '%s', 'str', ''),
            ('_computing.structure_solution', '%s', 'str', ''),
            ('_computing.structure_refinement', '%s', 'str', ''),
            ('_computing.pdbx_structure_refinement_method', '%s', 'str', '')
        ],
        'database': [
            ('_database.entry_id', '%s', 'str', ''),
            ('_database.pdbx_code_NDB', '%s', 'str', ''),
            ('_database.pdbx_code_PDB', '%s', 'str', ''),
            ('_database.code_CSD', '%s', 'str', ''),
            ('_database.pdbx_code_BMCD', '%s', 'str', ''),
            ('_database.pdbx_code_NDBDID', '%s', 'str', '')
        ],
        'database_2': [
            ('_database_2.database_id', '%s', 'str', ''),
            ('_database_2.database_code', '%s', 'str', '')
        ],
        'entity': [
            ('_entity.id', '%s', 'str', ''),
            ('_entity.type', '%s', 'str', ''),
            ('_entity.src_method', '%s', 'str', ''),
            ('_entity.pdbx_description', '%s', 'str', ''),
            ('_entity.formula_weight', '%s', 'str', ''),
            ('_entity.pdbx_number_of_molecules', '%s', 'str', ''),
            ('_entity.details', '%s', 'str', ''),
            ('_entity.pdbx_nonpoly_type', '%s', 'str', '')
        ],
        'entity_keywords': [
            ('_entity_keywords.entity_id', '%s', 'str', ''),
            ('_entity_keywords.text', '%s', 'str', ''),
            ('_entity_keywords.pdbx_mutation', '%s', 'str', ''),
            ('_entity_keywords.pdbx_fragment', '%s', 'str', ''),
            ('_entity_keywords.pdbx_antibody_isotype', '%s', 'str', ''),
            ('_entity_keywords.pdbx_ec', '%s', 'str', ''),
            ('_entity_keywords.pdbx_biological_unit', '%s', 'str', '')
        ],
        'entity_name_com': [
            ('_entity_name_com.entity_id', '%s', 'str', ''),
            ('_entity_name_com.name', '%s', 'str', '')
        ],
        'entity_name_sys': [
            ('_entity_name_sys.entity_id', '%s', 'str', ''),
            ('_entity_name_sys.name', '%s', 'str', '')
        ],
        'entity_poly_seq': [
            ('_entity_poly_seq.entity_id', '%s', 'str', ''),
            ('_entity_poly_seq.num', '%s', 'str', ''),
            ('_entity_poly_seq.mon_id', '%s', 'str', ''),
            ('_entity_poly_seq.hetero', '%s', 'str', '')
        ],
        'entity_poly': [
            ('_entity_poly.entity_id', '%s', 'str', ''),
            ('_entity_poly.type', '%s', 'str', ''),
            ('_entity_poly.nstd_linkage', '%s', 'str', ''),
            ('_entity_poly.nstd_monomer', '%s', 'str', ''),
            ('_entity_poly.pdbx_seq_one_letter_code', '%s', 'str', ''),
            ('_entity_poly.pdbx_seq_one_letter_code_can', '%s', 'str', ''),
            ('_entity_poly.pdbx_chain_id', '%s', 'str', ''),
            ('_entity_poly.pdbx_target_identifier', '%s', 'str', '')
        ],
        'entity_src_gen': [
            ('_entity_src_gen.entity_id', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_common_name', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_genus', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_gene', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_species', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_strain', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_tissue', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_tissue_fraction', '%s', 'str', ''),
            ('_entity_src_gen.gene_src_details', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_fragment', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_scientific_name', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_ncbi_taxonomy_id', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_variant', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_cell_line', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_atcc', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_culture_collection', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_organ', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_organelle', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_cell', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_gene_src_cellular_location', '%s', 'str', ''),
            ('_entity_src_gen.host_org_common_name', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_scientific_name', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_ncbi_taxonomy_id', '%s', 'str', ''),
            ('_entity_src_gen.host_org_genus', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_gene', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_organ', '%s', 'str', ''),
            ('_entity_src_gen.host_org_species', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_tissue', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_tissue_fraction', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_strain', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_variant', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_cell_line', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_atcc', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_culture_collection', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_cell', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_organelle', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_cellular_location', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_vector_type', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_host_org_vector', '%s', 'str', ''),
            ('_entity_src_gen.plasmid_name', '%s', 'str', ''),
            ('_entity_src_gen.plasmid_details', '%s', 'str', ''),
            ('_entity_src_gen.pdbx_description', '%s', 'str', '')
        ],
        'entity_src_nat': [
            ('_entity_src_nat.entity_id', '%s', 'str', ''),
            ('_entity_src_nat.common_name', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_organism_scientific', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_ncbi_taxonomy_id', '%s', 'str', ''),
            ('_entity_src_nat.genus', '%s', 'str', ''),
            ('_entity_src_nat.species', '%s', 'str', ''),
            ('_entity_src_nat.strain', '%s', 'str', ''),
            ('_entity_src_nat.tissue', '%s', 'str', ''),
            ('_entity_src_nat.tissue_fraction', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_secretion', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_fragment', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_variant', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_cell_line', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_atcc', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_culture_collection', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_cellular_location', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_organ', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_organelle', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_cell', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_plasmid_name', '%s', 'str', ''),
            ('_entity_src_nat.pdbx_plasmid_details', '%s', 'str', ''),
            ('_entity_src_nat.details', '%s', 'str', '')
        ],
        'pdbx_coord': [
            ('_pdbx_coord.entry_id', '%s', 'str', ''),
            ('_pdbx_coord.chain_atoms_Y_P', '%s', 'str', ''),
            ('_pdbx_coord.hydrogen_atoms_Y_N', '%s', 'str', ''),
            ('_pdbx_coord.solvent_atoms_Y_N', '%s', 'str', ''),
            ('_pdbx_coord.structure_factors_Y_N', '%s', 'str', '')
        ],
        'pdbx_nonstandard_list': [
            ('_pdbx_nonstandard_list.id', '%s', 'str', ''),
            ('_pdbx_nonstandard_list.label_asym_id', '%s', 'str', ''),
            ('_pdbx_nonstandard_list.label_seq_id', '%s', 'str', ''),
            ('_pdbx_nonstandard_list.ins_code', '%s', 'str', ''),
            ('_pdbx_nonstandard_list.auth_asym_id', '%s', 'str', ''),
            ('_pdbx_nonstandard_list.auth_seq_id', '%s', 'str', ''),
            ('_pdbx_nonstandard_list.number_atoms_nh', '%s', 'str', '')
        ],
        'pdbx_entity_src_syn': [
            ('_pdbx_entity_src_syn.entity_id', '%s', 'str', ''),
            ('_pdbx_entity_src_syn.organism_scientific', '%s', 'str', ''),
            ('_pdbx_entity_src_syn.organism_common_name', '%s', 'str', ''),
            ('_pdbx_entity_src_syn.ncbi_taxonomy_id', '%s', 'str', ''),
            ('_pdbx_entity_src_syn.details', '%s', 'str', '')
        ],
        'pdbx_missing_residue_list': [
            ('_pdbx_missing_residue_list.label_seq_id', '%s', 'str', ''),
            ('_pdbx_missing_residue_list.pdb_model_id', '%s', 'str', ''),
            ('_pdbx_missing_residue_list.pdb_chain_id', '%s', 'str', ''),
            ('_pdbx_missing_residue_list.pdb_residue_name', '%s', 'str', ''),
            ('_pdbx_missing_residue_list.pdb_residue_number', '%s', 'str', ''),
            ('_pdbx_missing_residue_list.pdb_insertion_code', '%s', 'str', '')
        ],
        'pdbx_struct_link': [
            ('_pdbx_struct_link.id', '%s', 'str', ''),
            ('_pdbx_struct_link.type', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_label_alt_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_label_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_label_atom_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_label_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_label_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_label_ins_code', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr1_symmetry', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_label_alt_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_label_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_label_atom_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_label_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_label_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_label_ins_code', '%s', 'str', ''),
            ('_pdbx_struct_link.ptnr2_symmetry', '%s', 'str', ''),
            ('_pdbx_struct_link.details', '%s', 'str', ''),
            ('_pdbx_struct_link.pdbx_dist_value', '%s', 'str', '')
        ],
        'pdbx_struct_ncs_gen': [
            ('_pdbx_struct_ncs_gen.id', '%s', 'str', ''),
            ('_pdbx_struct_ncs_gen.oper_id', '%s', 'str', ''),
            ('_pdbx_struct_ncs_gen.from_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_ncs_gen.from_pdb_chain_id', '%s', 'str', ''),
            ('_pdbx_struct_ncs_gen.to_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_ncs_gen.to_pdb_chain_id', '%s', 'str', ''),
            ('_pdbx_struct_ncs_gen.pdbx_pdb_order', '%s', 'str', '')
        ],
        'refine_hist': [
            ('_refine_hist.pdbx_refine_id', '%s', 'str', ''),
            ('_refine_hist.cycle_id', '%s', 'str', ''),
            ('_refine_hist.pdbx_number_atoms_protein', '%s', 'str', ''),
            ('_refine_hist.pdbx_number_atoms_nucleic_acid', '%s', 'str', ''),
            ('_refine_hist.pdbx_number_atoms_ligand', '%s', 'str', ''),
            ('_refine_hist.number_atoms_solvent', '%s', 'str', ''),
            ('_refine_hist.number_atoms_total', '%s', 'str', ''),
            ('_refine_hist.d_res_high', '%s', 'str', ''),
            ('_refine_hist.d_res_low', '%s', 'str', '')
        ],
        'struct': [
            ('_struct.entry_id', '%s', 'str', ''),
            ('_struct.title', '%s', 'str', ''),
            ('_struct.pdbx_descriptor', '%s', 'str', ''),
            ('_struct.pdbx_model_details', '%s', 'str', ''),
            ('_struct.pdbx_details', '%s', 'str', ''),
            ('_struct.pdbx_CASP_flag', '%s', 'str', ''),
            ('_struct.pdbx_model_type_details', '%s', 'str', '')
        ],
        'struct_asym': [
            ('_struct_asym.id', '%s', 'str', ''),
            ('_struct_asym.pdbx_pdb_id', '%s', 'str', ''),
            ('_struct_asym.pdbx_alt_id', '%s', 'str', ''),
            ('_struct_asym.pdbx_blank_PDB_chainid_flag', '%s', 'str', ''),
            ('_struct_asym.pdbx_type', '%s', 'str', ''),
            ('_struct_asym.pdbx_order', '%s', 'str', ''),
            ('_struct_asym.pdbx_modified', '%s', 'str', ''),
            ('_struct_asym.pdbx_fraction_per_asym_unit', '%s', 'str', ''),
            ('_struct_asym.entity_id', '%s', 'str', ''),
            ('_struct_asym.pdbx_missing_num_begin_of_chain_not_in_seqres', '%s', 'str', ''),
            ('_struct_asym.pdbx_missing_num_end_of_chain_not_in_seqres', '%s', 'str', ''),
            ('_struct_asym.pdbx_missing_num_begin_of_chain_in_seqres', '%s', 'str', ''),
            ('_struct_asym.details', '%s', 'str', '')
        ],
        'struct_biol_gen': [
            ('_struct_biol_gen.biol_id', '%s', 'str', ''),
            ('_struct_biol_gen.asym_id', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_new_asym_id', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_new_pdb_asym_id', '%s', 'str', ''),
            ('_struct_biol_gen.symmetry', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_before_begin_residue_no', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_before_end_residue_no', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_after_begin_residue_no', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_after_end_residue_no', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_color_red', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_color_green', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_color_blue', '%s', 'str', ''),
            ('_struct_biol_gen.details', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_full_symmetry_operation', '%s', 'str', ''),
            ('_struct_biol_gen.pdbx_pdb_order', '%s', 'str', '')
        ],
        'struct_conf': [
            ('_struct_conf.conf_type_id', '%s', 'str', ''),
            ('_struct_conf.id', '%s', 'str', ''),
            ('_struct_conf.pdb_id', '%s', 'str', ''),
            ('_struct_conf.beg_label_comp_id', '%s', 'str', ''),
            ('_struct_conf.beg_label_asym_id', '%s', 'str', ''),
            ('_struct_conf.beg_label_seq_id', '%s', 'str', ''),
            ('_struct_conf.pdbx_beg_label_ins_code_pdb', '%s', 'str', ''),
            ('_struct_conf.end_label_comp_id', '%s', 'str', ''),
            ('_struct_conf.end_label_asym_id', '%s', 'str', ''),
            ('_struct_conf.end_label_seq_id', '%s', 'str', ''),
            ('_struct_conf.pdbx_end_label_ins_code_pdb', '%s', 'str', ''),
            ('_struct_conf.beg_auth_comp_id', '%s', 'str', ''),
            ('_struct_conf.beg_auth_asym_id', '%s', 'str', ''),
            ('_struct_conf.beg_auth_seq_id', '%s', 'str', ''),
            ('_struct_conf.end_auth_comp_id', '%s', 'str', ''),
            ('_struct_conf.end_auth_asym_id', '%s', 'str', ''),
            ('_struct_conf.end_auth_seq_id', '%s', 'str', ''),
            ('_struct_conf.pdbx_helix_class_pdb', '%s', 'str', ''),
            ('_struct_conf.details', '%s', 'str', ''),
            ('_struct_conf.pdbx_length', '%s', 'str', '')
        ],
        'struct_conf_type': [
            ('_struct_conf_type.id', '%s', 'str', ''),
            ('_struct_conf_type.criteria', '%s', 'str', ''),
            ('_struct_conf_type.reference', '%s', 'str', '')
        ],
        'pdbx_struct_mod_residue': [
            ('_pdbx_struct_mod_residue.id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.label_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.label_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.label_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.auth_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.auth_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.auth_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.PDB_ins_code', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.parent_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_mod_residue.details', '%s', 'str', '')
        ],
        'struct_conn': [
            ('_struct_conn.id', '%s', 'str', ''),
            ('_struct_conn.conn_type_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_PDB_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr1_mod_name', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr1_replaced_atom', '%s', 'str', ''),
            ('_struct_conn.ptnr1_label_asym_id', '%s', 'str', ''),
            ('_struct_conn.ptnr1_label_comp_id', '%s', 'str', ''),
            ('_struct_conn.ptnr1_label_seq_id', '%s', 'str', ''),
            ('_struct_conn.ptnr1_label_atom_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr1_label_alt_loc', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr1_label_ins_code', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr1_standard_comp_id', '%s', 'str', ''),
            ('_struct_conn.ptnr1_symmetry', '%s', 'str', ''),
            ('_struct_conn.ptnr2_label_asym_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_label_comp_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_label_seq_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_label_atom_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr2_label_alt_loc', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr2_label_ins_code', '%s', 'str', ''),
            ('_struct_conn.ptnr1_auth_asym_id', '%s', 'str', ''),
            ('_struct_conn.ptnr1_auth_comp_id', '%s', 'str', ''),
            ('_struct_conn.ptnr1_auth_seq_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_auth_asym_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_auth_comp_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_auth_seq_id', '%s', 'str', ''),
            ('_struct_conn.ptnr2_symmetry', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr3_label_atom_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr3_label_seq_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr3_label_comp_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr3_label_asym_id', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr3_label_alt_loc', '%s', 'str', ''),
            ('_struct_conn.pdbx_ptnr3_label_ins_code', '%s', 'str', ''),
            ('_struct_conn.details', '%s', 'str', ''),
            ('_struct_conn.pdbx_dist_value', '%s', 'str', ''),
            ('_struct_conn.pdbx_value_order', '%s', 'str', '')
        ],
        'struct_conn_type': [
            ('_struct_conn_type.id', '%s', 'str', ''),
            ('_struct_conn_type.criteria', '%s', 'str', ''),
            ('_struct_conn_type.reference', '%s', 'str', '')
        ],
        'struct_ncs_oper': [
            ('_struct_ncs_oper.id', '%s', 'str', ''),
            ('_struct_ncs_oper.code', '%s', 'str', ''),
            ('_struct_ncs_oper.details', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[1][1]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[1][2]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[1][3]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[2][1]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[2][2]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[2][3]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[3][1]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[3][2]', '%s', 'str', ''),
            ('_struct_ncs_oper.matrix[3][3]', '%s', 'str', ''),
            ('_struct_ncs_oper.vector[1]', '%s', 'str', ''),
            ('_struct_ncs_oper.vector[2]', '%s', 'str', ''),
            ('_struct_ncs_oper.vector[3]', '%s', 'str', '')
        ],

        'struct_sheet': [
            ('_struct_sheet.id', '%s', 'str', ''),
            ('_struct_sheet.type', '%s', 'str', ''),
            ('_struct_sheet.number_strands', '%s', 'str', ''),
            ('_struct_sheet.details', '%s', 'str', '')
        ],
        'struct_sheet_order': [
            ('_struct_sheet_order.sheet_id', '%s', 'str', ''),
            ('_struct_sheet_order.range_id_1', '%s', 'str', ''),
            ('_struct_sheet_order.range_id_2', '%s', 'str', ''),
            ('_struct_sheet_order.offset', '%s', 'str', ''),
            ('_struct_sheet_order.sense', '%s', 'str', '')
        ],
        'struct_sheet_range': [
            ('_struct_sheet_range.sheet_id', '%s', 'str', ''),
            ('_struct_sheet_range.id', '%s', 'str', ''),
            ('_struct_sheet_range.beg_label_comp_id', '%s', 'str', ''),
            ('_struct_sheet_range.beg_label_asym_id', '%s', 'str', ''),
            ('_struct_sheet_range.beg_label_seq_id', '%s', 'str', ''),
            ('_struct_sheet_range.pdbx_beg_label_ins_code_pdb', '%s', 'str', ''),
            ('_struct_sheet_range.end_label_comp_id', '%s', 'str', ''),
            ('_struct_sheet_range.end_label_asym_id', '%s', 'str', ''),
            ('_struct_sheet_range.end_label_seq_id', '%s', 'str', ''),
            ('_struct_sheet_range.pdbx_end_label_ins_code_pdb', '%s', 'str', ''),
            ('_struct_sheet_range.symmetry', '%s', 'str', ''),
            ('_struct_sheet_range.beg_auth_comp_id', '%s', 'str', ''),
            ('_struct_sheet_range.beg_auth_asym_id', '%s', 'str', ''),
            ('_struct_sheet_range.beg_auth_seq_id', '%s', 'str', ''),
            ('_struct_sheet_range.end_auth_comp_id', '%s', 'str', ''),
            ('_struct_sheet_range.end_auth_asym_id', '%s', 'str', ''),
            ('_struct_sheet_range.end_auth_seq_id', '%s', 'str', '')
        ],
        'pdbx_struct_sheet_hbond': [
            ('_pdbx_struct_sheet_hbond.sheet_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_id_1', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_id_2', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_label_atom_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_label_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_label_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_label_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_PDB_ins_code', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_auth_atom_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_auth_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_auth_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_1_auth_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_label_atom_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_label_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_label_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_label_seq_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_PDB_ins_code', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_auth_atom_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_auth_comp_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_auth_asym_id', '%s', 'str', ''),
            ('_pdbx_struct_sheet_hbond.range_2_auth_seq_id', '%s', 'str', '')
        ],
        'diffrn_radiation_wavelength': [
            ('_diffrn_radiation_wavelength.id', '%s', 'str', ''),
            ('_diffrn_radiation_wavelength.wavelength', '%s', 'str', ''),
            ('_diffrn_radiation_wavelength.wt', '%s', 'str', '')
        ],

        'chem_comp': [
            ('_chem_comp.id', '%s', 'str', ''),
            ('_chem_comp.type', '%s', 'str', ''),
            ('_chem_comp.mon_nstd_flag', '%s', 'str', ''),
            ('_chem_comp.name', '%s', 'str', ''),
            ('_chem_comp.pdbx_synonyms', '%s', 'str', ''),
            ('_chem_comp.formula', '%s', 'str', ''),
            ('_chem_comp.formula_weight', '%s', 'str', '')
        ],
        'struct_mon_prot_cis': [
            ('_struct_mon_prot_cis.id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.label_comp_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.label_seq_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.label_asym_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.label_alt_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_label_ins_code', '%s', 'str', ''),
            ('_struct_mon_prot_cis.auth_comp_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.auth_seq_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.auth_asym_id', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_auth_ins_code', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_label_comp_id_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_label_seq_id_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_label_asym_id_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_label_ins_code_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_auth_comp_id_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_auth_seq_id_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_auth_asym_id_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_auth_ins_code_2', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_model_num', '%s', 'str', ''),
            ('_struct_mon_prot_cis.pdbx_omega_angle', '%s', 'str', '')
        ],
        'pdbx_coordinate_model': [
            ('_pdbx_coordinate_model.asym_id', '%s', 'str', ''),
            ('_pdbx_coordinate_model.type', '%s', 'str', '')
        ],
        'pdbx_validate_rmsd_angle': [
            ('_pdbx_validate_rmsd_angle.id', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.PDB_model_num', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_atom_id_1', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_asym_id_1', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_comp_id_1', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_seq_id_1', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.PDB_ins_code_1', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.label_alt_id_1', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_atom_id_2', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_asym_id_2', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_comp_id_2', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_seq_id_2', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.PDB_ins_code_2', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.label_alt_id_2', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_atom_id_3', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_asym_id_3', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_comp_id_3', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.auth_seq_id_3', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.PDB_ins_code_3', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.label_alt_id_3', '%s', 'str', ''),
            ('_pdbx_validate_rmsd_angle.angle_deviation', '%s', 'str', '')
        ],
        'pdbx_validate_torsion': [
            ('_pdbx_validate_torsion.id', '%s', 'str', ''),
            ('_pdbx_validate_torsion.PDB_model_num', '%s', 'str', ''),
            ('_pdbx_validate_torsion.auth_comp_id', '%s', 'str', ''),
            ('_pdbx_validate_torsion.auth_asym_id', '%s', 'str', ''),
            ('_pdbx_validate_torsion.auth_seq_id', '%s', 'str', ''),
            ('_pdbx_validate_torsion.PDB_ins_code', '%s', 'str', ''),
            ('_pdbx_validate_torsion.phi', '%s', 'str', ''),
            ('_pdbx_validate_torsion.psi', '%s', 'str', '')
        ],
        'pdbx_entity_nonpoly': [
            ('_pdbx_entity_nonpoly.entity_id', '%s', 'str', ''),
            ('_pdbx_entity_nonpoly.name', '%s', 'str', ''),
            ('_pdbx_entity_nonpoly.comp_id', '%s', 'str', '')
        ],
        'atom_site': [
            ('_atom_site.group_PDB', '%s', 'str', ''),
            ('_atom_site.id', '%s', 'str', ''),
            ('_atom_site.type_symbol', '%s', 'str', ''),
            ('_atom_site.label_atom_id', '%s', 'str', ''),
            ('_atom_site.label_alt_id', '%s', 'str', ''),
            ('_atom_site.label_comp_id', '%s', 'str', ''),
            ('_atom_site.label_asym_id', '%s', 'str', ''),
            ('_atom_site.label_entity_id', '%s', 'str', ''),
            ('_atom_site.label_seq_id', '%s', 'str', ''),
            ('_atom_site.pdbx_label_seq_num', '%s', 'str', ''),
            ('_atom_site.pdbx_ins_code', '%s', 'str', ''),
            ('_atom_site.Cartn_x', '%s', 'str', ''),
            ('_atom_site.Cartn_y', '%s', 'str', ''),
            ('_atom_site.Cartn_z', '%s', 'str', ''),
            ('_atom_site.occupancy', '%s', 'str', ''),
            ('_atom_site.B_iso_or_equiv', '%s', 'str', ''),
            ('_atom_site.Cartn_x_esd', '%s', 'str', ''),
            ('_atom_site.Cartn_y_esd', '%s', 'str', ''),
            ('_atom_site.Cartn_z_esd', '%s', 'str', ''),
            ('_atom_site.occupancy_esd', '%s', 'str', ''),
            ('_atom_site.B_iso_or_equiv_esd', '%s', 'str', ''),
            ('_atom_site.footnote_id', '%s', 'str', ''),
            ('_atom_site.pdbx_formal_charge', '%s', 'str', ''),
            ('_atom_site.auth_seq_id', '%s', 'str', ''),
            ('_atom_site.auth_comp_id', '%s', 'str', ''),
            ('_atom_site.auth_asym_id', '%s', 'str', ''),
            ('_atom_site.auth_atom_id', '%s', 'str', ''),
            ('_atom_site.pdbx_auth_seq_id', '%s', 'str', ''),
            ('_atom_site.pdbx_auth_comp_id', '%s', 'str', ''),
            ('_atom_site.pdbx_auth_asym_id', '%s', 'str', ''),
            ('_atom_site.pdbx_auth_atom_name', '%s', 'str', ''),
            ('_atom_site.pdbx_PDB_model', '%s', 'str', '')
        ]
    }

    _excludeList = []
    _suppressList = []
    #

    def __init__(self):
        super(PdbxReportCategoryStyle, self).__init__(styleId=PdbxReportCategoryStyle._styleId,
                                                      catFormatL=PdbxReportCategoryStyle._categoryInfo,
                                                      catItemD=PdbxReportCategoryStyle._cDict,
                                                      excludeList=PdbxReportCategoryStyle._excludeList,
                                                      suppressList=PdbxReportCategoryStyle._suppressList)
