##
# File: PdbxEmExtensionCategoryStyle.py
# Date: 00-Mon-2015  J. Westbrook
#
# Updates:
#  18-Aug-2015 jdw   add em_map.partition item
#   5-Mar-2018  jdw Py2-Py3 and refactor for Python Packaging
##
"""
Abbreviated PDBx style defining data categories containing ....  details.

"""
from __future__ import absolute_import
__docformat__ = "restructuredtext en"
__author__ = "John Westbrook"
__email__ = "john.westbrook@rcsb.org"
__license__ = "Apache 2.0"



from mmcif_utils.style.PdbxCategoryStyleBase import PdbxCategoryStyleBase


class PdbxEmExtensionCategoryStyle(PdbxCategoryStyleBase):

    _styleId = 'PDBX_STYLE_EmExtension_V1'
    _categoryInfo = [
        ('em_assembly', 'table'),
        ('em_entity_assembly', 'table'),
        ('em_virus_entity', 'table'),
        ('em_sample_preparation', 'table'),
        ('em_sample_support', 'table'),
        ('em_2d_crystal_grow', 'table'),
        ('em_buffer', 'table'),
        ('em_vitrification', 'table'),
        ('em_imaging', 'table'),
        ('em_detector', 'table'),
        ('em_image_scans', 'table'),
        ('em_2d_projection_selection', 'table'),
        ('em_3d_reconstruction', 'table'),
        ('em_3d_fitting', 'table'),
        ('em_3d_fitting_list', 'table'),
        ('em_helical_entity', 'table'),
        ('em_experiment', 'table'),
        ('em_single_particle_entity', 'table'),
        ('em_admin', 'table'),
        ('em_author_list', 'table'),
        ('em_db_reference', 'table'),
        ('em_db_reference_auxiliary', 'table'),
        ('em_depui', 'table'),
        ('em_obsolete', 'table'),
        ('em_supersede', 'table'),
        ('em_entity_assembly_molwt', 'table'),
        ('em_entity_assembly_naturalsource', 'table'),
        ('em_entity_assembly_recombinant', 'table'),
        ('em_virus_natural_host', 'table'),
        ('em_virus_shell', 'table'),
        ('em_specimen', 'table'),
        ('em_embedding', 'table'),
        ('em_fiducial_markers', 'table'),
        ('em_focused_ion_beam', 'table'),
        ('em_grid_pretreatment', 'table'),
        ('em_ultramicrotomy', 'table'),
        ('em_high_pressure_freezing', 'table'),
        ('em_shadowing', 'table'),
        ('em_tomography_specimen', 'table'),
        ('em_crystal_formation', 'table'),
        ('em_staining', 'table'),
        ('em_support_film', 'table'),
        ('em_buffer_component', 'table'),
        ('em_diffraction', 'table'),
        ('em_diffraction_shell', 'table'),
        ('em_diffraction_stats', 'table'),
        ('em_tomography', 'table'),
        ('em_image_recording', 'table'),
        ('em_imaging_optics', 'table'),
        ('em_final_classification', 'table'),
        ('em_start_model', 'table'),
        ('em_software', 'table'),
        ('em_euler_angle_assignment', 'table'),
        ('em_ctf_correction', 'table'),
        ('em_volume_selection', 'table'),
        ('em_3d_crystal_entity', 'table'),
        ('em_2d_crystal_entity', 'table'),
        ('em_image_processing', 'table'),
        ('em_particle_selection', 'table'),
        ('em_map', 'table'),
        ('em_fsc_curve', 'table'),
        ('em_interpret_figure', 'table'),
        ('em_layer_lines', 'table'),
        ('em_structure_factors', 'table'),
    ]
    _cDict = {
        'em_assembly': [
            ('_em_assembly.id', '%s', 'str', ''),
            ('_em_assembly.entry_id', '%s', 'str', ''),
            ('_em_assembly.name', '%s', 'str', ''),
            ('_em_assembly.aggregation_state', '%s', 'str', ''),
            ('_em_assembly.composition', '%s', 'str', ''),
            ('_em_assembly.num_components', '%s', 'str', ''),
            ('_em_assembly.mol_wt_exp', '%s', 'str', ''),
            ('_em_assembly.mol_wt_theo', '%s', 'str', ''),
            ('_em_assembly.mol_wt_method', '%s', 'str', ''),
            ('_em_assembly.details', '%s', 'str', ''),
        ],
        'em_entity_assembly': [
            ('_em_entity_assembly.id', '%s', 'str', ''),
            ('_em_entity_assembly.assembly_id', '%s', 'str', ''),
            ('_em_entity_assembly.parent_id', '%s', 'str', ''),
            #('_em_entity_assembly.chimera', '%s', 'str', ''),
            ('_em_entity_assembly.source', '%s', 'str', ''),
            ('_em_entity_assembly.type', '%s', 'str', ''),
            ('_em_entity_assembly.name', '%s', 'str', ''),
            ('_em_entity_assembly.details', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_organism_scientific', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_organism_common', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_strain', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_tissue', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_cell', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_organelle', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_cellular_location', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_engineered', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_expression_system', '%s', 'str', ''),
            ('_em_entity_assembly.ebi_expression_system_plasmid', '%s', 'str', ''),
            ('_em_entity_assembly.go_id', '%s', 'str', ''),
            ('_em_entity_assembly.ipr_id', '%s', 'str', ''),
            ('_em_entity_assembly.synonym', '%s', 'str', ''),
            ('_em_entity_assembly.mutant_flag', '%s', 'str', ''),
            ('_em_entity_assembly.number_of_copies', '%s', 'str', ''),
            ('_em_entity_assembly.oligomeric_details', '%s', 'str', ''),
            ('_em_entity_assembly.entity_id_list', '%s', 'str', ''),
        ],
        'em_virus_entity': [
            ('_em_virus_entity.id', '%s', 'str', ''),
            ('_em_virus_entity.virus_host_category', '%s', 'str', ''),
            ('_em_virus_entity.virus_host_species', '%s', 'str', ''),
            ('_em_virus_entity.virus_host_growth_cell', '%s', 'str', ''),
            ('_em_virus_entity.virus_type', '%s', 'str', ''),
            ('_em_virus_entity.virus_isolate', '%s', 'str', ''),
            ('_em_virus_entity.ictvdb_id', '%s', 'str', ''),
            ('_em_virus_entity.entity_assembly_id', '%s', 'str', ''),
            ('_em_virus_entity.enveloped', '%s', 'str', ''),
            ('_em_virus_entity.empty', '%s', 'str', ''),
            ('_em_virus_entity.details', '%s', 'str', ''),
        ],
        'em_sample_preparation': [
            ('_em_sample_preparation.entry_id', '%s', 'str', ''),
            ('_em_sample_preparation.id', '%s', 'str', ''),
            ('_em_sample_preparation.ph', '%s', 'str', ''),
            ('_em_sample_preparation.buffer_id', '%s', 'str', ''),
            ('_em_sample_preparation.sample_concentration', '%s', 'str', ''),
            ('_em_sample_preparation.2d_crystal_grow_id', '%s', 'str', ''),
            ('_em_sample_preparation.support_id', '%s', 'str', ''),
            ('_em_sample_preparation.entity_assembly_id', '%s', 'str', ''),
            ('_em_sample_preparation.details', '%s', 'str', ''),
        ],
        'em_sample_support': [
            ('_em_sample_support.id', '%s', 'str', ''),
            ('_em_sample_support.film_material', '%s', 'str', ''),
            ('_em_sample_support.method', '%s', 'str', ''),
            ('_em_sample_support.grid_material', '%s', 'str', ''),
            ('_em_sample_support.grid_mesh_size', '%s', 'str', ''),
            ('_em_sample_support.grid_type', '%s', 'str', ''),
            ('_em_sample_support.pretreatment', '%s', 'str', ''),
            ('_em_sample_support.details', '%s', 'str', ''),
            ('_em_sample_support.specimen_id', '%s', 'str', ''),
            ('_em_sample_support.citation_id', '%s', 'str', ''),
        ],
        'em_2d_crystal_grow': [
            ('_em_2d_crystal_grow.id', '%s', 'str', ''),
            ('_em_2d_crystal_grow.method', '%s', 'str', ''),
            ('_em_2d_crystal_grow.apparatus', '%s', 'str', ''),
            ('_em_2d_crystal_grow.atmosphere', '%s', 'str', ''),
            ('_em_2d_crystal_grow.pH', '%s', 'str', ''),
            ('_em_2d_crystal_grow.temp', '%s', 'str', ''),
            ('_em_2d_crystal_grow.time', '%s', 'str', ''),
            ('_em_2d_crystal_grow.buffer_id', '%s', 'str', ''),
            ('_em_2d_crystal_grow.details', '%s', 'str', ''),
            ('_em_2d_crystal_grow.number_2d_crystals', '%s', 'str', ''),
            ('_em_2d_crystal_grow.mean_2d_crystal_size', '%s', 'str', ''),
            ('_em_2d_crystal_grow.citation_id', '%s', 'str', ''),
        ],
        'em_buffer': [
            ('_em_buffer.id', '%s', 'str', ''),
            ('_em_buffer.specimen_id', '%s', 'str', ''),
            ('_em_buffer.name', '%s', 'str', ''),
            ('_em_buffer.details', '%s', 'str', ''),
            ('_em_buffer.pH', '%s', 'str', ''),
        ],
        'em_vitrification': [
            ('_em_vitrification.entry_id', '%s', 'str', ''),
            ('_em_vitrification.id', '%s', 'str', ''),
            ('_em_vitrification.sample_preparation_id', '%s', 'str', ''),
            ('_em_vitrification.specimen_id', '%s', 'str', ''),
            ('_em_vitrification.cryogen_name', '%s', 'str', ''),
            ('_em_vitrification.humidity', '%s', 'str', ''),
            ('_em_vitrification.temp', '%s', 'str', ''),
            ('_em_vitrification.chamber_temperature', '%s', 'str', ''),
            ('_em_vitrification.instrument', '%s', 'str', ''),
            ('_em_vitrification.method', '%s', 'str', ''),
            ('_em_vitrification.time_resolved_state', '%s', 'str', ''),
            ('_em_vitrification.citation_id', '%s', 'str', ''),
            ('_em_vitrification.details', '%s', 'str', ''),
        ],
        'em_imaging': [
            ('_em_imaging.entry_id', '%s', 'str', ''),
            ('_em_imaging.id', '%s', 'str', ''),
            ('_em_imaging.astigmatism', '%s', 'str', ''),
            ('_em_imaging.electron_beam_tilt_params', '%s', 'str', ''),
            ('_em_imaging.residual_tilt', '%s', 'str', ''),
            ('_em_imaging.sample_support_id', '%s', 'str', ''),
            ('_em_imaging.detector_id', '%s', 'str', ''),
            ('_em_imaging.scans_id', '%s', 'str', ''),
            ('_em_imaging.microscope_id', '%s', 'str', ''),
            ('_em_imaging.microscope_model', '%s', 'str', ''),
            ('_em_imaging.specimen_holder_type', '%s', 'str', ''),
            ('_em_imaging.specimen_holder_model', '%s', 'str', ''),
            ('_em_imaging.details', '%s', 'str', ''),
            ('_em_imaging.date', '%s', 'str', ''),
            ('_em_imaging.accelerating_voltage', '%s', 'str', ''),
            ('_em_imaging.illumination_mode', '%s', 'str', ''),
            ('_em_imaging.mode', '%s', 'str', ''),
            ('_em_imaging.nominal_cs', '%s', 'str', ''),
            ('_em_imaging.nominal_defocus_min', '%s', 'str', ''),
            ('_em_imaging.nominal_defocus_max', '%s', 'str', ''),
            ('_em_imaging.calibrated_defocus_min', '%s', 'str', ''),
            ('_em_imaging.calibrated_defocus_max', '%s', 'str', ''),
            ('_em_imaging.tilt_angle_min', '%s', 'str', ''),
            ('_em_imaging.tilt_angle_max', '%s', 'str', ''),
            ('_em_imaging.nominal_magnification', '%s', 'str', ''),
            ('_em_imaging.calibrated_magnification', '%s', 'str', ''),
            ('_em_imaging.electron_source', '%s', 'str', ''),
            ('_em_imaging.electron_dose', '%s', 'str', ''),
            ('_em_imaging.energy_filter', '%s', 'str', ''),
            ('_em_imaging.energy_window', '%s', 'str', ''),
            ('_em_imaging.citation_id', '%s', 'str', ''),
            ('_em_imaging.temperature', '%s', 'str', ''),
            ('_em_imaging.detector_distance', '%s', 'str', ''),
            ('_em_imaging.recording_temperature_minimum', '%s', 'str', ''),
            ('_em_imaging.recording_temperature_maximum', '%s', 'str', ''),
            ('_em_imaging.alignment_procedure', '%s', 'str', ''),
            ('_em_imaging.c2_aperture_diameter', '%s', 'str', ''),
            ('_em_imaging.specimen_id', '%s', 'str', ''),
            ('_em_imaging.cryogen', '%s', 'str', ''),
        ],
        'em_detector': [
            ('_em_detector.entry_id', '%s', 'str', ''),
            ('_em_detector.id', '%s', 'str', ''),
            ('_em_detector.details', '%s', 'str', ''),
            ('_em_detector.type', '%s', 'str', ''),
            ('_em_detector.detective_quantum_efficiency', '%s', 'str', ''),
            ('_em_detector.mode', '%s', 'str', ''),
        ],
        'em_image_scans': [
            ('_em_image_scans.entry_id', '%s', 'str', ''),
            ('_em_image_scans.id', '%s', 'str', ''),
            ('_em_image_scans.number_digital_images', '%s', 'str', ''),
            ('_em_image_scans.details', '%s', 'str', ''),
            ('_em_image_scans.scanner_model', '%s', 'str', ''),
            ('_em_image_scans.sampling_size', '%s', 'str', ''),
            ('_em_image_scans.od_range', '%s', 'str', ''),
            ('_em_image_scans.quant_bit_size', '%s', 'str', ''),
            ('_em_image_scans.citation_id', '%s', 'str', ''),
            ('_em_image_scans.dimension_height', '%s', 'str', ''),
            ('_em_image_scans.dimension_width', '%s', 'str', ''),
            ('_em_image_scans.frames_per_image', '%s', 'str', ''),
            ('_em_image_scans.image_recording_id', '%s', 'str', ''),
            ('_em_image_scans.used_frames_per_image', '%s', 'str', ''),
        ],
        'em_2d_projection_selection': [
            ('_em_2d_projection_selection.entry_id', '%s', 'str', ''),
            ('_em_2d_projection_selection.id', '%s', 'str', ''),
            ('_em_2d_projection_selection.num_particles', '%s', 'str', ''),
            ('_em_2d_projection_selection.software_name', '%s', 'str', ''),
            ('_em_2d_projection_selection.method', '%s', 'str', ''),
            ('_em_2d_projection_selection.details', '%s', 'str', ''),
            ('_em_2d_projection_selection.citation_id', '%s', 'str', ''),
        ],
        'em_3d_reconstruction': [
            ('_em_3d_reconstruction.entry_id', '%s', 'str', ''),
            ('_em_3d_reconstruction.id', '%s', 'str', ''),
            ('_em_3d_reconstruction.method', '%s', 'str', ''),
            ('_em_3d_reconstruction.algorithm', '%s', 'str', ''),
            ('_em_3d_reconstruction.citation_id', '%s', 'str', ''),
            ('_em_3d_reconstruction.details', '%s', 'str', ''),
            ('_em_3d_reconstruction.resolution', '%s', 'str', ''),
            ('_em_3d_reconstruction.resolution_method', '%s', 'str', ''),
            ('_em_3d_reconstruction.magnification_calibration', '%s', 'str', ''),
            ('_em_3d_reconstruction.ctf_correction_method', '%s', 'str', ''),
            ('_em_3d_reconstruction.nominal_pixel_size', '%s', 'str', ''),
            ('_em_3d_reconstruction.actual_pixel_size', '%s', 'str', ''),
            ('_em_3d_reconstruction.num_particles', '%s', 'str', ''),
            #('_em_3d_reconstruction.num_subtomograms', '%s', 'str', ''),
            ('_em_3d_reconstruction.euler_angles_details', '%s', 'str', ''),
            ('_em_3d_reconstruction.num_class_averages', '%s', 'str', ''),
            ('_em_3d_reconstruction.software', '%s', 'str', ''),
            ('_em_3d_reconstruction.fsc_type', '%s', 'str', ''),
            ('_em_3d_reconstruction.image_processing_id', '%s', 'str', ''),
            #('_em_3d_reconstruction.software_id_list', '%s', 'str', ''),
            ('_em_3d_reconstruction.symmetry_type', '%s', 'str', ''),
        ],
        'em_3d_fitting': [
            ('_em_3d_fitting.id', '%s', 'str', ''),
            ('_em_3d_fitting.entry_id', '%s', 'str', ''),
            ('_em_3d_fitting.method', '%s', 'str', ''),
            ('_em_3d_fitting.target_criteria', '%s', 'str', ''),
            ('_em_3d_fitting.software_name', '%s', 'str', ''),
            ('_em_3d_fitting.details', '%s', 'str', ''),
            ('_em_3d_fitting.overall_b_value', '%s', 'str', ''),
            ('_em_3d_fitting.ref_space', '%s', 'str', ''),
            ('_em_3d_fitting.ref_protocol', '%s', 'str', ''),
            #('_em_3d_fitting.software_id_list', '%s', 'str', ''),
        ],
        'em_3d_fitting_list': [
            ('_em_3d_fitting_list.id', '%s', 'str', ''),
            ('_em_3d_fitting_list.3d_fitting_id', '%s', 'str', ''),
            ('_em_3d_fitting_list.pdb_entry_id', '%s', 'str', ''),
            ('_em_3d_fitting_list.pdb_chain_id', '%s', 'str', ''),
            ('_em_3d_fitting_list.pdb_chain_residue_range', '%s', 'str', ''),
            ('_em_3d_fitting_list.details', '%s', 'str', ''),
        ],
        'em_helical_entity': [
            ('_em_helical_entity.id', '%s', 'str', ''),
            ('_em_helical_entity.entity_assembly_id', '%s', 'str', ''),
            ('_em_helical_entity.image_processing_id', '%s', 'str', ''),
            ('_em_helical_entity.details', '%s', 'str', ''),
            ('_em_helical_entity.dyad', '%s', 'str', ''),
            ('_em_helical_entity.axial_symmetry', '%s', 'str', ''),
            ('_em_helical_entity.angular_rotation_per_subunit', '%s', 'str', ''),
            ('_em_helical_entity.axial_rise_per_subunit', '%s', 'str', ''),
            ('_em_helical_entity.hand', '%s', 'str', ''),
        ],
        'em_experiment': [
            ('_em_experiment.entry_id', '%s', 'str', ''),
            ('_em_experiment.id', '%s', 'str', ''),
            ('_em_experiment.reconstruction_method', '%s', 'str', ''),
            ('_em_experiment.aggregation_state', '%s', 'str', ''),
            ('_em_experiment.specimen_type', '%s', 'str', ''),
            ('_em_experiment.entity_assembly_id', '%s', 'str', ''),
        ],
        'em_single_particle_entity': [
            ('_em_single_particle_entity.entry_id', '%s', 'str', ''),
            ('_em_single_particle_entity.id', '%s', 'str', ''),
            ('_em_single_particle_entity.symmetry_type', '%s', 'str', ''),
            ('_em_single_particle_entity.image_processing_id', '%s', 'str', ''),
            ('_em_single_particle_entity.point_symmetry', '%s', 'str', ''),
        ],
        'em_admin': [
            ('_em_admin.current_status', '%s', 'str', ''),
            ('_em_admin.deposition_date', '%s', 'str', ''),
            ('_em_admin.deposition_site', '%s', 'str', ''),
            ('_em_admin.details', '%s', 'str', ''),
            ('_em_admin.entry_id', '%s', 'str', ''),
            ('_em_admin.last_update', '%s', 'str', ''),
            ('_em_admin.map_hold_date', '%s', 'str', ''),
            ('_em_admin.map_release_date', '%s', 'str', ''),
            ('_em_admin.header_release_date', '%s', 'str', ''),
            ('_em_admin.obsoleted_date', '%s', 'str', ''),
            ('_em_admin.replace_existing_entry_flag', '%s', 'str', ''),
            ('_em_admin.title', '%s', 'str', ''),
        ],
        'em_author_list': [
            ('_em_author_list.author', '%s', 'str', ''),
            ('_em_author_list.ordinal', '%s', 'str', ''),
        ],
        'em_db_reference': [
            ('_em_db_reference.access_code', '%s', 'str', ''),
            ('_em_db_reference.db_name', '%s', 'str', ''),
            ('_em_db_reference.details', '%s', 'str', ''),
            ('_em_db_reference.id', '%s', 'str', ''),
            ('_em_db_reference.relationship', '%s', 'str', ''),
        ],
        'em_db_reference_auxiliary': [
            ('_em_db_reference_auxiliary.id', '%s', 'str', ''),
            ('_em_db_reference_auxiliary.link', '%s', 'str', ''),
            ('_em_db_reference_auxiliary.link_type', '%s', 'str', ''),
        ],
        'em_depui': [
            ('_em_depui.depositor_hold_instructions', '%s', 'str', ''),
            ('_em_depui.entry_id', '%s', 'str', ''),
            ('_em_depui.macromolecule_description', '%s', 'str', ''),
            ('_em_depui.obsolete_instructions', '%s', 'str', ''),
            ('_em_depui.same_authors_as_pdb', '%s', 'str', ''),
            ('_em_depui.same_title_as_pdb', '%s', 'str', ''),
        ],
        'em_obsolete': [
            ('_em_obsolete.date', '%s', 'str', ''),
            ('_em_obsolete.details', '%s', 'str', ''),
            ('_em_obsolete.entry', '%s', 'str', ''),
            ('_em_obsolete.id', '%s', 'str', ''),
        ],
        'em_supersede': [
            ('_em_supersede.date', '%s', 'str', ''),
            ('_em_supersede.details', '%s', 'str', ''),
            ('_em_supersede.entry', '%s', 'str', ''),
            ('_em_supersede.id', '%s', 'str', ''),
        ],
        'em_entity_assembly_molwt': [
            ('_em_entity_assembly_molwt.entity_assembly_id', '%s', 'str', ''),
            ('_em_entity_assembly_molwt.experimental_flag', '%s', 'str', ''),
            ('_em_entity_assembly_molwt.id', '%s', 'str', ''),
            ('_em_entity_assembly_molwt.units', '%s', 'str', ''),
            ('_em_entity_assembly_molwt.value', '%s', 'str', ''),
        ],
        'em_entity_assembly_naturalsource': [
            ('_em_entity_assembly_naturalsource.cell', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.cellular_location', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.entity_assembly_id', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.id', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.ncbi_tax_id', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.organism', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.organelle', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.organ', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.strain', '%s', 'str', ''),
            ('_em_entity_assembly_naturalsource.tissue', '%s', 'str', ''),
        ],
        'em_entity_assembly_recombinant': [
            ('_em_entity_assembly_recombinant.cell', '%s', 'str', ''),
            ('_em_entity_assembly_recombinant.entity_assembly_id', '%s', 'str', ''),
            ('_em_entity_assembly_recombinant.id', '%s', 'str', ''),
            ('_em_entity_assembly_recombinant.ncbi_tax_id', '%s', 'str', ''),
            ('_em_entity_assembly_recombinant.organism', '%s', 'str', ''),
            ('_em_entity_assembly_recombinant.plasmid', '%s', 'str', ''),
            ('_em_entity_assembly_recombinant.strain', '%s', 'str', ''),
        ],
        'em_virus_natural_host': [
            ('_em_virus_natural_host.entity_assembly_id', '%s', 'str', ''),
            ('_em_virus_natural_host.id', '%s', 'str', ''),
            ('_em_virus_natural_host.ncbi_tax_id', '%s', 'str', ''),
            ('_em_virus_natural_host.organism', '%s', 'str', ''),
            ('_em_virus_natural_host.strain', '%s', 'str', ''),
        ],
        'em_virus_shell': [
            ('_em_virus_shell.diameter', '%s', 'str', ''),
            ('_em_virus_shell.entity_assembly_id', '%s', 'str', ''),
            ('_em_virus_shell.id', '%s', 'str', ''),
            ('_em_virus_shell.name', '%s', 'str', ''),
            ('_em_virus_shell.triangulation', '%s', 'str', ''),
        ],
        'em_specimen': [
            ('_em_specimen.concentration', '%s', 'str', ''),
            ('_em_specimen.details', '%s', 'str', ''),
            ('_em_specimen.embedding_applied', '%s', 'str', ''),
            ('_em_specimen.experiment_id', '%s', 'str', ''),
            ('_em_specimen.id', '%s', 'str', ''),
            ('_em_specimen.shadowing_applied', '%s', 'str', ''),
            ('_em_specimen.staining_applied', '%s', 'str', ''),
            ('_em_specimen.vitrification_applied', '%s', 'str', ''),
        ],
        'em_embedding': [
            ('_em_embedding.details', '%s', 'str', ''),
            ('_em_embedding.id', '%s', 'str', ''),
            ('_em_embedding.material', '%s', 'str', ''),
            ('_em_embedding.specimen_id', '%s', 'str', ''),
        ],
        'em_fiducial_markers': [
            ('_em_fiducial_markers.diameter', '%s', 'str', ''),
            ('_em_fiducial_markers.em_tomography_specimen_id', '%s', 'str', ''),
            ('_em_fiducial_markers.id', '%s', 'str', ''),
            ('_em_fiducial_markers.manufacturer', '%s', 'str', ''),
        ],
        'em_focused_ion_beam': [
            ('_em_focused_ion_beam.current', '%s', 'str', ''),
            ('_em_focused_ion_beam.details', '%s', 'str', ''),
            ('_em_focused_ion_beam.dose_rate', '%s', 'str', ''),
            ('_em_focused_ion_beam.duration', '%s', 'str', ''),
            ('_em_focused_ion_beam.em_tomography_specimen_id', '%s', 'str', ''),
            ('_em_focused_ion_beam.final_thickness', '%s', 'str', ''),
            ('_em_focused_ion_beam.id', '%s', 'str', ''),
            ('_em_focused_ion_beam.initial_thickness', '%s', 'str', ''),
            ('_em_focused_ion_beam.instrument', '%s', 'str', ''),
            ('_em_focused_ion_beam.ion', '%s', 'str', ''),
            ('_em_focused_ion_beam.temperature', '%s', 'str', ''),
            ('_em_focused_ion_beam.voltage', '%s', 'str', ''),
        ],
        'em_grid_pretreatment': [
            ('_em_grid_pretreatment.atmosphere', '%s', 'str', ''),
            ('_em_grid_pretreatment.id', '%s', 'str', ''),
            ('_em_grid_pretreatment.pressure', '%s', 'str', ''),
            ('_em_grid_pretreatment.sample_support_id', '%s', 'str', ''),
            ('_em_grid_pretreatment.time', '%s', 'str', ''),
            ('_em_grid_pretreatment.type', '%s', 'str', ''),
        ],
        'em_ultramicrotomy': [
            ('_em_ultramicrotomy.details', '%s', 'str', ''),
            ('_em_ultramicrotomy.em_tomography_specimen_id', '%s', 'str', ''),
            ('_em_ultramicrotomy.final_thickness', '%s', 'str', ''),
            ('_em_ultramicrotomy.id', '%s', 'str', ''),
            ('_em_ultramicrotomy.instrument', '%s', 'str', ''),
            ('_em_ultramicrotomy.temperature', '%s', 'str', ''),
        ],
        'em_high_pressure_freezing': [
            ('_em_high_pressure_freezing.details', '%s', 'str', ''),
            ('_em_high_pressure_freezing.em_tomography_specimen_id', '%s', 'str', ''),
            ('_em_high_pressure_freezing.id', '%s', 'str', ''),
            ('_em_high_pressure_freezing.instrument', '%s', 'str', ''),
        ],
        'em_shadowing': [
            ('_em_shadowing.angle', '%s', 'str', ''),
            ('_em_shadowing.details', '%s', 'str', ''),
            ('_em_shadowing.id', '%s', 'str', ''),
            ('_em_shadowing.material', '%s', 'str', ''),
            ('_em_shadowing.specimen_id', '%s', 'str', ''),
            ('_em_shadowing.thickness', '%s', 'str', ''),
        ],
        'em_tomography_specimen': [
            ('_em_tomography_specimen.cryo_protectant', '%s', 'str', ''),
            ('_em_tomography_specimen.details', '%s', 'str', ''),
            ('_em_tomography_specimen.fiducial_markers', '%s', 'str', ''),
            ('_em_tomography_specimen.high_pressure_freezing', '%s', 'str', ''),
            ('_em_tomography_specimen.id', '%s', 'str', ''),
            ('_em_tomography_specimen.sectioning', '%s', 'str', ''),
            ('_em_tomography_specimen.specimen_id', '%s', 'str', ''),
        ],
        'em_crystal_formation': [
            ('_em_crystal_formation.atmosphere', '%s', 'str', ''),
            ('_em_crystal_formation.details', '%s', 'str', ''),
            ('_em_crystal_formation.id', '%s', 'str', ''),
            ('_em_crystal_formation.instrument', '%s', 'str', ''),
            ('_em_crystal_formation.lipid_mixture', '%s', 'str', ''),
            ('_em_crystal_formation.lipid_protein_ratio', '%s', 'str', ''),
            ('_em_crystal_formation.specimen_id', '%s', 'str', ''),
            ('_em_crystal_formation.temperature', '%s', 'str', ''),
            ('_em_crystal_formation.time', '%s', 'str', ''),
            ('_em_crystal_formation.time_unit', '%s', 'str', ''),
        ],
        'em_staining': [
            ('_em_staining.details', '%s', 'str', ''),
            ('_em_staining.id', '%s', 'str', ''),
            ('_em_staining.material', '%s', 'str', ''),
            ('_em_staining.specimen_id', '%s', 'str', ''),
            ('_em_staining.type', '%s', 'str', ''),
        ],
        'em_support_film': [
            ('_em_support_film.id', '%s', 'str', ''),
            ('_em_support_film.material', '%s', 'str', ''),
            ('_em_support_film.sample_support_id', '%s', 'str', ''),
            ('_em_support_film.thickness', '%s', 'str', ''),
            ('_em_support_film.topology', '%s', 'str', ''),
        ],
        'em_buffer_component': [
            ('_em_buffer_component.buffer_id', '%s', 'str', ''),
            ('_em_buffer_component.concentration', '%s', 'str', ''),
            ('_em_buffer_component.concentration_units', '%s', 'str', ''),
            ('_em_buffer_component.formula', '%s', 'str', ''),
            ('_em_buffer_component.id', '%s', 'str', ''),
            ('_em_buffer_component.name', '%s', 'str', ''),
        ],
        'em_diffraction': [
            ('_em_diffraction.camera_length', '%s', 'str', ''),
            ('_em_diffraction.id', '%s', 'str', ''),
            ('_em_diffraction.imaging_id', '%s', 'str', ''),
            ('_em_diffraction.tilt_angle_list', '%s', 'str', ''),
        ],
        'em_diffraction_shell': [
            ('_em_diffraction_shell.em_diffraction_stats_id', '%s', 'str', ''),
            ('_em_diffraction_shell.fourier_space_coverage', '%s', 'str', ''),
            ('_em_diffraction_shell.high_resolution', '%s', 'str', ''),
            ('_em_diffraction_shell.id', '%s', 'str', ''),
            ('_em_diffraction_shell.low_resolution', '%s', 'str', ''),
            ('_em_diffraction_shell.multiplicity', '%s', 'str', ''),
            ('_em_diffraction_shell.num_structure_factors', '%s', 'str', ''),
            ('_em_diffraction_shell.phase_residual', '%s', 'str', ''),
        ],
        'em_diffraction_stats': [
            ('_em_diffraction_stats.details', '%s', 'str', ''),
            ('_em_diffraction_stats.fourier_space_coverage', '%s', 'str', ''),
            ('_em_diffraction_stats.high_resolution', '%s', 'str', ''),
            ('_em_diffraction_stats.id', '%s', 'str', ''),
            ('_em_diffraction_stats.image_processing_id', '%s', 'str', ''),
            ('_em_diffraction_stats.num_intensities_measured', '%s', 'str', ''),
            ('_em_diffraction_stats.num_structure_factors', '%s', 'str', ''),
            ('_em_diffraction_stats.overall_phase_error', '%s', 'str', ''),
            ('_em_diffraction_stats.overall_phase_residual', '%s', 'str', ''),
            ('_em_diffraction_stats.phase_error_rejection_criteria', '%s', 'str', ''),
            ('_em_diffraction_stats.r_merge', '%s', 'str', ''),
            ('_em_diffraction_stats.r_sym', '%s', 'str', ''),
        ],
        'em_tomography': [
            ('_em_tomography.axis1_angle_increment', '%s', 'str', ''),
            ('_em_tomography.axis1_max_angle', '%s', 'str', ''),
            ('_em_tomography.axis1_min_angle', '%s', 'str', ''),
            ('_em_tomography.axis2_angle_increment', '%s', 'str', ''),
            ('_em_tomography.axis2_max_angle', '%s', 'str', ''),
            ('_em_tomography.axis2_min_angle', '%s', 'str', ''),
            ('_em_tomography.dual_tilt_axis_rotation', '%s', 'str', ''),
            ('_em_tomography.id', '%s', 'str', ''),
            ('_em_tomography.imaging_id', '%s', 'str', ''),
        ],
        'em_image_recording': [
            #('_em_image_recording.approximate_date', '%s', 'str', ''),
            ('_em_image_recording.average_exposure_time', '%s', 'str', ''),
            ('_em_image_recording.avg_electron_dose_per_image', '%s', 'str', ''),
            ('_em_image_recording.details', '%s', 'str', ''),
            ('_em_image_recording.detector_mode', '%s', 'str', ''),
            ('_em_image_recording.film_or_detector_model', '%s', 'str', ''),
            ('_em_image_recording.id', '%s', 'str', ''),
            ('_em_image_recording.imaging_id', '%s', 'str', ''),
            ('_em_image_recording.num_diffraction_images', '%s', 'str', ''),
            ('_em_image_recording.num_grids_imaged', '%s', 'str', ''),
            ('_em_image_recording.num_real_images', '%s', 'str', ''),
        ],
        'em_imaging_optics': [
            ('_em_imaging_optics.chr_aberration_corrector', '%s', 'str', ''),
            ('_em_imaging_optics.energyfilter_lower', '%s', 'str', ''),
            ('_em_imaging_optics.energyfilter_name', '%s', 'str', ''),
            ('_em_imaging_optics.energyfilter_upper', '%s', 'str', ''),
            ('_em_imaging_optics.id', '%s', 'str', ''),
            ('_em_imaging_optics.imaging_id', '%s', 'str', ''),
            ('_em_imaging_optics.phase_plate', '%s', 'str', ''),
            ('_em_imaging_optics.sph_aberration_corrector', '%s', 'str', ''),
        ],
        'em_final_classification': [
            ('_em_final_classification.avg_num_images_per_class', '%s', 'str', ''),
            ('_em_final_classification.details', '%s', 'str', ''),
            ('_em_final_classification.id', '%s', 'str', ''),
            ('_em_final_classification.image_processing_id', '%s', 'str', ''),
            ('_em_final_classification.num_classes', '%s', 'str', ''),
        ],
        'em_start_model': [
            ('_em_start_model.details', '%s', 'str', ''),
            ('_em_start_model.emdb_id', '%s', 'str', ''),
            ('_em_start_model.id', '%s', 'str', ''),
            ('_em_start_model.image_processing_id', '%s', 'str', ''),
            ('_em_start_model.insilico_model', '%s', 'str', ''),
            ('_em_start_model.orthogonal_tilt_angle1', '%s', 'str', ''),
            ('_em_start_model.orthogonal_tilt_angle2', '%s', 'str', ''),
            ('_em_start_model.orthogonal_tilt_num_images', '%s', 'str', ''),
            ('_em_start_model.other', '%s', 'str', ''),
            ('_em_start_model.pdb_id', '%s', 'str', ''),
            ('_em_start_model.random_conical_tilt_angle', '%s', 'str', ''),
            ('_em_start_model.random_conical_tilt_num_images', '%s', 'str', ''),
            ('_em_start_model.type', '%s', 'str', ''),
        ],
        'em_software': [
            ('_em_software.category', '%s', 'str', ''),
            ('_em_software.details', '%s', 'str', ''),
            ('_em_software.id', '%s', 'str', ''),
            ('_em_software.image_processing_id', '%s', 'str', ''),
            ('_em_software.name', '%s', 'str', ''),
            ('_em_software.version', '%s', 'str', ''),
        ],
        'em_euler_angle_assignment': [
            ('_em_euler_angle_assignment.details', '%s', 'str', ''),
            ('_em_euler_angle_assignment.id', '%s', 'str', ''),
            ('_em_euler_angle_assignment.image_processing_id', '%s', 'str', ''),
            ('_em_euler_angle_assignment.order', '%s', 'str', ''),
            ('_em_euler_angle_assignment.proj_matching_angular_sampling', '%s', 'str', ''),
            ('_em_euler_angle_assignment.proj_matching_merit_function', '%s', 'str', ''),
            ('_em_euler_angle_assignment.proj_matching_num_projections', '%s', 'str', ''),
            ('_em_euler_angle_assignment.type', '%s', 'str', ''),
        ],
        'em_ctf_correction': [
            ('_em_ctf_correction.amplitude_correction', '%s', 'str', ''),
            ('_em_ctf_correction.amplitude_correction_factor', '%s', 'str', ''),
            ('_em_ctf_correction.amplitude_correction_space', '%s', 'str', ''),
            ('_em_ctf_correction.correction_operation', '%s', 'str', ''),
            ('_em_ctf_correction.details', '%s', 'str', ''),
            #('_em_ctf_correction.em_software_id', '%s', 'str', ''),
            ('_em_ctf_correction.id', '%s', 'str', ''),
            ('_em_ctf_correction.phase_reversal', '%s', 'str', ''),
            ('_em_ctf_correction.phase_reversal_anisotropic', '%s', 'str', ''),
            ('_em_ctf_correction.phase_reversal_correction_space', '%s', 'str', ''),
            ('_em_ctf_correction.type', '%s', 'str', ''),
            ('_em_ctf_correction.amplitude_correction', '%s', 'str', ''),
            ('_em_ctf_correction.amplitude_correction_factor', '%s', 'str', ''),
            ('_em_ctf_correction.amplitude_correction_space', '%s', 'str', ''),
            ('_em_ctf_correction.correction_operation', '%s', 'str', ''),
            ('_em_ctf_correction.details', '%s', 'str', ''),
            #('_em_ctf_correction.em_software_id', '%s', 'str', ''),
            ('_em_ctf_correction.id', '%s', 'str', ''),
            ('_em_ctf_correction.phase_reversal', '%s', 'str', ''),
            ('_em_ctf_correction.phase_reversal_anisotropic', '%s', 'str', ''),
            ('_em_ctf_correction.phase_reversal_correction_space', '%s', 'str', ''),
            ('_em_ctf_correction.type', '%s', 'str', ''),
        ],
        'em_volume_selection': [
            ('_em_volume_selection.details', '%s', 'str', ''),
            ('_em_volume_selection.id', '%s', 'str', ''),
            ('_em_volume_selection.image_processing_id', '%s', 'str', ''),
            ('_em_volume_selection.method', '%s', 'str', ''),
            ('_em_volume_selection.num_tomograms', '%s', 'str', ''),
            ('_em_volume_selection.num_volumes_extracted', '%s', 'str', ''),
            ('_em_volume_selection.reference_model', '%s', 'str', ''),
        ],
        'em_3d_crystal_entity': [
            ('_em_3d_crystal_entity.angle_alpha', '%s', 'str', ''),
            ('_em_3d_crystal_entity.angle_beta', '%s', 'str', ''),
            ('_em_3d_crystal_entity.angle_gamma', '%s', 'str', ''),
            ('_em_3d_crystal_entity.image_processing_id', '%s', 'str', ''),
            ('_em_3d_crystal_entity.id', '%s', 'str', ''),
            ('_em_3d_crystal_entity.length_a', '%s', 'str', ''),
            ('_em_3d_crystal_entity.length_b', '%s', 'str', ''),
            ('_em_3d_crystal_entity.length_c', '%s', 'str', ''),
            ('_em_3d_crystal_entity.space_group_name', '%s', 'str', ''),
            ('_em_3d_crystal_entity.space_group_num', '%s', 'str', ''),
        ],
        'em_2d_crystal_entity': [
            ('_em_2d_crystal_entity.angle_gamma', '%s', 'str', ''),
            ('_em_2d_crystal_entity.c_sampling_length', '%s', 'str', ''),
            ('_em_2d_crystal_entity.image_processing_id', '%s', 'str', ''),
            ('_em_2d_crystal_entity.id', '%s', 'str', ''),
            ('_em_2d_crystal_entity.length_a', '%s', 'str', ''),
            ('_em_2d_crystal_entity.length_b', '%s', 'str', ''),
            ('_em_2d_crystal_entity.length_c', '%s', 'str', ''),
            ('_em_2d_crystal_entity.space_group_name_H-M', '%s', 'str', ''),
        ],
        'em_image_processing': [
            ('_em_image_processing.details', '%s', 'str', ''),
            ('_em_image_processing.id', '%s', 'str', ''),
            ('_em_image_processing.image_recording_id', '%s', 'str', ''),
        ],
        'em_particle_selection': [
            ('_em_particle_selection.details', '%s', 'str', ''),
            ('_em_particle_selection.id', '%s', 'str', ''),
            ('_em_particle_selection.image_processing_id', '%s', 'str', ''),
            ('_em_particle_selection.method', '%s', 'str', ''),
            ('_em_particle_selection.num_particles_selected', '%s', 'str', ''),
            ('_em_particle_selection.reference_model', '%s', 'str', ''),
        ],
        'em_map': [
            ('_em_map.annotation_details', '%s', 'str', ''),
            ('_em_map.axis_order_fast', '%s', 'str', ''),
            ('_em_map.axis_order_medium', '%s', 'str', ''),
            ('_em_map.axis_order_slow', '%s', 'str', ''),
            ('_em_map.cell_a', '%s', 'str', ''),
            ('_em_map.cell_b', '%s', 'str', ''),
            ('_em_map.cell_c', '%s', 'str', ''),
            ('_em_map.cell_alpha', '%s', 'str', ''),
            ('_em_map.cell_beta', '%s', 'str', ''),
            ('_em_map.cell_gamma', '%s', 'str', ''),
            ('_em_map.contour_level', '%s', 'str', ''),
            ('_em_map.contour_level_source', '%s', 'str', ''),
            ('_em_map.data_type', '%s', 'str', ''),
            ('_em_map.dimensions_col', '%s', 'str', ''),
            ('_em_map.dimensions_row', '%s', 'str', ''),
            ('_em_map.dimensions_sec', '%s', 'str', ''),
            ('_em_map.endian_type', '%s', 'str', ''),
            ('_em_map.file', '%s', 'str', ''),
            ('_em_map.format', '%s', 'str', ''),
            ('_em_map.id', '%s', 'str', ''),
            ('_em_map.entry_id', '%s', 'str', ''),
            ('_em_map.label', '%s', 'str', ''),
            ('_em_map.limit_col', '%s', 'str', ''),
            ('_em_map.limit_row', '%s', 'str', ''),
            ('_em_map.limit_sec', '%s', 'str', ''),
            ('_em_map.origin_col', '%s', 'str', ''),
            ('_em_map.origin_row', '%s', 'str', ''),
            ('_em_map.origin_sec', '%s', 'str', ''),
            ('_em_map.partition', '%s', 'str', ''),
            ('_em_map.pixel_spacing_x', '%s', 'str', ''),
            ('_em_map.pixel_spacing_y', '%s', 'str', ''),
            ('_em_map.pixel_spacing_z', '%s', 'str', ''),
            ('_em_map.size_kb', '%s', 'str', ''),
            ('_em_map.spacing_x', '%s', 'str', ''),
            ('_em_map.spacing_y', '%s', 'str', ''),
            ('_em_map.spacing_z', '%s', 'str', ''),
            ('_em_map.statistics_average', '%s', 'str', ''),
            ('_em_map.statistics_maximum', '%s', 'str', ''),
            ('_em_map.statistics_minimum', '%s', 'str', ''),
            ('_em_map.statistics_std', '%s', 'str', ''),
            ('_em_map.symmetry_space_group', '%s', 'str', ''),
            ('_em_map.type', '%s', 'str', ''),
        ],
        'em_fsc_curve': [
            ('_em_fsc_curve.details', '%s', 'str', ''),
            ('_em_fsc_curve.file', '%s', 'str', ''),
            ('_em_fsc_curve.id', '%s', 'str', ''),
        ],
        'em_interpret_figure': [
            ('_em_interpret_figure.details', '%s', 'str', ''),
            ('_em_interpret_figure.file', '%s', 'str', ''),
            ('_em_interpret_figure.id', '%s', 'str', ''),
        ],
        'em_layer_lines': [
            ('_em_layer_lines.details', '%s', 'str', ''),
            ('_em_layer_lines.experiment_id', '%s', 'str', ''),
            ('_em_layer_lines.file', '%s', 'str', ''),
            ('_em_layer_lines.id', '%s', 'str', ''),
        ],
        'em_structure_factors': [
            ('_em_structure_factors.details', '%s', 'str', ''),
            ('_em_structure_factors.experiment_id', '%s', 'str', ''),
            ('_em_structure_factors.file', '%s', 'str', ''),
            ('_em_structure_factors.id', '%s', 'str', ''),
        ],
    }
    _excludeList = []
    _suppressList = []

    #
    def __init__(self):
        super(PdbxEmExtensionCategoryStyle, self).__init__(styleId=PdbxEmExtensionCategoryStyle._styleId,
                                                           catFormatL=PdbxEmExtensionCategoryStyle._categoryInfo,
                                                           catItemD=PdbxEmExtensionCategoryStyle._cDict,
                                                           excludeList=PdbxEmExtensionCategoryStyle._excludeList,
                                                           suppressList=PdbxEmExtensionCategoryStyle._suppressList)
