# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class SmartDiagnosticsApiConfiguration(Configuration):
    """Configuration for SmartDiagnosticsApi
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        if not base_url:
            base_url = 'https://sd.kcftech.com'

        super(SmartDiagnosticsApiConfiguration, self).__init__(base_url)

        self.add_user_agent('kcf_sd_sdk/{}'.format(VERSION))


class SmartDiagnosticsApi(SDKClient):
    """SmartDiagnostics REST API for internal users only

    :ivar config: Configuration for client.
    :vartype config: SmartDiagnosticsApiConfiguration

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        self.config = SmartDiagnosticsApiConfiguration(base_url)
        super(SmartDiagnosticsApi, self).__init__(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v3'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def get_activity_events(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets activity events.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `ActivityLineEnabled` | Boolean | `eq, neq` |
         | `AssetCardEnabled` | Boolean | `eq, neq` |
         | `BindId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `BindType` | ActivityEventBindType? | `eq, neq, in` |
         | `CategoryCode` | String | `eq, neq, like, in` |
         | `CategoryFlag` | ActivityEventCategoryFlag? | `eq, neq, in` |
         | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryOwnerType` | ActivityEventOwnerType? | `eq, neq, in` |
         | `Description` | String | `eq, neq, like, in` |
         | `EndDateTime` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `FieldCode` | String | `eq, neq, like, in` |
         | `FieldId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `FieldType` | ActivityEventFieldType? | `eq, neq, in` |
         | `FieldValue` | String | `eq, neq, like, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Note` | String | `eq, neq, like, in` |
         | `RelationshipFromId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `RelationshipToId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `RelationshipType` | ActivityEventRelationshipType? | `eq, neq, in`
         |
         | `StartDateTime` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `SubcategoryCode` | String | `eq, neq, like, in` |
         | `SubcategoryId` | Guid | `eq, neq, in` |
         | `Title` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Description` | String |
         | `EndDateTime` | DateTime? |
         | `LocationName` | String |
         | `Note` | String |
         | `StartDateTime` | DateTime |
         | `Title` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_events.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelActivityEventResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_events.metadata = {'url': '/api/v3.0/ActivityEvents'}

    def create_activity_event(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Create an activity event.

        Required Permissions: Location User.

        :param body: Activity event create request
        :type body: ~smartdiagnostics_sdk.models.ActivityEventCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_activity_event.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityEventCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_activity_event.metadata = {'url': '/api/v3.0/ActivityEvents'}

    def get_activity_event(
            self, activity_event_id, custom_headers=None, raw=False, **operation_config):
        """Gets an activity event.

        Required Permissions: Location User.

        :param activity_event_id: Id of activity event to return
        :type activity_event_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event.metadata['url']
        path_format_arguments = {
            'activityEventId': self._serialize.url("activity_event_id", activity_event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event.metadata = {'url': '/api/v3.0/ActivityEvents/{activityEventId}'}

    def update_activity_event(
            self, activity_event_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Update an activity event.

        Required Permissions: Location User.

        :param activity_event_id: Id of the activity event
        :type activity_event_id: str
        :param body: Activity event update request
        :type body: ~smartdiagnostics_sdk.models.ActivityEventUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_activity_event.metadata['url']
        path_format_arguments = {
            'activityEventId': self._serialize.url("activity_event_id", activity_event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityEventUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_activity_event.metadata = {'url': '/api/v3.0/ActivityEvents/{activityEventId}'}

    def delete_activity_event(
            self, activity_event_id, custom_headers=None, raw=False, **operation_config):
        """Delete an activity event.

        Required Permissions: Location Admin.

        :param activity_event_id: Id of the activity event
        :type activity_event_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_activity_event.metadata['url']
        path_format_arguments = {
            'activityEventId': self._serialize.url("activity_event_id", activity_event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_activity_event.metadata = {'url': '/api/v3.0/ActivityEvents/{activityEventId}'}

    def get_activity_event_detail(
            self, activity_event_id, custom_headers=None, raw=False, **operation_config):
        """Gets an activity event details. Expands on standard get activity event
        (by id) method.

        Required Permissions: Location User.

        :param activity_event_id: Id of activity event to return
        :type activity_event_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_detail.metadata['url']
        path_format_arguments = {
            'activityEventId': self._serialize.url("activity_event_id", activity_event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventDetailResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_detail.metadata = {'url': '/api/v3.0/ActivityEvents/{activityEventId}/details'}

    def get_activity_event_categories(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets activity event categories.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `ActivityLineEnabled` | Boolean | `eq, neq` |
         | `AssetCardEnabled` | Boolean | `eq, neq` |
         | `CategoryFlag` | ActivityEventCategoryFlag? | `eq, neq, in` |
         | `Code` | String | `eq, neq, like, in` |
         | `Description` | String | `eq, neq, like, in` |
         | `Internal` | Boolean | `eq, neq` |
         | `Name` | String | `eq, neq, like, in` |
         | `OwnerType` | ActivityEventOwnerType | `eq, neq, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Code` | String |
         | `Description` | String |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_categories.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelActivityEventCategoryResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_categories.metadata = {'url': '/api/v3.0/ActivityEvents/Categories'}

    def get_activity_event_category(
            self, activity_event_category_id, custom_headers=None, raw=False, **operation_config):
        """Gets an activity event category.

        Required Permissions: Location User.

        :param activity_event_category_id: Id of activity event category to
         return
        :type activity_event_category_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_category.metadata['url']
        path_format_arguments = {
            'activityEventCategoryId': self._serialize.url("activity_event_category_id", activity_event_category_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventCategoryResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_category.metadata = {'url': '/api/v3.0/ActivityEvents/Categories/{activityEventCategoryId}'}

    def get_activity_event_category_fields(
            self, activity_event_category_id, custom_headers=None, raw=False, **operation_config):
        """Get activity event category fields.

        Required Permissions: Location User.

        :param activity_event_category_id: Id of the activity event category
        :type activity_event_category_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_category_fields.metadata['url']
        path_format_arguments = {
            'activityEventCategoryId': self._serialize.url("activity_event_category_id", activity_event_category_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ActivityEventFieldResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_category_fields.metadata = {'url': '/api/v3.0/ActivityEvents/Categories/{activityEventCategoryId}/fields'}

    def get_activity_event_subcategories(
            self, activity_event_category_id, location_id=None, custom_headers=None, raw=False, **operation_config):
        """Get activity event subcategories.

        Required Permissions: Location User.

        :param activity_event_category_id: Id of parent activity event
         category
        :type activity_event_category_id: int
        :param location_id: Optional location id
        :type location_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_subcategories.metadata['url']
        path_format_arguments = {
            'activityEventCategoryId': self._serialize.url("activity_event_category_id", activity_event_category_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if location_id is not None:
            query_parameters['locationId'] = self._serialize.query("location_id", location_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ActivityEventSubcategoryResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_subcategories.metadata = {'url': '/api/v3.0/ActivityEvents/Categories/{activityEventCategoryId}/subcategories'}

    def create_activity_event_category_relationship(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Create an activity event category relationship.

        Required Permissions: SaaS / Sentry.

        :param body: Activity event category relationship create request
        :type body:
         ~smartdiagnostics_sdk.models.ActivityEventCategoryRelationshipCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_activity_event_category_relationship.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityEventCategoryRelationshipCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventCategoryRelationshipResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_activity_event_category_relationship.metadata = {'url': '/api/v3.0/ActivityEvents/CategoryRelationships'}

    def get_activity_event_category_relationship(
            self, activity_event_category_relationship_id, custom_headers=None, raw=False, **operation_config):
        """Gets an activity event category relationship.

        Required Permissions: SaaS / Sentry.

        :param activity_event_category_relationship_id: Id of activity event
         category relationship to return
        :type activity_event_category_relationship_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_category_relationship.metadata['url']
        path_format_arguments = {
            'activityEventCategoryRelationshipId': self._serialize.url("activity_event_category_relationship_id", activity_event_category_relationship_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventCategoryRelationshipResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_category_relationship.metadata = {'url': '/api/v3.0/ActivityEvents/CategoryRelationships/{activityEventCategoryRelationshipId}'}

    def delete_activity_event_category_relationship(
            self, activity_event_category_relationship_id, custom_headers=None, raw=False, **operation_config):
        """Delete an activity event category relationship.

        Required Permissions: SaaS / Sentry.

        :param activity_event_category_relationship_id: Id of the activity
         event category relationship
        :type activity_event_category_relationship_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_activity_event_category_relationship.metadata['url']
        path_format_arguments = {
            'activityEventCategoryRelationshipId': self._serialize.url("activity_event_category_relationship_id", activity_event_category_relationship_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_activity_event_category_relationship.metadata = {'url': '/api/v3.0/ActivityEvents/CategoryRelationships/{activityEventCategoryRelationshipId}'}

    def get_activity_event_field_values(
            self, activity_event_field_id, bind_type=None, bind_id=None, allow_query_fallback=True, custom_headers=None, raw=False, **operation_config):
        """Get activity event field values (if any).

        Required Permissions: Location User.

        :param activity_event_field_id: Id of the activity event field
        :type activity_event_field_id: str
        :param bind_type: Optional bind type. Possible values include:
         'Group', 'Indicator', 'EvidenceIndicator', 'Model', 'GroupModel',
         'Alert'
        :type bind_type: str
        :param bind_id: Optional bind id (requires bind type).
        :type bind_id: str
        :param allow_query_fallback: Allow query fallback if no matches for
         bind type / bind id
        :type allow_query_fallback: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_field_values.metadata['url']
        path_format_arguments = {
            'activityEventFieldId': self._serialize.url("activity_event_field_id", activity_event_field_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if bind_type is not None:
            query_parameters['bindType'] = self._serialize.query("bind_type", bind_type, 'str')
        if bind_id is not None:
            query_parameters['bindId'] = self._serialize.query("bind_id", bind_id, 'str')
        if allow_query_fallback is not None:
            query_parameters['allowQueryFallback'] = self._serialize.query("allow_query_fallback", allow_query_fallback, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ActivityEventFieldValueResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_field_values.metadata = {'url': '/api/v3.0/ActivityEvents/Fields/{activityEventFieldId}/values'}

    def update_activity_event_field_values(
            self, activity_event_field_id, bind_type=None, bind_id=None, body=None, custom_headers=None, raw=False, **operation_config):
        """Update / replace activity event field values list.

        Required Permissions: SaaS / Sentry.

        :param activity_event_field_id: Id of the activity event field
        :type activity_event_field_id: str
        :param bind_type: Optional bind type. Possible values include:
         'Group', 'Indicator', 'EvidenceIndicator', 'Model', 'GroupModel',
         'Alert'
        :type bind_type: str
        :param bind_id: Optional bind id (requires bind type).
        :type bind_id: str
        :param body:
        :type body:
         list[~smartdiagnostics_sdk.models.ActivityEventFieldValueRequest]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_activity_event_field_values.metadata['url']
        path_format_arguments = {
            'activityEventFieldId': self._serialize.url("activity_event_field_id", activity_event_field_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if bind_type is not None:
            query_parameters['bindType'] = self._serialize.query("bind_type", bind_type, 'str')
        if bind_id is not None:
            query_parameters['bindId'] = self._serialize.query("bind_id", bind_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[ActivityEventFieldValueRequest]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[ActivityEventFieldValueResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_activity_event_field_values.metadata = {'url': '/api/v3.0/ActivityEvents/Fields/{activityEventFieldId}/values'}

    def get_hierarchy_activity_events_post(
            self, is_slim=False, is_export=False, page=None, page_limit=None, order_by=None, name_search=None, body=None, custom_headers=None, raw=False, **operation_config):
        """Gets activity events for hierarchy groups.

        Required Permissions: Location User.

        :param is_slim: Set to true for slim (less properties) response list
        :type is_slim: bool
        :param is_export:
        :type is_export: bool
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Created` | DateTime? |
         | `CreatedBy` | String |
         | `Description` | String |
         | `EndDateTime` | DateTime? |
         | `LocationName` | String |
         | `StartDateTime` | DateTime |
         | `Title` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Description`, `HierarchySearch`, `Title`.
        :type name_search: str
        :param body: ActivityEventHierarchyGroupRequest instance
        :type body:
         ~smartdiagnostics_sdk.models.ActivityEventHierarchyGroupRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hierarchy_activity_events_post.metadata['url']

        # Construct parameters
        query_parameters = {}
        if is_slim is not None:
            query_parameters['isSlim'] = self._serialize.query("is_slim", is_slim, 'bool')
        if is_export is not None:
            query_parameters['isExport'] = self._serialize.query("is_export", is_export, 'bool')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityEventHierarchyGroupRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelActivityEventHierarchyGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hierarchy_activity_events_post.metadata = {'url': '/api/v3.0/ActivityEvents/HierarchyGroups'}

    def create_activity_event_relationship(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Create an activity event relationship.

        Required Permissions: Location User.

        :param body: Activity event relationship create request
        :type body:
         ~smartdiagnostics_sdk.models.ActivityEventRelationshipCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_activity_event_relationship.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityEventRelationshipCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventRelationshipResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_activity_event_relationship.metadata = {'url': '/api/v3.0/ActivityEvents/Relationships'}

    def get_activity_event_relationship(
            self, activity_event_relationship_id, custom_headers=None, raw=False, **operation_config):
        """Gets an activity event relationship.

        Required Permissions: Location User.

        :param activity_event_relationship_id: Id of activity event
         relationship to return
        :type activity_event_relationship_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_event_relationship.metadata['url']
        path_format_arguments = {
            'activityEventRelationshipId': self._serialize.url("activity_event_relationship_id", activity_event_relationship_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityEventRelationshipResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_event_relationship.metadata = {'url': '/api/v3.0/ActivityEvents/Relationships/{activityEventRelationshipId}'}

    def delete_activity_event_relationship(
            self, activity_event_relationship_id, custom_headers=None, raw=False, **operation_config):
        """Delete an activity event relationship.

        Required Permissions: Location User.

        :param activity_event_relationship_id: Id of the activity event
         relationship
        :type activity_event_relationship_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_activity_event_relationship.metadata['url']
        path_format_arguments = {
            'activityEventRelationshipId': self._serialize.url("activity_event_relationship_id", activity_event_relationship_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_activity_event_relationship.metadata = {'url': '/api/v3.0/ActivityEvents/Relationships/{activityEventRelationshipId}'}

    def acknowledge_alerts(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Acknowledges all alerts for the supplied groups.

        Required Permissions: Location User.

        :param body: Supplied groups for which alerts will be acknowledged
        :type body: ~smartdiagnostics_sdk.models.AlertAcknowledgementRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.acknowledge_alerts.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AlertAcknowledgementRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AcknowledgedAlertsResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    acknowledge_alerts.metadata = {'url': '/api/v3.0/Alerts/acknowledge'}

    def get_analytics_models(
            self, location_ids=None, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Analytics Models.

        Required Permissions: SaaS / Sentry.

        :param location_ids: A list of location ids to filter the results to
         models that are assigned to them or are global
        :type location_ids: list[str]
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `ErrorType` | AnalyticsModelErrorTypeCodes? | `eq, neq, in` |
         | `GroupType` | GroupTypeCodes? | `eq, neq, in` |
         | `IsDeprecated` | Boolean | `eq, neq` |
         | `IsGlobal` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `Type` | AnalyticModelType | `eq, neq, in` |
         | `Version` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Created` | DateTime |
         | `Name` | String |
         | `Type` | AnalyticModelType |
         | `Version` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_models.metadata['url']

        # Construct parameters
        query_parameters = {}
        if location_ids is not None:
            query_parameters['locationIds'] = self._serialize.query("location_ids", location_ids, '[str]', div=',')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models'}

    def create_analytics_models(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an Analytics Model.

        Required Permissions: SaaS.

        :param body: The requested values for the new analytics model
        :type body: ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_analytics_models.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AnalyticsModelCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models'}

    def get_analytics_model(
            self, model_id, custom_headers=None, raw=False, **operation_config):
        """Gets an Analytics Model.

        Required Permissions: SaaS / Sentry.

        :param model_id: Id of the analytics model requested
        :type model_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_model.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_model.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}

    def update_analytics_models(
            self, model_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an Analytics Model.

        Required Permissions: SaaS / Sentry.

        :param model_id: Id of the model being updated
        :type model_id: str
        :param body: The requested update values
        :type body: ~smartdiagnostics_sdk.models.AnalyticsModelUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_analytics_models.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AnalyticsModelUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}

    def delete_analytics_model(
            self, model_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an Analytics Model.

        Required Permissions: SaaS.

        :param model_id:
        :type model_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_analytics_model.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_analytics_model.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}

    def get_analytics_logs(
            self, model_id, start_date, end_date, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets logs for the model.

        Required Permissions: SaaS / Sentry.

        :param model_id: Id of the model
        :type model_id: str
        :param start_date:
        :type start_date: datetime
        :param end_date:
        :type end_date: datetime
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Message` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Date` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_logs.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAnalyticsLogResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_logs.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}/Logs'}

    def get_analytics_model_source(
            self, model_id, custom_headers=None, raw=False, **operation_config):
        """Gets the files associated with an analytics model.

        Required Permissions: Sentry.

        :param model_id:
        :type model_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_model_source.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_model_source.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}/Source'}

    def update_analytics_model_source(
            self, model_id, file=None, custom_headers=None, raw=False, **operation_config):
        """Updates the files associated with an analytics model.

        Required Permissions: minimum Sentry.

        :param model_id:
        :type model_id: str
        :param file:
        :type file: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_analytics_model_source.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'file': file,
        }

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_analytics_model_source.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}/Source'}

    def update_analytics_model_status(
            self, model_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates the status of the model.

        Required Permissions: KCF admin.

        :param model_id: Id of the model being updated
        :type model_id: str
        :param body: The updated status values
        :type body:
         ~smartdiagnostics_sdk.models.AnalyticsModelStatusUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_analytics_model_status.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AnalyticsModelStatusUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_analytics_model_status.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}/status'}

    def get_analytics_model_template(
            self, custom_headers=None, raw=False, **operation_config):
        """Gets the analytics model template file.

        Required Permissions: Sentry.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_model_template.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_model_template.metadata = {'url': '/api/v3.0/Analytics/Models/Source/Template'}

    def get_assets(
            self, group_ids=None, include_analytics_models=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Assets.

        Required Permissions: Location User.

        :param group_ids: The groupIds to grab assets from under
        :type group_ids: list[str]
        :param include_analytics_models: Determines whether to include the
         Analytics Model with the asset
        :type include_analytics_models: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `AnalyticsModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `AnalyticsModelId` | Guid | `eq, neq, in` |
         | `AnalyticsModelName` | String | `eq, neq, like, in` |
         | `CategoryCode` | String | `eq, neq, like, in` |
         | `CategoryId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryName` | String | `eq, neq, like, in` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `CriticalityId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `CriticalityName` | String | `eq, neq, like, in` |
         | `IsOperatorView` | Boolean | `eq, neq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Manufacturer` | String | `eq, neq, like, in` |
         | `ModelName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `NodeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `NodeSerialNumber` | String | `eq, neq, like, in` |
         | `SizeCode` | String | `eq, neq, like, in` |
         | `SizeId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `SizeName` | String | `eq, neq, like, in` |
         | `Supplier` | String | `eq, neq, like, in` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, like, in` |
         | `TypeCode` | String | `eq, neq, like, in` |
         | `TypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `TypeName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CategoryCode` | String |
         | `CategoryName` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `CriticalityId` | Int32? |
         | `CriticalityName` | String |
         | `LocationName` | String |
         | `Name` | String |
         | `SizeCode` | String |
         | `SizeName` | String |
         | `TypeCode` | String |
         | `TypeName` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_assets.metadata['url']

        # Construct parameters
        query_parameters = {}
        if group_ids is not None:
            query_parameters['groupIds'] = self._serialize.query("group_ids", group_ids, '[str]', div=',')
        if include_analytics_models is not None:
            query_parameters['includeAnalyticsModels'] = self._serialize.query("include_analytics_models", include_analytics_models, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_assets.metadata = {'url': '/api/v3.0/Assets'}

    def create_asset(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an asset.

        Required Permissions: Location User.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.AssetCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_asset.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AssetCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_asset.metadata = {'url': '/api/v3.0/Assets'}

    def get_asset(
            self, asset_id, include_analytics_models=False, custom_headers=None, raw=False, **operation_config):
        """Gets an Asset.

        Required Permissions: Location User.

        :param asset_id:
        :type asset_id: str
        :param include_analytics_models: Determines whether to include the
         Analytics Model with the asset
        :type include_analytics_models: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_analytics_models is not None:
            query_parameters['includeAnalyticsModels'] = self._serialize.query("include_analytics_models", include_analytics_models, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}

    def update_asset(
            self, asset_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an asset.

        Required Permissions: Location User.

        :param asset_id:
        :type asset_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.AssetUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AssetUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}

    def delete_asset(
            self, asset_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an asset.

        Required Permissions: Location Admin.

        :param asset_id:
        :type asset_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}

    def get_asset_markers(
            self, asset_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all markers on an asset.

        Required Permissions: User.

        :param asset_id: Id of asset
        :type asset_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `MarkerType` | MarkerType | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `Value` | Double | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Name` | String |
         | `Order` | Int32 |
         | `Value` | Double |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_markers.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMarkerResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_markers.metadata = {'url': '/api/v3.0/Assets/{assetId}/markers'}

    def replace_asset_markers(
            self, asset_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Replaces all the existing markers on the asset with new ones.

        Required Permissions: User.

        :param asset_id: Id of the asset
        :type asset_id: str
        :param body: Request containing marker information
        :type body: list[~smartdiagnostics_sdk.models.MarkerUpdateRequest]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.replace_asset_markers.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[MarkerUpdateRequest]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[MarkerResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    replace_asset_markers.metadata = {'url': '/api/v3.0/Assets/{assetId}/markers'}

    def move_asset(
            self, asset_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves an asset.

        Required Permissions: Location User.

        :param asset_id:
        :type asset_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}/Move'}

    def get_asset_status(
            self, asset_id, custom_headers=None, raw=False, **operation_config):
        """Gets an asset's status.

        Required Permissions: Location User.

        :param asset_id:
        :type asset_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_status.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('GroupStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_status.metadata = {'url': '/api/v3.0/Assets/{assetId}/Status'}

    def get_asset_statuses(
            self, group_ids=None, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets Asset Statuses.

        Required Permissions: Location User.

        :param group_ids:
        :type group_ids: list[str]
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `AlarmCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `DamageScore` | Double? | `eq, neq, in, lt, gt, leq, geq` |
         | `Id` | Guid | `eq, neq, in` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `IsSnoozed` | Boolean | `eq, neq` |
         | `ModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `Name` | String | `eq, neq, like, in` |
         | `WarningCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `AlarmCount` | Int32 |
         | `DamageScore` | Double? |
         | `Name` | String |
         | `WarningCount` | Int32 |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_statuses.metadata['url']

        # Construct parameters
        query_parameters = {}
        if group_ids is not None:
            query_parameters['groupIds'] = self._serialize.query("group_ids", group_ids, '[str]', div=',')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_statuses.metadata = {'url': '/api/v3.0/Assets/Status'}

    def get_asset_types(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets Asset Types.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CategoryCode` | String | `eq, neq, like, in` |
         | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryName` | String | `eq, neq, like, in` |
         | `Code` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Code` | String |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_types.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAssetTypeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_types.metadata = {'url': '/api/v3.0/Assets/Types'}

    def get_base_stations(
            self, include_state=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a paged list of Base Stations.

        Required Permissions: SaaS / Sentry.

        :param include_state: Determines whether to include the states for
         the LastDataUpdate, LastStatusUpdate, and IsOnline
        :type include_state: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `CurrentSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq, geq`
         |
         | `CurrentSoftwareReleaseName` | String | `eq, neq, like, in` |
         | `HardwareRevisionId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `HardwareRevisionName` | String | `eq, neq, like, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` |
         | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `ReceiverName` | String | `eq, neq, like, in` |
         | `ReceiverNetworkId` | String | `eq, neq, like, in` |
         | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq,
         geq` |
         | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `ReceiverSerialNumber` | String | `eq, neq, like, in` |
         | `ReleaseRingId` | Guid | `eq, neq, in` |
         | `ReleaseRingName` | String | `eq, neq, like, in` |
         | `SerialNumber` | String | `eq, neq, like, in` |
         | `TargetedSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq,
         geq` |
         | `TargetedSoftwareReleaseName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `CurrentSoftwareReleaseName` | String |
         | `HardwareRevisionId` | Int32 |
         | `HardwareRevisionName` | String |
         | `LocationName` | String |
         | `Name` | String |
         | `PushToStage` | Boolean |
         | `ReceiverFirmwareVersion` | String |
         | `ReceiverName` | String |
         | `ReceiverNetworkId` | String |
         | `ReceiverPendingRfChannel` | Int32? |
         | `ReceiverRfChannel` | Int32? |
         | `ReleaseRingId` | Guid |
         | `ReleaseRingName` | String |
         | `SerialNumber` | String |
         | `TargetedSoftwareReleaseName` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `CorporationName`,
         `CurrentSoftwareReleaseName`, `HardwareRevisionName`, `LocationName`,
         `Name`, `ReleaseRingName`, `SerialNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_base_stations.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBaseStationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_base_stations.metadata = {'url': '/api/v3.0/BaseStations'}

    def create_base_station(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a Base Station.

        Required Permissions: SaaS.

        :param body: Specifies the properties for the new Base Station
        :type body: ~smartdiagnostics_sdk.models.BaseStationCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_base_station.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'BaseStationCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_base_station.metadata = {'url': '/api/v3.0/BaseStations'}

    def get_base_station(
            self, base_station_id, include_state=False, custom_headers=None, raw=False, **operation_config):
        """Gets a Base Station by Id.

        Required Permissions: SaaS / Sentry.

        :param base_station_id: Id of the Base Station
        :type base_station_id: long
        :param include_state: Determines whether to include the states for
         the LastDataUpdate, LastStatusUpdate, and IsOnline
        :type include_state: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_base_station.metadata['url']
        path_format_arguments = {
            'baseStationId': self._serialize.url("base_station_id", base_station_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_base_station.metadata = {'url': '/api/v3.0/BaseStations/{baseStationId}'}

    def edit_base_station(
            self, base_station_id, include_state=False, body=None, custom_headers=None, raw=False, **operation_config):
        """Edits a Base Station.

        Required Permissions: SaaS.

        :param base_station_id: Id of the Base Station
        :type base_station_id: long
        :param include_state: Determines whether to include the states for
         the LastDataUpdate, LastStatusUpdate, and IsOnline
        :type include_state: bool
        :param body: Contains the properties to update
        :type body: ~smartdiagnostics_sdk.models.BaseStationUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.edit_base_station.metadata['url']
        path_format_arguments = {
            'baseStationId': self._serialize.url("base_station_id", base_station_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'BaseStationUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    edit_base_station.metadata = {'url': '/api/v3.0/BaseStations/{baseStationId}'}

    def get_bearings(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all bearing responses.

        Required Permissions: User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Manufacturer` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `RollerCount` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Bpfi` | Double |
         | `Bpfo` | Double |
         | `Bsf` | Double |
         | `Ftf` | Double |
         | `Manufacturer` | String |
         | `Name` | String |
         | `RollerCount` | Int64 |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Manufacturer`, `Name`, `RollerCount`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_bearings.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBearingResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_bearings.metadata = {'url': '/api/v3.0/Bearings'}

    def get_bearing(
            self, bearing_id, custom_headers=None, raw=False, **operation_config):
        """Gets a bearing.

        Required Permissions: User.

        :param bearing_id: Id of bearing to return
        :type bearing_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_bearing.metadata['url']
        path_format_arguments = {
            'bearingId': self._serialize.url("bearing_id", bearing_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BearingResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_bearing.metadata = {'url': '/api/v3.0/Bearings/{bearingId}'}

    def get_corporations(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns paginated list corporations.

        Required Permissions: Corporation User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `Id` | Guid | `eq, neq, in` |
         | `IndustryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `Active` | Boolean |
         | `Created` | DateTime |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporations.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelCorporationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporations.metadata = {'url': '/api/v3.0/Corporations'}

    def create_corporation(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new corporation.

        Required Permissions: SaaS.

        :param body: A corporation create request
        :type body: ~smartdiagnostics_sdk.models.CorporationCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_corporation.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'CorporationCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_corporation.metadata = {'url': '/api/v3.0/Corporations'}

    def get_corporation(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Returns a single corporation.

        Required Permissions: Corporation User.

        :param id: Id of the corporation
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporation.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporation.metadata = {'url': '/api/v3.0/Corporations/{id}'}

    def update_corporation(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a Corporation.

        Required Permissions: SaaS.

        :param id: Id of the Corporation to be updated
        :type id: str
        :param body: Corporation Update Request
        :type body: ~smartdiagnostics_sdk.models.CorporationUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_corporation.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'CorporationUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_corporation.metadata = {'url': '/api/v3.0/Corporations/{id}'}

    def upload_corporation_icon(
            self, id, file=None, custom_headers=None, raw=False, **operation_config):
        """Updates a Corporations Icon.

        Required Permissions: SaaS.

        :param id: Id of the Corporation to be updated
        :type id: str
        :param file: The image file to upload
        :type file: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.upload_corporation_icon.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'file': file,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 422]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 422:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    upload_corporation_icon.metadata = {'url': '/api/v3.0/Corporations/{id}/Icon'}

    def get_corporation_roi(
            self, corporation_id, start_date=None, end_date=None, custom_headers=None, raw=False, **operation_config):
        """Gets ROI information for a corporation.

        Required Permissions: Corporation User.

        :param corporation_id: The ID of the specified corporation
        :type corporation_id: str
        :param start_date:
        :type start_date: datetime
        :param end_date:
        :type end_date: datetime
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporation_roi.metadata['url']
        path_format_arguments = {
            'corporationId': self._serialize.url("corporation_id", corporation_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if start_date is not None:
            query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RoiResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporation_roi.metadata = {'url': '/api/v3.0/Corporations/{corporationId}/roi'}

    def get_dashboards(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all dashboards available to the user.

        Required Permissions: Location User for location dashboards.
        Required Permissions: Corporation User for corporation dashboards.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `DashboardTypeName` | String | `eq, neq, like, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `PowerBiReportUrl` | Uri | `eq, neq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `DashboardTypeName` | String |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_dashboards.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelDashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_dashboards.metadata = {'url': '/api/v3.0/Dashboards'}

    def create_dashboard(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new dashboard.

        Required Permissions: Corporation Admin if only CorporationId is
        provided
        Required Permissions: Location Admin if both LocationId and
        CorporationId are provided.

        :param body: Contains dashboard details
        :type body: ~smartdiagnostics_sdk.models.DashboardCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_dashboard.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_dashboard.metadata = {'url': '/api/v3.0/Dashboards'}

    def get_dashboard(
            self, id, custom_headers=None, raw=False, **operation_config):
        """

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_dashboard.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}

    def update_dashboard(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a dashboard.

        Required Permissions: Location Admin for a location dashboard
        Required Permissions: Corporation Admin for a corporation dashboard.

        :param id: Id of the dashboard
        :type id: str
        :param body: Updated dashboard details
        :type body: ~smartdiagnostics_sdk.models.DashboardUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_dashboard.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}

    def delete_dashboard(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Deletes a dashboard.

        :param id: Id of the dashboard
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_dashboard.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}

    def update_dashboard_permissions(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates dashboard permissions.

        Required Permissions: SaaS / Sentry.

        :param id: Id of the dashboard
        :type id: str
        :param body: Dashboard permission details
        :type body:
         ~smartdiagnostics_sdk.models.DashboardPermissionsUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_dashboard_permissions.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardPermissionsUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_dashboard_permissions.metadata = {'url': '/api/v3.0/Dashboards/{id}/permissions'}

    def get_dashboard_templates(
            self, filter=None, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets dashboard templates.

        Required Permissions: User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_dashboard_templates.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelDashboardTemplateResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_dashboard_templates.metadata = {'url': '/api/v3.0/Dashboards/templates'}

    def update_event(
            self, event_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an Event.

        :param event_id:
        :type event_id: str
        :param body: New Event values
        :type body: ~smartdiagnostics_sdk.models.EventModelV3
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_event.metadata['url']
        path_format_arguments = {
            'eventId': self._serialize.url("event_id", event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'EventModelV3')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EventModelV3', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_event.metadata = {'url': '/api/v3.0/Events/{eventId}'}

    def export_events(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Enqueues a report that contains all events for the params.

        :param group_id: Id of a group
        :type group_id: str
        :param body: Time Range
        :type body: ~smartdiagnostics_sdk.models.TimeRangeModelV3
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_events.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TimeRangeModelV3')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 202, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_events.metadata = {'url': '/api/v3.0/Events/{groupId}/export'}

    def get_files(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Get all the files.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Corporation User
        Location Admin
        Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `FileType` | ContentType | `eq, neq, in` |
         | `IsRootFolder` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `ParentFolderId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CreationDate` | DateTime |
         | `DisplayName` | String |
         | `FileName` | String |
         | `UpdateDate` | DateTime |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Description`, `DisplayName`, `TagName`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_files.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_files.metadata = {'url': '/api/v3.0/Files'}

    def create_file(
            self, file_type, parent_folder_id, display_name=None, description=None, location_id=None, corporation_id=None, group_ids=None, files=None, custom_headers=None, raw=False, **operation_config):
        """Creates a file.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Location Admin.

        :param file_type: Type of file. Possible values include: 'Invalid',
         'Picture', 'Folder'
        :type file_type: str
        :param parent_folder_id: The id of the folder that the file is inside
         of
        :type parent_folder_id: str
        :param display_name: Name of file
        :type display_name: str
        :param description: File Description
        :type description: str
        :param location_id: Location id of file
        :type location_id: str
        :param corporation_id: Corporation id of file
        :type corporation_id: str
        :param group_ids: Ids of groups the file belongs to
        :type group_ids: list[str]
        :param files: The file that will be associated with the file model
         object
        :type files: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_file.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'FileType': file_type,
            'ParentFolderId': parent_folder_id,
            'DisplayName': display_name,
            'Description': description,
            'LocationId': location_id,
            'CorporationId': corporation_id,
            'GroupIds': group_ids,
            'files': files,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 422]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 422:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_file.metadata = {'url': '/api/v3.0/Files'}

    def get_file(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets a file.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Corporation User
        Location Admin
        Location User.

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_file.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_file.metadata = {'url': '/api/v3.0/Files/{id}'}

    def update_file(
            self, file_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Update a file.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Location Admin.

        :param file_id:
        :type file_id: str
        :param body: File object to update
        :type body: ~smartdiagnostics_sdk.models.FilesUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_file.metadata['url']
        path_format_arguments = {
            'fileId': self._serialize.url("file_id", file_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'FilesUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_file.metadata = {'url': '/api/v3.0/Files/{fileId}'}

    def delete_file(
            self, file_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a file.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Location Admin.

        :param file_id: File id
        :type file_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_file.metadata['url']
        path_format_arguments = {
            'fileId': self._serialize.url("file_id", file_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_file.metadata = {'url': '/api/v3.0/Files/{fileId}'}

    def get_corporation_files(
            self, corporation_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all files for a corporation.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Location Admin.

        :param corporation_id:
        :type corporation_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `FileType` | ContentType | `eq, neq, in` |
         | `IsRootFolder` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `ParentFolderId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CreationDate` | DateTime |
         | `DisplayName` | String |
         | `FileName` | String |
         | `UpdateDate` | DateTime |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Description`, `DisplayName`, `TagName`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporation_files.metadata['url']
        path_format_arguments = {
            'corporationId': self._serialize.url("corporation_id", corporation_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporation_files.metadata = {'url': '/api/v3.0/Files/corporations/{corporationId}'}

    def get_location_files(
            self, location_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all files for a location.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Corporation User
        Location Admin
        Location User.

        :param location_id:
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `FileType` | ContentType | `eq, neq, in` |
         | `IsRootFolder` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `ParentFolderId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CreationDate` | DateTime |
         | `DisplayName` | String |
         | `FileName` | String |
         | `UpdateDate` | DateTime |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Description`, `DisplayName`, `TagName`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_location_files.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_location_files.metadata = {'url': '/api/v3.0/Files/locations/{locationId}'}

    def move_files(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves files to a folder.

        Required Permissions:
        Saas / Sentry
        Corporation Admin
        Location Admin.

        :param body: Move Request
        :type body: ~smartdiagnostics_sdk.models.MoveFilesRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_files.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'MoveFilesRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MoveFilesResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_files.metadata = {'url': '/api/v3.0/Files/move'}

    def get_file_object(
            self, object_filename, custom_headers=None, raw=False, **operation_config):
        """Gets a file object.

        :param object_filename: Filename (key) of requested object
        :type object_filename: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_file_object.metadata['url']
        path_format_arguments = {
            'objectFilename': self._serialize.url("object_filename", object_filename, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_file_object.metadata = {'url': '/api/v3.0/Files/object/{objectFilename}'}

    def get_indicator_filters(
            self, include_global_filters_when_filtering_on_location_id=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets many indicator filters.

        Required Permissions: Location User.

        :param include_global_filters_when_filtering_on_location_id: Specifies
         if global filters should be included even if filtering on {LocationId}
        :type include_global_filters_when_filtering_on_location_id: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `IsGlobal` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `SystemId` | Guid | `eq, neq, in` |
         | `SystemName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `LocationName` | String |
         | `Name` | String |
         | `SortOrder` | Int32 |
         | `SystemName` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_filters.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_global_filters_when_filtering_on_location_id is not None:
            query_parameters['includeGlobalFiltersWhenFilteringOnLocationId'] = self._serialize.query("include_global_filters_when_filtering_on_location_id", include_global_filters_when_filtering_on_location_id, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorFilterResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_filters.metadata = {'url': '/api/v3.0/Filters/Indicators'}

    def create_indicator_filter(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an indicator filter.

        Required Permissions: Location User.

        :param body: Indicator filter create request
        :type body: ~smartdiagnostics_sdk.models.IndicatorFilterCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_indicator_filter.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorFilterCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators'}

    def get_indicator_filter(
            self, indicator_filter_id, custom_headers=None, raw=False, **operation_config):
        """Gets a single indicator filter.

        Required Permissions: Location User.

        :param indicator_filter_id: Id of indicator filter
        :type indicator_filter_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_filter.metadata['url']
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}

    def update_indicator_filter(
            self, indicator_filter_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an indicator filter.

        Required Permissions: Location User.

        :param indicator_filter_id: The id of the indicator filter
        :type indicator_filter_id: str
        :param body: Indicator filter update request
        :type body: ~smartdiagnostics_sdk.models.IndicatorFilterUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_indicator_filter.metadata['url']
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorFilterUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}

    def delete_indicator_filter(
            self, indicator_filter_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an indicator filter.

        Required Permissions: Location User.

        :param indicator_filter_id: The id of the indicator filter
        :type indicator_filter_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_indicator_filter.metadata['url']
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}

    def get_group_analytics_models_for_group(
            self, group_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Analytics Models assigned to a specific group.

        Required Permissions: SaaS / Sentry.

        :param group_id: GroupId from which to obtain assigned analytic
         models.
        :type group_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `ErrorType` | AnalyticsModelErrorTypeCodes? | `eq, neq, in` |
         | `GroupType` | GroupTypeCodes? | `eq, neq, in` |
         | `IsDeprecated` | Boolean | `eq, neq` |
         | `IsGlobal` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `Type` | AnalyticModelType | `eq, neq, in` |
         | `Version` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Created` | DateTime |
         | `GroupName` | String |
         | `Name` | String |
         | `Type` | AnalyticModelType |
         | `Version` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `GroupName`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_group_analytics_models_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupAnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_group_analytics_models_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/Analytics/Models'}

    def add_analytics_model_to_group(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Add Analytics Models to a Group.

        Required Permissions: SaaS / Sentry.

        :param group_id:
        :type group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupAnalyticsModelAddRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.add_analytics_model_to_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupAnalyticsModelAddRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('GroupAnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    add_analytics_model_to_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/Analytics/Models'}

    def get_group_analytics_model(
            self, group_id, model_id, custom_headers=None, raw=False, **operation_config):
        """Gets a Group Analytics Model.

        Required Permissions: SaaS / Sentry.

        :param group_id:
        :type group_id: str
        :param model_id:
        :type model_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_group_analytics_model.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('GroupAnalyticsModelResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_group_analytics_model.metadata = {'url': '/api/v3.0/Groups/{groupId}/Analytics/Models/{modelId}'}

    def update_analytics_model_on_group(
            self, group_id, model_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates Analytics Models for a Group.

        Required Permissions: SaaS / Sentry.

        :param group_id:
        :type group_id: str
        :param model_id:
        :type model_id: str
        :param body:
        :type body:
         ~smartdiagnostics_sdk.models.GroupAnalyticsModelUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_analytics_model_on_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupAnalyticsModelUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('GroupAnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_analytics_model_on_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/Analytics/Models/{modelId}'}

    def delete_analytics_model_from_group(
            self, group_id, model_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an Analytics Model from group.

        Required Permissions: SaaS / Sentry.

        :param group_id: Group form which to remove the model
        :type group_id: str
        :param model_id: ID of the model to be removed
        :type model_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_analytics_model_from_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str'),
            'modelId': self._serialize.url("model_id", model_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_analytics_model_from_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/Analytics/Models/{modelId}'}

    def get_bearings_for_group(
            self, group_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all bearings for a group.

        Required Permissions: User.

        :param group_id:
        :type group_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Manufacturer` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `RollerCount` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Bpfi` | Double |
         | `Bpfo` | Double |
         | `Bsf` | Double |
         | `Ftf` | Double |
         | `Manufacturer` | String |
         | `Name` | String |
         | `RollerCount` | Int64 |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_bearings_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBearingResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_bearings_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/bearings'}

    def update_bearings_for_group(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates bearings for a group.

        Required Permissions: User.

        :param group_id:
        :type group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.UpdateBearingsForGroupRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_bearings_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UpdateBearingsForGroupRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[BearingResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_bearings_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/bearings'}

    def get_group_analytics_models(
            self, location_ids=None, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Analytics Models assigned to a group.

        Required Permissions: SaaS / Sentry.

        :param location_ids: A list of location ids to filter the results to
         models that are assigned to them or are global
        :type location_ids: list[str]
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `ErrorType` | AnalyticsModelErrorTypeCodes? | `eq, neq, in` |
         | `GroupType` | GroupTypeCodes? | `eq, neq, in` |
         | `IsDeprecated` | Boolean | `eq, neq` |
         | `IsGlobal` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `Type` | AnalyticModelType | `eq, neq, in` |
         | `Version` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Created` | DateTime |
         | `GroupName` | String |
         | `Name` | String |
         | `Type` | AnalyticModelType |
         | `Version` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `GroupName`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_group_analytics_models.metadata['url']

        # Construct parameters
        query_parameters = {}
        if location_ids is not None:
            query_parameters['locationIds'] = self._serialize.query("location_ids", location_ids, '[str]', div=',')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupAnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_group_analytics_models.metadata = {'url': '/api/v3.0/Groups/Analytics/Models'}

    def get_hardware_events_for_location(
            self, location_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets a listing of hardware event logs for a location.

        :param location_id:
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `EventType` | String | `eq, neq, like, in` |
         | `HardwareType` | String | `eq, neq, like, in` |
         | `TimeAcked` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `TimeNotified` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `EventType` | String |
         | `HardwareType` | String |
         | `TimeAcked` | DateTime? |
         | `TimeEntered` | DateTime |
         | `TimeExited` | DateTime? |
         | `TimeNotified` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hardware_events_for_location.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelHardwareEventModelV3', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hardware_events_for_location.metadata = {'url': '/api/v3.0/HardwareEvents/location/{locationId}'}

    def get_collectors_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets the online status for the desired base stations.

        Required Permissions: User is limited to view status only for those
        Locations they have access to.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_collectors_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_collectors_status.metadata = {'url': '/api/v3.0/HardwareStatus/baseStations'}

    def get_hubs_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets all status for hubs.

        Required Permissions: User should only see counts based on hubs in
        corporations and locations which they have access to.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hubs_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hubs_status.metadata = {'url': '/api/v3.0/HardwareStatus/hubs'}

    def get_nodes_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets all status for nodes.

        Required Permissions: User should be limited to only view status based
        on the Location.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_nodes_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_nodes_status.metadata = {'url': '/api/v3.0/HardwareStatus/nodes'}

    def get_repeaters_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets the online status for repeaters, grouped by location.

        Required Permissions: User should only see counts based on repeaters in
        corporations and locations which they have access to.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_repeaters_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_repeaters_status.metadata = {'url': '/api/v3.0/HardwareStatus/repeaters'}

    def get_hubs(
            self, include_online_status=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all hubs a user has access to.

        Required Permissions: Location User.

        :param include_online_status:
        :type include_online_status: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `FirmwareVersion` | String | `eq, neq, like, in` |
         | `HubTypeId` | HubType? | `eq, neq, in` |
         | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Nickname` | String | `eq, neq, like, in` |
         | `PowerTypeId` | HubPowerType? | `eq, neq, in` |
         | `ReceiverFirmwareVersion` | String | `eq, neq, like, in` |
         | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `ReceiverName` | String | `eq, neq, like, in` |
         | `ReceiverNetworkId` | String | `eq, neq, like, in` |
         | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq,
         geq` |
         | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `ReceiverSerialNumber` | String | `eq, neq, like, in` |
         | `SerialNumber` | String | `eq, neq, like, in` |
         | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `FirmwareVersion` | String |
         | `HubTypeId` | HubType? |
         | `LocationName` | String |
         | `Nickname` | String |
         | `PowerTypeId` | HubPowerType? |
         | `ReceiverFirmwareVersion` | String |
         | `ReceiverName` | String |
         | `ReceiverNetworkId` | String |
         | `ReceiverPendingRfChannel` | Int32? |
         | `ReceiverRfChannel` | Int32? |
         | `SerialNumber` | String |
         | `Updated` | DateTime |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `CorporationName`, `LocationName`, `Nickname`,
         `SerialNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hubs.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_online_status is not None:
            query_parameters['includeOnlineStatus'] = self._serialize.query("include_online_status", include_online_status, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelHubResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hubs.metadata = {'url': '/api/v3.0/Hubs'}

    def get_hub(
            self, hub_id, include_online_status=False, custom_headers=None, raw=False, **operation_config):
        """Returns a single Hub with the supplied Id.

        Required Permissions: Location User.

        :param hub_id: The Id of the Hub
        :type hub_id: long
        :param include_online_status:
        :type include_online_status: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hub.metadata['url']
        path_format_arguments = {
            'hubId': self._serialize.url("hub_id", hub_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_online_status is not None:
            query_parameters['includeOnlineStatus'] = self._serialize.query("include_online_status", include_online_status, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HubResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hub.metadata = {'url': '/api/v3.0/Hubs/{hubId}'}

    def get_identity_providers(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all identity providers.

        Required Permissions: SaaS / Sentry.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `CorporationName`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_identity_providers.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIdentityProviderResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_identity_providers.metadata = {'url': '/api/v3.0/IdentityProviders'}

    def create_identity_provider(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new identity provider.

        Required Permissions: SaaS / Sentry.

        :param body: Contains new provider information
        :type body: ~smartdiagnostics_sdk.models.IdentityProviderCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_identity_provider.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IdentityProviderCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IdentityProviderResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_identity_provider.metadata = {'url': '/api/v3.0/IdentityProviders'}

    def get_identity_provider(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets the identity provider with the provided ID.

        Required Permissions: SaaS / Sentry.

        :param id: Identity Provider ID
        :type id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_identity_provider.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IdentityProviderResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_identity_provider.metadata = {'url': '/api/v3.0/IdentityProviders/{id}'}

    def update_identity_provider(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Edits an identity provider.

        Required Permissions: KCF Admin.

        :param id: Identity Provider ID
        :type id: int
        :param body: Identity provider info that will be changed
        :type body: ~smartdiagnostics_sdk.models.IdentityProviderUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_identity_provider.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IdentityProviderUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IdentityProviderResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_identity_provider.metadata = {'url': '/api/v3.0/IdentityProviders/{id}'}

    def get_indicator_groups(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicatorGroups.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_groups.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_groups.metadata = {'url': '/api/v3.0/IndicatorGroups'}

    def create_indicator_group(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a indicatorGroup.

        Required Permissions: Location User.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.IndicatorGroupCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_indicator_group.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorGroupCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups'}

    def get_indicator_group(
            self, indicator_group_id, custom_headers=None, raw=False, **operation_config):
        """Gets a indicatorGroup.

        Required Permissions: Location User.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}

    def update_indicator_group(
            self, indicator_group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a indicatorGroup.

        Required Permissions: Location User.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.IndicatorGroupUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorGroupUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}

    def delete_indicator_group(
            self, indicator_group_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a indicatorGroup.

        Required Permissions: Location Admin.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}

    def move_indicator_group(
            self, indicator_group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves a indicatorGroup.

        Required Permissions: Location User.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}/Move'}

    def get_indicators(
            self, group_ids=None, filter_ids=None, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicator responses.

        Required Permissions: Location User.

        :param group_ids: A list of groupIds to filter the result
        :type group_ids: list[str]
        :param filter_ids: A list of filterIds to filter the result
        :type filter_ids: list[str]
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `Id` | Guid | `eq, neq, in` |
         | `IndicatorType` | MetricTypeCodes | `eq, neq, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `MeasureOf` | SensorRoleTypeCodes | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationId` | Guid |
         | `Id` | Guid |
         | `LocationId` | Guid |
         | `MeasureOf` | SensorRoleTypeCodes |
         | `Name` | String |
         | `SystemSortOrder` | Int32 |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `HierarchySearch`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicators.metadata['url']

        # Construct parameters
        query_parameters = {}
        if group_ids is not None:
            query_parameters['groupIds'] = self._serialize.query("group_ids", group_ids, '[str]', div=',')
        if filter_ids is not None:
            query_parameters['filterIds'] = self._serialize.query("filter_ids", filter_ids, '[str]', div=',')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicators.metadata = {'url': '/api/v3.0/Indicators'}

    def get_indicator(
            self, indicator_id, custom_headers=None, raw=False, **operation_config):
        """Gets an indicator response.

        Required Permissions: Location User.

        :param indicator_id:
        :type indicator_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}'}

    def get_indicator_alarm_state(
            self, indicator_id, custom_headers=None, raw=False, **operation_config):
        """Get the alarm state for a specific indicator.

        Required Permissions: Location User.

        :param indicator_id: Id of specific indicator
        :type indicator_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_alarm_state.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorAlarmStateResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_alarm_state.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/alarmState'}

    def get_burst_data_audio(
            self, indicator_id, utc_timestamp, custom_headers=None, raw=False, **operation_config):
        """Generates audio from Indicator burst data.  Only vibration Indicators
        are supported.

        Required Permissions: SaaS / Sentry.

        :param indicator_id: The indicator to generate audio for
        :type indicator_id: str
        :param utc_timestamp: The UTC timestamp used to locate the burst data
         used to generate the audio
        :type utc_timestamp: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_burst_data_audio.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str'),
            'utcTimestamp': self._serialize.url("utc_timestamp", utc_timestamp, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_burst_data_audio.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/burstDataAudio/{utcTimestamp}'}

    def set_smart_alarms(
            self, indicator_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Calculates and sets smart alarms for the given indicator.

        Required Permissions: Location Admin.

        :param indicator_id: The indicator to calculate the thresholds for
        :type indicator_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SmartAlarmsRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.set_smart_alarms.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SmartAlarmsRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    set_smart_alarms.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/smartAlarms'}

    def get_statistics_for_indicator(
            self, indicator_id, start_date=None, end_date=None, custom_headers=None, raw=False, **operation_config):
        """Gets statistics for a specific indicator.

        Required Permissions: Location User.

        :param indicator_id: Id of requested indicator
        :type indicator_id: str
        :param start_date: Start of the time duration used to calculate the
         statistics. Defaults to one day.
        :type start_date: datetime
        :param end_date: End of the time duration used to calculate the
         statistics. Defaults to one day.
        :type end_date: datetime
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_statistics_for_indicator.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if start_date is not None:
            query_parameters['startDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['endDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorStatisticsResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_statistics_for_indicator.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/statistics'}

    def get_indicators_alarm_state(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Get the alarm state for a list of indicators.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Id` | Guid | `eq, neq, in` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicators_alarm_state.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[IndicatorAlarmStateResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicators_alarm_state.metadata = {'url': '/api/v3.0/Indicators/alarmState'}

    def get_measure_ofs_for_indicator(
            self, custom_headers=None, raw=False, **operation_config):
        """Returns a list of measureOf values and their UI-friendly format.

        Required Permissions: Location User.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_measure_ofs_for_indicator.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorOptionsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_measure_ofs_for_indicator.metadata = {'url': '/api/v3.0/Indicators/measureOfs'}

    def get_indicator_statistics(
            self, group_ids=None, filter_ids=None, start_date=None, end_date=None, is_export=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicator statistics.

        Required Permissions: Location User.

        :param group_ids: A list of groupIds to filter the result
        :type group_ids: list[str]
        :param filter_ids: A list of filterIds to filter the result
        :type filter_ids: list[str]
        :param start_date: Start of the time duration used to calculate the
         statistics. Defaults to one day.
        :type start_date: datetime
        :param end_date: End of the time duration used to calculate the
         statistics. Defaults to one day.
        :type end_date: datetime
        :param is_export: If true, this route will email an excel workbook
         instead of returning the json response
        :type is_export: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Id` | Guid | `eq, neq, in` |
         | `IndicatorType` | MetricTypeCodes | `eq, neq, in` |
         | `MeasureOf` | SensorRoleTypeCodes | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `AverageValue` | Double? |
         | `MaxValue` | Double? |
         | `MeasureOf` | SensorRoleTypeCodes |
         | `OnTime` | Double? |
         | `SystemSortOrder` | Int32 |
         | `TimeInAlarm` | Double? |
         | `TimeInWarning` | Double? |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `HierarchyAbbreviation`, `HierarchyName`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_statistics.metadata['url']

        # Construct parameters
        query_parameters = {}
        if group_ids is not None:
            query_parameters['groupIds'] = self._serialize.query("group_ids", group_ids, '[str]', div=',')
        if filter_ids is not None:
            query_parameters['filterIds'] = self._serialize.query("filter_ids", filter_ids, '[str]', div=',')
        if start_date is not None:
            query_parameters['startDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['endDate'] = self._serialize.query("end_date", end_date, 'iso-8601')
        if is_export is not None:
            query_parameters['isExport'] = self._serialize.query("is_export", is_export, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorStatisticsResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_statistics.metadata = {'url': '/api/v3.0/Indicators/statistics'}

    def get_indicator_types(
            self, filter=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicator types.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Id` | Int32 |
         | `IndicatorType` | MetricTypeCodes |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_types.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[IndicatorTypesResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_types.metadata = {'url': '/api/v3.0/Indicators/Types'}

    def get_installs(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a list of installs for the current user.

        Required Permissions: SaaS / Sentry.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `UserEmail` | String | `eq, neq, like, in` |
         | `UserFirstName` | String | `eq, neq, like, in` |
         | `UserId` | Guid | `eq, neq, in` |
         | `UserLastName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `EndDate` | DateTime? |
         | `Name` | String |
         | `StartDate` | DateTime |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_installs.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelInstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_installs.metadata = {'url': '/api/v3.0/Installs'}

    def get_install(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets a single Install.

        Required Permissions: SaaS / Sentry.

        :param id: Id of install
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_install.metadata = {'url': '/api/v3.0/Installs/{id}'}

    def update_install(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates properties related to an install.

        Required Permissions: SaaS / Sentry.

        :param id: the Guid for the install
        :type id: str
        :param body: the model containing the properties to update
        :type body: ~smartdiagnostics_sdk.models.InstallUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_install.metadata = {'url': '/api/v3.0/Installs/{id}'}

    def export_install_report(
            self, install_id, custom_headers=None, raw=False, **operation_config):
        """Triggers a Hangfire job that will email an install's status report to
        the user.

        Required Permissions: SaaS / Sentry.

        :param install_id:
        :type install_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_install_report.metadata['url']
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_install_report.metadata = {'url': '/api/v3.0/Installs/{installId}/exportReport'}

    def get_node_install_status(
            self, install_id, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets a list of nodes per install.

        Required Permissions: SaaS / Sentry.

        :param install_id: Id of an install
        :type install_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_node_install_status.metadata['url']
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelInstallNodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_node_install_status.metadata = {'url': '/api/v3.0/Installs/{installId}/nodes'}

    def update_node_install_status(
            self, install_id, node_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a node's status for the install.

        Required Permissions: SaaS / Sentry.

        :param install_id: Id of install
        :type install_id: str
        :param node_id: Id of node
        :type node_id: long
        :param body: Status to change node to and accompanying note
        :type body: ~smartdiagnostics_sdk.models.InstallNodeUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_node_install_status.metadata['url']
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallNodeUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallNodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_node_install_status.metadata = {'url': '/api/v3.0/Installs/{installId}/nodes/{nodeId}'}

    def add_users_to_install(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Adds one or more users to an install.

        Required Permissions: SaaS / Sentry.

        :param id: Id of an install
        :type id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.InstallModifyUsersRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.add_users_to_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallModifyUsersRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallAddUserResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    add_users_to_install.metadata = {'url': '/api/v3.0/Installs/{id}/users'}

    def remove_users_from_install(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Removes one or more users from an install.

        Required Permissions: SaaS / Sentry.

        :param id: Id of an install
        :type id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.InstallModifyUsersRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.remove_users_from_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallModifyUsersRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    remove_users_from_install.metadata = {'url': '/api/v3.0/Installs/{id}/users'}

    def get_locations(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns a paged list of all locations that the user has access to.

        Required Permissions: Users, Sentry, and Saas will receive all the
        locations that are visible to them at their access level.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Id` | Guid | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `Active` | Boolean |
         | `CorporationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_locations.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelLocationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_locations.metadata = {'url': '/api/v3.0/Locations'}

    def create_location(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new location.

        Required Permissions: SaaS / Sentry / Corporation Admin.

        :param body: Model for new location
        :type body: ~smartdiagnostics_sdk.models.LocationCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_location.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'LocationCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('LocationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_location.metadata = {'url': '/api/v3.0/Locations'}

    def get_location(
            self, location_id, custom_headers=None, raw=False, **operation_config):
        """Gets a specific location.

        Required Permissions: Users, Sentry, and Saas will receive all the
        locations that are visible to them at their access level.

        :param location_id: Id of location
        :type location_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_location.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('LocationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_location.metadata = {'url': '/api/v3.0/Locations/{locationId}'}

    def get_baseline_indicators_for_location(
            self, location_id, page=None, page_limit=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a list of valid baselines.

        Required Permissions: Location User
        The searching on this route mimics the original copy baseline
        functionality from Sd3.
        This means the user can choose to narrow down searching on either the
        group hierarchy, the indicator, or both.
        When an asterisk ('*') is included, everything before the asterisk is
        considered a search on the group hierarchy while
        everything after the asterisk will search on the indicator name.
        Leaving out an asterisk will do a search
        on both the indicator name and the group hierarchy.

        :param location_id: Id of requested location
        :type location_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_baseline_indicators_for_location.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorBaselineResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_baseline_indicators_for_location.metadata = {'url': '/api/v3.0/Locations/{locationId}/indicators/baselines'}

    def get_location_roi(
            self, location_id, start_date=None, end_date=None, custom_headers=None, raw=False, **operation_config):
        """Gets ROI information for a location.

        Required Permissions: Location User.

        :param location_id:
        :type location_id: str
        :param start_date:
        :type start_date: datetime
        :param end_date:
        :type end_date: datetime
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_location_roi.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if start_date is not None:
            query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RoiResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_location_roi.metadata = {'url': '/api/v3.0/Locations/{locationId}/roi'}

    def get_monitoring_points(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Monitoring Points.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `BearingId` | Guid | `eq, neq, in` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `NodeSerialNumber` | String | `eq, neq, like, in` |
         | `ParentId` | Guid | `eq, neq, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_points.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMonitoringPointResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_points.metadata = {'url': '/api/v3.0/MonitoringPoints'}

    def create_monitoring_point(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a monitoringPoint.

        Required Permissions: Location User.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.MonitoringPointCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_monitoring_point.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'MonitoringPointCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MonitoringPointResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_monitoring_point.metadata = {'url': '/api/v3.0/MonitoringPoints'}

    def get_monitoring_point(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets a Monitoring Point.

        Required Permissions: Location User.

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MonitoringPointResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point.metadata = {'url': '/api/v3.0/MonitoringPoints/{id}'}

    def update_monitoring_point(
            self, monitoring_point_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a monitoringPoint.

        Required Permissions: Location User.

        :param monitoring_point_id:
        :type monitoring_point_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.MonitoringPointUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_monitoring_point.metadata['url']
        path_format_arguments = {
            'monitoringPointId': self._serialize.url("monitoring_point_id", monitoring_point_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'MonitoringPointUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MonitoringPointResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_monitoring_point.metadata = {'url': '/api/v3.0/MonitoringPoints/{monitoringPointId}'}

    def delete_monitoring_point(
            self, monitoring_point_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a monitoringPoint.

        Required Permissions: Location Admin.

        :param monitoring_point_id:
        :type monitoring_point_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_monitoring_point.metadata['url']
        path_format_arguments = {
            'monitoringPointId': self._serialize.url("monitoring_point_id", monitoring_point_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_monitoring_point.metadata = {'url': '/api/v3.0/MonitoringPoints/{monitoringPointId}'}

    def get_monitoring_point_assignments(
            self, monitoring_point_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all of the node assignment history for a monitoring point
        including the current assignment.

        Required Permissions: Location User.

        :param monitoring_point_id: The monitoringPointId to retrieve the node
         assignment history for.
        :type monitoring_point_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `NodeSerialNumber` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `EndDate` | DateTime? |
         | `StartDate` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point_assignments.metadata['url']
        path_format_arguments = {
            'monitoringPointId': self._serialize.url("monitoring_point_id", monitoring_point_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMonitoringPointAssignmentResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point_assignments.metadata = {'url': '/api/v3.0/MonitoringPoints/{monitoringPointId}/assignments'}

    def get_monitoring_point_current_assignment(
            self, monitoring_point_id, custom_headers=None, raw=False, **operation_config):
        """Gets the currently assigned node to a monitoring point.

        Required Permissions: Location User.

        :param monitoring_point_id: The monitoringPointId used to retrieve the
         current assignment
        :type monitoring_point_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point_current_assignment.metadata['url']
        path_format_arguments = {
            'monitoringPointId': self._serialize.url("monitoring_point_id", monitoring_point_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MonitoringPointAssignmentResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point_current_assignment.metadata = {'url': '/api/v3.0/MonitoringPoints/{monitoringPointId}/assignments/current'}

    def get_monitoring_point_overview(
            self, group_ids=None, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets an overview of monitoring point(s) which includes the node
        settings.

        Required Permissions: Location User.

        :param group_ids:
        :type group_ids: list[str]
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `HierarchyAbbreviation` | String | `eq, neq, like, in` |
         | `HierarchyName` | String | `eq, neq, like, in` |
         | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `NodeNickname` | String | `eq, neq, like, in` |
         | `NodeSerialNumber` | String | `eq, neq, like, in` |
         | `RunningSpeedMultiplier` | Double? | `eq, neq, in, lt, gt, leq, geq`
         |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `DecimationFactor` | NodeSettingValues |
         | `HierarchyAbbreviation` | String |
         | `HierarchyName` | String |
         | `MonitoringPointType` | MonitoringPointTypeCodes |
         | `Name` | String |
         | `NodeNickname` | String |
         | `NodeSerialNumber` | String |
         | `RunningSpeedMultiplier` | Double? |
         | `UpdateInterval` | NodeSettingValues |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `HierarchySearch`, `NodeNickname`,
         `NodeSerialNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point_overview.metadata['url']

        # Construct parameters
        query_parameters = {}
        if group_ids is not None:
            query_parameters['groupIds'] = self._serialize.query("group_ids", group_ids, '[str]', div=',')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMonitoringPointOverviewResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point_overview.metadata = {'url': '/api/v3.0/MonitoringPoints/overview'}

    def get_monitoring_point_type_codes(
            self, custom_headers=None, raw=False, **operation_config):
        """

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point_type_codes.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[MonitoringPointTypeCodeModel]', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point_type_codes.metadata = {'url': '/api/v3.0/MonitoringPointTypeCodes'}

    def get_nodes(
            self, include_state=False, is_slim=False, group_ids=None, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a paginated list of the nodes to which a user has access.

        Required Permissions: Location User.

        :param include_state: If set to true node state information will be
         included in the response
        :type include_state: bool
        :param is_slim: If set to true, only a small subset of information on
         the node(s) will be included in the response
        :type is_slim: bool
        :param group_ids: If specified, only nodes assigned to monitoring
         points under these groupIds will be retrieved
        :type group_ids: list[str]
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `BaseStationId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `BaseStationName` | String | `eq, neq, like, in` |
         | `BaseStationReceiverSerialNumber` | String | `eq, neq, like, in` |
         | `BaseStationSerialNumber` | String | `eq, neq, like, in` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `FirmwareVersion` | String | `eq, neq, like, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Nickname` | String | `eq, neq, like, in` |
         | `NodeTypeCode` | NodeTypeCodes | `eq, neq, in` |
         | `RepeaterId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `RepeaterName` | String | `eq, neq, like, in` |
         | `RepeaterSerialNumber` | String | `eq, neq, like, in` |
         | `SerialNumber` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `FirmwareVersion` | String |
         | `LocationName` | String |
         | `Nickname` | String |
         | `NodeTypeCode` | NodeTypeCodes |
         | `SerialNumber` | String |
         | `Updated` | DateTime |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Nickname`, `SerialNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_nodes.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')
        if is_slim is not None:
            query_parameters['isSlim'] = self._serialize.query("is_slim", is_slim, 'bool')
        if group_ids is not None:
            query_parameters['groupIds'] = self._serialize.query("group_ids", group_ids, '[str]', div=',')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelNodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_nodes.metadata = {'url': '/api/v3.0/Nodes'}

    def get_node(
            self, node_id, include_state=False, custom_headers=None, raw=False, **operation_config):
        """Gets the requested node.

        Required Permissions: Location User.

        :param node_id: The ID of the node
        :type node_id: long
        :param include_state: Query parameter used to specify if the returned
         NodeResponse
         should include certain properties
        :type include_state: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_node.metadata['url']
        path_format_arguments = {
            'nodeId': self._serialize.url("node_id", node_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_node.metadata = {'url': '/api/v3.0/Nodes/{nodeId}'}

    def export_long_burst(
            self, long_burst_id, node_id, custom_headers=None, raw=False, **operation_config):
        """Get a node longburst.

        Required Permissions: Location Admin.

        :param long_burst_id:
        :type long_burst_id: long
        :param node_id:
        :type node_id: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_long_burst.metadata['url']
        path_format_arguments = {
            'longBurstId': self._serialize.url("long_burst_id", long_burst_id, 'long'),
            'nodeId': self._serialize.url("node_id", node_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_long_burst.metadata = {'url': '/api/v3.0/Nodes/{nodeId}/longBurst/{longBurstId}/export'}

    def get_pictures(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns a paged list of all pictures.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Id` | Guid | `eq, neq, in` |
         | `ImageFileName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `ThumbnailFileName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Id` | Guid |
         | `ImageFileName` | String |
         | `Name` | String |
         | `ThumbnailFileName` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `ImageFileName`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_pictures.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_pictures.metadata = {'url': '/api/v3.0/Pictures'}

    def get_picture(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Returns a single picture.

        :param id: Picture Id
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_picture.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_picture.metadata = {'url': '/api/v3.0/Pictures/{id}'}

    def get_pictures_for_group(
            self, group_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Get a paged list of pictures associated with a group.

        :param group_id: The GUID of the group
        :type group_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Id` | Guid | `eq, neq, in` |
         | `ImageFileName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `ThumbnailFileName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Id` | Guid |
         | `ImageFileName` | String |
         | `Name` | String |
         | `ThumbnailFileName` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_pictures_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_pictures_for_group.metadata = {'url': '/api/v3.0/Pictures/group/{groupId}'}

    def assign_pictures_to_group(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Associate an ordered list of pictures to a group.

        :param group_id: The GUID of the group to assign pictures to
        :type group_id: str
        :param body: An ordered list of picture GUIDs to associate with the
         group.
        :type body: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.assign_pictures_to_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[str]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    assign_pictures_to_group.metadata = {'url': '/api/v3.0/Pictures/group/{groupId}'}

    def get_pictures_for_location(
            self, location_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns a paged list of pictures associated with an account.

        :param location_id: The GUID of the account/location
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Id` | Guid | `eq, neq, in` |
         | `ImageFileName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `ThumbnailFileName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Id` | Guid |
         | `ImageFileName` | String |
         | `Name` | String |
         | `ThumbnailFileName` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `ImageFileName`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_pictures_for_location.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_pictures_for_location.metadata = {'url': '/api/v3.0/Pictures/location/{locationId}'}

    def get_properties(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Properties.

        Required Permissions: SaaS / Sentry.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Name` | String | `eq, neq, like, in` |
         | `ValueType` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Name` | String |
         | `ValueType` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_properties.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPropertyResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_properties.metadata = {'url': '/api/v3.0/Properties'}

    def get_property(
            self, property_id, custom_headers=None, raw=False, **operation_config):
        """Gets an Property.

        Required Permissions: SaaS / Sentry.

        :param property_id:
        :type property_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_property.metadata['url']
        path_format_arguments = {
            'propertyId': self._serialize.url("property_id", property_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PropertyResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_property.metadata = {'url': '/api/v3.0/Properties/{propertyId}'}

    def get_repeater(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Get receivers subject to query options.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `LastStatusUpdate` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `RadioMacAddress` | String | `eq, neq, like, in` |
         | `SerialNumber` | String | `eq, neq, like, in` |
         | `Type` | ReceiverLocationTypeCodes | `eq, neq, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `CorporationId` | Guid? |
         | `CorporationName` | String |
         | `Id` | Int64 |
         | `LastStatusUpdate` | DateTime? |
         | `LocationId` | Guid? |
         | `LocationName` | String |
         | `RadioMacAddress` | String |
         | `SerialNumber` | String |
         | `Type` | ReceiverLocationTypeCodes |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `CorporationName`, `LocationName`,
         `RadioMacAddress`, `SerialNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_repeater.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelRepeaterModelV3', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_repeater.metadata = {'url': '/api/v3.0/Repeaters'}

    def request_base_station_report(
            self, ids=None, file_name=None, custom_headers=None, raw=False, **operation_config):
        """This will download a base station and repeater hardware report for the
        locations provided in the details model.

        :param ids: A list of Locations Guids whose hardware should appear in
         the report
        :type ids: list[str]
        :param file_name: The Name of the File
        :type file_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_base_station_report.metadata['url']

        # Construct parameters
        query_parameters = {}
        if ids is not None:
            query_parameters['Ids'] = self._serialize.query("ids", ids, '[str]', div=',')
        if file_name is not None:
            query_parameters['FileName'] = self._serialize.query("file_name", file_name, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_base_station_report.metadata = {'url': '/api/v3.0/Reports/hardware/basestation'}

    def request_low_battery_report(
            self, location_id, custom_headers=None, raw=False, **operation_config):
        """This will download a low battery report for the location provided in
        the details model.

        :param location_id: Id of the location whose nodes will appear in the
         report
        :type location_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_low_battery_report.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['LocationId'] = self._serialize.query("location_id", location_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_low_battery_report.metadata = {'url': '/api/v3.0/Reports/hardware/lowBattery'}

    def request_heatmap_report(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Enqueues a job to run and later email a heatmap report for the group
        provided using the options provided.

        Required Permissions: SaaS / Sentry.

        :param group_id: Id of the group to run the report on
        :type group_id: str
        :param body: Contains the options for the report
        :type body: ~smartdiagnostics_sdk.models.HeatmapReportRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_heatmap_report.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'HeatmapReportRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_heatmap_report.metadata = {'url': '/api/v3.0/Reports/heatmap/group/{groupId}'}

    def request_statistics_report(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Emails a statistics report for the group provided using the options
        provided.

        Required Permissions: SaaS / Sentry.

        :param group_id: Id of the group to run the report on
        :type group_id: str
        :param body: Contains the options for the report
        :type body: ~smartdiagnostics_sdk.models.StatisticsReportRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_statistics_report.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'StatisticsReportRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_statistics_report.metadata = {'url': '/api/v3.0/Reports/statistics/group/{groupId}'}

    def create_session(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """

        :param body:
        :type body: ~smartdiagnostics_sdk.models.Sd4SessionCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_session.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'Sd4SessionCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Sd4SessionResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_session.metadata = {'url': '/api/v3.0/Sd4Sessions'}

    def get_session(
            self, id, custom_headers=None, raw=False, **operation_config):
        """

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_session.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('Sd4SessionResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_session.metadata = {'url': '/api/v3.0/Sd4Sessions/{id}'}

    def get_spreadsheet(
            self, job_type, location_id=None, filter_id=None, custom_headers=None, raw=False, **operation_config):
        """Gets the template spreadsheet for the given job type.

        Required Permissions: SaaS / Sentry.

        :param job_type: The job type to get the template for
        :type job_type: str
        :param location_id: The location to get the template for
        :type location_id: str
        :param filter_id:
        :type filter_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_spreadsheet.metadata['url']
        path_format_arguments = {
            'jobType': self._serialize.url("job_type", job_type, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if location_id is not None:
            query_parameters['locationId'] = self._serialize.query("location_id", location_id, 'str')
        if filter_id is not None:
            query_parameters['filterId'] = self._serialize.query("filter_id", filter_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_spreadsheet.metadata = {'url': '/api/v3.0/SetupTools/{jobType}'}

    def run_setup_tool_job(
            self, job_type, location_id=None, file=None, custom_headers=None, raw=False, **operation_config):
        """Enqueues a job of the given type to be run.

        Required Permissions: SaaS / Sentry.

        :param job_type: The type of job to run
        :type job_type: str
        :param location_id: The location to run the job for
        :type location_id: str
        :param file: The file to be processed
        :type file: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.run_setup_tool_job.metadata['url']
        path_format_arguments = {
            'jobType': self._serialize.url("job_type", job_type, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'locationId': location_id,
            'file': file,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 400, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 202:
            deserialized = self._deserialize('JobResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('JobUploadErrorResponse', response)
        if response.status_code == 403:
            deserialized = self._deserialize('JobUploadErrorResponse', response)
        if response.status_code == 404:
            deserialized = self._deserialize('JobUploadErrorResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    run_setup_tool_job.metadata = {'url': '/api/v3.0/SetupTools/{jobType}'}

    def get_sub_systems(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets subSystems.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_sub_systems.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_sub_systems.metadata = {'url': '/api/v3.0/SubSystems'}

    def create_sub_system(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a subSystem.

        Required Permissions: Location User.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.SubSystemCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_sub_system.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SubSystemCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_sub_system.metadata = {'url': '/api/v3.0/SubSystems'}

    def get_sub_system(
            self, sub_system_id, custom_headers=None, raw=False, **operation_config):
        """Gets a subSystem.

        Required Permissions: Location User.

        :param sub_system_id:
        :type sub_system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}

    def update_sub_system(
            self, sub_system_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a subSystem.

        Required Permissions: Location User.

        :param sub_system_id:
        :type sub_system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SubSystemUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SubSystemUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}

    def delete_sub_system(
            self, sub_system_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a subSystem.

        Required Permissions: Location Admin.

        :param sub_system_id:
        :type sub_system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}

    def move_sub_system(
            self, sub_system_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves a subSystem.

        Required Permissions: Location User.

        :param sub_system_id:
        :type sub_system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}/Move'}

    def get_systems(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets systems.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsCollectorDependentSystem` | Boolean | `eq, neq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `IsVisible` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_systems.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_systems.metadata = {'url': '/api/v3.0/Systems'}

    def create_system(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a system.

        Required Permissions: Location User.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.SystemCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_system.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SystemCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_system.metadata = {'url': '/api/v3.0/Systems'}

    def get_system(
            self, system_id, custom_headers=None, raw=False, **operation_config):
        """Gets a system.

        Required Permissions: Location User.

        :param system_id:
        :type system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_system.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_system.metadata = {'url': '/api/v3.0/Systems/{systemId}'}

    def update_system(
            self, system_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a system.

        Required Permissions: Location User.

        :param system_id:
        :type system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SystemUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_system.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SystemUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_system.metadata = {'url': '/api/v3.0/Systems/{systemId}'}

    def get_asset_status_summaries_for_system(
            self, system_id, custom_headers=None, raw=False, **operation_config):
        """Gets asset status summary for a system.

        Required Permissions: Location User.

        :param system_id:
        :type system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_status_summaries_for_system.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemAssetsStatusSummaryResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_status_summaries_for_system.metadata = {'url': '/api/v3.0/Systems/{systemId}/Assets/Summary/Status'}

    def get_system_overview(
            self, system_id, custom_headers=None, raw=False, **operation_config):
        """Gets the system overview for a single system.

        :param system_id:
        :type system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_system_overview.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemOverviewResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_system_overview.metadata = {'url': '/api/v3.0/Systems/{systemId}/overview'}

    def get_asset_status_summaries_for_systems(
            self, filter=None, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets asset status summary for systems.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationId` | Guid | `eq, neq, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_status_summaries_for_systems.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemAssetsStatusSummaryResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_status_summaries_for_systems.metadata = {'url': '/api/v3.0/Systems/Assets/Summary/Status'}

    def get_systems_overview(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all system overviews.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsCollectorDependentSystem` | Boolean | `eq, neq` |
         | `IsFavorited` | Boolean | `eq, neq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `IsSnoozed` | Boolean | `eq, neq` |
         | `IsVisible` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_systems_overview.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemOverviewResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_systems_overview.metadata = {'url': '/api/v3.0/Systems/overview'}

    def get_tags(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets tags.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsGlobal` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `Type` | TagCategories | `eq, neq, in` |
         | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
         | `Type` | TagCategories |
         | `Updated` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tags.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTagResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tags.metadata = {'url': '/api/v3.0/Tags'}

    def create_tag(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a tag.

        Required Permissions: Location User.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.TagCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_tag.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TagCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TagResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_tag.metadata = {'url': '/api/v3.0/Tags'}

    def get_tag(
            self, tag_id, custom_headers=None, raw=False, **operation_config):
        """Gets a tag.

        Required Permissions: Location User.

        :param tag_id:
        :type tag_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tag.metadata['url']
        path_format_arguments = {
            'tagId': self._serialize.url("tag_id", tag_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TagResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tag.metadata = {'url': '/api/v3.0/Tags/{tagId}'}

    def update_tag(
            self, tag_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a tag.

        Required Permissions: Location User.

        :param tag_id:
        :type tag_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.TagUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_tag.metadata['url']
        path_format_arguments = {
            'tagId': self._serialize.url("tag_id", tag_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TagUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TagResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_tag.metadata = {'url': '/api/v3.0/Tags/{tagId}'}

    def get_thermal_cameras(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Get multiple ThermalCamera objects.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Updated` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_thermal_cameras.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelThermalCameraResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_thermal_cameras.metadata = {'url': '/api/v3.0/ThermalCameras'}

    def create_thermal_camera(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Create ThermalCamera object with associated ThermalCameraSettings.

        Required Permissions: Location Admin.

        :param body: ThermalCamera and ThermalCameraSettings properties.
        :type body: ~smartdiagnostics_sdk.models.ThermalCameraCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_thermal_camera.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ThermalCameraCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_thermal_camera.metadata = {'url': '/api/v3.0/ThermalCameras'}

    def get_thermal_camera(
            self, thermal_camera_serial_number, custom_headers=None, raw=False, **operation_config):
        """Get a single ThermalCamera object.

        Required Permissions: Location User.

        :param thermal_camera_serial_number:
        :type thermal_camera_serial_number: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_thermal_camera.metadata['url']
        path_format_arguments = {
            'thermalCameraSerialNumber': self._serialize.url("thermal_camera_serial_number", thermal_camera_serial_number, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_thermal_camera.metadata = {'url': '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}'}

    def update_thermal_camera(
            self, thermal_camera_serial_number, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a single Thermal Camera/ settings.

        Updating a ThermalCamera is location admin only.
        Updating a ThermalCamera Location is SaaS/Sentry only.

        :param thermal_camera_serial_number: The id of the thermal camera to
         update
        :type thermal_camera_serial_number: long
        :param body: The update request for a given Thermal Camera
        :type body: ~smartdiagnostics_sdk.models.ThermalCameraUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_thermal_camera.metadata['url']
        path_format_arguments = {
            'thermalCameraSerialNumber': self._serialize.url("thermal_camera_serial_number", thermal_camera_serial_number, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ThermalCameraUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_thermal_camera.metadata = {'url': '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}'}

    def delete_thermal_camera(
            self, thermal_camera_serial_number, custom_headers=None, raw=False, **operation_config):
        """Deletes a ThermalCamera object and it's associated objects:
        Regions, Images, Settings.

        Deletion of a ThermalCamera is location admin only.

        :param thermal_camera_serial_number: The serial number of the
         ThermalCamera to delete
        :type thermal_camera_serial_number: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_thermal_camera.metadata['url']
        path_format_arguments = {
            'thermalCameraSerialNumber': self._serialize.url("thermal_camera_serial_number", thermal_camera_serial_number, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_thermal_camera.metadata = {'url': '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}'}

    def get_image(
            self, thermal_camera_serial_number, timestamp, custom_headers=None, raw=False, **operation_config):
        """Gets a single thermal camera image.

        Required Permissions: Location User.

        :param thermal_camera_serial_number: The serial number of the camera
        :type thermal_camera_serial_number: long
        :param timestamp: The unix timestamp of the image in ms
        :type timestamp: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_image.metadata['url']
        path_format_arguments = {
            'thermalCameraSerialNumber': self._serialize.url("thermal_camera_serial_number", thermal_camera_serial_number, 'long', minimum=0),
            'timestamp': self._serialize.url("timestamp", timestamp, 'long', minimum=0)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_image.metadata = {'url': '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}/images/{timestamp}'}

    def get_latest_image(
            self, thermal_camera_serial_number, custom_headers=None, raw=False, **operation_config):
        """Gets the latest ThermalCameraImage for a ThermalCamera.

        Required Permissions: Location User.

        :param thermal_camera_serial_number: The serial number of the camera
        :type thermal_camera_serial_number: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_latest_image.metadata['url']
        path_format_arguments = {
            'thermalCameraSerialNumber': self._serialize.url("thermal_camera_serial_number", thermal_camera_serial_number, 'long', minimum=0)
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraImageResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_latest_image.metadata = {'url': '/api/v3.0/ThermalCameras/{thermalCameraSerialNumber}/images/latest'}

    def get_thermal_camera_regions(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets Thermal Camera Regions.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `ThermalCameraSerialNumber` | Int64 | `eq, neq, in, lt, gt, leq,
         geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `Created` | DateTime |
         | `Height` | Int32 |
         | `Name` | String |
         | `Updated` | DateTime |
         | `Width` | Int32 |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_thermal_camera_regions.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelThermalCameraRegionResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_thermal_camera_regions.metadata = {'url': '/api/v3.0/ThermalCameras/regions'}

    def create_thermal_camera_region(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a Thermal Camera Region.

        Required Permissions: Location Admin.

        :param body:
        :type body:
         ~smartdiagnostics_sdk.models.ThermalCameraRegionCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_thermal_camera_region.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ThermalCameraRegionCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraRegionResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_thermal_camera_region.metadata = {'url': '/api/v3.0/ThermalCameras/regions'}

    def get_thermal_camera_region(
            self, region_id, custom_headers=None, raw=False, **operation_config):
        """Gets a single Thermal Camera Region.

        Required Permissions: Location User.

        :param region_id: The id of the region to get
        :type region_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_thermal_camera_region.metadata['url']
        path_format_arguments = {
            'regionId': self._serialize.url("region_id", region_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraRegionResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_thermal_camera_region.metadata = {'url': '/api/v3.0/ThermalCameras/regions/{regionId}'}

    def update_thermal_camera_region(
            self, region_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a single Thermal Camera Region.

        Required Permissions: Location Admin.

        :param region_id: The id of the region to update
        :type region_id: str
        :param body: The update request for a given Thermal Camera Region
        :type body:
         ~smartdiagnostics_sdk.models.ThermalCameraRegionUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_thermal_camera_region.metadata['url']
        path_format_arguments = {
            'regionId': self._serialize.url("region_id", region_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ThermalCameraRegionUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ThermalCameraRegionResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_thermal_camera_region.metadata = {'url': '/api/v3.0/ThermalCameras/regions/{regionId}'}

    def delete_thermal_camera_region(
            self, region_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a Thermal Camera Region.

        Required Permissions: Location Admin.

        :param region_id: The id of the region to delete
        :type region_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_thermal_camera_region.metadata['url']
        path_format_arguments = {
            'regionId': self._serialize.url("region_id", region_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_thermal_camera_region.metadata = {'url': '/api/v3.0/ThermalCameras/regions/{regionId}'}

    def exchange_token(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """

        :param body:
        :type body: ~smartdiagnostics_sdk.models.TokenExchangeRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TokenExchangeResponse or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.TokenExchangeResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.exchange_token.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TokenExchangeRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TokenExchangeResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    exchange_token.metadata = {'url': '/api/v3.0/Tokens/exchange'}

    def get_tree_items(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets treeItems.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, like, in` |
         | `Active` | Boolean | `eq, neq` |
         | `AssetClassCode` | String | `eq, neq, like, in` |
         | `CategoryCode` | String | `eq, neq, like, in` |
         | `CategoryId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryName` | String | `eq, neq, like, in` |
         | `ChildId` | Guid | `eq, neq, in` |
         | `ChildName` | String | `eq, neq, like, in` |
         | `ChildType` | GroupTypeCodes | `eq, neq, in` |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsCollectorDependentSystem` | Boolean | `eq, neq` |
         | `IsPaused` | Boolean | `eq, neq` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `SizeCode` | String | `eq, neq, like, in` |
         | `SizeId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `SizeName` | String | `eq, neq, like, in` |
         | `TreeItemType` | GroupTypeCodes | `eq, neq, in` |
         | `TypeCode` | String | `eq, neq, like, in` |
         | `TypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `TypeName` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CategoryCode` | String |
         | `CategoryName` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
         | `SizeCode` | String |
         | `SizeName` | String |
         | `TypeCode` | String |
         | `TypeName` | String |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Abbreviation`, `Name`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tree_items.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTreeItemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tree_items.metadata = {'url': '/api/v3.0/TreeItems'}

    def get_tree_item(
            self, tree_item_id, custom_headers=None, raw=False, **operation_config):
        """Gets a treeItem.

        Required Permissions: Location User.

        :param tree_item_id:
        :type tree_item_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tree_item.metadata['url']
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TreeItemResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}'}

    def delete_tree_item(
            self, tree_item_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a treeItem.

        Required Permissions: Location Admin.

        :param tree_item_id:
        :type tree_item_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_tree_item.metadata['url']
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}'}

    def get_tree_item_available_asset_classes(
            self, tree_item_id, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets available asset classes in the subtree rooted at treeItemId.

        Required Permissions: Location User.

        :param tree_item_id:
        :type tree_item_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tree_item_available_asset_classes.metadata['url']
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTreeItemAvailableAssetClassResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tree_item_available_asset_classes.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}/AvailableAssetClasses'}

    def move_tree_item(
            self, tree_item_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves a treeItem.

        Required Permissions: Location User.

        :param tree_item_id:
        :type tree_item_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_tree_item.metadata['url']
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TreeItemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}/Move'}

    def get_user_permissions_options(
            self, custom_headers=None, raw=False, **operation_config):
        """

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_user_permissions_options.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserPermissionsOptionsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_user_permissions_options.metadata = {'url': '/api/v3.0/UserPermission/options'}

    def get_users(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `AcceptedEula` | Boolean | `eq, neq` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `Email` | String | `eq, neq, like, in` |
         | `FirstName` | String | `eq, neq, like, in` |
         | `IsApproved` | Boolean | `eq, neq` |
         | `LastLogin` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `LastName` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LockedOut` | Boolean | `eq, neq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `AcceptedEula` | Boolean |
         | `Email` | String |
         | `FirstName` | String |
         | `IsApproved` | Boolean |
         | `LastLogin` | DateTime? |
         | `LastName` | String |
         | `LockedOut` | Boolean |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Email`, `FirstName`, `FullName`, `LastName`,
         `PhoneNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_users.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelUserResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_users.metadata = {'url': '/api/v3.0/Users'}

    def create_user(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Create a new user.

        Required Permissions:
        - Saas can create any type of user
        - Sentry can create sentry and below
        - Corporation admins can create corporation admins and below
        - Location admins can create location admins and below
        - Users without admin rights cannot create users.

        :param body: Request to create a new user
        :type body: ~smartdiagnostics_sdk.models.UserCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_user.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UserCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_user.metadata = {'url': '/api/v3.0/Users'}

    def get_user(
            self, user_id, custom_headers=None, raw=False, **operation_config):
        """Returns a specified user.

        Required Permissions:
        - Saas and Sentry can get any user
        - Corporation admins can get other corporation admins and users in
        their corporation as
        well as location admins and users in the locations under their
        corporation
        - Corporation users can get other corporation users in their
        corporation
        - Location admins can get other location admins and location users in
        their location
        - Location users can get other location users in their location.

        :param user_id: The Id of the User to return
        :type user_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_user.metadata['url']
        path_format_arguments = {
            'userId': self._serialize.url("user_id", user_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_user.metadata = {'url': '/api/v3.0/Users/{userId}'}

    def update_user(
            self, user_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a user.

        Required Permissions:
        - Saas can update any type of user
        - Sentry can update sentry and below
        - Corporation admins can update corporation admins and below
        - Location admins can update location admins and below
        - Users without admin rights cannot update users.

        :param user_id: ID of the user to update
        :type user_id: str
        :param body: Request to update the user
        :type body: ~smartdiagnostics_sdk.models.UserUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_user.metadata['url']
        path_format_arguments = {
            'userId': self._serialize.url("user_id", user_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UserUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_user.metadata = {'url': '/api/v3.0/Users/{userId}'}

    def get_user_profile(
            self, user_id, custom_headers=None, raw=False, **operation_config):
        """Gets a user's profile.

        Required Permissions:
        - Saas and Sentry can get any user
        - Corporation admins can get other corporation admins and users in
        their corporation as
        well as location admins and users in the locations under their
        corporation
        - Corporation users can get other corporation users in their
        corporation
        - Location admins can get other location admins and location users in
        their location
        - Location users can get other location users in their location.

        :param user_id: The user's ID
        :type user_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_user_profile.metadata['url']
        path_format_arguments = {
            'userId': self._serialize.url("user_id", user_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserProfileResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_user_profile.metadata = {'url': '/api/v3.0/Users/{userId}/profile'}

    def update_user_profile(
            self, user_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a user's profile.

        Required Permissions: User.

        :param user_id: The user's ID
        :type user_id: str
        :param body: Request object used to update the profile
        :type body: ~smartdiagnostics_sdk.models.UserProfileUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_user_profile.metadata['url']
        path_format_arguments = {
            'userId': self._serialize.url("user_id", user_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UserProfileUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('UserProfileResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_user_profile.metadata = {'url': '/api/v3.0/Users/{userId}/profile'}

    def get_current_user(
            self, custom_headers=None, raw=False, **operation_config):
        """

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_current_user.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CurrentUserResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_current_user.metadata = {'url': '/api/v3.0/Users/currentUser'}

    def get_personal_access_tokens(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Lists the current user's access tokens.

        Required Permissions: User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `Description` | String | `eq, neq, like, in` |
         | `LastUsed` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `Updated` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `Created` | DateTime |
         | `Description` | String |
         | `LastUsed` | DateTime? |
         | `Updated` | DateTime? |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `Description`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_personal_access_tokens.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPersonalAccessTokenResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_personal_access_tokens.metadata = {'url': '/api/v3.0/Users/currentUser/tokens'}

    def generate_personal_access_tokens(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Generate a new access token for the current user.

        Required Permissions: User.

        :param body:
        :type body:
         ~smartdiagnostics_sdk.models.PersonalAccessTokenCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.generate_personal_access_tokens.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'PersonalAccessTokenCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 201:
            deserialized = self._deserialize('PersonalAccessTokenCreateResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    generate_personal_access_tokens.metadata = {'url': '/api/v3.0/Users/currentUser/tokens'}

    def get_personal_access_token(
            self, token_id, custom_headers=None, raw=False, **operation_config):
        """Get one of the current user's access tokens.

        Required Permissions: User.

        :param token_id:
        :type token_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_personal_access_token.metadata['url']
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PersonalAccessTokenResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}

    def update_personal_access_token(
            self, token_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Update one of the current user's access tokens.

        Required Permissions: User.

        :param token_id:
        :type token_id: str
        :param body:
        :type body:
         ~smartdiagnostics_sdk.models.PersonalAccessTokenUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_personal_access_token.metadata['url']
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'PersonalAccessTokenUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PersonalAccessTokenResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}

    def delete_personal_access_token(
            self, token_id, custom_headers=None, raw=False, **operation_config):
        """Revokes one of the current user's access tokens.

        Required Permissions: User.

        :param token_id:
        :type token_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_personal_access_token.metadata['url']
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}

    def send_confirmation_code(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Sends a confirmation code to the supplied phone number.

        Required Permissions: User.

        :param body: The request object containing the phone number to send
         the confirmation code to
        :type body: ~smartdiagnostics_sdk.models.UserPhoneNumberConfirmRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.send_confirmation_code.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UserPhoneNumberConfirmRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    send_confirmation_code.metadata = {'url': '/api/v3.0/Users/phoneNumber/confirm'}

    def get_profile_options(
            self, custom_headers=None, raw=False, **operation_config):
        """Gets all possible options for user profile properties.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_profile_options.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ProfileOptionsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_profile_options.metadata = {'url': '/api/v3.0/Users/profiles/options'}

    def get_activities(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets Activities.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `ActivityCategory` | CaseContentType | `eq, neq, in` |
         | `ActivityCodeId` | Guid | `eq, neq, in` |
         | `CreatedBy` | String | `eq, neq, like, in` |
         | `DateOccurred` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `Description` | String | `eq, neq, like, in` |
         | `GroupId` | Guid | `eq, neq, in` |
         | `IndicatorId` | Guid | `eq, neq, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `ModifiedBy` | String | `eq, neq, like, in` |
         | `Savings` | Single | `eq, neq, in, lt, gt, leq, geq` |
         | `Title` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `ActivityCategory` | CaseContentType |
         | `Created` | DateTime |
         | `CreatedBy` | String |
         | `DateOccurred` | DateTime |
         | `Description` | String |
         | `GroupName` | String |
         | `LocationName` | String |
         | `Modified` | DateTime |
         | `ModifiedBy` | String |
         | `Savings` | Single |
         | `Title` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activities.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelActivityResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activities.metadata = {'url': '/api/v3.0/Activities'}

    def create_activity(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an Activity.

        Required Permissions: Location User.

        :param body: Activity details
        :type body: ~smartdiagnostics_sdk.models.ActivityCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_activity.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_activity.metadata = {'url': '/api/v3.0/Activities'}

    def get_activity(
            self, activity_id, custom_headers=None, raw=False, **operation_config):
        """Gets an Activity.

        Required Permissions: Location User.

        :param activity_id: Id of the activity
        :type activity_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity.metadata['url']
        path_format_arguments = {
            'activityId': self._serialize.url("activity_id", activity_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity.metadata = {'url': '/api/v3.0/Activities/{activityId}'}

    def update_activity(
            self, activity_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an Activity.

        Required Permissions: Location User.

        :param activity_id:
        :type activity_id: str
        :param body: Activity details
        :type body: ~smartdiagnostics_sdk.models.ActivityUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_activity.metadata['url']
        path_format_arguments = {
            'activityId': self._serialize.url("activity_id", activity_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'ActivityUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ActivityResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_activity.metadata = {'url': '/api/v3.0/Activities/{activityId}'}

    def delete_activity(
            self, activity_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an activity.

        Required Permissions: Location Admin.

        :param activity_id: Id of the activity
        :type activity_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_activity.metadata['url']
        path_format_arguments = {
            'activityId': self._serialize.url("activity_id", activity_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_activity.metadata = {'url': '/api/v3.0/Activities/{activityId}'}

    def get_activity_categories(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets activity categories.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_categories.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelActivityCategoryResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_categories.metadata = {'url': '/api/v3.0/Activities/Categories'}

    def get_activity_codes(
            self, category_type, location_id=None, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets activity codes for category type.

        Required Permissions: Location User.

        :param category_type: The category to get the associated codes.
         Possible values include: 'None', 'OperationalCondition', 'Fault',
         'RootCause', 'Evidence', 'Inspection', 'PreventativeMaintenance',
         'CorrectiveMaintenance', 'Observation', 'Document', 'Description',
         'SamplingFrequencyChange', 'PendingSamplingFrequencyChange',
         'AutoInvalidBurstData', 'UserInvalidBurstData'
        :type category_type: str
        :param location_id: Optional param to get location specific codes
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Name` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_activity_codes.metadata['url']
        path_format_arguments = {
            'categoryType': self._serialize.url("category_type", category_type, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if location_id is not None:
            query_parameters['locationId'] = self._serialize.query("location_id", location_id, 'str')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelActivityCodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_activity_codes.metadata = {'url': '/api/v3.0/Activities/Categories/{categoryType}/codes'}

    def create_event(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an event.

        :param body: Model for the new event
        :type body: ~smartdiagnostics_sdk.models.EventModelV3
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_event.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'EventModelV3')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EventModelV3', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_event.metadata = {'url': '/api/v3.0/Events'}

    def get_group_alerts(
            self, group_id, filter_ids=None, sensor_role_type=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets the alerts for the given group.

        Required Permissions:
        User must have access to the Group
        User must have access to the Filters.

        :param group_id: The group to get the alerts for
        :type group_id: str
        :param filter_ids:
        :type filter_ids: list[str]
        :param sensor_role_type: SensorRoleType is an additional filtering
         component for limiting to X or Y.
        :type sensor_role_type: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `IndicatorName` | String |
         | `IndicatorSortOrder` | Int32? |
         | `TimeOfAlert` | DateTime? |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: None.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_group_alerts.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter_ids is not None:
            query_parameters['FilterIds'] = self._serialize.query("filter_ids", filter_ids, '[str]', div=',')
        if sensor_role_type is not None:
            query_parameters['SensorRoleType'] = self._serialize.query("sensor_role_type", sensor_role_type, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupAlertsResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_group_alerts.metadata = {'url': '/api/v3.0/Groups/{groupId}/alerts'}

    def get_monitoring_point_overview1(
            self, group_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets an overview of monitoring point(s) which includes the node
        settings.

        :param group_id:
        :type group_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `HierarchyAbbreviation` | String | `eq, neq, like, in` |
         | `HierarchyName` | String | `eq, neq, like, in` |
         | `MonitoringPointType` | MonitoringPointTypeCodes | `eq, neq, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `NodeNickname` | String | `eq, neq, like, in` |
         | `NodeSerialNumber` | String | `eq, neq, like, in` |
         | `RunningSpeedMultiplier` | Double? | `eq, neq, in, lt, gt, leq, geq`
         |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `DecimationFactor` | NodeSettingValues |
         | `HierarchyAbbreviation` | String |
         | `HierarchyName` | String |
         | `MonitoringPointType` | MonitoringPointTypeCodes |
         | `Name` | String |
         | `NodeNickname` | String |
         | `NodeSerialNumber` | String |
         | `RunningSpeedMultiplier` | Double? |
         | `UpdateInterval` | NodeSettingValues |
        :type order_by: str
        :param name_search: Provide search terms to narrow result.
         Searchable properties: `HierarchySearch`, `NodeNickname`,
         `NodeSerialNumber`.
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point_overview1.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMonitoringPointOverviewResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point_overview1.metadata = {'url': '/api/v3.0/Groups/{groupId}/monitoringPoints/overview'}

    def get_spectrum_chart_settings(
            self, group_id, custom_headers=None, raw=False, **operation_config):
        """Gets the Spectrum Chart Settings for a given group.

        Required Permissions: Location User.

        :param group_id: The group to retrieve the spectrum chart settings for
        :type group_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_spectrum_chart_settings.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SpectrumChartSettingsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_spectrum_chart_settings.metadata = {'url': '/api/v3.0/Groups/{groupId}/spectrumChartSettings'}

    def create_spectrum_chart_settings(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates the Spectrum Chart settings for a group.

        Required Permissions: Location User.

        :param group_id:
        :type group_id: str
        :param body: Contains chart setting info for the Frequency and Time
         Domains
        :type body:
         ~smartdiagnostics_sdk.models.SpectrumChartSettingsCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_spectrum_chart_settings.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SpectrumChartSettingsCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SpectrumChartSettingsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_spectrum_chart_settings.metadata = {'url': '/api/v3.0/Groups/{groupId}/spectrumChartSettings'}

    def get_options_for_indicator(
            self, custom_headers=None, raw=False, **operation_config):
        """Gets options for indicators.

        Required Permissions: Location User.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_options_for_indicator.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorOptionsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_options_for_indicator.metadata = {'url': '/api/v3.0/Indicators/options'}

    def get_receivers(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets receivers.

        Required Permissions: Location User.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, like, in` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, like, in` |
         | `FirmwareVersion` | String | `eq, neq, like, in` |
         | `LocationAbbreviation` | String | `eq, neq, like, in` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, like, in` |
         | `MacAddress` | String | `eq, neq, like, in` |
         | `Name` | String | `eq, neq, like, in` |
         | `NetworkId` | String | `eq, neq, like, in` |
         | `PendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `RadioMacAddress` | String | `eq, neq, like, in` |
         | `ReceiverType` | ReceiverType | `eq, neq, in` |
         | `RfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `SerialNumber` | String | `eq, neq, like, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `FirmwareVersion` | String |
         | `LocationName` | String |
         | `MacAddress` | String |
         | `Name` | String |
         | `NetworkId` | String |
         | `PendingRfChannel` | Int32? |
         | `RadioMacAddress` | String |
         | `ReceiverType` | ReceiverType |
         | `RfChannel` | Int32? |
         | `SerialNumber` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_receivers.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelReceiverResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_receivers.metadata = {'url': '/api/v3.0/Receivers'}

    def get_receiver(
            self, receiver_id, custom_headers=None, raw=False, **operation_config):
        """Gets a receiver.

        Required Permissions: Location User.

        :param receiver_id:
        :type receiver_id: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_receiver.metadata['url']
        path_format_arguments = {
            'receiverId': self._serialize.url("receiver_id", receiver_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ReceiverResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_receiver.metadata = {'url': '/api/v3.0/Receivers/{receiverId}'}
