# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UserResponse(Model):
    """UserResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param first_name: Required.
    :type first_name: str
    :param last_name: Required.
    :type last_name: str
    :param email: Required.
    :type email: str
    :param phone_number:
    :type phone_number: str
    :param application_role_code: Required. Possible values include:
     'Invalid', 'SaasAdmin', 'AccountAdmin', 'ApplicationUser', 'Technician',
     'User', 'SystemProcess', 'Sentry', 'Sales', 'CorporationAdmin',
     'CorporationUser', 'CorporationNone'
    :type application_role_code: str or ~smartdiagnostics_sdk.models.enum
    :param is_approved: Required.
    :type is_approved: bool
    :param accepted_eula: Required.
    :type accepted_eula: bool
    :param last_login:
    :type last_login: datetime
    :param locked_out: Required. This is only relevant to non-SSO users, even
     if it is {true}
    :type locked_out: bool
    :param corporations: Required.
    :type corporations:
     list[~smartdiagnostics_sdk.models.UserCorporationChild]
    :param locations: Required.
    :type locations: list[~smartdiagnostics_sdk.models.UserLocationChild]
    """

    _validation = {
        'id': {'required': True},
        'first_name': {'required': True},
        'last_name': {'required': True},
        'email': {'required': True},
        'application_role_code': {'required': True},
        'is_approved': {'required': True},
        'accepted_eula': {'required': True},
        'locked_out': {'required': True},
        'corporations': {'required': True},
        'locations': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'first_name': {'key': 'FirstName', 'type': 'str'},
        'last_name': {'key': 'LastName', 'type': 'str'},
        'email': {'key': 'Email', 'type': 'str'},
        'phone_number': {'key': 'PhoneNumber', 'type': 'str'},
        'application_role_code': {'key': 'ApplicationRoleCode', 'type': 'str'},
        'is_approved': {'key': 'IsApproved', 'type': 'bool'},
        'accepted_eula': {'key': 'AcceptedEula', 'type': 'bool'},
        'last_login': {'key': 'LastLogin', 'type': 'iso-8601'},
        'locked_out': {'key': 'LockedOut', 'type': 'bool'},
        'corporations': {'key': 'Corporations', 'type': '[UserCorporationChild]'},
        'locations': {'key': 'Locations', 'type': '[UserLocationChild]'},
    }

    def __init__(self, *, id: str, first_name: str, last_name: str, email: str, application_role_code, is_approved: bool, accepted_eula: bool, locked_out: bool, corporations, locations, phone_number: str=None, last_login=None, **kwargs) -> None:
        super(UserResponse, self).__init__(**kwargs)
        self.id = id
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.phone_number = phone_number
        self.application_role_code = application_role_code
        self.is_approved = is_approved
        self.accepted_eula = accepted_eula
        self.last_login = last_login
        self.locked_out = locked_out
        self.corporations = corporations
        self.locations = locations
