# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ThermalCameraSettingsCreateRequest(Model):
    """Request object for creating ThermalCameraSettings.

    All required parameters must be populated in order to send to Azure.

    :param atmosphere_temperature: Required. The ambient temperature on the
     camera in Kelvin.
    :type atmosphere_temperature: float
    :param emissivity: Required. The Emissivity value used in calculating
     temperature.
    :type emissivity: float
    :param distance: Required. The distance in meters between the camera and
     the object being measured.
    :type distance: float
    :param reflected_temperature: Required. The reflected temperature of the
     object in Kelvin.
    :type reflected_temperature: float
    :param relative_humidity: Required. The relative humidity of the camera.
    :type relative_humidity: float
    :param window_transmission_rate: Required. The amount of thermal radiation
     allowed through an external window.
    :type window_transmission_rate: float
    :param window_temperature: Required. The temperature of any external
     thermal windows in Kelvin.
    :type window_temperature: float
    :param update_interval: Required. How often a value is transmitted to SD
    :type update_interval: int
    """

    _validation = {
        'atmosphere_temperature': {'required': True},
        'emissivity': {'required': True, 'maximum': 1, 'minimum': 0.001},
        'distance': {'required': True},
        'reflected_temperature': {'required': True},
        'relative_humidity': {'required': True, 'maximum': 1, 'minimum': 0},
        'window_transmission_rate': {'required': True, 'maximum': 1, 'minimum': 0.001},
        'window_temperature': {'required': True},
        'update_interval': {'required': True},
    }

    _attribute_map = {
        'atmosphere_temperature': {'key': 'AtmosphereTemperature', 'type': 'float'},
        'emissivity': {'key': 'Emissivity', 'type': 'float'},
        'distance': {'key': 'Distance', 'type': 'float'},
        'reflected_temperature': {'key': 'ReflectedTemperature', 'type': 'float'},
        'relative_humidity': {'key': 'RelativeHumidity', 'type': 'float'},
        'window_transmission_rate': {'key': 'WindowTransmissionRate', 'type': 'float'},
        'window_temperature': {'key': 'WindowTemperature', 'type': 'float'},
        'update_interval': {'key': 'UpdateInterval', 'type': 'int'},
    }

    def __init__(self, *, atmosphere_temperature: float, emissivity: float, distance: float, reflected_temperature: float, relative_humidity: float, window_transmission_rate: float, window_temperature: float, update_interval: int, **kwargs) -> None:
        super(ThermalCameraSettingsCreateRequest, self).__init__(**kwargs)
        self.atmosphere_temperature = atmosphere_temperature
        self.emissivity = emissivity
        self.distance = distance
        self.reflected_temperature = reflected_temperature
        self.relative_humidity = relative_humidity
        self.window_transmission_rate = window_transmission_rate
        self.window_temperature = window_temperature
        self.update_interval = update_interval
