# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ThermalCameraRegionCreateRequest(Model):
    """ThermalCameraRegionCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the region
    :type name: str
    :param xcoordinate: Required. The "X" coordinate that determines the
     position of the region.
     In other words, where the region is located.
    :type xcoordinate: int
    :param ycoordinate: Required. The "Y" coordinate that determines the
     position of the region.
     In other words, where the region is located.
    :type ycoordinate: int
    :param width: Required. The width of the region
    :type width: int
    :param height: Required. The height of the region
    :type height: int
    :param thermal_camera_serial_number: Required. The serial number for the
     Thermal Camera the region belongs to
    :type thermal_camera_serial_number: long
    :param instance: Required. The unique set of coordinates that designates a
     region.
     Each thermal camera can have up to 5 unique instances.
    :type instance: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 50},
        'xcoordinate': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'ycoordinate': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'width': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'height': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'thermal_camera_serial_number': {'required': True},
        'instance': {'required': True, 'maximum': 5, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'xcoordinate': {'key': 'XCoordinate', 'type': 'int'},
        'ycoordinate': {'key': 'YCoordinate', 'type': 'int'},
        'width': {'key': 'Width', 'type': 'int'},
        'height': {'key': 'Height', 'type': 'int'},
        'thermal_camera_serial_number': {'key': 'ThermalCameraSerialNumber', 'type': 'long'},
        'instance': {'key': 'Instance', 'type': 'int'},
    }

    def __init__(self, *, name: str, xcoordinate: int, ycoordinate: int, width: int, height: int, thermal_camera_serial_number: int, instance: int, **kwargs) -> None:
        super(ThermalCameraRegionCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.xcoordinate = xcoordinate
        self.ycoordinate = ycoordinate
        self.width = width
        self.height = height
        self.thermal_camera_serial_number = thermal_camera_serial_number
        self.instance = instance
