# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LocationResponse(Model):
    """Location response.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Id of the location
    :type id: str
    :param name: Required. Location's name
    :type name: str
    :param abbreviation: Location's abbreviation
    :type abbreviation: str
    :param active: Required. If the location is active
    :type active: bool
    :param created: Required. When the location was created
    :type created: datetime
    :param api_key: The location's API key
    :type api_key: str
    :param site_ids: The location's siteIds
    :type site_ids: list[str]
    :param settings:
    :type settings: ~smartdiagnostics_sdk.models.LocationSettingsChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.PrimaryCorporationChild
    :param systems: The systems in the location
    :type systems: list[~smartdiagnostics_sdk.models.SystemChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'created': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'api_key': {'key': 'ApiKey', 'type': 'str'},
        'site_ids': {'key': 'SiteIds', 'type': '[str]'},
        'settings': {'key': 'Settings', 'type': 'LocationSettingsChild'},
        'corporation': {'key': 'Corporation', 'type': 'PrimaryCorporationChild'},
        'systems': {'key': 'Systems', 'type': '[SystemChild]'},
    }

    def __init__(self, *, id: str, name: str, active: bool, created, abbreviation: str=None, api_key: str=None, site_ids=None, settings=None, corporation=None, systems=None, **kwargs) -> None:
        super(LocationResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.created = created
        self.api_key = api_key
        self.site_ids = site_ids
        self.settings = settings
        self.corporation = corporation
        self.systems = systems
