# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobResponse(Model):
    """JobResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The unique Id for the Job
    :type id: str
    :param enqueued_time: Required. The time the job was created
    :type enqueued_time: datetime
    :param finished_time: The time the job was finished
    :type finished_time: datetime
    :param errored_time: The time the job errored
    :type errored_time: datetime
    :param status: Required. The status of the job. Possible values include:
     'Queued', 'Running', 'Finished', 'FinishedWithErrors', 'Errored',
     'Deferred'
    :type status: str or ~smartdiagnostics_sdk.models.enum
    :param type: Required. The type of job. Possible values include:
     'SensorAssignment', 'SystemCreation', 'EditGroups', 'EditAssetDetails',
     'EditIndicators'
    :type type: str or ~smartdiagnostics_sdk.models.enum
    :param uploaded_file_name: Required. The name of the file that was
     uploaded
    :type uploaded_file_name: str
    :param error_file_name: The name of the error file, if the job has a
     Status of FinishedWithErrors
    :type error_file_name: str
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param user: Required.
    :type user: ~smartdiagnostics_sdk.models.UserChild
    """

    _validation = {
        'id': {'required': True},
        'enqueued_time': {'required': True},
        'status': {'required': True},
        'type': {'required': True},
        'uploaded_file_name': {'required': True},
        'location': {'required': True},
        'corporation': {'required': True},
        'user': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'enqueued_time': {'key': 'EnqueuedTime', 'type': 'iso-8601'},
        'finished_time': {'key': 'FinishedTime', 'type': 'iso-8601'},
        'errored_time': {'key': 'ErroredTime', 'type': 'iso-8601'},
        'status': {'key': 'Status', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'uploaded_file_name': {'key': 'UploadedFileName', 'type': 'str'},
        'error_file_name': {'key': 'ErrorFileName', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'user': {'key': 'User', 'type': 'UserChild'},
    }

    def __init__(self, **kwargs):
        super(JobResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.enqueued_time = kwargs.get('enqueued_time', None)
        self.finished_time = kwargs.get('finished_time', None)
        self.errored_time = kwargs.get('errored_time', None)
        self.status = kwargs.get('status', None)
        self.type = kwargs.get('type', None)
        self.uploaded_file_name = kwargs.get('uploaded_file_name', None)
        self.error_file_name = kwargs.get('error_file_name', None)
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.user = kwargs.get('user', None)
