# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GroupAnalyticsModelResponse(Model):
    """GroupAnalyticsModelResponse.

    All required parameters must be populated in order to send to Azure.

    :param group: Required.
    :type group: ~smartdiagnostics_sdk.models.GroupChild
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param version: Required.
    :type version: str
    :param type: Required. Possible values include: 'SMARTIndicator',
     'Classifier'
    :type type: str or ~smartdiagnostics_sdk.models.enum
    :param created: Required.
    :type created: datetime
    :param group_type: Possible values include: 'Asset', 'MonitoringPoint',
     'IndicatorGroup', 'Group', 'AnalyticModel'
    :type group_type: str or ~smartdiagnostics_sdk.models.enum
    :param is_global: Required.
    :type is_global: bool
    :param is_deprecated: Required.
    :type is_deprecated: bool
    :param last_upload:
    :type last_upload: datetime
    :param error_type: Possible values include: 'RetainedInfoTooLarge',
     'ModelTimeout', 'SyntaxError', 'MalformedResults', 'NoExecuteMethod',
     'FailureRateReached'
    :type error_type: str or ~smartdiagnostics_sdk.models.enum
    :param disable_date:
    :type disable_date: datetime
    :param indicators:
    :type indicators:
     list[~smartdiagnostics_sdk.models.AnalyticsModelIndicatorChild]
    :param properties:
    :type properties: list[~smartdiagnostics_sdk.models.PropertyChild]
    :param related_models:
    :type related_models:
     list[~smartdiagnostics_sdk.models.AnalyticsModelRelatedModelChild]
    :param created_by:
    :type created_by: ~smartdiagnostics_sdk.models.UserChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param triggers:
    :type triggers: list[~smartdiagnostics_sdk.models.TriggerChild]
    :param tags:
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    """

    _validation = {
        'group': {'required': True},
        'id': {'required': True},
        'name': {'required': True},
        'version': {'required': True},
        'type': {'required': True},
        'created': {'required': True},
        'is_global': {'required': True},
        'is_deprecated': {'required': True},
    }

    _attribute_map = {
        'group': {'key': 'Group', 'type': 'GroupChild'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'is_deprecated': {'key': 'IsDeprecated', 'type': 'bool'},
        'last_upload': {'key': 'LastUpload', 'type': 'iso-8601'},
        'error_type': {'key': 'ErrorType', 'type': 'str'},
        'disable_date': {'key': 'DisableDate', 'type': 'iso-8601'},
        'indicators': {'key': 'Indicators', 'type': '[AnalyticsModelIndicatorChild]'},
        'properties': {'key': 'Properties', 'type': '[PropertyChild]'},
        'related_models': {'key': 'RelatedModels', 'type': '[AnalyticsModelRelatedModelChild]'},
        'created_by': {'key': 'CreatedBy', 'type': 'UserChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'triggers': {'key': 'Triggers', 'type': '[TriggerChild]'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
    }

    def __init__(self, **kwargs):
        super(GroupAnalyticsModelResponse, self).__init__(**kwargs)
        self.group = kwargs.get('group', None)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.version = kwargs.get('version', None)
        self.type = kwargs.get('type', None)
        self.created = kwargs.get('created', None)
        self.group_type = kwargs.get('group_type', None)
        self.is_global = kwargs.get('is_global', None)
        self.is_deprecated = kwargs.get('is_deprecated', None)
        self.last_upload = kwargs.get('last_upload', None)
        self.error_type = kwargs.get('error_type', None)
        self.disable_date = kwargs.get('disable_date', None)
        self.indicators = kwargs.get('indicators', None)
        self.properties = kwargs.get('properties', None)
        self.related_models = kwargs.get('related_models', None)
        self.created_by = kwargs.get('created_by', None)
        self.corporation = kwargs.get('corporation', None)
        self.location = kwargs.get('location', None)
        self.triggers = kwargs.get('triggers', None)
        self.tags = kwargs.get('tags', None)
