# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AssetUpdateRequest(Model):
    """AssetUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param is_paused: Required.
    :type is_paused: bool
    :param running_speed_min:
    :type running_speed_min: float
    :param running_speed_max:
    :type running_speed_max: float
    :param running_speed_type: Possible values include: 'Invalid', 'Fixed',
     'Ranged', 'AutoTrack'
    :type running_speed_type: str or ~smartdiagnostics_sdk.models.enum
    :param running_speed_reference_monitoring_point_id:
    :type running_speed_reference_monitoring_point_id: str
    :param running_speed_sensor_role_type: Possible values include: 'Invalid',
     'CurrentPhaseA', 'PeakCurrentPhaseA', 'CurrentPhaseB',
     'PeakCurrentPhaseB', 'CurrentPhaseC', 'PeakCurrentPhaseC',
     'DifferentialPressure', 'Flow', 'Humidity', 'NodeTemperature',
     'NodeVoltage', 'PeakVibration', 'Pressure', 'RmsVibration',
     'SignalStrength', 'StandardAirVelocity', 'SupplyVoltage', 'Temperature',
     'TotalCurrent', 'VibrationXAxis', 'VibrationYAxis', 'Voltage', 'Current',
     'AtoDChannel1', 'AtoDChannel2', 'AtoDChannel3', 'AtoDChannel4',
     'AtoDChannel5', 'AtoDChannel6', 'OilTemperature', 'OilHumidity', 'X', 'Y',
     'Z', 'Custom', 'WirelessEfficiency', 'PacketSuccessRate', 'NodeHumidity',
     'BurstSuccessRate'
    :type running_speed_sensor_role_type: str or
     ~smartdiagnostics_sdk.models.enum
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view: Required.
    :type is_operator_view: bool
    :param type_id:
    :type type_id: int
    :param category_id:
    :type category_id: int
    :param size_id:
    :type size_id: int
    :param criticality_id:
    :type criticality_id: int
    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _validation = {
        'is_paused': {'required': True},
        'name': {'required': True, 'max_length': 100},
        'abbreviation': {'max_length': 5},
        'supplier': {'max_length': 128},
        'manufacturer': {'max_length': 128},
        'model_name': {'max_length': 128},
        'location_notes': {'max_length': 256},
        'notes': {'max_length': 2000},
        'generic_input': {'max_length': 2000},
        'is_operator_view': {'required': True},
        'type_id': {'maximum': 2147483647, 'minimum': 0},
        'category_id': {'maximum': 2147483647, 'minimum': 0},
        'size_id': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'running_speed_min': {'key': 'RunningSpeedMin', 'type': 'float'},
        'running_speed_max': {'key': 'RunningSpeedMax', 'type': 'float'},
        'running_speed_type': {'key': 'RunningSpeedType', 'type': 'str'},
        'running_speed_reference_monitoring_point_id': {'key': 'RunningSpeedReferenceMonitoringPointId', 'type': 'str'},
        'running_speed_sensor_role_type': {'key': 'RunningSpeedSensorRoleType', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(AssetUpdateRequest, self).__init__(**kwargs)
        self.is_paused = kwargs.get('is_paused', None)
        self.running_speed_min = kwargs.get('running_speed_min', None)
        self.running_speed_max = kwargs.get('running_speed_max', None)
        self.running_speed_type = kwargs.get('running_speed_type', None)
        self.running_speed_reference_monitoring_point_id = kwargs.get('running_speed_reference_monitoring_point_id', None)
        self.running_speed_sensor_role_type = kwargs.get('running_speed_sensor_role_type', None)
        self.name = kwargs.get('name', None)
        self.abbreviation = kwargs.get('abbreviation', None)
        self.supplier = kwargs.get('supplier', None)
        self.manufacturer = kwargs.get('manufacturer', None)
        self.model_name = kwargs.get('model_name', None)
        self.location_notes = kwargs.get('location_notes', None)
        self.notes = kwargs.get('notes', None)
        self.generic_input = kwargs.get('generic_input', None)
        self.is_operator_view = kwargs.get('is_operator_view', None)
        self.type_id = kwargs.get('type_id', None)
        self.category_id = kwargs.get('category_id', None)
        self.size_id = kwargs.get('size_id', None)
        self.criticality_id = kwargs.get('criticality_id', None)
        self.asset_cost = kwargs.get('asset_cost', None)
        self.date_installed = kwargs.get('date_installed', None)
        self.annual_run_time = kwargs.get('annual_run_time', None)
        self.lost_production_cost = kwargs.get('lost_production_cost', None)
        self.overhaul_cost = kwargs.get('overhaul_cost', None)
        self.power_consumption = kwargs.get('power_consumption', None)
        self.life_expectancy = kwargs.get('life_expectancy', None)
        self.unscheduled_downtime = kwargs.get('unscheduled_downtime', None)
        self.running_speed_harmonic = kwargs.get('running_speed_harmonic', None)
