# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AnalyticsModelCreateRequest(Model):
    """AnalyticsModelCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param version: Required.
    :type version: str
    :param location_id:
    :type location_id: str
    :param corporation_id:
    :type corporation_id: str
    :param type: Required. Possible values include: 'SMARTIndicator',
     'Classifier'
    :type type: str or ~smartdiagnostics_sdk.models.enum
    :param group_type: Possible values include: 'Asset', 'MonitoringPoint',
     'IndicatorGroup', 'Group', 'AnalyticModel'
    :type group_type: str or ~smartdiagnostics_sdk.models.enum
    :param indicators:
    :type indicators:
     list[~smartdiagnostics_sdk.models.AnalyticsModelIndicatorChild]
    :param related_model_ids:
    :type related_model_ids: list[str]
    :param properties:
    :type properties: list[~smartdiagnostics_sdk.models.PropertyRequestChild]
    :param triggers:
    :type triggers: list[~smartdiagnostics_sdk.models.TriggerChild]
    :param tag_ids:
    :type tag_ids: list[str]
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'version': {'required': True, 'max_length': 10, 'min_length': 0},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
        'indicators': {'key': 'Indicators', 'type': '[AnalyticsModelIndicatorChild]'},
        'related_model_ids': {'key': 'RelatedModelIds', 'type': '[str]'},
        'properties': {'key': 'Properties', 'type': '[PropertyRequestChild]'},
        'triggers': {'key': 'Triggers', 'type': '[TriggerChild]'},
        'tag_ids': {'key': 'TagIds', 'type': '[str]'},
    }

    def __init__(self, *, name: str, version: str, type, location_id: str=None, corporation_id: str=None, group_type=None, indicators=None, related_model_ids=None, properties=None, triggers=None, tag_ids=None, **kwargs) -> None:
        super(AnalyticsModelCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.version = version
        self.location_id = location_id
        self.corporation_id = corporation_id
        self.type = type
        self.group_type = group_type
        self.indicators = indicators
        self.related_model_ids = related_model_ids
        self.properties = properties
        self.triggers = triggers
        self.tag_ids = tag_ids
