# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityEventResponse(Model):
    """ActivityEventResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Activity event id
    :type id: str
    :param title: Required. The title of activity event
    :type title: str
    :param description: The description of what occurred during the activity
     event.
    :type description: str
    :param note: Note for activity event
    :type note: str
    :param start_date_time: Required. Activity event start date / time
    :type start_date_time: datetime
    :param end_date_time: Activity event end date / time (if available)
    :type end_date_time: datetime
    :param activity_line_enabled: Enabled for activity line display
    :type activity_line_enabled: bool
    :param asset_card_enabled: Enabled for asset card display
    :type asset_card_enabled: bool
    :param document:
    :type document: ~smartdiagnostics_sdk.models.DocumentChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param category: Required.
    :type category: ~smartdiagnostics_sdk.models.ActivityEventCategoryChild
    :param subcategories: List of subcategories
    :type subcategories:
     list[~smartdiagnostics_sdk.models.ActivityEventSubcategoryChild]
    :param binds: List of binds (entity associations)
    :type binds: list[~smartdiagnostics_sdk.models.ActivityEventBindChild]
    :param fields: List of field / field entries
    :type fields:
     list[~smartdiagnostics_sdk.models.ActivityEventFieldEntryChild]
    :param relationships: List of relationships involving this activity event.
    :type relationships:
     list[~smartdiagnostics_sdk.models.ActivityEventRelationshipChild]
    """

    _validation = {
        'id': {'required': True},
        'title': {'required': True},
        'start_date_time': {'required': True},
        'location': {'required': True},
        'category': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'note': {'key': 'Note', 'type': 'str'},
        'start_date_time': {'key': 'StartDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'EndDateTime', 'type': 'iso-8601'},
        'activity_line_enabled': {'key': 'ActivityLineEnabled', 'type': 'bool'},
        'asset_card_enabled': {'key': 'AssetCardEnabled', 'type': 'bool'},
        'document': {'key': 'Document', 'type': 'DocumentChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'category': {'key': 'Category', 'type': 'ActivityEventCategoryChild'},
        'subcategories': {'key': 'Subcategories', 'type': '[ActivityEventSubcategoryChild]'},
        'binds': {'key': 'Binds', 'type': '[ActivityEventBindChild]'},
        'fields': {'key': 'Fields', 'type': '[ActivityEventFieldEntryChild]'},
        'relationships': {'key': 'Relationships', 'type': '[ActivityEventRelationshipChild]'},
    }

    def __init__(self, **kwargs):
        super(ActivityEventResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.note = kwargs.get('note', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.activity_line_enabled = kwargs.get('activity_line_enabled', None)
        self.asset_card_enabled = kwargs.get('asset_card_enabled', None)
        self.document = kwargs.get('document', None)
        self.location = kwargs.get('location', None)
        self.category = kwargs.get('category', None)
        self.subcategories = kwargs.get('subcategories', None)
        self.binds = kwargs.get('binds', None)
        self.fields = kwargs.get('fields', None)
        self.relationships = kwargs.get('relationships', None)
