
# Document Fields.
document_fields = [
    'abstract',
    'action',
    'agencies',
    'agency_names',
    'body_html_url',
    'cfr_references',
    'citation',
    'comment_url',
    'comments_close_on',
    'correction_of',
    'corrections',
    'dates',
    'disposition_notes',
    'docket_id',
    'docket_ids',
    'document_number',
    'effective_on',
    'end_page',
    'excerpts',
    'executive_order_notes',
    'executive_order_number',
    'full_text_xml_url',
    'html_url',
    'images',
    'json_url',
    'mods_url',
    'page_length',
    'page_views',
    'pdf_url',
    'president',
    'presidential_document_number',
    'proclamation_number',
    'public_inspection_pdf_url',
    'publication_date',
    'raw_text_url',
    'regulation_id_number_info',
    'regulation_id_numbers',
    'regulations_dot_gov_info',
    'regulations_dot_gov_url',
    'significant',
    'signing_date',
    'start_page',
    'subtype',
    'title',
    'toc_doc',
    'toc_subject',
    'topics',
    'type',
    'volume'
]

# Publishing Agencies that we can search for.
publishing_agencies = [
    'administration-office-executive-office-of-the-president',
    'administrative-conference-of-the-united-states',
    'administrative-office-of-united-states-courts',
    'advisory-council-on-historic-preservation',
    'advocacy-and-outreach-office',
    'african-development-foundation',
    'agency-for-healthcare-research-and-quality',
    'agency-for-international-development',
    'agency-for-toxic-substances-and-disease-registry',
    'aging-administration',
    'agricultural-marketing-service',
    'agricultural-research-service',
    'agriculture-department',
    'air-force-department',
    'air-quality-national-commission',
    'air-transportation-stabilization-board',
    'alaska-power-administration',
    'alcohol-and-tobacco-tax-and-trade-bureau',
    'alcohol-tobacco-firearms-and-explosives-bureau',
    'american-battle-monuments-commission',
    'amtrak-reform-council',
    'animal-and-plant-health-inspection-service',
    'antitrust-division',
    'antitrust-modernization-commission',
    'appalachian-regional-commission',
    'appalachian-states-low-level-radioactive-waste-commission',
    'architect-of-the-capitol',
    'architectural-and-transportation-barriers-compliance-board',
    'arctic-research-commission',
    'armed-forces-retirement-home',
    'arms-control-and-disarmament-agency',
    'army-department',
    'assassination-records-review-board',
    'benefits-review-board',
    'bipartisan-commission-on-entitlement-and-tax-reform',
    'board-of-directors-of-the-hope-for-homeowners-program',
    'bonneville-power-administration',
    'broadcasting-board-of-governors',
    'bureau-of-the-fiscal-service',
    'census-bureau',
    'census-monitoring-board',
    'centers-for-disease-control-and-prevention',
    'centers-for-medicare-medicaid-services',
    'central-intelligence-agency',
    'chemical-safety-and-hazard-investigation-board',
    'child-support-enforcement-office',
    'children-and-families-administration',
    'christopher-columbus-quincentenary-jubilee-commission',
    'civil-rights-commission',
    'coast-guard',
    'commerce-department',
    'commercial-space-transportation-office',
    'commission-of-fine-arts',
    'commission-on-immigration-reform',
    'commission-on-protecting-and-reducing-government-secrecy',
    'commission-on-the-advancement-of-federal-law-enforcement',
    'commission-on-the-social-security-notch-issue',
    'committee-for-the-implementation-of-textile-agreements',
    'commodity-credit-corporation',
    'commodity-futures-trading-commission',
    'community-development-financial-institutions-fund',
    'community-living-administration',
    'competitiveness-policy-council',
    'comptroller-of-the-currency',
    'congressional-budget-office',
    'consumer-financial-protection-bureau',
    'consumer-product-safety-commission',
    'cooperative-state-research-education-and-extension-service',
    'copyright-office-library-of-congress',
    'copyright-royalty-board',
    'copyright-royalty-judges',
    'corporation-for-national-and-community-service',
    'council-of-the-inspectors-general-on-integrity-and-efficiency',
    'council-on-environmental-quality',
    'counsel-to-the-president',
    'crime-and-security-in-u-s-seaports-interagency-commission',
    'customs-service',
    'defense-acquisition-regulations-system',
    'defense-base-closure-and-realignment-commission',
    'defense-contract-audit-agency',
    'defense-criminal-investigative-service',
    'defense-department',
    'defense-information-systems-agency',
    'defense-intelligence-agency',
    'defense-investigative-service',
    'defense-logistics-agency',
    'defense-mapping-agency',
    'defense-nuclear-facilities-safety-board',
    'defense-special-weapons-agency',
    'delaware-river-basin-commission',
    'denali-commission',
    'disability-employment-policy-office',
    'drug-enforcement-administration',
    'economic-analysis-bureau',
    'economic-analysis-staff',
    'economic-development-administration',
    'economic-research-service',
    'economics-and-statistics-administration',
    'education-department',
    'election-assistance-commission',
    'electronic-commerce-advisory-commission',
    'emergency-oil-and-gas-guaranteed-loan-board',
    'emergency-steel-guarantee-loan-board',
    'employee-benefits-security-administration',
    'employees-compensation-appeals-board',
    'employment-and-training-administration',
    'employment-standards-administration',
    'energy-department',
    'energy-efficiency-and-renewable-energy-office',
    'energy-information-administration',
    'energy-policy-and-new-uses-office',
    'energy-research-office',
    'engineers-corps',
    'engraving-and-printing-bureau',
    'environment-office-energy-department',
    'environmental-protection-agency',
    'equal-employment-opportunity-commission',
    'executive-council-on-integrity-and-efficiency',
    'executive-office-for-immigration-review',
    'executive-office-of-the-president',
    'export-administration-bureau',
    'export-import-bank',
    'family-assistance-office',
    'farm-credit-administration',
    'farm-credit-system-insurance-corporation',
    'farm-service-agency',
    'federal-accounting-standards-advisory-board',
    'federal-acquisition-regulation-system',
    'federal-aviation-administration',
    'federal-bureau-of-investigation',
    'federal-communications-commission',
    'federal-contract-compliance-programs-office',
    'federal-council-on-the-arts-and-the-humanities',
    'federal-crop-insurance-corporation',
    'federal-deposit-insurance-corporation',
    'federal-election-commission',
    'federal-emergency-management-agency',
    'federal-energy-regulatory-commission',
    'federal-financial-institutions-examination-council',
    'federal-highway-administration',
    'federal-housing-enterprise-oversight-office',
    'federal-housing-finance-agency',
    'federal-housing-finance-board',
    'federal-labor-relations-authority',
    'federal-law-enforcement-training-center',
    'federal-maritime-commission',
    'federal-mediation-and-conciliation-service',
    'federal-mine-safety-and-health-review-commission',
    'federal-motor-carrier-safety-administration',
    'federal-pay-advisory-committee',
    'federal-permitting-improvement-steering-council',
    'federal-prison-industries',
    'federal-procurement-policy-office',
    'federal-railroad-administration',
    'federal-register-office',
    'federal-register-administrative-committee',
    'federal-reserve-system',
    'federal-retirement-thrift-investment-board',
    'federal-service-impasses-panel',
    'federal-trade-commission',
    'federal-transit-administration',
    'financial-crimes-enforcement-network',
    'financial-crisis-inquiry-commission',
    'financial-research-office',
    'financial-stability-oversight-council',
    'first-responder-network-authority',
    'fiscal-service',
    'fish-and-wildlife-service',
    'food-and-consumer-service',
    'food-and-drug-administration',
    'food-and-nutrition-service',
    'food-safety-and-inspection-service',
    'foreign-agricultural-service',
    'foreign-assets-control-office',
    'foreign-claims-settlement-commission',
    'foreign-service-grievance-board',
    'foreign-service-impasse-disputes-panel',
    'foreign-service-labor-relations-board',
    'foreign-trade-zones-board',
    'forest-service',
    'general-services-administration',
    'geographic-names-board',
    'geological-survey',
    'government-accountability-office',
    'government-ethics-office',
    'government-national-mortgage-association',
    'government-publishing-office',
    'grain-inspection-packers-and-stockyards-administration',
    'gulf-coast-ecosystem-restoration-council',
    'harry-s-truman-scholarship-foundation',
    'health-and-human-services-department',
    'health-care-finance-administration',
    'health-resources-and-services-administration',
    'hearings-and-appeals-office-energy-department',
    'hearings-and-appeals-office-interior-department',
    'homeland-security-department',
    'housing-and-urban-development-department',
    'immigration-and-naturalization-service',
    'indian-affairs-bureau',
    'indian-arts-and-crafts-board',
    'indian-health-service',
    'indian-trust-transition-office',
    'industry-and-security-bureau',
    'information-security-oversight-office',
    'inspector-general-office-agriculture-department',
    'inspector-general-office-health-and-human-services-department',
    'institute-of-museum-and-library-services',
    'inter-american-foundation',
    'interagency-floodplain-management-review-committee',
    'intergovernmental-relations-advisory-commission',
    'interior-department',
    'internal-revenue-service',
    'international-broadcasting-board',
    'international-development-cooperation-agency',
    'international-investment-office',
    'international-joint-commission-united-states-and-canada',
    'international-organizations-employees-loyalty-board',
    'international-trade-administration',
    'international-trade-commission',
    'interstate-commerce-commission',
    'investment-security-office',
    'james-madison-memorial-fellowship-foundation',
    'japan-united-states-friendship-commission',
    'joint-board-for-enrollment-of-actuaries',
    'judicial-conference-of-the-united-states',
    'judicial-review-commission-on-foreign-asset-control',
    'justice-department',
    'justice-programs-office',
    'juvenile-justice-and-delinquency-prevention-office',
    'labor-department',
    'labor-statistics-bureau',
    'labor-management-standards-office',
    'land-management-bureau',
    'legal-services-corporation',
    'library-of-congress',
    'local-television-loan-guarantee-board',
    'management-and-budget-office',
    'marine-mammal-commission',
    'maritime-administration',
    'medicare-payment-advisory-commission',
    'merit-systems-protection-board',
    'military-compensation-and-retirement-modernization-commission',
    'millennium-challenge-corporation',
    'mine-safety-and-health-administration',
    'minerals-management-service',
    'mines-bureau',
    'minority-business-development-agency',
    'minority-economic-impact-office',
    'mississippi-river-commission',
    'monetary-offices',
    'morris-k-udall-and-stewart-l-udall-foundation',
    'national-aeronautics-and-space-administration',
    'national-agricultural-library',
    'national-agricultural-statistics-service',
    'national-archives-and-records-administration',
    'national-assessment-governing-board',
    'national-bankruptcy-review-commission',
    'national-biological-service',
    'national-bipartisan-commission-on-future-of-medicare',
    'national-capital-planning-commission',
    'national-civilian-community-corps',
    'national-commission-on-fiscal-responsibility-and-reform',
    'national-commission-on-intermodal-transportation',
    'national-commission-on-libraries-and-information-science',
    'national-commission-on-manufactured-housing',
    'national-commission-on-military-national-and-public-service',
    'national-commission-on-the-cost-of-higher-education',
    'national-communications-system',
    'national-consumer-cooperative-bank',
    'national-council-on-disability',
    'national-counterintelligence-center',
    'national-credit-union-administration',
    'national-crime-prevention-and-privacy-compact-council',
    'national-economic-council',
    'national-education-goals-panel',
    'national-endowment-for-the-arts',
    'national-endowment-for-the-humanities',
    'national-foundation-on-the-arts-and-the-humanities',
    'national-gambling-impact-study-commission',
    'national-geospatial-intelligence-agency',
    'national-highway-traffic-safety-administration',
    'national-historical-publications-and-records-commission',
    'national-indian-gaming-commission',
    'national-institute-for-literacy',
    'national-institute-of-corrections',
    'national-institute-of-food-and-agriculture',
    'national-institute-of-justice',
    'national-institute-of-standards-and-technology',
    'national-institutes-of-health',
    'national-intelligence-office-of-the-national-director',
    'national-labor-relations-board',
    'national-library-of-medicine',
    'national-mediation-board',
    'national-nanotechnology-coordination-office',
    'national-nuclear-security-administration',
    'national-oceanic-and-atmospheric-administration',
    'national-park-service',
    'national-partnership-for-reinventing-government',
    'national-prison-rape-elimination-commission',
    'national-railroad-passenger-corporation',
    'national-science-foundation',
    'national-security-agency-central-security-service',
    'national-security-commission-on-artificial-intelligence',
    'national-security-council',
    'national-shipping-authority',
    'national-skill-standards-board',
    'national-technical-information-service',
    'national-telecommunications-and-information-administration',
    'national-transportation-safety-board',
    'national-women-s-business-council',
    'natural-resources-conservation-service',
    'natural-resources-revenue-office',
    'navajo-and-hopi-indian-relocation-office',
    'navy-department',
    'neighborhood-reinvestment-corporation',
    'northeast-dairy-compact-commission',
    'northeast-interstate-low-level-radioactive-waste-commission',
    'nuclear-energy-office',
    'nuclear-regulatory-commission',
    'nuclear-waste-technical-review-board',
    'occupational-safety-and-health-administration',
    'occupational-safety-and-health-review-commission',
    'ocean-energy-management-bureau',
    'ocean-energy-management-regulation-and-enforcement-bureau',
    'ocean-policy-commission',
    'office-of-government-information-services',
    'office-of-motor-carrier-safety',
    'office-of-national-drug-control-policy',
    'office-of-policy-development',
    'office-of-the-chief-financial-officer-agriculture-department',
    'oklahoma-city-national-memorial-trust',
    'operations-office',
    'ounce-of-prevention-council',
    'overseas-private-investment-corporation',
    'panama-canal-commission',
    'parole-commission',
    'partnerships-and-public-engagement-office',
    'patent-and-trademark-office',
    'peace-corps',
    'pension-and-welfare-benefits-administration',
    'pension-benefit-guaranty-corporation',
    'personnel-management-office',
    'physician-payment-review-commission',
    'pipeline-and-hazardous-materials-safety-administration',
    'postal-rate-commission',
    'postal-regulatory-commission',
    'postal-service',
    'president-s-council-on-integrity-and-efficiency',
    'president-s-council-on-sustainable-development',
    'president-s-critical-infrastructure-protection-board',
    'president-s-economic-policy-advisory-board',
    'presidential-documents',
    'presidio-trust',
    'prisons-bureau',
    'privacy-and-civil-liberties-oversight-board',
    'procurement-and-property-management-office-of',
    'program-support-center',
    'prospective-payment-assessment-commission',
    'public-buildings-reform-board',
    'public-debt-bureau',
    'public-health-service',
    'railroad-retirement-board',
    'reagan-udall-foundation-for-the-food-and-drug-administration',
    'reclamation-bureau',
    'recovery-accountability-and-transparency-board',
    'refugee-resettlement-office',
    'regulatory-information-service-center',
    'research-and-innovative-technology-administration',
    'research-and-special-programs-administration',
    'resolution-trust-corporation',
    'risk-management-agency',
    'rural-business-cooperative-service',
    'rural-housing-and-community-development-service',
    'rural-housing-service',
    'rural-telephone-bank',
    'rural-utilities-service',
    'safety-and-environmental-enforcement-bureau',
    'saint-lawrence-seaway-development-corporation',
    'science-and-technology-policy-office',
    'secret-service',
    'securities-and-exchange-commission',
    'selective-service-system',
    'small-business-administration',
    'smithsonian-institution',
    'social-security-administration',
    'southeastern-power-administration',
    'southwestern-power-administration',
    'special-counsel-office',
    'special-inspector-general-for-afghanistan-reconstruction',
    'special-inspector-general-for-iraq-reconstruction',
    'special-trustee-for-american-indians-office',
    'state-department',
    'state-justice-institute',
    'substance-abuse-and-mental-health-services-administration',
    'surface-mining-reclamation-and-enforcement-office',
    'surface-transportation-board',
    'susquehanna-river-basin-commission',
    'technology-administration',
    'tennessee-valley-authority',
    'the-white-house-office',
    'thrift-depositor-protection-oversight-board',
    'thrift-supervision-office',
    'trade-and-development-agency',
    'trade-representative-office-of-united-states',
    'transportation-department',
    'transportation-office',
    'transportation-security-administration',
    'transportation-statistics-bureau',
    'travel-and-tourism-administration',
    'treasury-department',
    'twenty-first-century-workforce-commission',
    'u-s-citizenship-and-immigration-services',
    'us-codex-office',
    'u-s-customs-and-border-protection',
    'u-s-house-of-representatives',
    'u-s-immigration-and-customs-enforcement',
    'u-s-international-development-finance-corporation',
    'u-s-trade-deficit-review-commission',
    'u-s-china-economic-and-security-review-commission',
    'under-secretary-for-economic-affairs',
    'unified-carrier-registration-plan',
    'uniformed-services-university-of-the-health-sciences',
    'united-states-enrichment-corporation',
    'united-states-information-agency',
    'united-states-institute-of-peace',
    'united-states-marshals-service',
    'united-states-mint',
    'united-states-sentencing-commission',
    'utah-reclamation-mitigation-and-conservation-commission',
    'valles-caldera-trust',
    'veterans-affairs-department',
    'veterans-employment-and-training-service',
    'victims-of-crime-office',
    'wage-and-hour-division',
    'western-area-power-administration',
    'women-s-business-enterprise-interagency-committee',
    'women-s-progress-commemoration-commission',
    'women-s-suffrage-centennial-commission',
    'workers-compensation-programs-office',
]

# Section IDs used to query documents.
section_ids = [
    'business-and-industry',
    'environment',
    'health-and-public-welfare',
    'money,science-and-technology',
    'world'
]

# For the Suggested Search/Slug
search_slugs_id = [
    "accountable-care-organizations",
    "agricultural-grades-and-standards",
    "air-travel",
    "airspace-classifications",
    "airworthiness-directives",
    "americans-with-disabilities-act",
    "animal-drugs",
    "arms-sales-notifications",
    "automated-commercial-environment-ace-",
    "automobile-safety-fuel-economy",
    "bank-secrecy-financial-crime-",
    "broadband-policy",
    "clean-air-act-state-implementation-plans",
    "climate-change",
    "clinical-laboratory-improvement-program",
    "commodity-promotion-agricultural-marketing",
    "community-right-to-know",
    "continuation-of-health-benefits-cobra-",
    "controlled-exports-ccl-usml-",
    "controlled-substances",
    "crop-insurance",
    "cultural-objects-imported-for-exhibition",
    "defense-federal-acquisition-regulation-supplement-dfars-",
    "denied-persons-specially-designated-nationals",
    "disaster-declarations-assistance",
    "dodd-frank-wall-steet-reform",
    "economic-sanctions-foreign-assets-control",
    "education-department-grants-funding",
    "education-initiatives",
    "electronic-health-information-technology",
    "endangered-threatened-species",
    "energy-department-grants-funding",
    "energy-efficiency-renewable-resources",
    "federal-property-management",
    "federal-travel-regulations",
    "fishery-management",
    "food-safety",
    "food-substances-generally-recognized-as-safe",
    "government-contracts",
    "health-and-human-services-grants-funding",
    "health-care-reform",
    "housing-and-urban-development-department-grants-funding",
    "immigration-border-control",
    "information-collection-notices",
    "international-trade-anti-dumping-",
    "meaningful-use-of-electronic-health-records",
    "medical-devices",
    "medical-privacy-hipaa-",
    "medicare-medicaid-and-schip-payments",
    "migratory-bird-protection",
    "milk-marketing-orders",
    "national-environmental-policy-act",
    "national-register-of-historic-places",
    "native-american-remains-and-funerary-objects",
    "navigation-areas-safety-and-security-zones",
    "north-american-free-trade-agreement-nafta-",
    "nutrition-assistance-programs",
    "oil-hazardous-substances-pollution-response",
    "oil-and-gas-leasing",
    "outer-continental-shelf",
    "parks-recreation",
    "patent-trademark-and-copyright",
    "pesticide-tolerances",
    "pipeline-safety",
    "plant-protection-and-quarantine-",
    "ports-of-entry",
    "prevailing-rate-systems",
    "preventing-collisions-at-sea-72-colregs-",
    "privacy-act-notices-regs",
    "product-safety",
    "public-land-orders",
    "quarterly-publication-of-individuals-who-have-chosen-to-expatriate",
    "radio-television-broadcasting-services",
    "regulatory-management-publication",
    "resource-conservation-and-recovery-act-rcra-",
    "sentencing-guidelines",
    "social-security-rulings-and-acquiescence-rulings",
    "standard-instrument-approach-procedures",
    "state-hazardous-waste-management-program",
    "stock-commodities-trading-",
    "student-financial-aid",
    "taking-of-marine-mammals",
    "technical-barriers-to-trade-tbt-sps-agreements-",
    "toxic-substances-control",
    "trade-adjustment-assistance",
    "transparency-open-government",
    "truth-in-lending-regulation-z-",
    "underground-storage-tank-program",
    "veterans-disability-ratings-claims",
    "veterans-educational-benefits",
    "veterans-employment-training",
    "veterinary-biologics-animal-disease",
    "voting-elections"
]

# Order Fields for document searches.
order_fields = [
    "relevance",
    "newest",
    "oldest",
    "executive_order_number"
]

# Document Types for document searches.
document_types = [
    "--",
    "RULE",
    "PRORULE",
    "NOTICE",
    "PRESDOCU"
]

# Presidential Document Types for document searches.
presidential_document_types = [
    "determination",
    "executive_order",
    "memorandum",
    "notice",
    "proclamation",
    "presidential_order"
]

# Presidents for document searches.
presidents = [
    "william-j-clinton",
    "george-w-bush",
    "barack-obama",
    "donald-trump"
]

# Topic IDs that you can use to query documents.
topic_ids = [
    "accountants",
    "accounting",
    "acid-rain",
    "acreage-allotments",
    "actuaries-joint-board-enrollment",
    "adhesives",
    "administration-office-executive-office-president",
    "administrative-practice-procedure",
    "adoption-foster-care",
    "adult-education",
    "advertising",
    "advisory-committees",
    "afghanistan",
    "african-development-bank",
    "african-development-foundation",
    "aged",
    "agency-international-development",
    "agricultural-commodities",
    "agricultural-marketing-service",
    "agricultural-research",
    "agricultural-research-service",
    "agriculture",
    "agriculture-department",
    "aid-families-with-dependent-children",
    "air-carriers",
    "air-force-department",
    "air-pollution-control",
    "air-rates-fares",
    "air-taxis",
    "air-traffic-control",
    "air-traffic-controllers",
    "air-transportation",
    "air-transportation-stabilization-board",
    "aircraft",
    "airmen",
    "airports",
    "airspace",
    "alaska",
    "alcohol-abuse",
    "alcohol-alcoholic-beverages",
    "alcohol-tobacco-tax-trade-bureau",
    "alcohol-tobacco-firearms-explosives-bureau",
    "alcoholism",
    "alien-property",
    "aliens",
    "alimony",
    "almonds",
    "aluminum",
    "american-battle-monuments-commission",
    "american-samoa",
    "ammonium-sulfate-plants",
    "anchorage-grounds",
    "animal-plant-health-inspection-service",
    "animal-biologics",
    "animal-diseases",
    "animal-drugs",
    "animal-feeds",
    "animal-foods",
    "animal-welfare",
    "animals",
    "antarctica",
    "antidumping",
    "antitrust",
    "appalachia",
    "appalachian-regional-commission",
    "apples",
    "apricots",
    "aquatic-plant-control",
    "architectural-transportation-barriers-compliance-board",
    "archives-records",
    "arctic-research-commission",
    "armed-forces",
    "armed-forces-reserves",
    "armed-forces-retirement-home",
    "arms-munitions",
    "army-department",
    "arsenic",
    "arson",
    "arts-crafts",
    "asbestos",
    "asian-development-bank",
    "australia",
    "authority-delegations-government-agencies",
    "aviation-safety",
    "avocados",
    "bakery-products",
    "bank-deposit-insurance",
    "bankruptcy",
    "banks-banking",
    "barley",
    "batteries",
    "beans",
    "beer",
    "bees",
    "benefits-review-board-labor-department",
    "benzene",
    "beryllium",
    "beverages",
    "bicycles",
    "bilingual-education",
    "biologics",
    "bison",
    "black-lung-benefits",
    "blind",
    "blind-or-severely-disabled-committee-purchase-from-people-who-are",
    "blocking-assets",
    "blood",
    "blood-diseases",
    "blueberries",
    "bonds",
    "bottled-water",
    "boycotts",
    "bridges",
    "broadband",
    "broadcasting-board-governors",
    "brokers",
    "buildings-facilities",
    "bunk-beds",
    "burma",
    "buses",
    "business-industry",
    "cable-television",
    "cacao-products",
    "cambodia",
    "campaign-funds",
    "canada",
    "cancer",
    "carbon-dioxide",
    "carbon-industry",
    "carbon-monoxide",
    "cargo-vessels",
    "caribbean-basin-initiative",
    "carpets-rugs",
    "carpools",
    "cattle",
    "cement-industry",
    "cemeteries",
    "census-bureau",
    "census-data",
    "centers-medicare-medicaid-services",
    "central-intelligence-agency",
    "cereals-food",
    "cervids",
    "chaplains",
    "charitable-contributions",
    "charter-flights",
    "cheese",
    "chemical-safety-hazard-investigation-board",
    "chemicals",
    "cherries",
    "child-labor",
    "child-support",
    "child-support-enforcement-office",
    "child-welfare",
    "china",
    "cigarette-lighters",
    "cigars-cigarettes",
    "citizenship-naturalization",
    "citrus-fruits",
    "civil-defense",
    "civil-disorders",
    "civil-rights",
    "civil-rights-commission",
    "claims",
    "classified-information",
    "clemency",
    "clothing",
    "coal",
    "coast-guard",
    "coastal-zone",
    "code-federal-regulations",
    "coffee",
    "coil-coating-industry",
    "colleges-universities",
    "color-additives",
    "commerce-department",
    "commodity-credit-corporation",
    "commodity-futures",
    "commodity-futures-trading-commission",
    "common-carriers",
    "communicable-diseases",
    "communications",
    "communications-common-carriers",
    "communications-equipment",
    "community-action-programs",
    "community-development",
    "community-development-block-grants",
    "community-development-financial-institutions-fund",
    "community-services-office",
    "comptroller-currency",
    "computer-technology",
    "concessions",
    "condominiums",
    "conduct-standards",
    "confidential-business-information",
    "conflict-interests",
    "conscientious-objectors",
    "construction-industry",
    "construction-industry-collective-bargaining-commission",
    "consumer-product-safety-commission",
    "consumer-protection",
    "continental-shelf",
    "cooperative-state-research-education-extension-service",
    "cooperatives",
    "copper",
    "copyright",
    "copyright-office-library-congress",
    "copyright-royalty-board",
    "corn",
    "corporation-national-community-service",
    "cosmetics",
    "board",
    "cotton",
    "cottonseeds",
    "counterfeiting",
    "countervailing-duties",
    "court-services-offender-supervision-agency-district-columbia",
    "courts",
    "cranberries",
    "cream",
    "credit",
    "credit-unions",
    "cribs-bassinets",
    "crime",
    "crop-insurance",
    "cuba",
    "cultural-exchange-programs",
    "currency",
    "customs-border-protection-bureau",
    "customs-duties-inspection",
    "dairy-products",
    "dams",
    "dates",
    "day-care",
    "decorations-medals-awards",
    "defense-communications",
    "defense-department",
    "defense-logistics-agency",
    "defense-nuclear-facilities-safety-board",
    "delaware-river-basin-commission",
    "denmark",
    "dental-health",
    "diamonds",
    "dibenzo-para-dioxins-dibenzofurans",
    "dietary-foods",
    "disability-benefits",
    "disaster-assistance",
    "district-columbia",
    "diving",
    "domestic-violence",
    "drug-abuse",
    "drug-enforcement-administration",
    "drug-testing",
    "drug-traffic-control",
    "drugs",
    "dry-cleaners",
    "east-west-foreign-trade-board",
    "economic-analysis-bureau",
    "economic-development-administration",
    "economic-statistics",
    "ecuador",
    "education",
    "education-department",
    "education-disadvantaged",
    "education-individuals-with-disabilities",
    "educational-facilities",
    "educational-research",
    "educational-study-programs",
    "eggs-egg-products",
    "elections",
    "electric-power",
    "electric-power-plants",
    "electric-power-rates",
    "electric-utilities",
    "electronic-funds-transfers",
    "electronic-products",
    "electroplating",
    "elementary-secondary-education",
    "emergency-medical-services",
    "emergency-oil-gas-guaranteed-loan-board",
    "emergency-powers",
    "emergency-steel-guarantee-loan-board",
    "employee-benefit-plans",
    "employee-benefits-security-administration",
    "employees-compensation-appeals-board",
    "employment",
    "employment-training-administration",
    "employment-policy-national-commission",
    "employment-standards-administration",
    "employment-taxes",
    "endangered-threatened-species",
    "endangered-species-committee",
    "energy",
    "energy-conservation",
    "energy-department",
    "engineers",
    "engineers-corps",
    "engraving-printing-bureau",
    "environmental-impact-statements",
    "environmental-protection",
    "environmental-protection-agency",
    "environmental-quality-council",
    "equal-access-justice",
    "equal-educational-opportunity",
    "equal-employment-opportunity",
    "equal-employment-opportunity-commission",
    "estate-taxes",
    "estates",
    "ethics",
    "ethiopia",
    "european-bank-reconstruction-development",
    "excise-taxes",
    "executive-office-president",
    "executive-orders",
    "explosives",
    "export-import-bank",
    "exports",
    "fair-housing",
    "fairs-expositions",
    "family-assistance-office",
    "family-planning",
    "family-planning-miscellaneous-regulations",
    "farm-credit-administration",
    "farm-credit-system-insurance-corporation",
    "farm-service-agency",
    "federal-aviation-administration",
    "federal-buildings-facilities",
    "federal-communications-commission",
    "federal-contract-compliance-programs-office",
    "federal-crop-insurance-corporation",
    "federal-deposit-insurance-corporation",
    "federal-election-commission",
    "federal-emergency-management-agency",
    "federal-energy-regulatory-commission",
    "federal-financial-institutions-examination-council",
    "federal-financing-bank",
    "federal-highway-administration",
    "federal-home-loan-banks",
    "federal-home-loan-mortgage-corporation",
    "federal-housing-finance-board",
    "federal-labor-relations-authority",
    "federal-law-enforcement-training-center",
    "federal-maritime-commission",
    "federal-mediation-conciliation-service",
    "federal-mine-safety-health-review-commission",
    "federal-motor-carrier-safety-administration",
    "federal-national-mortgage-association",
    "federal-open-market-committee",
    "federal-prison-industries",
    "federal-procurement-policy-office-cost-accounting-standards-board",
    "federal-railroad-administration",
    "federal-register",
    "federal-register-administrative-committee",
    "federal-register-office",
    "federal-reserve-system",
    "federal-retirement-thrift-investment-board",
    "federal-service-impasses-panel",
    "federal-trade-commission",
    "federal-transit-administration",
    "federally-affected-areas",
    "feed-grains",
    "feedlots",
    "fertilizers",
    "filberts",
    "fine-arts-commission",
    "fire-prevention",
    "firefighters",
    "fireworks",
    "fiscal-service",
    "fish",
    "fish-wildlife-service",
    "fisheries",
    "fishing",
    "fishing-vessels",
    "flags",
    "flammable-materials",
    "flood-control",
    "flood-insurance",
    "flood-plains",
    "fluoride",
    "food-additives",
    "food-drug-administration",
    "food-nutrition-service",
    "food-assistance-programs",
    "food-grades-standards",
    "food-labeling",
    "food-packaging",
    "food-safety-inspection-service",
    "food-stamps",
    "foods",
    "foreign-agricultural-service",
    "foreign-aid",
    "foreign-assets-control-office",
    "foreign-banking",
    "foreign-claims",
    "foreign-claims-settlement-commission",
    "foreign-currencies",
    "foreign-exchange",
    "foreign-investments-united-states",
    "foreign-officials",
    "foreign-relations",
    "foreign-service",
    "foreign-service-impasse-disputes-panel",
    "foreign-service-labor-relations-board",
    "foreign-trade",
    "foreign-trade-zones",
    "foreign-trade-zones-board",
    "forest-service",
    "forests-forest-products",
    "forgery",
    "foundations",
    "four-h-club",
    "france",
    "fraud",
    "freedom-information",
    "freight",
    "freight-forwarders",
    "frozen-foods",
    "fruit-juices",
    "fruits",
    "fuel-additives",
    "fuel-economy",
    "funeral-industry",
    "furniture-industry",
    "furs",
    "gambling",
    "gases",
    "gasohol",
    "gasoline",
    "general-accountability-office",
    "general-services-administration",
    "genetic-diseases",
    "geological-survey",
    "geothermal-energy",
    "gift-taxes",
    "glass-glass-products",
    "goats",
    "gold",
    "government-contracts",
    "government-employees",
    "government-ethics-office",
    "government-procurement",
    "government-property",
    "government-property-management",
    "government-publications",
    "government-securities",
    "grain-inspection-packers-stockyards-administration",
    "grains",
    "grant-administrations",
    "grant-programs",
    "grant-programs-agriculture",
    "grant-programs-business",
    "grant-programs-communications",
    "grant-programs-education",
    "grant-programs-energy",
    "grant-programs-environmental-protection",
    "grant-programs-foreign-relations",
    "grant-programs-health",
    "grant-programs-housing-community-development",
    "grant-programs-indians",
    "grant-programs-labor",
    "grant-programs-law",
    "grant-programs-national-defense",
    "grant-programs-natural-resources",
    "grant-programs-recreation",
    "grant-programs-science-technology",
    "grant-programs-social-programs",
    "grant-programs-transportation",
    "grant-programs-veterans",
    "grapefruit",
    "grapes",
    "graphic-arts-industry",
    "grazing-lands",
    "great-lakes",
    "guam",
    "guantanamo-bay-naval-station-cuba",
    "haiti",
    "harbors",
    "harry-truman-scholarship-foundation",
    "hawaiian-natives",
    "hay",
    "hazardous-materials-transportation",
    "hazardous-substances",
    "hazardous-waste",
    "hazelnuts",
    "health",
    "health-human-services-department",
    "health-care",
    "health-facilities",
    "health-insurance",
    "health-maintenance-organizations-hmo",
    "health-professions",
    "health-records",
    "health-statistics",
    "heart-diseases",
    "heaters",
    "helium",
    "highway-safety",
    "highways-roads",
    "historic-preservation",
    "historic-preservation-advisory-council",
    "historical-records",
    "hiv-aids",
    "hobbies",
    "hogs",
    "holding-companies",
    "holidays",
    "home-improvement",
    "homeland-security-department",
    "homeless",
    "homesteads",
    "homeworkers",
    "honey",
    "horses",
    "hospice-care",
    "hospitals",
    "hostages",
    "household-appliances",
    "housing",
    "housing-urban-development-department",
    "housing-standards",
    "human-cells-tissue-based-products",
    "human-development-services-office",
    "human-research-subjects",
    "humanitarian-aid",
    "hunting",
    "hydrocarbons",
    "ice-cream",
    "immigration",
    "immigration-naturalization",
    "immigration-review-executive-office",
    "immunization",
    "imports",
    "income-taxes",
    "indemnity-payments",
    "independent-counsel-office",
    "indian-affairs-bureau",
    "indian-arts-crafts-board",
    "indian-health-service",
    "indians",
    "indians-arts-crafts",
    "indians-business-finance",
    "indians-claims",
    "indians-education",
    "indians-enrollment",
    "indians-judgment-funds",
    "indians-lands",
    "indians-law",
    "indians-tribal-government",
    "individuals-with-disabilities",
    "industry-security-bureau",
    "information-security-oversight-office",
    "ink-industry",
    "inspector-general-office-health-human-services-department",
    "insulation",
    "insurance",
    "insurance-companies",
    "inter-american-development-bank",
    "inter-american-foundation",
    "intergovernmental-relations",
    "interior-department",
    "intermodal-transportation",
    "internal-revenue-service",
    "international-bank-reconstruction-development",
    "international-boundaries",
    "international-boundary-water-commission-u-mexico",
    "international-development-cooperation-agency",
    "international-finance-corporation",
    "international-investment-office",
    "international-joint-commission-u-canada",
    "international-organizations",
    "international-organizations-employees-loyalty-board",
    "international-trade-administration",
    "international-trade-commission",
    "inventions-patents",
    "investigations",
    "investment-companies",
    "investments",
    "iran",
    "iraq",
    "ireland",
    "iron",
    "irrigation",
    "israel",
    "james-madison-memorial-fellowship-foundation",
    "japan",
    "japan-united-states-friendship-commission",
    "job-corps",
    "john-f-kennedy-center-performing-arts",
    "jukeboxes",
    "justice-department",
    "juvenile-delinquency",
    "kidney-diseases",
    "kingman-reef",
    "kiwifruit",
    "korea-democratic-peoples-republic",
    "kuwait",
    "labeling",
    "labor",
    "labor-department",
    "labor-management-relations",
    "labor-management-standards-office",
    "labor-unions",
    "laboratories",
    "land-management-bureau",
    "land-sales",
    "lasers",
    "law",
    "law-enforcement",
    "law-enforcement-officers",
    "lawn-darts",
    "lawn-mowers",
    "lawyers",
    "lead",
    "lead-poisoning",
    "leather-leather-products-industry",
    "lebanon",
    "legal-services",
    "legal-services-corporation",
    "leprosy-hansen-disease",
    "liberia",
    "libraries",
    "libraries-information-science-national-commission",
    "library-congress",
    "libya",
    "lie-detector-tests",
    "life-insurance",
    "lighthouse-service",
    "lime",
    "limes",
    "liquors",
    "literary-works",
    "livestock",
    "loan-programs",
    "loan-programs-agriculture",
    "loan-programs-business",
    "loan-programs-communications",
    "loan-programs-education",
    "loan-programs-energy",
    "loan-programs-foreign-relations",
    "loan-programs-health",
    "loan-programs-housing-community-development",
    "loan-programs-indians",
    "loan-programs-national-defense",
    "loan-programs-natural-resources",
    "loan-programs-social-programs",
    "loan-programs-transportation",
    "loan-programs-veterans",
    "lobbying",
    "local-television-loan-guarantee-board",
    "longshore-harbor-workers",
    "lotteries",
    "low-moderate-income-housing",
    "lung-diseases",
    "management-budget-office",
    "mango",
    "manpower",
    "manpower-training-programs",
    "manufactured-homes",
    "margarine",
    "marihuana",
    "marine-mammal-commission",
    "marine-resources",
    "marine-safety",
    "marital-status-discrimination",
    "maritime-administration",
    "maritime-carriers",
    "maritime-security",
    "marketing-agreements",
    "marketing-quotas",
    "mass-transportation",
    "matchbooks",
    "maternal-child-health",
    "mattresses-mattress-pads",
    "measurement-standards",
    "meat-meat-products",
    "meat-inspection",
    "medicaid",
    "medical-dental-schools",
    "medical-assistance-program",
    "medical-devices",
    "medical-research",
    "medicare",
    "melons",
    "memorandums-presidential",
    "memorials",
    "mental-health-programs",
    "mercury",
    "merit-systems-protection-board",
    "metallic-nonmetallic-mineral-processing-plants",
    "metals",
    "metalworking-fluids",
    "methadone",
    "methane",
    "metric-system",
    "mexico",
    "micrographics",
    "micronesian-status-negotiations-office",
    "microwave-ovens",
    "midway-islands",
    "migrant-labor",
    "military-academies",
    "military-air-transportation",
    "military-law",
    "military-personnel",
    "milk",
    "milk-marketing-orders",
    "millenium-challenge-corporation",
    "mine-safety-health",
    "mine-safety-health-administration",
    "mineral-resources",
    "mineral-royalties",
    "minerals-management-service",
    "miners",
    "mines",
    "minimum-wages",
    "minority-business-development-agency",
    "minority-businesses",
    "mississippi-river",
    "mohair",
    "money-orders",
    "monuments-memorials",
    "morris-k-udall-scholarship-excellence-national-environmental-policy-foundation",
    "mortgage-insurance",
    "mortgages",
    "motion-pictures",
    "motor-carriers",
    "motor-vehicle-pollution",
    "motor-vehicle-safety",
    "motor-vehicles",
    "moving-household-goods",
    "multi-purpose-lighters",
    "museums",
    "mushrooms",
    "music",
    "national-aeronautics-space-administration",
    "national-arboretum",
    "national-archives-records-administration",
    "national-banks",
    "national-capital-planning-commission",
    "national-council-disability",
    "national-counterintelligence-center",
    "national-credit-union-administration",
    "national-crime-prevention-privacy-compact-council",
    "national-defense",
    "national-drug-control-policy-office",
    "national-forests",
    "national-foundation-arts-humanities",
    "national-gallery-art",
    "national-grasslands",
    "national-highway-traffic-safety-administration",
    "national-indian-gaming-commission",
    "national-institute-literacy",
    "national-institute-standards-technology",
    "national-intelligence-office-director",
    "national-labor-relations-board",
    "national-mediation-board",
    "national-ocean-survey",
    "national-oceanic-atmospheric-administration",
    "national-park-service",
    "national-parks",
    "national-railroad-adjustment-board",
    "national-railroad-passenger-corporation-amtrak",
    "national-science-foundation",
    "national-security-agency-central-security-service",
    "national-security-council",
    "national-telecommunications-information-administration",
    "national-trails-system",
    "national-transportation-safety-board",
    "national-wild-scenic-rivers-system",
    "national-zoological-park",
    "natural-gas",
    "natural-resources",
    "natural-resources-conservation-service",
    "navajo-hopi-indian-relocation-office",
    "navigation-air",
    "navigation-water",
    "navy-department",
    "nectarines",
    "neighborhood-reinvestment-corporation",
    "new-investment",
    "news-media",
    "newspapers-magazines",
    "nicaragua",
    "nitric-acid-plants",
    "nitrogen-dioxide",
    "nitrogen-oxides",
    "noise-control",
    "nonprofit-organizations",
    "northeast-interstate-low-level-radioactive-waste-commission",
    "northern-mariana-islands",
    "nuclear-energy",
    "nuclear-materials",
    "nuclear-power-plants-reactors",
    "nuclear-regulatory-commission",
    "nuclear-vessels",
    "nuclear-waste-technical-review-board",
    "nursery-stock",
    "nursing-homes",
    "nutrition",
    "nuts",
    "oats",
    "occupational-safety-health",
    "occupational-safety-health-administration",
    "occupational-safety-health-review-commission",
    "oceanographic-research-vessels",
    "oil-gas-exploration",
    "oil-gas-reserves",
    "oil-imports",
    "oil-pollution",
    "oils-fats",
    "oilseeds",
    "oklahoma-city-national-memorial-trust",
    "old-age-survivors-disability-insurance",
    "olives",
    "onions",
    "ophthalmic-goods-services",
    "oranges",
    "organization-functions-government-agencies",
    "over-counter-drugs",
    "overseas-private-investment-corporation",
    "ozone",
    "pacific-islands-trust-territory",
    "packaging-containers",
    "paint-industry",
    "paper-paper-products-industry",
    "parking",
    "particulate-matter",
    "passenger-vessels",
    "passports-visas",
    "patent-trademark-office-u",
    "paving-roofing-materials",
    "peace-corps",
    "peaches",
    "peanuts",
    "pears",
    "peer-review-organizations-pro",
    "penalties",
    "pennsylvania-avenue-development-corporation",
    "pension-benefit-guaranty-corporation",
    "pension-insurance",
    "personnel-management-office",
    "petroleum",
    "petroleum-allocation",
    "petroleum-price-regulations",
    "pets",
    "philippines",
    "phosphate",
    "photographic-industry",
    "pipeline-hazardous-materials-safety-administration-transportation-department",
    "pipeline-safety",
    "pipelines",
    "pistachios",
    "plant-diseases-pests",
    "plants",
    "plastics-materials-synthetics",
    "plums",
    "plutonium",
    "poison-prevention",
    "political-activities-government-employees",
    "political-affiliation-discrimination",
    "political-candidates",
    "political-committees-parties",
    "polychlorinated-biphenyls-pcb",
    "polymers",
    "popcorn",
    "porcelain-enameling-industry",
    "postal-rate-commission",
    "postal-regulatory-commission",
    "postal-service",
    "potassium",
    "potatoes",
    "poultry-poultry-products",
    "prescription-drugs",
    "presidential-documents",
    "presidio-trust",
    "price-controls",
    "price-support-programs",
    "printing",
    "prisoners",
    "prisoners-war",
    "prisons",
    "prisons-bureau",
    "privacy",
    "private-schools",
    "probation-parole",
    "proclamations",
    "prunes",
    "public-assistance-programs",
    "public-health",
    "public-health-service",
    "public-housing",
    "public-lands",
    "public-lands-classification",
    "public-lands-grants",
    "public-lands-mineral-resources",
    "public-lands-rights-way",
    "public-lands-sale",
    "public-lands-withdrawal",
    "public-papers-presidents-united-states",
    "puerto-rico",
    "quarantine",
    "rabbits-rabbit-products",
    "radiation-protection",
    "radio",
    "radioactive-materials",
    "radionuclides",
    "radon",
    "railroad-employees",
    "railroad-retirement",
    "railroad-retirement-board",
    "railroad-safety",
    "railroad-unemployment-insurance",
    "railroads",
    "raisins",
    "range-management",
    "real-property-acquisition",
    "reclamation",
    "reclamation-bureau",
    "recordings",
    "recycling",
    "red-cross",
    "refrigerators",
    "refugee-resettlement-office",
    "refugees",
    "refuse-bins",
    "reindeer",
    "religious-discrimination",
    "relocation-assistance",
    "rent-subsidies",
    "reporting-recordkeeping-requirements",
    "research",
    "reservoirs",
    "retirement",
    "revenue-sharing",
    "rice",
    "rights-way",
    "rivers",
    "rubber-rubber-products",
    "rural-areas",
    "rural-business-cooperative-service",
    "rural-housing-service",
    "rural-telephone-bank",
    "rural-utilities-service",
    "russian-federation",
    "safety",
    "saint-lawrence-seaway-development-corporation",
    "satellites",
    "savings-associations",
    "scholarships-fellowships",
    "school-breakfast-lunch-programs",
    "school-construction",
    "schools",
    "science-technology",
    "science-technology-policy-office",
    "scientific-equipment",
    "scientists",
    "seafood",
    "seals-insignia",
    "seamen",
    "search-warrants",
    "seashores",
    "secret-service",
    "securities",
    "securities-exchange-commission",
    "security-measures",
    "seeds",
    "seismic-safety",
    "seizures-forfeitures",
    "selective-service-system",
    "semiconductor-chip-products",
    "services",
    "sewage-disposal",
    "sex-discrimination",
    "sheep",
    "shoes",
    "signs-symbols",
    "silk",
    "silver",
    "small-business-administration",
    "small-businesses",
    "smallpox",
    "smithsonian-institution",
    "smoking",
    "soap-detergent-industry",
    "social-security",
    "social-security-administration",
    "sodium",
    "soil-conservation",
    "solar-energy",
    "solar-energy-energy-conservation-bank",
    "sorghum",
    "soybeans",
    "space-transportation-exploration",
    "spearmint-oil",
    "special-counsel-office",
    "specially-designated-nationals",
    "spices-flavorings",
    "sporting-goods",
    "sports",
    "spray-cans",
    "state-local-governments",
    "state-department",
    "statistics",
    "steel",
    "stills",
    "stocks",
    "stockyards",
    "strategic-critical-materials",
    "straw",
    "student-aid",
    "student-loan-marketing-association-sallie-mae",
    "students",
    "sudan",
    "sugar",
    "sulfur",
    "sulfur-oxides",
    "sulfuric-acid-plants",
    "sunshine-act",
    "superfund",
    "supplemental-security-income-ssi",
    "surety-bonds",
    "surface-mining",
    "surface-mining-reclamation-appeals-board",
    "surface-mining-reclamation-enforcement-office",
    "surface-transportation-board",
    "surplus-government-property",
    "susquehanna-river-basin-commission",
    "swimming-pool-slides",
    "swine-flu-immunization-program",
    "switzerland",
    "tangelos",
    "tangerines",
    "tax-treaties",
    "taxes",
    "tea",
    "teachers",
    "technical-assistance",
    "technology-administration-commerce-department",
    "telecommunications",
    "telegraph",
    "telephone",
    "television",
    "tennessee-valley-authority",
    "terrorism",
    "textiles",
    "thorium",
    "thrift-supervision-office",
    "time",
    "tires",
    "tobacco",
    "tomatoes",
    "toys",
    "trade-adjustment-assistance",
    "trade-agreements",
    "trade-names",
    "trade-practices",
    "trade-representative-office-united-states",
    "trademarks",
    "traffic-regulations",
    "transportation",
    "transportation-department",
    "transportation-office-agriculture-department",
    "transportation-security-administration",
    "transportation-statistics-bureau",
    "travel",
    "travel-transportation-expenses",
    "travel-restrictions",
    "treasury-department",
    "treaties",
    "trees",
    "trusts-trustees",
    "truth-lending",
    "truth-savings",
    "tuberculosis",
    "underground-mining",
    "unemployment-compensation",
    "uniform-system-accounts",
    "united-service-organizations-uso",
    "united-states-government-manual",
    "united-states-institute-peace",
    "united-states-investments-abroad",
    "upper-mississippi-river-basin-commission",
    "uranium",
    "urban-areas",
    "urethane",
    "utah-reclamation-mitigation-conservation-commission",
    "utilities",
    "vegetable-juices",
    "vegetables",
    "venereal-diseases",
    "vessels",
    "veterans",
    "veterans-affairs-department",
    "veterans-employment-training-service-office-assistant-secretary-labor-department",
    "veterinarians",
    "vice-president-u-office",
    "victim-compensation",
    "vietnam",
    "vinegar",
    "vinyl",
    "vinyl-chloride",
    "virgin-islands",
    "vocational-education",
    "vocational-rehabilitation",
    "volatile-organic-compounds",
    "voluntary-standards",
    "volunteers",
    "voting-rights",
    "wage-hour-division",
    "wages",
    "wake-island",
    "walnuts",
    "war-claims",
    "war-risk-insurance",
    "warehouses",
    "waste-treatment-disposal",
    "watches-jewelry",
    "water-bank-program",
    "water-pollution-control",
    "water-resources",
    "water-resources-council",
    "water-supply",
    "watermelons",
    "watersheds",
    "waterways",
    "weather",
    "weekly-compilation-presidential-documents",
    "western-balkans",
    "marine-mammals",
    "wheat",
    "whistleblowing",
    "white-house-fellowships-president-commission",
    "wilderness-areas",
    "wildlife",
    "wildlife-refuges",
    "wine",
    "wiretapping-electronic-surveillance",
    "women",
    "woodrow-wilson-international-center-scholars",
    "wool",
    "work-incentive-programs-win",
    "workers-compensation",
    "workers-compensation-programs-office",
    "x-rays",
    "yogurt",
    "youth",
    "yugoslavia",
    "zinc",
    "zoning"
]

# Facet IDs used to query documents.
facet_ids = [
    "daily",
    "weekly",
    "monthly",
    "quarterly",
    "yearly",
    "agency",
    "topic",
    "section",
    "type",
    "subtype"
]

# Public Document Fields used to query different info.
public_document_fields = [
    "agencies",
    "agency_names",
    "docket_numbers",
    "document_number",
    "editorial_note",
    "excerpts",
    "filed_at",
    "filing_type",
    "html_url",
    "json_url",
    "num_pages",
    "pdf_file_name",
    "pdf_file_size",
    "pdf_updated_at",
    "pdf_url",
    "publication_date",
    "raw_text_url",
    "subject_1",
    "subject_2",
    "subject_3",
    "title",
    "toc_doc",
    "toc_subject",
    "type"
]
