<a id="mypy-boto3-wafv2"></a>

# mypy-boto3-wafv2

[![PyPI - mypy-boto3-wafv2](https://img.shields.io/pypi/v/mypy-boto3-wafv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-wafv2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-wafv2.svg?color=blue)](https://pypi.org/project/mypy-boto3-wafv2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-wafv2?color=blue)](https://pypistats.org/packages/mypy-boto3-wafv2)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.WAFV2 1.19.12](https://boto3.amazonaws.com/v1/documentation/api/1.19.12/reference/services/wafv2.html#WAFV2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.1.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-wafv2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_wafv2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-wafv2](#mypy-boto3-wafv2)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `WAFV2` service.

```bash
python -m pip install boto3-stubs[wafv2]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[wafv2]` in your environment:
  `python -m pip install 'boto3-stubs[wafv2]'`

Both type checking and auto-complete should work for `WAFV2` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[wafv2]` in your environment:
  `python -m pip install 'boto3-stubs[wafv2]'`

Both type checking and auto-complete should work for `WAFV2` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[wafv2]` in your environment:
  `python -m pip install 'boto3-stubs[wafv2]'`
- Run `mypy` as usual

Type checking should work for `WAFV2` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[wafv2]` in your environment:
  `python -m pip install 'boto3-stubs[wafv2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WAFV2` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`WAFV2Client` provides annotations for `boto3.client("wafv2")`.

```python
import boto3

from mypy_boto3_wafv2 import WAFV2Client

client: WAFV2Client = boto3.client("wafv2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WAFV2Client = session.client("wafv2")
```

<a id="literals"></a>

### Literals

`mypy_boto3_wafv2.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_wafv2.literals import (
    ActionValueType,
    BodyParsingFallbackBehaviorType,
    ComparisonOperatorType,
    CountryCodeType,
    FallbackBehaviorType,
    FilterBehaviorType,
    FilterRequirementType,
    ForwardedIPPositionType,
    IPAddressVersionType,
    JsonMatchScopeType,
    LabelMatchScopeType,
    PositionalConstraintType,
    RateBasedStatementAggregateKeyTypeType,
    ResourceTypeType,
    ResponseContentTypeType,
    ScopeType,
    TextTransformationTypeType,
    ServiceName,
)

def check_value(value: ActionValueType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_wafv2.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_wafv2.type_defs import (
    ActionConditionTypeDef,
    AllowActionTypeDef,
    AndStatementTypeDef,
    AssociateWebACLRequestRequestTypeDef,
    BlockActionTypeDef,
    ByteMatchStatementTypeDef,
    CheckCapacityRequestRequestTypeDef,
    CheckCapacityResponseTypeDef,
    ConditionTypeDef,
    CountActionTypeDef,
    CreateIPSetRequestRequestTypeDef,
    CreateIPSetResponseTypeDef,
    CreateRegexPatternSetRequestRequestTypeDef,
    CreateRegexPatternSetResponseTypeDef,
    CreateRuleGroupRequestRequestTypeDef,
    CreateRuleGroupResponseTypeDef,
    CreateWebACLRequestRequestTypeDef,
    CreateWebACLResponseTypeDef,
    CustomHTTPHeaderTypeDef,
    CustomRequestHandlingTypeDef,
    CustomResponseBodyTypeDef,
    CustomResponseTypeDef,
    DefaultActionTypeDef,
    DeleteFirewallManagerRuleGroupsRequestRequestTypeDef,
    DeleteFirewallManagerRuleGroupsResponseTypeDef,
    DeleteIPSetRequestRequestTypeDef,
    DeleteLoggingConfigurationRequestRequestTypeDef,
    DeletePermissionPolicyRequestRequestTypeDef,
    DeleteRegexPatternSetRequestRequestTypeDef,
    DeleteRuleGroupRequestRequestTypeDef,
    DeleteWebACLRequestRequestTypeDef,
    DescribeManagedRuleGroupRequestRequestTypeDef,
    DescribeManagedRuleGroupResponseTypeDef,
    DisassociateWebACLRequestRequestTypeDef,
    ExcludedRuleTypeDef,
    FieldToMatchTypeDef,
    FilterTypeDef,
    FirewallManagerRuleGroupTypeDef,
    FirewallManagerStatementTypeDef,
    ForwardedIPConfigTypeDef,
    GeoMatchStatementTypeDef,
    GetIPSetRequestRequestTypeDef,
    GetIPSetResponseTypeDef,
    GetLoggingConfigurationRequestRequestTypeDef,
    GetLoggingConfigurationResponseTypeDef,
    GetManagedRuleSetRequestRequestTypeDef,
    GetManagedRuleSetResponseTypeDef,
    GetPermissionPolicyRequestRequestTypeDef,
    GetPermissionPolicyResponseTypeDef,
    GetRateBasedStatementManagedKeysRequestRequestTypeDef,
    GetRateBasedStatementManagedKeysResponseTypeDef,
    GetRegexPatternSetRequestRequestTypeDef,
    GetRegexPatternSetResponseTypeDef,
    GetRuleGroupRequestRequestTypeDef,
    GetRuleGroupResponseTypeDef,
    GetSampledRequestsRequestRequestTypeDef,
    GetSampledRequestsResponseTypeDef,
    GetWebACLForResourceRequestRequestTypeDef,
    GetWebACLForResourceResponseTypeDef,
    GetWebACLRequestRequestTypeDef,
    GetWebACLResponseTypeDef,
    HTTPHeaderTypeDef,
    HTTPRequestTypeDef,
    IPSetForwardedIPConfigTypeDef,
    IPSetReferenceStatementTypeDef,
    IPSetSummaryTypeDef,
    IPSetTypeDef,
    JsonBodyTypeDef,
    JsonMatchPatternTypeDef,
    LabelMatchStatementTypeDef,
    LabelNameConditionTypeDef,
    LabelSummaryTypeDef,
    LabelTypeDef,
    ListAvailableManagedRuleGroupVersionsRequestRequestTypeDef,
    ListAvailableManagedRuleGroupVersionsResponseTypeDef,
    ListAvailableManagedRuleGroupsRequestRequestTypeDef,
    ListAvailableManagedRuleGroupsResponseTypeDef,
    ListIPSetsRequestRequestTypeDef,
    ListIPSetsResponseTypeDef,
    ListLoggingConfigurationsRequestRequestTypeDef,
    ListLoggingConfigurationsResponseTypeDef,
    ListManagedRuleSetsRequestRequestTypeDef,
    ListManagedRuleSetsResponseTypeDef,
    ListRegexPatternSetsRequestRequestTypeDef,
    ListRegexPatternSetsResponseTypeDef,
    ListResourcesForWebACLRequestRequestTypeDef,
    ListResourcesForWebACLResponseTypeDef,
    ListRuleGroupsRequestRequestTypeDef,
    ListRuleGroupsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListWebACLsRequestRequestTypeDef,
    ListWebACLsResponseTypeDef,
    LoggingConfigurationTypeDef,
    LoggingFilterTypeDef,
    ManagedRuleGroupStatementTypeDef,
    ManagedRuleGroupSummaryTypeDef,
    ManagedRuleGroupVersionTypeDef,
    ManagedRuleSetSummaryTypeDef,
    ManagedRuleSetTypeDef,
    ManagedRuleSetVersionTypeDef,
    NotStatementTypeDef,
    OrStatementTypeDef,
    OverrideActionTypeDef,
    PutLoggingConfigurationRequestRequestTypeDef,
    PutLoggingConfigurationResponseTypeDef,
    PutManagedRuleSetVersionsRequestRequestTypeDef,
    PutManagedRuleSetVersionsResponseTypeDef,
    PutPermissionPolicyRequestRequestTypeDef,
    RateBasedStatementManagedKeysIPSetTypeDef,
    RateBasedStatementTypeDef,
    RegexMatchStatementTypeDef,
    RegexPatternSetReferenceStatementTypeDef,
    RegexPatternSetSummaryTypeDef,
    RegexPatternSetTypeDef,
    RegexTypeDef,
    ResponseMetadataTypeDef,
    RuleActionTypeDef,
    RuleGroupReferenceStatementTypeDef,
    RuleGroupSummaryTypeDef,
    RuleGroupTypeDef,
    RuleSummaryTypeDef,
    RuleTypeDef,
    SampledHTTPRequestTypeDef,
    SingleHeaderTypeDef,
    SingleQueryArgumentTypeDef,
    SizeConstraintStatementTypeDef,
    SqliMatchStatementTypeDef,
    StatementTypeDef,
    TagInfoForResourceTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    TextTransformationTypeDef,
    TimeWindowTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateIPSetRequestRequestTypeDef,
    UpdateIPSetResponseTypeDef,
    UpdateManagedRuleSetVersionExpiryDateRequestRequestTypeDef,
    UpdateManagedRuleSetVersionExpiryDateResponseTypeDef,
    UpdateRegexPatternSetRequestRequestTypeDef,
    UpdateRegexPatternSetResponseTypeDef,
    UpdateRuleGroupRequestRequestTypeDef,
    UpdateRuleGroupResponseTypeDef,
    UpdateWebACLRequestRequestTypeDef,
    UpdateWebACLResponseTypeDef,
    VersionToPublishTypeDef,
    VisibilityConfigTypeDef,
    WebACLSummaryTypeDef,
    WebACLTypeDef,
    XssMatchStatementTypeDef,
)

def get_structure() -> ActionConditionTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-wafv2` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-wafv2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_wafv2/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
