# robotframework-testrail-library

This is a robot framework library to be used with Testrail API.

The library requires a Testrail username and API key, which needs to be created in testrail. The credentials are passed to the library with the `connect to testrail` keyword. So library can be imported without credentials, and it will connect only when a keyword is called.

Some keywords are trying to find a suite/run... by name, and they assume the name is unique, given some conditions. For example it is assumed that in same project there is only one run with a specific name. This can be overriden by providing a special attribute for the class. Some adding keywords have logic to find a particular run or suite by either id or name, and if name is used and there are duplicates, then either exception is raised (default) or empty dictionary is returned (in case expected duplicates is True), since we cannot be sure which object we are adding stuff.

Deleting keywords are currently not supported, for safety reasons, as accidentally deleted wrong objects, may delete hundreds of other related objects, so it is preferrable to delete things manually in Testrail.

Installation:
```
pip install robotframework-testrail-library-nerajarolle
```

Example Usage:
```
*** Settings ***
Library   TestrailLibrary  
Suite Setup    connect to testrail    ${SERVER}   
...                 ${TESTRAIL_USERNAME}   ${TESTRAIL_KEY}

*** Test Cases ***
Test Get Project
    [Tags]   project   id
    ${project}   Get Project     1 
    IF  ${project}
        Log To Console  ${project}
    ELSE
        Log To Console    Project id 1 Not found  
    END

Test Get Project by Name
    [Tags]   project  name
    ${project}   Get Project by Name    TA Test Project  
    IF  ${project}
        Log To Console  ${project}
    ELSE
        Log To Console   TA Test Project Not found  
    END

Test Update Run Status 
    [Tags]   update_status
    ${params}   Create Dictionary    project_id=${PROJECT_ID}   run_name=Run number 1  
    ...   suite_name=${SUITE_NAME}   test_name=${TEST_NAME}   section_name=${SUITE_NAME}
    ...   elapsed=20s   comment=a comment   
    ${response}  set status on test run   status_id=1   &{params}  
    IF  ${response}
        log To Console    ${response}
    ELSE 
        log to console    Failed to update run ${response}
    END  

```

